/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.replication.service.impl;

import com.huawei.ism.base.sdk.model.StorageNE;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryResourceService;
import com.huawei.ism.drm.operation.sdk.model.OperationResult;
import com.huawei.ism.drm.operation.sdk.model.OperationResultBill;
import com.huawei.ism.drm.recovery.process.IRecoveryProcessHandler;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.storage.manager.proxy.StorageReplicationManagerProxy;
import com.huawei.ism.drm.storage.manager.proxy.StorageReprotectManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageReplicationBaseManager;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageReprotectBaseManager;
import com.huawei.ism.drm.storage.sdk.model.DrStorage;
import com.huawei.ism.drm.storage.sdk.model.ReplicationLink;
import com.huawei.ism.drm.storage.sdk.model.ReplicationRelation;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.ism.drm.storage.sdk.service.IStorageReplicationService;
import com.huawei.ism.drm.storage.sdk.service.IStorageService;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service(name="com.huawei.ism.drm.storage.sdk.service.IStorageReplicationService", desc="", interfaceClass=IStorageReplicationService.class)
public class StorageReplicationServiceImpl
extends BaseService
implements IStorageReplicationService {
    private static final Log logger = LogFactory.getInstance(StorageReplicationServiceImpl.class);
    private IRecoveryProcessHandler recoveryProcessHandler;

    public void setRecoveryProcessHandler(IRecoveryProcessHandler recoveryProcessHandler) {
        this.recoveryProcessHandler = recoveryProcessHandler;
    }

    public IRecoveryProcessHandler getRecoveryProcessHandler() {
        return this.recoveryProcessHandler;
    }

    public OperationResult syncReplication(String srcDeviceId, String tgtDeviceId, String replicationId, boolean isConsistentGroup) {
        OperationResultBill bill = this.recoveryProcessHandler.synchronize(replicationId, srcDeviceId, tgtDeviceId, isConsistentGroup);
        if (VerifyUtil.isEmpty((Object)bill) || VerifyUtil.isEmpty((Collection)bill.getOperationResults())) {
            throw new LegoCheckedException(1073947393L);
        }
        return (OperationResult)bill.getOperationResults().get(0);
    }

    public void refreshStorage(String deviceId) {
        IStorageReprotectBaseManager storageReprotectMgr = StorageReprotectManagerProxy.getInstance().getStorageReprotectMgrByDevId(deviceId);
        storageReprotectMgr.refreshStorage(deviceId);
    }

    public List<ReplicationTargetLun> querySyncStatus(String sourceArrayId, String targetArrayId, String replicationId, boolean isConsistentGroup) {
        return this.recoveryProcessHandler.querySyncStatus(sourceArrayId, targetArrayId, replicationId, isConsistentGroup);
    }

    public ReplicationRelation getReplication(String srcDeviceId, String tgtDeviceId, String replicationId, boolean isConsistentGroup) {
        IRecoveryResourceService recoveryResourceService = (IRecoveryResourceService)ServiceLocator.getInstance().getService(IRecoveryResourceService.class);
        return recoveryResourceService.queryReplication(srcDeviceId, tgtDeviceId, replicationId, isConsistentGroup);
    }

    public List<ReplicationTargetLun> getTargetLunList(String srcDeviceId, String tgtDeviceId, String ... lunId) {
        try {
            HashMap<String, Object> trgProps = new HashMap<String, Object>();
            trgProps.put("tgtDevSN", tgtDeviceId);
            trgProps.put("devSn", srcDeviceId);
            trgProps.put("tgtLunId", lunId);
            return CommonDAOLocator.getMoDao().findMoBy(ReplicationTargetLun.class, trgProps);
        }
        catch (Exception e) {
            logger.error((Object)("getTrgLunBySnAndLunID failed" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786962L);
            return new ArrayList<ReplicationTargetLun>();
        }
    }

    public List<ReplicationLink> getReplicationLinks(String srcDeviceId, String tgtDeviceId) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("deviceId", srcDeviceId);
        props.put("remoteArrayId", tgtDeviceId);
        List linkList = CommonDAOLocator.getMoDao().findMoBy(ReplicationLink.class, props);
        if (linkList != null) {
            IStorageService storageService = (IStorageService)ServiceLocator.getInstance().getService(IStorageService.class);
            String devName = "";
            StorageNE storageArray = storageService.getStorageBySn(srcDeviceId, null);
            if (storageArray != null) {
                devName = storageArray.getName();
            }
            String tgtName = "";
            StorageNE storage = storageService.getStorageBySn(tgtDeviceId, null);
            if (storage == null) {
                DrStorage drStorage = (DrStorage)((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySn(tgtDeviceId, "ism.deviceType.storage.mainType");
                if (drStorage != null) {
                    tgtName = drStorage.getName();
                }
            } else {
                tgtName = storage.getName();
            }
            for (ReplicationLink link : linkList) {
                link.setProductArrayName(devName);
                link.setRecoveryArrayName(tgtName);
            }
        }
        return linkList;
    }

    public List<Object> groupReplicationPairStatus(String srcDeviceId, String tgtDeviceId) {
        ArrayList<Object> listResult = new ArrayList();
        String hql = "select pairStatus, count(pairStatus) from ReplicationTargetLun where tgtDevSN=? and devSn =? group by pairStatus";
        try {
            listResult = CommonDAOLocator.getBaseDao().getHibernateTemplate().find(hql, new Object[]{tgtDeviceId, srcDeviceId});
        }
        catch (Exception e) {
            logger.error((Object)("setStorageLinkStatus failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786962L);
        }
        return listResult;
    }

    public void modifyReplication(String devSn, String replicationId, boolean isConsistentGroup, Map<String, Object> info) {
        IStorageReplicationBaseManager adapter = StorageReplicationManagerProxy.getInstance().getStorageReplicationAdapter(devSn);
        adapter.modify(devSn, replicationId, isConsistentGroup, info);
        CommonUtil.sleep((long)5000L);
        adapter.refresh(devSn, Arrays.asList(replicationId), isConsistentGroup);
    }
}

