/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.service.impl;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.huawei.ism.array.sdk.model.HvsUnit;
import com.huawei.ism.array.sdk.model.HyperMetroConsistentGroup;
import com.huawei.ism.array.sdk.model.HyperMetroDomain;
import com.huawei.ism.array.sdk.model.HyperMetroPair;
import com.huawei.ism.array.sdk.model.QuorumServer;
import com.huawei.ism.array.sdk.model.QuorumServerLink;
import com.huawei.ism.array.sdk.model.RemoteDevice;
import com.huawei.ism.base.sdk.model.Initiator;
import com.huawei.ism.base.sdk.model.StorageNE;
import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.base.sdk.model.StorageUnit;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.proxy.xve.XveEnumDefine;
import com.huawei.ism.cbb.proxy.xve.XveEnumDefinePParent;
import com.huawei.ism.cbb.proxy.xve.XveMOType;
import com.huawei.ism.cbb.proxy.xve.XveUUID;
import com.huawei.ism.cbb.util.StringUtil;
import com.huawei.ism.drm.base.service.IsmDrmBaseService;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.base.util.SiteUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.rest.client.RestClient;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.ManagementServer;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.IManagementServerService;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.storage.manager.proxy.StorageFileSystemManagerProxy;
import com.huawei.ism.drm.storage.manager.proxy.StorageHyperMetroManagerProxy;
import com.huawei.ism.drm.storage.manager.proxy.StorageHyperVaultManagerProxy;
import com.huawei.ism.drm.storage.manager.proxy.StorageVstoreHyperMetroPairManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageFileSystemManager;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageHyperMetroBaseManager;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageHyperVaultManager;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageVstoreHyperMetroPairManager;
import com.huawei.ism.drm.storage.sdk.service.IStorageResourceService;
import com.huawei.ism.drm.storage.sdk.service.IStorageService;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.ism.unistor.sdk.model.NasFileSystem;
import com.huawei.ism.unistor.sdk.model.VstoreHyperMetroPair;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;
import org.springframework.orm.hibernate5.HibernateTemplate;
import org.springframework.util.CollectionUtils;

@Service(name="com.huawei.ism.drm.storage.sdk.service.IStorageResourceService", desc="", interfaceClass=IStorageResourceService.class)
public class StorageResourceServiceImpl
extends IsmDrmBaseService
implements IStorageResourceService {
    private Log logger = LogFactory.getInstance(((Object)((Object)this)).getClass());
    private LoadingCache<String, Map<String, String>> wwnMapCache = CacheBuilder.newBuilder().maximumSize(10L).expireAfterWrite(10L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<String, Map<String, String>>(){

        public Map<String, String> load(String key) throws Exception {
            return StorageResourceServiceImpl.this.getTakeOverWwnMap();
        }
    });

    public <T extends StorageResource> List<T> getStorageResources(String devSn, List<String> resourceIds, Class<T> clazz) {
        this.logger.debug((Object)("sn=" + devSn + ", resourceIds=" + resourceIds + ",clazz=" + clazz));
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("devSn", devSn);
        props.put("resourceId", resourceIds.toArray());
        List list = this.getMoDao().findMoBy(clazz, props);
        return list;
    }

    public <T extends StorageResource> T getStorageResource(String devSn, String resourceId, Class<T> clazz) {
        this.logger.debug((Object)("sn=" + devSn + ", resourceId=" + resourceId + ",clazz=" + clazz));
        if (VerifyUtil.isEmpty((String)devSn) || VerifyUtil.isEmpty((String)resourceId)) {
            return null;
        }
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("devSn", devSn);
        props.put("resourceId", resourceId);
        List list = this.getMoDao().findMoBy(clazz, props);
        if (!VerifyUtil.isEmpty((Collection)list)) {
            return (T)((StorageResource)list.get(0));
        }
        return null;
    }

    public List<Initiator> getArrayInitiators(String deviceSn, Site site) {
        this.logger.debug((Object)("sn=" + deviceSn + ", site=" + site));
        if (VerifyUtil.isEmpty((Object)site) || site.getSiteType() == 0) {
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("devSn", deviceSn);
            List list = this.getMoDao().findMoBy(StorageUnit.class, props);
            if (VerifyUtil.isEmpty((Collection)list)) {
                return null;
            }
            HashMap<String, Long> iprops = new HashMap<String, Long>();
            iprops.put("parentMo.moId", ((StorageUnit)list.get(0)).getMoId());
            List initiatorList = this.getMoDao().findMoBy(Initiator.class, iprops);
            return initiatorList;
        }
        return this.getInitiatorsFromRemote(deviceSn, site);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<NasFileSystem> getFileSystemsByNFSShare(String lifIpAddr, String nfsSharePath, boolean isPrimary) {
        Session session;
        block10: {
            List<NasFileSystem> list;
            ArrayList<NasFileSystem> fileSystems;
            block9: {
                this.logger.debug((Object)("lifIpAddr=" + lifIpAddr + ", nfsSharePath=" + nfsSharePath));
                fileSystems = new ArrayList<NasFileSystem>();
                session = null;
                session = this.getMoDao().getHibernateTemplate().getSessionFactory().openSession();
                StringBuilder strHQL = new StringBuilder();
                strHQL.append("select fs from NasFileSystem fs, LogicInterface lif ");
                strHQL.append("where (lif.ipv4Addr=:ipv4Addr or lif.ipv6Addr=:ipv6Addr) ");
                strHQL.append("and fs.devSn = lif.devSn and fs.name=:fsName");
                Query query = session.createQuery(strHQL.toString());
                query.setString("ipv4Addr", lifIpAddr);
                query.setString("ipv6Addr", lifIpAddr);
                if (nfsSharePath.endsWith("/")) {
                    query.setString("fsName", nfsSharePath.substring(1, nfsSharePath.length() - 1));
                } else {
                    query.setString("fsName", nfsSharePath.substring(1));
                }
                List results = query.list();
                if (!VerifyUtil.isEmpty((Collection)results)) {
                    for (Object obj : results) {
                        fileSystems.add((NasFileSystem)obj);
                    }
                }
                if (fileSystems.size() <= 1 || !isPrimary) break block9;
                list = Arrays.asList(this.getHyperNasFileSystemByNFSShare(fileSystems));
                DBOperationUtil.closeSession((Session)session);
                return list;
            }
            try {
                if (VerifyUtil.isEmpty(fileSystems)) break block10;
                list = fileSystems;
            }
            catch (Exception e) {
                try {
                    this.logger.error((Object)("Getting fs by nfs share failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
                }
                catch (Throwable throwable) {
                    DBOperationUtil.closeSession(session);
                    throw throwable;
                }
                DBOperationUtil.closeSession((Session)session);
            }
            DBOperationUtil.closeSession((Session)session);
            return list;
        }
        DBOperationUtil.closeSession((Session)session);
        return null;
    }

    private NasFileSystem getHyperNasFileSystemByNFSShare(List<NasFileSystem> nasList) {
        ArrayList<String> fileIds = new ArrayList<String>();
        for (NasFileSystem fileSystem : nasList) {
            fileIds.add(fileSystem.getResourceId());
        }
        List<HyperMetroPair> pairlist = this.getHyperMetroPairByFileSystems(null, fileIds, Boolean.TRUE);
        if (!CollectionUtils.isEmpty(pairlist)) {
            for (HyperMetroPair hyperMetroPair : pairlist) {
                for (NasFileSystem fileSystem : nasList) {
                    if (!fileSystem.getResourceId().equals(hyperMetroPair.getLocalObjId()) || !fileSystem.getDevSn().equals(hyperMetroPair.getDevSn()) || VerifyUtil.isEmpty((String)hyperMetroPair.getVstorePairId())) continue;
                    return fileSystem;
                }
            }
        }
        return nasList.get(0);
    }

    public List<NasFileSystem> getFileSystemsByVstore(String devSN, String vstoreId) {
        this.logger.debug((Object)("getFileSystemsByVstore devSN=" + devSN + ", vstoreId=" + vstoreId));
        VerifyUtil.checkStrs((String[])new String[]{devSN, vstoreId});
        IStorageFileSystemManager mgr = StorageFileSystemManagerProxy.getInstance().getStorageFileSystemManager(devSN);
        return mgr.queryFileSystems(devSN, vstoreId);
    }

    private List<Initiator> getInitiatorsFromRemote(String deviceSn, Site site) {
        ArrayList<Initiator> initiators = new ArrayList<Initiator>();
        if (site.getSiteType() == 1) {
            RestClient client = SiteUtil.initClient((Site)site);
            HashMap<String, String> uriVariabels = new HashMap<String, String>();
            uriVariabels.put("devSn", deviceSn);
            try {
                String result = client.get("/ws/storages/{devSn}/initiators", uriVariabels);
                JSONArray jsonArray = JSONArray.fromObject((Object)result);
                if (null != jsonArray && jsonArray.size() > 0) {
                    Iterator it = jsonArray.iterator();
                    while (it.hasNext()) {
                        JSONObject jsonObject = JSONObject.fromObject(it.next());
                        Initiator initiator = new Initiator();
                        initiator.setUuid(jsonObject.getString("uuid"));
                        initiator.setIdentity(jsonObject.getString("identity"));
                        initiator.setHbaType(jsonObject.getString("hbaType"));
                        this.setStatus(jsonObject, initiator);
                        initiators.add(initiator);
                    }
                }
            }
            catch (Exception e) {
                this.logger.error((Object)("getInitiatorsFromRemote failed, deviceSn: " + deviceSn + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786962L);
            }
        }
        return initiators;
    }

    private void setStatus(JSONObject jsonObject, Initiator initiator) {
        if (jsonObject.containsKey((Object)"healthStatus")) {
            initiator.setHealthStatus(Integer.valueOf(jsonObject.getInt("healthStatus")));
        }
        if (jsonObject.containsKey((Object)"runningStatus")) {
            initiator.setRunningStatus(Integer.valueOf(jsonObject.getInt("runningStatus")));
        }
    }

    public HyperMetroPair getHyperMetroPair(String sn, String id, boolean isRealTime, String vstoreId) {
        this.logger.debug((Object)("Enter getHyperMetroPair, sn=" + sn + ", id=" + id + ", isRealTime=" + isRealTime));
        VerifyUtil.checkStrs((String[])new String[]{sn, id});
        HyperMetroPair pair = null;
        if (isRealTime) {
            IStorageHyperMetroBaseManager mgr = StorageHyperMetroManagerProxy.getInstance().getMgrByDevId(sn);
            pair = mgr.queryHyperMetroPair(sn, id, vstoreId);
        } else {
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("devSn", sn);
            props.put("id", id);
            List pairs = this.getMoDao().findMoBy(HyperMetroPair.class, props);
            if (VerifyUtil.isEmpty((Collection)pairs)) {
                this.logger.info((Object)"pair not exist.");
            } else {
                pair = (HyperMetroPair)pairs.get(0);
            }
        }
        this.logger.debug((Object)("Exit getHyperMetroPair, pair=" + pair));
        return pair;
    }

    public List<HyperMetroPair> getHyperMetroPairByFileSystems(String devSN, List<String> fileSystemIds, Boolean isPrimary) {
        return this.getHyperMetroPairByFileSystems(devSN, fileSystemIds, isPrimary, false);
    }

    public List<HyperMetroPair> getHyperMetroPairByFileSystems(String devSN, List<String> fileSystemIds, Boolean isPrimary, Boolean isRealtime) {
        this.logger.debug((Object)("devSn=" + devSN + ", isPrimary=" + isPrimary));
        if (null == isRealtime || !isRealtime.booleanValue()) {
            return this.getHyperMetroPairByFileSystems(fileSystemIds, devSN, isPrimary);
        }
        List<HyperMetroPair> pairsInDb = this.getHyperMetroPairByFileSystems(fileSystemIds, devSN, null);
        return this.queryHyperMetroPairRealtime(pairsInDb, isPrimary);
    }

    public List<HyperMetroPair> getHyperMetroPairByWwn(List<String> wwns, Boolean isPrimary) {
        return this.getHyperMetroPairByWwn(wwns, isPrimary, "", false);
    }

    public List<HyperMetroPair> getHyperMetroPairByWwn(List<String> wwns, Boolean isPrimary, boolean isRealtime) {
        return this.getHyperMetroPairByWwn(wwns, isPrimary, "", isRealtime);
    }

    public List<HyperMetroPair> getHyperMetroPairByWwn(List<String> wwns, Boolean isPrimary, String devSn, boolean isRealtime) {
        ArrayList<String> wwnTemp = new ArrayList<String>(wwns);
        Map<String, String> wwnMap = this.getTakeOverWwnMapWithCache();
        ArrayList<String> addWwnList = new ArrayList<String>();
        ArrayList<String> removeWwnList = new ArrayList<String>();
        for (String wwn : wwnTemp) {
            String deviceWwn = wwnMap.get(wwn);
            if (VerifyUtil.isEmpty((String)deviceWwn)) continue;
            this.logger.debug((Object)("finde devicewwn:" + deviceWwn + " for takeOverWwn:" + wwn));
            addWwnList.add(deviceWwn);
            removeWwnList.add(wwn);
        }
        wwnTemp.addAll(addWwnList);
        wwnTemp.removeAll(removeWwnList);
        return this.getHyperMetroPairByWwnOld(wwnTemp, isPrimary, devSn, isRealtime);
    }

    public Map<String, String> getTakeOverWwnMapWithCache() {
        Map<String, String> wwnMap;
        try {
            wwnMap = (Map<String, String>)this.wwnMapCache.get((Object)"");
        }
        catch (Exception e) {
            this.logger.error((Object)"cache get error:", (Throwable)e);
            wwnMap = this.getTakeOverWwnMap();
        }
        return wwnMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getTakeOverWwnMap() {
        HashMap<String, String> wwnMap = new HashMap<String, String>();
        Session session = null;
        try {
            HibernateTemplate template = this.getMoDao().getHibernateTemplate();
            session = template.getSessionFactory().openSession();
            String querySQL = "select WWN,DEVICE_LUN_WWN from ti_lun where WWN is not null and DEVICE_LUN_WWN is not null";
            NativeQuery query = session.createSQLQuery(querySQL);
            List results = query.list();
            for (Object object : results) {
                Object[] values;
                if (!(object instanceof Object[]) || 2 != (values = (Object[])object).length) continue;
                String wwn = CommUtil.convertToString((Object)values[0]);
                String deviceWwn = CommUtil.convertToString((Object)values[1]);
                wwnMap.put(wwn, deviceWwn);
            }
        }
        catch (Exception e) {
            try {
                this.logger.error((Object)("Getting plan progress failed. Ids:" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession((Session)session);
        }
        DBOperationUtil.closeSession((Session)session);
        return wwnMap;
    }

    private List<HyperMetroPair> getHyperMetroPairByWwnOld(List<String> wwns, Boolean isPrimary, String devSn, boolean isRealtime) {
        this.logger.info((Object)("Query HyperMetroPair by wwn, wwns=" + StringUtil.arrayToString((Object[])wwns.toArray()) + ", isPrimary=" + isPrimary + ", isRealtime=" + isRealtime), 90160758784000L);
        if (VerifyUtil.isEmpty(wwns)) {
            throw new LegoCheckedException(1073947393L);
        }
        if (!isRealtime) {
            return this.getHyperMetroPairByWwn(wwns, isPrimary, devSn);
        }
        List<HyperMetroPair> pairsInDb = this.getHyperMetroPairByWwn(wwns, null, devSn);
        return this.queryHyperMetroPairRealtime(pairsInDb, isPrimary);
    }

    private List<HyperMetroPair> getHyperMetroPairByWwn(List<String> wwns, Boolean isPrimary, String devSn) {
        this.logger.debug((Object)("wwns=" + wwns + ", isPrimary=" + isPrimary));
        if (VerifyUtil.isEmpty(wwns)) {
            throw new LegoCheckedException(1073947393L);
        }
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("resourceWwn", wwns.toArray(new String[wwns.size()]));
        if (null != isPrimary) {
            props.put("isPrimary", isPrimary);
        }
        if (!VerifyUtil.isEmpty((String)devSn)) {
            props.put("devSn", devSn);
        }
        List pairs = this.getMoDao().findMoBy(HyperMetroPair.class, props);
        return pairs;
    }

    private List<HyperMetroPair> getHyperMetroPairByFileSystems(List<String> fileSystemIds, String devSN, Boolean isPrimary) {
        if (VerifyUtil.isEmpty(fileSystemIds)) {
            throw new LegoCheckedException(1073947393L);
        }
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("localObjId", fileSystemIds.toArray(new String[fileSystemIds.size()]));
        if (null != isPrimary) {
            props.put("isPrimary", isPrimary);
        }
        if (null != devSN) {
            props.put("devSn", devSN);
        }
        return this.getMoDao().findMoBy(HyperMetroPair.class, props);
    }

    private String getVstoreIdByHyperMetroPair(HyperMetroPair hyperMetroPair) {
        if (VerifyUtil.isEmpty((String)hyperMetroPair.getVstorePairId())) {
            return null;
        }
        String uuid = new XveUUID(hyperMetroPair.getDevSn(), XveMOType.VSTORE_HYPERMETRO_PAIR, hyperMetroPair.getVstorePairId()).toString();
        VstoreHyperMetroPair vstoreHyperMetroPair = (VstoreHyperMetroPair)this.getMoDao().getMoByUuid(uuid, Boolean.valueOf(true));
        if (VerifyUtil.isEmpty((Object)vstoreHyperMetroPair)) {
            return null;
        }
        return vstoreHyperMetroPair.getLocalVstoreId();
    }

    private List<HyperMetroPair> queryHyperMetroPairRealtime(List<HyperMetroPair> pairsInDb, Boolean isPrimary) {
        ArrayList<HyperMetroPair> pairs = new ArrayList<HyperMetroPair>();
        HashSet<String> pairIdSet = new HashSet<String>();
        for (HyperMetroPair mo : pairsInDb) {
            String sn = mo.getDevSn();
            String id = mo.getId();
            String vstoreId = this.getVstoreIdByHyperMetroPair(mo);
            if (pairIdSet.contains(id)) {
                this.logger.info((Object)("The pair is in list: " + id + ", sn=" + sn));
                continue;
            }
            StorageNE storage = (StorageNE)this.getMoDao().getMo(StorageNE.class, "sn", (Object)sn);
            if (VerifyUtil.isEmpty((Object)storage) || Integer.valueOf(-1).equals(storage.getStatus()) || Integer.valueOf(2).equals(storage.getStatus())) {
                this.logger.warn((Object)("The storage is no valid: " + id + ", sn=" + sn));
                continue;
            }
            IStorageHyperMetroBaseManager manager = StorageHyperMetroManagerProxy.getInstance().getMgrByDevId(sn);
            HyperMetroPair pair = manager.queryHyperMetroPair(sn, id, vstoreId);
            this.logger.info((Object)("devSn=" + sn + ", id=" + id + ", realSn=" + pair.getDevSn() + "realId=" + pair.getId() + "realWwn=" + pair.getResourceWwn()), 90160758784000L);
            if (null == isPrimary) {
                pairs.add(pair);
                continue;
            }
            if (!isPrimary.equals(pair.getIsPrimary())) continue;
            pairs.add(pair);
            pairIdSet.add(pair.getId());
        }
        return pairs;
    }

    public List<QuorumServer> getQuorumServers(String devSn) {
        this.logger.debug((Object)("sn=" + devSn));
        if (VerifyUtil.isEmpty((String)devSn)) {
            throw new LegoCheckedException(1073947393L);
        }
        List servers = this.getMoDao().getMoList(QuorumServer.class, "devSn", (Object)devSn);
        return servers;
    }

    public List<QuorumServerLink> getQuorumServerLink(String devSn, String quorumServerId) {
        List links;
        this.logger.debug((Object)("sn=" + devSn + ", quorumServerId=" + quorumServerId));
        if (VerifyUtil.isEmpty((String)devSn)) {
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)quorumServerId)) {
            throw new LegoCheckedException(1073947393L);
        }
        DrResource drResource = ((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySn(devSn);
        if (null == drResource) {
            throw new LegoCheckedException(2117645L);
        }
        Site site = ((ISiteService)ServiceLocator.getInstance().getService(ISiteService.class)).getSiteById(drResource.getSiteId());
        if (null == site) {
            throw new LegoCheckedException(2117645L);
        }
        if (1 == site.getSiteType()) {
            RestClient client = SiteUtil.initClient((Site)site);
            String url = "/ws/storages/{devSn}/quorumserverlinks?quorumServerId={quorumServerId}";
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("devSn", devSn);
            props.put("quorumServerId", quorumServerId);
            links = client.getForObjects(url, props, QuorumServerLink.class);
        } else {
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("devSn", devSn);
            props.put("quorumServerId", quorumServerId);
            links = this.getMoDao().findMoBy(QuorumServerLink.class, props);
        }
        return links;
    }

    public List<QuorumServerLink> getQuorumServerLink(String devSn, String quorumServerId, boolean isRealTime) {
        this.logger.debug((Object)("sn=" + devSn + ", quorumServerId=" + quorumServerId + ",isRealtime=" + isRealTime));
        List<QuorumServerLink> moList = this.getQuorumServerLink(devSn, quorumServerId);
        if (!isRealTime || VerifyUtil.isEmpty(moList)) {
            return moList;
        }
        IStorageHyperMetroBaseManager manager = StorageHyperMetroManagerProxy.getInstance().getMgrByDevId(devSn);
        List links = manager.queryQuorumServerLinks(devSn, quorumServerId);
        return links;
    }

    public List<HyperMetroDomain> getHyperMetroDomains(String devSn) {
        this.logger.debug((Object)("sn=" + devSn));
        if (VerifyUtil.isEmpty((String)devSn)) {
            throw new LegoCheckedException(1073947393L);
        }
        List domains = CommonDAOLocator.getMoDao().getMoList(HyperMetroDomain.class, "devSn", (Object)devSn);
        return domains;
    }

    public <T extends StorageResource> List<T> getStorageResourcesByUuid(List<String> resourceUuids, Class<T> clazz) {
        this.logger.debug((Object)("resourceUuids=" + resourceUuids + ", clazz=" + clazz));
        HashMap<String, Object[]> props = new HashMap<String, Object[]>();
        props.put("uuid", resourceUuids.toArray());
        List list = this.getMoDao().findMoBy(clazz, props);
        return list;
    }

    public List<HyperMetroConsistentGroup> getHyperMetroConsistentGroupByLunWwn(String devSn, String wwn, boolean isRealtime) {
        this.logger.debug((Object)("devSn=" + devSn + ", wwn=" + wwn + ", isRealtime=" + isRealtime));
        if (VerifyUtil.isEmpty((String)wwn)) {
            this.logger.error((Object)"wwn is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        HashMap<String, Object> props = new HashMap<String, Object>();
        if (null != devSn) {
            props.put("devSn", devSn);
        }
        props.put("resourceWwn", new String[]{wwn});
        List pairs = this.getMoDao().findMoBy(HyperMetroPair.class, props);
        ArrayList<HyperMetroConsistentGroup> groups = new ArrayList<HyperMetroConsistentGroup>();
        for (HyperMetroPair pair : pairs) {
            if (!pair.getInCg().booleanValue()) {
                this.logger.info((Object)("Current pair is not in cg, sn=" + pair.getDevSn() + ", id=" + pair.getId() + ", www=" + wwn));
                continue;
            }
            IStorageHyperMetroBaseManager mgr = StorageHyperMetroManagerProxy.getInstance().getMgrByDevId(pair.getDevSn());
            HyperMetroConsistentGroup group = mgr.queryHyperMetroCGroup(pair.getDevSn(), pair.getCgId());
            if (null == group) {
                this.logger.error((Object)("can not find cg, sn=" + pair.getDevSn() + ", id=" + pair.getCgId()));
                continue;
            }
            groups.add(group);
        }
        return groups;
    }

    public HyperMetroConsistentGroup getHyperMetroConsistentGroup(String devSn, String cgId, boolean isRealTime) {
        this.logger.debug((Object)("sn=" + devSn + ", cgId=" + cgId + ", isRealTime=" + isRealTime));
        VerifyUtil.checkStrs((String[])new String[]{devSn, cgId});
        HyperMetroConsistentGroup group = null;
        if (isRealTime) {
            IStorageHyperMetroBaseManager mgr = StorageHyperMetroManagerProxy.getInstance().getMgrByDevId(devSn);
            group = mgr.queryHyperMetroCGroup(devSn, cgId);
        } else {
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("devSn", devSn);
            props.put("id", cgId);
            List list = this.getMoDao().findMoBy(HyperMetroConsistentGroup.class, props);
            if (!VerifyUtil.isEmpty((Collection)list)) {
                group = (HyperMetroConsistentGroup)list.get(0);
            }
        }
        this.logger.debug((Object)group);
        return group;
    }

    public List<HyperMetroPair> getHyperMetroPairByConsistentGroup(String devSn, String cgId, boolean isRealTime) {
        List pairs;
        this.logger.debug((Object)("sn=" + devSn + ", cgId=" + cgId + ", isRealTime=" + isRealTime));
        if (VerifyUtil.isEmpty((String)devSn)) {
            this.logger.error((Object)"sn is empty.");
            throw new LegoCheckedException(1073947393L, devSn);
        }
        if (VerifyUtil.isEmpty((String)cgId)) {
            this.logger.error((Object)"cgId is empty.");
            throw new LegoCheckedException(1073947393L, cgId);
        }
        if (isRealTime) {
            IStorageHyperMetroBaseManager mgr = StorageHyperMetroManagerProxy.getInstance().getMgrByDevId(devSn);
            pairs = mgr.queryHyperMetroPairsByCg(devSn, cgId);
        } else {
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("devSn", devSn);
            props.put("cgId", cgId);
            pairs = this.getMoDao().findMoBy(HyperMetroPair.class, props);
        }
        return pairs;
    }

    public List<StorageResource> queryRemoteResource(String devSn, String srcResourceId, String remoteDeviceSn, int arrayType, int resType, int rssType) {
        this.logger.debug((Object)("sn=" + devSn + ", srcResourceId=" + srcResourceId + ", remoteDeviceSn=" + remoteDeviceSn + "arrayType=" + arrayType + ", resType=" + resType + ",rssType=" + rssType));
        VerifyUtil.checkStrs((String[])new String[]{devSn, srcResourceId, remoteDeviceSn});
        IStorageHyperVaultManager mgr = StorageHyperVaultManagerProxy.getInstance().getMgrByDevId(devSn);
        if (null == mgr) {
            this.logger.error((Object)("mgr is not exsit, sn=" + devSn));
            throw new LegoCheckedException(102L);
        }
        NasFileSystem fs = this.getStorageResource(devSn, srcResourceId, NasFileSystem.class);
        if (null == fs) {
            this.logger.error((Object)("FileSystem not exist, sn=" + devSn + ", id=" + srcResourceId));
            throw new LegoCheckedException(2117645L);
        }
        long capacityInBytelongValue = fs.getCapacity();
        if (null == ((IStorageService)ServiceLocator.getInstance().getService(IStorageService.class)).getStorageBySn(remoteDeviceSn)) {
            this.logger.error((Object)("Storage not exist, remoteDeviceSn=" + remoteDeviceSn));
            throw new LegoCheckedException(2117645L);
        }
        RemoteDevice remoteDevice = ((IStorageService)ServiceLocator.getInstance().getService(IStorageService.class)).queryRemoteDevice(devSn, remoteDeviceSn);
        if (null == remoteDevice) {
            this.logger.error((Object)("remoteDevice is null, devSn=" + devSn + ", remoteSn=" + remoteDeviceSn));
            throw new LegoCheckedException(1073947393L);
        }
        String remoteDeviceId = remoteDevice.getId();
        if (VerifyUtil.isEmpty((String)remoteDeviceId)) {
            this.logger.error((Object)("remoteDeviceId is empty, devSn=" + devSn + ", remoteSn=" + remoteDeviceSn));
            throw new LegoCheckedException(2117645L);
        }
        List remoteResources = mgr.queryRemoteResource(devSn, capacityInBytelongValue, remoteDeviceId, XveEnumDefinePParent.EPL_ARRAY_TYPE_E.valueOf((int)arrayType), XveMOType.getType((int)resType), XveEnumDefine.RSSLUN_TYPE_E.getType((int)rssType));
        return remoteResources;
    }

    public List<NasFileSystem> queryHyperVaultCandidateTargetFs(String devSn, String srcFsId, String remoteDeviceSn) {
        this.logger.debug((Object)("devSn=" + devSn + ",srcFsId=" + srcFsId + ", remoteDevicesn=" + remoteDeviceSn));
        VerifyUtil.checkStrs((String[])new String[]{devSn, srcFsId, remoteDeviceSn});
        List<StorageResource> remoteResources = this.queryRemoteResource(devSn, srcFsId, remoteDeviceSn, XveEnumDefinePParent.EPL_ARRAY_TYPE_E.EPL_ARRAY_PRIVATE.getValue(), XveMOType.FILESYSTEM.getValue(), XveEnumDefine.RSSLUN_TYPE_E.REPHV_SECONDARY_FS.getValue());
        return Arrays.asList(remoteResources.toArray(new NasFileSystem[remoteResources.size()]));
    }

    public void synchronize(String devSn, String id, boolean isCg, String vstoreId) {
        this.logger.debug((Object)("devSn=" + devSn + ",id=" + id + ", isCg=" + isCg));
        VerifyUtil.checkStrs((String[])new String[]{devSn, id});
        IStorageHyperMetroBaseManager mgr = StorageHyperMetroManagerProxy.getInstance().getMgrByDevId(devSn);
        mgr.synchronize(devSn, id, isCg, vstoreId);
    }

    public void disable(String devSn, String id, DrmEnumDefine.RoleType role, boolean isCg, String vstoreId) {
        this.logger.debug((Object)("devSn=" + devSn + ",id=" + id + ", role=" + role + ", isCg=" + isCg));
        VerifyUtil.checkStrs((String[])new String[]{devSn, id});
        IStorageHyperMetroBaseManager mgr = StorageHyperMetroManagerProxy.getInstance().getMgrByDevId(devSn);
        mgr.disable(devSn, id, role, isCg, vstoreId);
    }

    public VstoreHyperMetroPair getVstoreHyperMetroPairById(String devSN, String id, Boolean isAssociate) {
        this.logger.debug((Object)("devSn=" + devSN + ",id=" + id + " ,isAssociate=" + isAssociate));
        VerifyUtil.checkStrs((String[])new String[]{devSN, id});
        VstoreHyperMetroPair vstoreHyperMetroPair = null;
        IStorageVstoreHyperMetroPairManager mgr = StorageVstoreHyperMetroPairManagerProxy.getInstance().getMgrByDevId(devSN);
        vstoreHyperMetroPair = mgr.queryVstoreHyperMetroPair(devSN, id, isAssociate.booleanValue());
        return vstoreHyperMetroPair;
    }

    public List<HyperMetroPair> getHyperMetroPairByVstore(String devSn, String vstoreId) {
        this.logger.debug((Object)("sn=" + devSn + ", vstoreId=" + vstoreId));
        VerifyUtil.checkStrs((String[])new String[]{devSn, vstoreId});
        IStorageHyperMetroBaseManager mgr = StorageHyperMetroManagerProxy.getInstance().getMgrByDevId(devSn);
        List pairs = mgr.queryHyperMetroPairs(devSn, vstoreId);
        return pairs;
    }

    public void swapVstoreHyperMetroPair(String devSN, String vstorePairId) {
        this.logger.debug((Object)("devSn=" + devSN + ",vstorePairId=" + vstorePairId));
        VerifyUtil.checkStrs((String[])new String[]{devSN, vstorePairId});
        IStorageVstoreHyperMetroPairManager mgr = StorageVstoreHyperMetroPairManagerProxy.getInstance().getMgrByDevId(devSN);
        mgr.swap(devSN, vstorePairId, Boolean.FALSE.booleanValue());
    }

    public List<VstoreHyperMetroPair> getRemoteVstoreHyperMetroPair(String vstorePairId, String localVstoreId, String remoteVstoreId) {
        VerifyUtil.checkStrs((String[])new String[]{vstorePairId});
        HashMap<String, String> condition = new HashMap<String, String>();
        condition.put("vstorePairId", vstorePairId);
        if (!VerifyUtil.isEmpty((String)remoteVstoreId)) {
            condition.put("localVstoreId", remoteVstoreId);
        }
        if (!VerifyUtil.isEmpty((String)localVstoreId)) {
            condition.put("remoteVstoreId", localVstoreId);
        }
        return CommonDAOLocator.getMoDao().findMoBy(VstoreHyperMetroPair.class, condition);
    }

    public VstoreHyperMetroPair getVstoreHyperMetroPairByIdFromRemote(Site site, String devSN, String id, Boolean isAssociate) {
        RestClient client = SiteUtil.initClient((Site)site);
        String url = "/ws/storages/{devSn}/vstore_hypermetro_pair/{isAssociate}/{id}";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("devSn", devSN);
        params.put("id", id);
        params.put("isAssociate", isAssociate);
        return (VstoreHyperMetroPair)client.getForObject(url, params, VstoreHyperMetroPair.class);
    }

    public List<VstoreHyperMetroPair> getVstoreHyperPair(String serverUuid, String vstorePairId, String localVstoreId, String remoteVstoreId) {
        this.logger.debug((Object)("Enter getVstoreHyperPair, serverUuid=" + serverUuid));
        VerifyUtil.checkStrs((String[])new String[]{vstorePairId});
        ManagementServer server = null;
        if (!VerifyUtil.isEmpty((String)serverUuid)) {
            server = ((IManagementServerService)ServiceLocator.getInstance().getService(IManagementServerService.class)).getServer(serverUuid);
        }
        List list = null;
        if (null == server || 0 == server.getServerType()) {
            HashMap<String, String> condition = new HashMap<String, String>();
            condition.put("vstorePairId", vstorePairId);
            if (!VerifyUtil.isEmpty((String)remoteVstoreId)) {
                condition.put("localVstoreId", remoteVstoreId);
            }
            if (!VerifyUtil.isEmpty((String)localVstoreId)) {
                condition.put("remoteVstoreId", localVstoreId);
            }
            list = CommonDAOLocator.getMoDao().findMoBy(VstoreHyperMetroPair.class, condition);
        } else {
            RestClient client = SiteUtil.initClientByServerUuid((String)serverUuid);
            String url = "/ws/storages/vstore_hypermetro_pair/remote?vstorePairId={vstorePairId}&localVstoreId={localVstoreId}&remoteVstoreId={remoteVstoreId}";
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("vstorePairId", vstorePairId);
            params.put("localVstoreId", localVstoreId);
            params.put("remoteVstoreId", remoteVstoreId);
            list = client.getForObjects(url, params, VstoreHyperMetroPair.class);
            for (VstoreHyperMetroPair pair : list) {
                if (null == pair.getExpendField()) continue;
                HvsUnit hvsUnit = new HvsUnit();
                hvsUnit.setDevSn(pair.getExpendField());
                pair.setParentMo((ManagedObject)hvsUnit);
            }
        }
        this.logger.debug((Object)"Exit getVstoreHyperPair");
        return list;
    }
}

