/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.util;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupHelper;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupUtil;
import com.huawei.ism.drm.protection.framework.template.factory.ReplicaBuilderFactory;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.protection.provider.sdk.service.IProtectObjectProvider;
import com.huawei.ism.drm.protection.provider.sdk.service.IProtectObjectProviderDelegate;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.service.IReplicaService;
import com.huawei.ism.drm.protection.schedule.sdk.model.RetentionPolicy;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.schedule.sdk.model.ScheduleProtectedType;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.protection.template.sdk.service.IReplicaBuilder;
import com.huawei.ism.drm.storage.manager.proxy.StorageSnapshotScheduleManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageSnapshotScheduleManager;
import com.huawei.ism.drm.storage.sdk.model.SnapshotSchedule;
import com.huawei.ism.drm.storage.sdk.service.IStorageService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.map.LRUMap;

public class SnapshotScheduleUtil {
    private static Log logger = LogFactory.getInstance(SnapshotScheduleUtil.class);
    private static final String SCHEDULE_NAME_PRE = "RD_";
    private static final int CACHE_MAX_SIZE = 5000;
    private static ReplicaBuilderFactory factory = ReplicaBuilderFactory.getInstance();
    private static Map<String, ProtectGroupReplica> replicaCache = Collections.synchronizedMap(new LRUMap(5000));

    public static SnapshotSchedule constructNewSnapshotSchedule(PolicyTemplate template, String devSn, Schedule schedule) {
        if (SnapshotScheduleUtil.isExistsSecondSchedule(schedule)) {
            SnapshotSchedule snapshotSchedule = new SnapshotSchedule();
            int snapshotNum = SnapshotScheduleUtil.getSnapshotNum(schedule);
            snapshotSchedule.setSnapshotMaxNum(Integer.valueOf(snapshotNum));
            snapshotSchedule.setScheduleType(SnapshotSchedule.SCHEDULE_TYPE.SNAPSHOT.getValue());
            snapshotSchedule.setDevSn(devSn);
            snapshotSchedule.setName(SCHEDULE_NAME_PRE + System.currentTimeMillis());
            snapshotSchedule.setFrequencyValue(Long.valueOf(schedule.getPeriodInterval()));
            return snapshotSchedule;
        }
        return null;
    }

    public static boolean isExistsSecondSchedule(Set<Schedule> schedules) {
        if (VerifyUtil.isEmpty(schedules)) {
            return false;
        }
        for (Schedule schedule : schedules) {
            if (schedule.getProtectLocation() != DrmEnumDefine.ProtectLocation.A_A.getValue()) continue;
            return SnapshotScheduleUtil.isExistsSecondSchedule(schedule);
        }
        return false;
    }

    public static boolean isExistsSecondSchedule(Schedule schedule) {
        if (VerifyUtil.isEmpty((Object)schedule)) {
            return false;
        }
        return schedule.getScheduleMode() == 0 && schedule.getPeriodType() == 5;
    }

    public static void putProtectGroupReplica(ProtectGroupReplica replica) {
        replicaCache.put(replica.getId(), replica);
    }

    public static ProtectGroupReplica getProtectGroupReplica(String replicaId) {
        return replicaCache.get(replicaId);
    }

    public static void dealSecondPolicyRefineModify(ProtectGroup protectGroup, Schedule newSchedule) {
        Schedule oldSchdule = SnapshotScheduleUtil.getOldSchedule(protectGroup, newSchedule);
        boolean oldPolicyExistSecondPolicy = SnapshotScheduleUtil.isExistsSecondSchedule(oldSchdule);
        boolean newPolicyExistSecondPolicy = SnapshotScheduleUtil.isExistsSecondSchedule(newSchedule);
        if (!oldPolicyExistSecondPolicy && !newPolicyExistSecondPolicy) {
            logger.info((Object)"no exists second schedule modify.");
            return;
        }
        String devSn = SnapshotScheduleUtil.getDevSnBySchedule(protectGroup, newSchedule);
        String snapshotScheduleId = SnapshotScheduleUtil.getScheduleIdFromProtectGroup(protectGroup, devSn);
        IStorageSnapshotScheduleManager scheduleManager = StorageSnapshotScheduleManagerProxy.getInstance().getStorageSnapshotMgrByDevId(devSn, newSchedule.getProtectedType());
        if (oldPolicyExistSecondPolicy && newPolicyExistSecondPolicy) {
            SnapshotScheduleUtil.modifySnapshotSchedule(protectGroup, devSn, snapshotScheduleId, newSchedule);
            return;
        }
        if (oldPolicyExistSecondPolicy && !newPolicyExistSecondPolicy) {
            SnapshotScheduleUtil.checkReplicasIsMounted(protectGroup, newSchedule);
            SnapshotScheduleUtil.disableSchedule(protectGroup, scheduleManager, devSn, snapshotScheduleId, newSchedule);
            return;
        }
        if (!oldPolicyExistSecondPolicy && newPolicyExistSecondPolicy) {
            SnapshotScheduleUtil.checkReplicasIsMounted(protectGroup, newSchedule);
            String str = (String)protectGroup.getProps().get("PROP_KEY_OLD_SNAPSHOT_SCHEDULE");
            JSONObject obj = JSONObject.fromObject((Object)str);
            IProtectGroupService service = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
            if (oldSchdule.getScheduleMode() == 0) {
                service.disableSchedule(protectGroup.getUuid(), oldSchdule.getScheduleId());
            }
            if (VerifyUtil.isEmpty((String)str) || obj.isEmpty()) {
                SnapshotScheduleUtil.createSnapshotSchedule(protectGroup, newSchedule, devSn);
            } else {
                String oldSnapshotScheduleId = (String)obj.get(devSn);
                if (oldSnapshotScheduleId == null) {
                    logger.debug((Object)"old snapshot schedule Id cannot find.");
                    SnapshotScheduleUtil.createSnapshotSchedule(protectGroup, newSchedule, devSn);
                    SnapshotScheduleUtil.deleteReplicas(protectGroup, newSchedule);
                    return;
                }
                SnapshotSchedule schedule = scheduleManager.query(devSn, oldSnapshotScheduleId);
                if (schedule == null) {
                    logger.debug((Object)"old schedule cannot find.");
                    SnapshotScheduleUtil.createSnapshotSchedule(protectGroup, newSchedule, devSn);
                } else {
                    SnapshotScheduleUtil.modifySnapshotSchedule(protectGroup, devSn, oldSnapshotScheduleId, newSchedule);
                    scheduleManager.enable(devSn, oldSnapshotScheduleId, true);
                    protectGroup.getProps().put("PROP_KEY_SNAPSHOT_SCHEDULE" + devSn, oldSnapshotScheduleId);
                    ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).saveOrUpdateProtectGroupProps(protectGroup.getUuid(), protectGroup.getProps());
                }
            }
            SnapshotScheduleUtil.deleteReplicas(protectGroup, newSchedule);
        }
    }

    private static Schedule getOldSchedule(ProtectGroup protectGroup, Schedule schedule) {
        Set scheduleList = protectGroup.getTemplate().getSchedules();
        for (Schedule schedule1 : scheduleList) {
            if (!schedule1.getScheduleId().equals(schedule.getScheduleId())) continue;
            return schedule1;
        }
        logger.error((Object)"can't find oldSchedule.");
        throw new LegoCheckedException(1073947394L);
    }

    private static String getDevSnBySchedule(ProtectGroup protectGroup, Schedule schedule) {
        IReplicaBuilder builder = factory.getTemplateByType(protectGroup.getTemplate().getType());
        Map devSns = builder.getProtectedDeviceSn(protectGroup);
        if (null == devSns) {
            logger.error((Object)"devSns is empty.");
            throw new LegoCheckedException(1073947394L);
        }
        for (Map.Entry entry : devSns.entrySet()) {
            if (((Integer)entry.getKey()).intValue() != schedule.getProtectLocation()) continue;
            return (String)entry.getValue();
        }
        logger.error((Object)"devSn is empty.");
        throw new LegoCheckedException(1073947394L);
    }

    public static void disableSchedule(ProtectGroup protectGroup, IStorageSnapshotScheduleManager scheduleManager, String devSn, String snapshotScheduleId, Schedule schedule) {
        SnapshotSchedule snapshotSchedule = scheduleManager.query(devSn, snapshotScheduleId);
        if (null == snapshotSchedule) {
            logger.error((Object)"snapshot schedule is null.");
            return;
        }
        scheduleManager.enable(devSn, snapshotScheduleId, false);
        String scheduleIds = (String)protectGroup.getProps().get("PROP_KEY_OLD_SNAPSHOT_SCHEDULE");
        JSONObject obj = JSONObject.fromObject((Object)scheduleIds);
        obj.put((Object)devSn, (Object)snapshotScheduleId);
        protectGroup.getProps().put("PROP_KEY_OLD_SNAPSHOT_SCHEDULE", obj.toString());
        ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).saveOrUpdateProtectGroupProps(protectGroup.getUuid(), protectGroup.getProps());
    }

    public static String getScheduleIdFromProtectGroup(ProtectGroup protectGroup, String devSn) {
        String schedule = (String)protectGroup.getProps().get("PROP_KEY_SNAPSHOT_SCHEDULE" + devSn);
        if (!VerifyUtil.isEmpty((String)schedule)) {
            return schedule;
        }
        return (String)protectGroup.getProps().get("PROP_KEY_SNAPSHOT_SCHEDULE");
    }

    public static SnapshotSchedule createSnapshotSchedule(ProtectGroup protectGroup, Schedule schedule, String devSn) {
        IStorageSnapshotScheduleManager scheduleManager = StorageSnapshotScheduleManagerProxy.getInstance().getStorageSnapshotMgrByDevId(devSn, schedule.getProtectedType());
        ArrayList lunIds = new ArrayList();
        ArrayList<String> wwns = new ArrayList<String>();
        IProtectObjectProvider provider = (IProtectObjectProvider)((IProtectObjectProviderDelegate)ServiceLocator.getInstance().getService(IProtectObjectProviderDelegate.class)).getProviderByAppType(protectGroup.getPoType());
        for (ProtectObjectStorageInfo storageInfo : protectGroup.distinctStorageInfo()) {
            if (schedule.getProtectedType() == ScheduleProtectedType.HYPERCDP.getValue() && provider.isProtectArchieveLog(storageInfo)) continue;
            wwns.add(storageInfo.getLunWWN());
        }
        ((IStorageService)ServiceLocator.getInstance().getService(IStorageService.class)).getStorageResourceByWwn(wwns.toArray(new String[wwns.size()])).forEach(storageResource -> {
            if (storageResource.getDevSn().equals(devSn) && !lunIds.contains(storageResource.getResourceId())) {
                lunIds.add(storageResource.getResourceId());
            }
        });
        SnapshotSchedule newSchedule = scheduleManager.create(protectGroup, schedule, devSn, lunIds);
        protectGroup.getProps().put("PROP_KEY_SNAPSHOT_SCHEDULE" + devSn, newSchedule.getId());
        protectGroup.getProps().put("PROP_KEY_SNAPSHOT_SCHEDULE_NAME" + devSn, newSchedule.getName());
        List dbResults = CommonDAOLocator.getMoDao().find("from ProtectGroup where uuid=?", new Object[]{protectGroup.getUuid()});
        if (!VerifyUtil.isEmpty((Collection)dbResults)) {
            ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).saveOrUpdateProtectGroupProps(protectGroup.getUuid(), protectGroup.getProps());
        }
        return newSchedule;
    }

    public static int getSnapshotNum(Schedule schedule) {
        return schedule.getRetentionPolicy().getLatestCopies();
    }

    public static SnapshotSchedule constructNewHyperCDPSchedule(ProtectGroup protectGroup, String devSn, Schedule schedule) {
        if (SnapshotScheduleUtil.isExistsSecondSchedule(schedule)) {
            SnapshotSchedule snapshotSchedule = new SnapshotSchedule();
            int snapshotNum = SnapshotScheduleUtil.getSnapshotNum(schedule);
            String scheduleName = "RD_CDP_" + System.currentTimeMillis();
            snapshotSchedule.setName(scheduleName);
            snapshotSchedule.setSnapshotMaxNum(Integer.valueOf(snapshotNum));
            snapshotSchedule.setDevSn(devSn);
            snapshotSchedule.setFrequencyValue(Long.valueOf(schedule.getPeriodInterval()));
            snapshotSchedule.setScheduleType(SnapshotSchedule.SCHEDULE_TYPE.HYPERCDP.getValue());
            SnapshotScheduleUtil.putReplicaRetentionToHyperCDPSchedule(snapshotSchedule, schedule.getRetentionPolicy());
            return snapshotSchedule;
        }
        return null;
    }

    public static void putReplicaRetentionToHyperCDPSchedule(SnapshotSchedule snapshotSchedule, RetentionPolicy strategy) {
        int dailyRetention = strategy.getDailyCopies();
        if (dailyRetention > 0) {
            snapshotSchedule.getProps().put("DAYHOURS", "[23]");
            snapshotSchedule.getProps().put("DAYMINUTE", "59");
            snapshotSchedule.getProps().put("DAILYSNAPSHOTNUM", String.valueOf(dailyRetention));
        } else if (dailyRetention == 0) {
            snapshotSchedule.getProps().put("DAYHOURS", "[]");
            snapshotSchedule.getProps().put("DAYMINUTE", "");
            snapshotSchedule.getProps().put("DAILYSNAPSHOTNUM", "0");
        }
        int weeklyRetention = strategy.getWeeklyCopies();
        if (weeklyRetention > 0) {
            snapshotSchedule.getProps().put("WEEKLYDAYS", "[0]");
            snapshotSchedule.getProps().put("STARTTIMEOFWEEK", "23:59");
            snapshotSchedule.getProps().put("WEEKLYSNAPSHOTNUM", String.valueOf(weeklyRetention));
        } else if (weeklyRetention == 0) {
            snapshotSchedule.getProps().put("WEEKLYDAYS", "[]");
            snapshotSchedule.getProps().put("STARTTIMEOFWEEK", "");
            snapshotSchedule.getProps().put("WEEKLYSNAPSHOTNUM", "0");
        }
        int monthlyRetention = strategy.getMonthlyCopyies();
        if (monthlyRetention > 0) {
            snapshotSchedule.getProps().put("MONTHDAYS", "[31]");
            snapshotSchedule.getProps().put("STARTTIMEOFMONTH", "23:59");
            snapshotSchedule.getProps().put("MONTHSNAPSHOTNUM", String.valueOf(monthlyRetention));
        } else if (monthlyRetention == 0) {
            snapshotSchedule.getProps().put("MONTHDAYS", "[]");
            snapshotSchedule.getProps().put("STARTTIMEOFMONTH", "");
            snapshotSchedule.getProps().put("MONTHSNAPSHOTNUM", "0");
        }
    }

    private static void modifySnapshotSchedule(ProtectGroup protectGroup, String devSn, String snapshotScheduleId, Schedule modifySchedule) {
        IStorageSnapshotScheduleManager scheduleManager = StorageSnapshotScheduleManagerProxy.getInstance().getStorageSnapshotMgrByDevId(devSn, modifySchedule.getProtectedType());
        SnapshotScheduleUtil.consistentLuns(protectGroup, scheduleManager, devSn, snapshotScheduleId);
        SnapshotSchedule snapshotSchedule = scheduleManager.query(devSn, snapshotScheduleId);
        if (VerifyUtil.isEmpty((Object)snapshotSchedule)) {
            throw new LegoCheckedException(1073947394L);
        }
        scheduleManager.modify(protectGroup, snapshotSchedule, modifySchedule);
    }

    private static void consistentLuns(ProtectGroup protectGroup, IStorageSnapshotScheduleManager scheduleManager, String devSn, String snapshotScheduleId) {
        SnapshotSchedule schedule = scheduleManager.query(devSn, snapshotScheduleId);
        if (schedule == null) {
            logger.error((Object)"consistent lun error prarm,schedule not exists.");
            throw new LegoCheckedException(201L);
        }
        String id = snapshotScheduleId;
        if (scheduleManager.getSnapshotType() == SnapshotSchedule.SCHEDULE_TYPE.HYPERCDP.getValue()) {
            id = (String)protectGroup.getProps().get("PROP_KEY_LUN_CG_KEY:" + devSn);
        }
        Set arrayLuns = scheduleManager.getExistLunsByScheduleId(devSn, id);
        ArrayList lunIds = new ArrayList();
        ArrayList<String> wwns = new ArrayList<String>();
        IProtectObjectProvider provider = (IProtectObjectProvider)((IProtectObjectProviderDelegate)ServiceLocator.getInstance().getService(IProtectObjectProviderDelegate.class)).getProviderByAppType(protectGroup.getPoType());
        for (Object storageInfo : protectGroup.distinctStorageInfo()) {
            if (scheduleManager.getSnapshotType() == SnapshotSchedule.SCHEDULE_TYPE.HYPERCDP.getValue() && provider.isProtectArchieveLog((ProtectObjectStorageInfo)storageInfo)) continue;
            wwns.add(storageInfo.getLunWWN());
        }
        ((IStorageService)ServiceLocator.getInstance().getService(IStorageService.class)).getStorageResourceByWwn(wwns.toArray(new String[wwns.size()])).forEach(storageResource -> {
            if (storageResource.getDevSn().equals(devSn)) {
                lunIds.add(storageResource.getResourceId());
            }
        });
        HashSet<String> commonLuns = new HashSet<String>();
        for (String lunId : lunIds) {
            if (!arrayLuns.contains(devSn + ":" + lunId)) continue;
            commonLuns.add(lunId);
        }
        ArrayList addLuns = new ArrayList(lunIds);
        addLuns.removeAll(commonLuns);
        List<String> removeLuns = SnapshotScheduleUtil.getLunIds(devSn, arrayLuns);
        removeLuns.removeAll(commonLuns);
        if (!addLuns.isEmpty()) {
            scheduleManager.addLun(devSn, id, addLuns);
        }
        if (!removeLuns.isEmpty()) {
            scheduleManager.removeLun(devSn, id, removeLuns);
        }
    }

    private static List<String> getLunIds(String devSn, Set<String> arrayLuns) {
        ArrayList<String> lunIds = new ArrayList<String>();
        for (String id : arrayLuns) {
            String[] strings = id.split(":");
            String devSn0 = strings[0];
            String lunId0 = strings[1];
            if (!devSn.equals(devSn0)) continue;
            lunIds.add(lunId0);
        }
        return lunIds;
    }

    private static void deleteReplicas(ProtectGroup protectGroup, Schedule schedule) {
        if (protectGroup.getReplicaList() == null) {
            return;
        }
        HashSet<ProtectGroupReplica> replicas = new HashSet<ProtectGroupReplica>();
        Iterator iterator = protectGroup.getReplicaList().iterator();
        while (iterator.hasNext()) {
            ProtectGroupReplica replica = (ProtectGroupReplica)iterator.next();
            if (!ProtectGroupUtil.isLocalStorageReplica((ProtectGroupReplica)replica) || replica.getProtectLocation() != schedule.getProtectLocation() || !ScheduleProtectedType.isSameType((int)replica.getType(), (int)schedule.getProtectedType())) continue;
            replica = ((IReplicaService)ServiceLocator.getInstance().getService(IReplicaService.class)).queryProtectGroupReplicaById(replica.getId());
            replicas.add(replica);
            iterator.remove();
        }
        ProtectGroup pg = null;
        try {
            pg = (ProtectGroup)protectGroup.clone();
            pg.getReplicaList().clear();
            pg.getReplicaList().addAll(replicas);
        }
        catch (CloneNotSupportedException ex) {
            logger.error((Object)"Clone ProtectGroup error.", (Throwable)ex);
        }
        ProtectGroupHelper.getInstance().deleteReplica(pg);
    }

    private static void checkReplicasIsMounted(ProtectGroup protectGroup, Schedule schedule) {
        HashSet<ProtectGroupReplica> set = new HashSet<ProtectGroupReplica>();
        for (ProtectGroupReplica replica : protectGroup.getReplicaList()) {
            if (replica.getProtectLocation() != schedule.getProtectLocation() || !ScheduleProtectedType.isSameType((int)replica.getType(), (int)schedule.getProtectedType())) continue;
            set.add(replica);
        }
        if (ProtectGroupUtil.isReplicaMounted(set)) {
            logger.error((Object)"ProtectGroup( %s ) has replica is mounted.", new Object[]{protectGroup.getUuid()});
            throw new LegoCheckedException(1073948252L);
        }
    }

    public static void enable(ProtectGroup protectGroup, Schedule schedule, boolean enable) {
        String devSn = SnapshotScheduleUtil.getDevSnBySchedule(protectGroup, schedule);
        String snapshotScheduleId = SnapshotScheduleUtil.getScheduleIdFromProtectGroup(protectGroup, devSn);
        IStorageSnapshotScheduleManager scheduleManager = StorageSnapshotScheduleManagerProxy.getInstance().getStorageSnapshotMgrByDevId(devSn, schedule.getProtectedType());
        SnapshotSchedule snapshotSchedule = scheduleManager.query(devSn, snapshotScheduleId);
        if (snapshotSchedule == null) {
            logger.error((Object)"snapshot schedule is null.");
            return;
        }
        scheduleManager.enable(devSn, snapshotScheduleId, enable);
    }
}

