/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.system.cfgdata.database;

import com.huawei.ism.drm.system.cfgdata.database.AESUtil;
import com.huawei.ism.drm.system.cfgdata.database.CmdUtil;
import com.huawei.ism.drm.system.cfgdata.database.GuassDBdumpImpl;
import com.huawei.ism.drm.system.cfgdata.database.ZipUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.LegoConfig;
import java.io.File;

public class GuassDBdumpExtendImpl
extends GuassDBdumpImpl {
    private static final Log logger = LogFactory.getInstance(GuassDBdumpExtendImpl.class);
    private static final String AUTO_BACKUP_FILE = "AutoBackupData.zip";
    private static final String AUTO_BACKUP_PATH_KEY = "autoBackup.path.key";
    private static final String LINUX_DMP = "/usr/local/gaussdb/bin/gs_dump";

    public void executeAutoBackup(String pwd) {
        String osName = System.getProperty("os.name");
        if (osName == null) {
            throw new LegoCheckedException(-1L, "The system property os.name does not exist.");
        }
        this.checkParam();
        String autoBackupPath = LegoConfig.getInstance().getKeyValue(AUTO_BACKUP_PATH_KEY, "/home/ICUser/");
        this.backupLinux(pwd, false, autoBackupPath, AUTO_BACKUP_FILE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File backupLinux(String encryptPwd, boolean isDataAnonymous, String autoBackupPath, String destZipFile) {
        StringBuffer path = new StringBuffer();
        StringBuffer param = new StringBuffer();
        path.append(LINUX_DMP);
        param.append(" -h").append(this.host);
        param.append(" -U").append(this.userName);
        param.append(" -W").append(this.userPass);
        param.append(" -p ").append(this.dbPort);
        param.append(" --pg-format ");
        param.append(this.dbName);
        param.append(" -f ");
        String fileName = exportPath.replace(" ", "\" \"") + this.dbName + ".sql";
        param.append(fileName);
        logger.info((Object)"Linux GUASS Backup is started.", 90160758786816L);
        String cmd = path.toString();
        File sf = null;
        File f = null;
        File tempFile = null;
        File outPut = null;
        File zipFile = null;
        try {
            CmdUtil.runShell((String)cmd, (String[])new String[]{param.toString()});
            sf = new File(fileName);
            if (!sf.exists() || 0L == sf.length()) {
                throw new LegoCheckedException(0x300001L);
            }
            if (isDataAnonymous) {
                tempFile = this.resolveSQLFile(sf);
                zipFile = ZipUtil.getInstance().zipFile(tempFile);
            } else {
                zipFile = ZipUtil.getInstance().zipFile(sf);
            }
            f = AESUtil.getInstance().encryptFile(zipFile, ".zip", encryptPwd);
            this.exportWccKey(encryptPwd);
            outPut = this.getOutPutFile(f, autoBackupPath, destZipFile);
        }
        catch (Exception e) {
            File file;
            try {
                ExceptionUtil.rethrowException((Throwable)e, (String)"backupLinux error:", (long)0x300001L, (String[])new String[0], (Log)logger);
                file = null;
            }
            catch (Throwable throwable) {
                this.deleteTmpFile(sf);
                this.deleteTmpFile(tempFile);
                this.deleteTmpFile(zipFile);
                throw throwable;
            }
            this.deleteTmpFile(sf);
            this.deleteTmpFile(tempFile);
            this.deleteTmpFile(zipFile);
            return file;
        }
        this.deleteTmpFile(sf);
        this.deleteTmpFile(tempFile);
        this.deleteTmpFile(zipFile);
        return outPut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getOutPutFile(File zipFile, String exportPath, String destZipFile) {
        if (zipFile == null || !zipFile.exists()) {
            return null;
        }
        File outFile = null;
        try {
            this.fileList.add(zipFile.getName());
            this.fileList.add("zip2.tmp");
            this.fileList.add("zip1.tmp");
            this.zipOutPutFile(exportPath, exportPath + destZipFile);
            outFile = new File(exportPath + destZipFile);
        }
        catch (Exception e) {
            logger.error((Object)"getCanonicalPath error!", 90160758787071L);
            ExceptionUtil.rethrowException((Exception)e, (String)"getCanonicalPath error!", (long)90160758787071L, null);
        }
        finally {
            this.deleteTmpFile(zipFile);
        }
        return outFile;
    }
}

