/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.system.cfgdata.processor;

import com.huawei.ism.drm.system.cfgdata.sdk.service.IConfigDataBackupService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.core.sdk.util.WccEncryptor;
import java.util.TimerTask;

public class AutoBackupTask
extends TimerTask {
    private static final Log logger = LogFactory.getInstance(AutoBackupTask.class);

    @Override
    public void run() {
        try {
            String encryptPwd = LegoConfig.getInstance().getKeyValue("config.backup.sftp.password.default");
            String decryptPwd = WccEncryptor.decrypt((String)encryptPwd);
            if (VerifyUtil.isEmpty((String)decryptPwd)) {
                logger.error((Object)"Decrypt Pwd error.");
                throw new LegoCheckedException(0x300001L);
            }
            IConfigDataBackupService backupService = (IConfigDataBackupService)ServiceLocator.getInstance().getService(IConfigDataBackupService.class);
            backupService.executeAutoBackupData(decryptPwd);
        }
        catch (Exception e) {
            logger.error((Object)"Auto backup error.", (Throwable)e);
        }
    }
}

