/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.system.syslog;

import com.huawei.ism.drm.constant.coreenum.SyslogEncryptionModeEnum;
import com.huawei.ism.drm.system.syslog.ISyslogWriter;
import com.huawei.ism.drm.system.syslog.TcpBacklogHandler;
import com.huawei.ism.drm.system.syslog.TcpSyslogMessageProcessor;
import com.huawei.ism.drm.system.syslog.ssl.SSLSyslogConfig;
import com.huawei.ism.drm.system.syslog.tcp.TCPSyslogConfig;
import com.huawei.ism.drm.system.thirdservice.sdk.model.LogNotifyServer;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import org.graylog2.syslog4j.SyslogConfigIF;
import org.graylog2.syslog4j.SyslogMessageProcessorIF;
import org.graylog2.syslog4j.SyslogRuntimeException;
import org.graylog2.syslog4j.impl.AbstractSyslogWriter;
import org.graylog2.syslog4j.impl.net.tcp.TCPNetSyslog;
import org.graylog2.syslog4j.impl.net.tcp.TCPNetSyslogConfig;

public class SysLogTcpClient {
    private static final Log logger = LogFactory.getInstance(SysLogTcpClient.class);
    private TCPNetSyslog tcpclient = null;

    public SysLogTcpClient(LogNotifyServer logServer) {
        this.initSyslogClient(logServer);
    }

    private void initSyslogClient(LogNotifyServer logServer) {
        String param = logServer.getProtocalProps();
        JSONObject jsonobj = JSONObject.fromObject((Object)param);
        String ip = jsonobj.getString("ip");
        String port = jsonobj.getString("port");
        String encrytionMode = jsonobj.getString("encryptionMode");
        TCPSyslogConfig tcpconfig = SysLogTcpClient.getTcpConfig(encrytionMode);
        SysLogTcpClient.initTcpConfig(tcpconfig, logServer.getLogType(), ip, port);
        this.tcpclient = SysLogTcpClient.getNetClient(tcpconfig);
        this.tcpclient.initialize(SyslogEncryptionModeEnum.getProtocol((String)encrytionMode), (SyslogConfigIF)tcpconfig);
        this.tcpclient.getWriter().setThread(null);
        this.tcpclient.setMessageProcessor((SyslogMessageProcessorIF)new TcpSyslogMessageProcessor());
    }

    private static void initTcpConfig(TCPSyslogConfig tcpconfig, String logType, String ip, String port) {
        tcpconfig.setThreaded(false);
        tcpconfig.setLocalName("eReplication");
        tcpconfig.setCacheHostAddress(false);
        TcpBacklogHandler backHandler = new TcpBacklogHandler();
        backHandler.setLogType(logType);
        tcpconfig.addBackLogHandler(backHandler);
        tcpconfig.setPort(Integer.parseInt(port));
        tcpconfig.setHost(ip);
        tcpconfig.setMaxMessageLength(0x200000);
        tcpconfig.setThrowExceptionOnWrite(true);
    }

    public void log(int level, String message) {
        this.tcpclient.log(level, message);
    }

    public void stop() {
        if (null != this.tcpclient) {
            this.tcpclient.shutdown();
        }
    }

    public static void checkConnection(String ip, String port, String encrytionMode) {
        TCPSyslogConfig config = SysLogTcpClient.getTcpConfig(encrytionMode);
        TCPNetSyslog testConnectionClient = SysLogTcpClient.getNetClient(config);
        SysLogTcpClient.initTcpConfig(config, "test", ip, port);
        String testEncrytionMode = "test_" + encrytionMode;
        testConnectionClient.initialize(testEncrytionMode, (SyslogConfigIF)config);
        try {
            ISyslogWriter w;
            AbstractSyslogWriter writer = testConnectionClient.getWriter();
            if (writer instanceof ISyslogWriter && !(w = (ISyslogWriter)writer).avaliable()) {
                throw new LegoCheckedException(1073947407L);
            }
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("checkSysLogSeverConnection failed ip:" + ip + "  port:" + port + "  protocol:" + encrytionMode));
            throw e;
        }
        finally {
            try {
                testConnectionClient.shutdown();
            }
            catch (SyslogRuntimeException e) {
                logger.error((Object)("Closing syslog failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            }
        }
    }

    private static TCPSyslogConfig getTcpConfig(String encrytionMode) {
        if (SyslogEncryptionModeEnum.TCP.getName().equalsIgnoreCase(encrytionMode)) {
            return new TCPSyslogConfig(false);
        }
        if (SyslogEncryptionModeEnum.SSL_TCP.getName().equalsIgnoreCase(encrytionMode) || SyslogEncryptionModeEnum.TLS_TCP.getName().equalsIgnoreCase(encrytionMode)) {
            return new SSLSyslogConfig(false);
        }
        throw new LegoCheckedException(1073947393L);
    }

    private static TCPNetSyslog getNetClient(TCPNetSyslogConfig config) {
        try {
            return (TCPNetSyslog)config.getSyslogClass().newInstance();
        }
        catch (Exception e) {
            logger.error((Object)("get net client error ." + ExceptionUtil.getErrorMessage((Throwable)e)));
            throw new LegoCheckedException(1073947393L, (Throwable)e);
        }
    }

    public boolean isAvaliable() {
        AbstractSyslogWriter writer = this.tcpclient.getWriter();
        if (writer instanceof ISyslogWriter) {
            ISyslogWriter w = (ISyslogWriter)writer;
            return w.avaliable();
        }
        return false;
    }
}

