/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.system.syslog.ssl;

import com.huawei.ism.drm.system.syslog.ISyslogWriter;
import com.huawei.ism.drm.system.syslog.tcp.TCPSyslogConfig;
import com.huawei.ism.drm.wcc.rest.security.SecureRandomFactory;
import com.huawei.lego.comm.security.BcmX509TrustManager;
import com.huawei.lego.comm.security.IBcmX509TrustHandler;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.io.IOException;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.graylog2.syslog4j.SyslogRuntimeException;
import org.graylog2.syslog4j.impl.net.tcp.ssl.SSLTCPNetSyslogWriter;

public class SSLSyslogWriter
extends SSLTCPNetSyslogWriter
implements ISyslogWriter {
    private static final Log logger = LogFactory.getInstance(SSLSyslogWriter.class);
    private static final long serialVersionUID = 1L;

    protected SocketFactory obtainSocketFactory() {
        SSLSocketFactory factory = null;
        try {
            SSLContext context = this.createSSLContext(null);
            factory = context.getSocketFactory();
        }
        catch (IllegalStateException e) {
            throw new LegoCheckedException(1073947407L, (Throwable)e);
        }
        return factory;
    }

    protected SSLContext createSSLContext(IBcmX509TrustHandler handler) {
        SSLContext sslContext;
        try {
            sslContext = SSLContext.getInstance("TLS");
            TCPSyslogConfig config = (TCPSyslogConfig)this.syslogConfig;
            String ip = config.getHost();
            TrustManager[] tms = new TrustManager[]{new BcmX509TrustManager(ip, Boolean.FALSE.booleanValue())};
            SecureRandom random = SecureRandomFactory.getInstanceStrongWithDRBG();
            sslContext.init(null, tms, random);
        }
        catch (NoSuchAlgorithmException e) {
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
        catch (KeyManagementException e) {
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
        catch (Exception e) {
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
        return sslContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkHandshake(Socket socket) {
        Socket newSocket = null;
        try {
            newSocket = this.createSSLContext(new IBcmX509TrustHandler(){

                public void handle(long phase) {
                    logger.error((Object)"test IBcmX509TrustHandler:%s.", new Object[]{String.valueOf(phase)});
                }
            }).getSocketFactory().createSocket(socket.getInetAddress(), socket.getPort());
            if (newSocket instanceof SSLSocket) {
                SSLSocket sslSocket = (SSLSocket)newSocket;
                sslSocket.setSoTimeout(5000);
                sslSocket.startHandshake();
                boolean bl = true;
                return bl;
            }
            boolean sslSocket = false;
            return sslSocket;
        }
        catch (IOException e) {
            logger.error((Object)"test socket connection failed,error:%s. ", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            boolean bl = false;
            return bl;
        }
        finally {
            if (newSocket != null) {
                try {
                    newSocket.close();
                }
                catch (IOException e) {
                    logger.error((Object)"close socket failed. ");
                }
            }
        }
    }

    protected boolean isAvaliableSocket(Socket socket) {
        if (socket.isClosed()) {
            return false;
        }
        return this.checkHandshake(socket);
    }

    @Override
    public boolean avaliable() {
        Socket socket = null;
        try {
            socket = this.getSocket();
        }
        catch (SyslogRuntimeException e) {
            logger.error((Object)"Avaliable:%s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
        }
        return socket != null && this.isAvaliableSocket(socket);
    }
}

