/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.topo.service.impl;

import com.huawei.ism.array.sdk.model.HvsUnit;
import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.base.sdk.model.Initiator;
import com.huawei.ism.base.sdk.model.StorageNE;
import com.huawei.ism.cbb.base.service.IsmBaseService;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.base.util.SiteUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanBaseService;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryResourceService;
import com.huawei.ism.drm.license.sdk.ILicenseBaseControl;
import com.huawei.ism.drm.license.sdk.ILicenseControl;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupBaseService;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.service.IReplicaBaseService;
import com.huawei.ism.drm.protection.replica.sdk.service.IReplicaService;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.rest.client.RestClient;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteBaseService;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.storage.sdk.model.HyperCloneTargetLun;
import com.huawei.ism.drm.storage.sdk.model.ReplicationGroup;
import com.huawei.ism.drm.storage.sdk.model.ReplicationLink;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.sdk.model.ReplicationRelation;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.ism.drm.storage.sdk.service.IStorageBaseService;
import com.huawei.ism.drm.storage.sdk.service.IStorageResourceBaseService;
import com.huawei.ism.drm.storage.sdk.service.IStorageResourceService;
import com.huawei.ism.drm.storage.sdk.service.IStorageService;
import com.huawei.ism.drm.storage.service.router.StorageResourceServiceRouter;
import com.huawei.ism.drm.topo.builder.GlobalTopoBuilder;
import com.huawei.ism.drm.topo.sdk.context.TopoContext;
import com.huawei.ism.drm.topo.sdk.manager.ITopoBuilderManager;
import com.huawei.ism.drm.topo.sdk.manager.ITopoResourceManager;
import com.huawei.ism.drm.topo.sdk.model.ReplicationLinkTopoData;
import com.huawei.ism.drm.topo.sdk.model.SiteLink;
import com.huawei.ism.drm.topo.sdk.model.Topo;
import com.huawei.ism.drm.topo.sdk.service.IDrmTopoBaseService;
import com.huawei.ism.drm.topo.sdk.service.IDrmTopoService;
import com.huawei.ism.drm.topo.service.impl.TopoPollerManagerImpl;
import com.huawei.ism.drm.topo.service.impl.TopoResourceManagerImpl;
import com.huawei.ism.drm.topo.utils.TooltipUtil;
import com.huawei.ism.drm.topo.utils.TopoBuildUtil;
import com.huawei.ism.drm.topo.utils.TopoServiceUtil;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.ism.unistor.sdk.model.VstoreHyperMetroPair;
import com.huawei.lego.cbb.i18n.sdk.I18nMgr;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.twaver.DataBox;
import com.huawei.twaver.ElementBox;
import com.huawei.twaver.IData;
import com.huawei.twaver.IElement;
import com.huawei.twaver.Link;
import com.huawei.twaver.Node;
import com.huawei.twaver.XMLSerializer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.NativeQuery;
import org.springframework.dao.DataAccessException;

@Service(name="com.huawei.ism.drm.topo.sdk.service.IDrmTopoService", desc="", interfaceClass=IDrmTopoService.class)
public class TopoServiceImpl
extends IsmBaseService
implements IDrmTopoService {
    private static final int POLL_PERIOD_TWO_MINUTE = 120;
    private static final String STR_POLL_PERIOD_HALF_MINUTE = "30";
    private static final String STR_POLL_PERIOD_ONE_MINUTE = "60";
    private static final String STR_POLL_PERIOD_TWO_MINUTE = "120";
    private static final String STR_POLL_PERIOD_FIVE_MINUTE = "300";
    private static final String STR_POLL_PERIOD_TEN_MINUTE = "600";
    private static final String STR_POLL_PERIOD_THIRTY_MINUTE = "1800";
    private static final String POLL_PERIOD_HALF_MINUTE_INDEX = "0";
    private static final String POLL_PERIOD_ONE_MINUTE_INDEX = "1";
    private static final String POLL_PERIOD_TWO_MINUTE_INDEX = "2";
    private static final String POLL_PERIOD_FIVE_MINUTE_INDEX = "3";
    private static final String POLL_PERIOD_TEN_MINUTE_INDEX = "4";
    private static final String POLL_PERIOD_THIRTY_MINUTE_INDEX = "5";
    private static final String TOPO_INDEX_ID = "1000001";
    private static final String TOPO_TIME_INDEX_ID = "1000002";
    private static final int POLL_PERIOD_SET_INTERVAL = 120000;
    private static final int REPLICATION_ASYN_Y_OFFSET = -25;
    private static final String REPLICATION_TYPE = "0";
    private static final String HYPERMETRO_TYPE = "1";
    private static final String CLOUDBACKUP_TYPE = "2";
    private static final Map<String, String> INDEX_PERIOD_MAP = new HashMap<String, String>();
    private static final Map<String, String> PERIOD_INDEX_MAP;
    private static final Log logger;
    private ISiteService siteService;
    private IStorageService storageService;
    private IProtectGroupService protectGroupService;
    private IRecoveryPlanService recoveryPlanService;
    private IStorageResourceService storageResourceService;
    private ITopoBuilderManager topoBuilderManager;
    private ITopoResourceManager topoResourceManager;
    private ILicenseControl licenseControl;
    private IReplicaService replicaService;
    private I18nMgr i18nMgr;

    public I18nMgr getI18nMgr() {
        return this.i18nMgr;
    }

    public void setI18nMgr(I18nMgr i18nMgr) {
        this.i18nMgr = i18nMgr;
    }

    public IStorageResourceService getStorageResourceService() {
        return this.storageResourceService;
    }

    public void setStorageResourceService(IStorageResourceService storageResourceService) {
        this.storageResourceService = storageResourceService;
    }

    public ILicenseControl getLicenseControl() {
        return this.licenseControl;
    }

    public void setLicenseControl(ILicenseControl licenseControl) {
        this.licenseControl = licenseControl;
    }

    public IReplicaService getReplicaService() {
        return this.replicaService;
    }

    public void setReplicaService(IReplicaService replicaService) {
        this.replicaService = replicaService;
    }

    public void setSiteService(ISiteService siteService) {
        this.siteService = siteService;
    }

    public ISiteService getSiteService() {
        return this.siteService;
    }

    public IRecoveryPlanService getRecoveryPlanService() {
        return this.recoveryPlanService;
    }

    public void setRecoveryPlanService(IRecoveryPlanService recoveryPlanService) {
        this.recoveryPlanService = recoveryPlanService;
    }

    public IStorageService getStorageService() {
        return this.storageService;
    }

    public void setStorageService(IStorageService storageService) {
        this.storageService = storageService;
    }

    public void setProtectGroupService(IProtectGroupService protectGroupService) {
        this.protectGroupService = protectGroupService;
    }

    public IProtectGroupService getProtectGroupService() {
        return this.protectGroupService;
    }

    public ITopoResourceManager getTopoResourceManager() {
        return this.topoResourceManager;
    }

    public void setTopoResourceManager(ITopoResourceManager topoResourceManager) {
        this.topoResourceManager = topoResourceManager;
    }

    public List<ReplicationLinkTopoData> getLinkDetailInfo(String devSN, String trgSN) {
        Site site;
        DrResource drStorage;
        String query = "from ReplicationLink as rl where rl.deviceId = ? and rl.remoteArrayId = ?";
        List linkInfos = CommonDAOLocator.getBaseDao().getHibernateTemplate().find(query, new Object[]{devSN, trgSN});
        List<Object> linkDetails = new ArrayList<ReplicationLinkTopoData>();
        if ((linkInfos == null || linkInfos.isEmpty()) && null != (drStorage = this.getDrResource(devSN)) && null != (site = this.siteService.getSiteById(drStorage.getSiteId())) && site.getSiteType() == 1) {
            RestClient client = SiteUtil.initClient((Site)site);
            HashMap<String, String> uriVariabels = new HashMap<String, String>();
            uriVariabels.put("srcDeviceSn", devSN);
            uriVariabels.put("tgtDeviceSn", trgSN);
            linkDetails = client.getForObjects("/ws/replications/{srcDeviceSn}/{tgtDeviceSn}/action/getReplicationLinks", uriVariabels, ReplicationLinkTopoData.class);
            return linkDetails;
        }
        if (linkInfos != null && !linkInfos.isEmpty()) {
            String devName = this.getDevName(devSN);
            String trgName = this.getDevName(trgSN);
            for (ReplicationLink eachLinkInfo : linkInfos) {
                ReplicationLinkTopoData eachLinkDetail = new ReplicationLinkTopoData();
                eachLinkDetail.setLinkId(eachLinkInfo.getLinkId());
                eachLinkDetail.setProductArrayName(devName);
                eachLinkDetail.setRecoveryArrayName(trgName);
                eachLinkDetail.setDeviceId(eachLinkInfo.getDeviceId());
                eachLinkDetail.setRemoteArrayId(eachLinkInfo.getRemoteArrayId());
                eachLinkDetail.setLinkStatus(eachLinkInfo.getLinkStatus());
                eachLinkDetail.setLinkType(eachLinkInfo.getLinkType());
                eachLinkDetail.setLinkIp(eachLinkInfo.getLinkIp());
                linkDetails.add(eachLinkDetail);
            }
        }
        return linkDetails;
    }

    private String getDevName(String devSN) {
        DrResource drStorage = this.getDrResource(devSN);
        if (drStorage != null) {
            return drStorage.getName();
        }
        StorageNE storageArray = this.storageService.getStorageBySn(devSN, null);
        if (storageArray != null) {
            return storageArray.getName();
        }
        return devSN;
    }

    private DrResource getDrResource(String sn) {
        String hql = "from DrResource where deviceSn=?";
        List drResource = CommonDAOLocator.getBaseDao().getHibernateTemplate().find(hql, new Object[]{sn});
        if (drResource == null || drResource.isEmpty()) {
            logger.debug((Object)("The drResource is null, sn=" + sn), 1L);
            return null;
        }
        return (DrResource)drResource.get(0);
    }

    public synchronized void updateTopo(String topoXml) {
        logger.info((Object)"Update Topo Data.", 90160758784000L);
        try {
            List<DrResource> listHosts = this.getAllHostResource();
            for (DrResource eachHost : listHosts) {
                String hostIndexFlag = "<c n='topoHostName'>" + eachHost.getName() + "</c>";
                if (topoXml.indexOf(hostIndexFlag) == -1) continue;
                String hostReplace = "<c n='topoHostName'>HostName</c>";
                topoXml = topoXml.replace(hostIndexFlag, hostReplace);
            }
        }
        catch (Exception e) {
            logger.info((Object)"Deal topoXml exception!", 90160758786873L);
        }
        Topo topoInfo = new Topo();
        topoInfo.setTopoId(TOPO_INDEX_ID);
        topoInfo.setTopoDetail(topoXml);
        topoInfo.setDescription("");
        CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)topoInfo);
    }

    private List<DrResource> getAllHostResource() {
        String hql = "from DrHost";
        List drResources = CommonDAOLocator.getBaseDao().getHibernateTemplate().find(hql, new Object[0]);
        return drResources;
    }

    public String getTopo() {
        String topoXml = "";
        try {
            Topo topoInfo = (Topo)CommonDAOLocator.getBaseDao().getHibernateTemplate().get(Topo.class, (Serializable)((Object)TOPO_INDEX_ID));
            if (topoInfo != null) {
                topoXml = topoInfo.getTopoDetail();
            }
        }
        catch (DataAccessException ex) {
            logger.error((Object)"unable to get sites", (Throwable)ex, 90160758786873L);
        }
        return topoXml;
    }

    public synchronized void updatePollPeriod(String topoPeriodIndex) {
        logger.info((Object)"Update Poll Period.", 90160758784000L);
        long currentTime = System.currentTimeMillis();
        long savedTime = this.getTopoPeriodSaveTime();
        if (currentTime - savedTime < 120000L) {
            throw new LegoCheckedException(1073947404L);
        }
        Topo topoInfo = new Topo();
        topoInfo.setTopoId(TOPO_TIME_INDEX_ID);
        String strPeriod = this.convertIndexToPeriod(topoPeriodIndex);
        topoInfo.setTopoDetail(strPeriod);
        topoInfo.setDescription(String.valueOf(currentTime));
        CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)topoInfo);
        TopoPollerManagerImpl.TopoConnPoolChecker.setConnCheckIntervalTime((long)Integer.parseInt(strPeriod));
    }

    private String convertIndexToPeriod(String topoPeriodIndex) {
        return INDEX_PERIOD_MAP.getOrDefault(topoPeriodIndex, STR_POLL_PERIOD_TWO_MINUTE);
    }

    private String convertPeriodToIndex(String topoPeriod) {
        return PERIOD_INDEX_MAP.getOrDefault(topoPeriod, "2");
    }

    public String getTopoPeriod() {
        String topoPeriod = STR_POLL_PERIOD_TWO_MINUTE;
        try {
            Topo topoInfo = (Topo)CommonDAOLocator.getBaseDao().getHibernateTemplate().get(Topo.class, (Serializable)((Object)TOPO_TIME_INDEX_ID));
            if (topoInfo != null) {
                topoPeriod = topoInfo.getTopoDetail();
            }
        }
        catch (DataAccessException ex) {
            logger.error((Object)"unable to get sites", (Throwable)ex, 90160758786873L);
        }
        return topoPeriod;
    }

    public long getTopoPeriodSaveTime() {
        long topoPeriod = 0L;
        try {
            Topo topoInfo = (Topo)CommonDAOLocator.getBaseDao().getHibernateTemplate().get(Topo.class, (Serializable)((Object)TOPO_TIME_INDEX_ID));
            if (topoInfo != null) {
                topoPeriod = Long.parseLong(topoInfo.getDescription());
            }
        }
        catch (DataAccessException ex) {
            topoPeriod = 0L;
            logger.error((Object)"unable to get Topo Period Save Time", (Throwable)ex, 90160758786873L);
        }
        catch (NumberFormatException e) {
            topoPeriod = 0L;
            logger.error((Object)"unable to get Topo Period Save Time", (Throwable)e, 90160758786986L);
        }
        return topoPeriod;
    }

    public int getPollPeriod() {
        int topoPeriod = 120;
        try {
            topoPeriod = Integer.parseInt(this.getTopoPeriod());
        }
        catch (NumberFormatException e) {
            topoPeriod = 120;
            logger.error((Object)"unable to get poll period", (Throwable)e, 90160758786986L);
        }
        return topoPeriod;
    }

    public List<String> createProtectGroupTopoData(String pgId, long userId, String locale) {
        logger.info((Object)("Create ProtectGroup Topo Data. ProtectGroup ID: " + pgId), 90160758784000L);
        this.topoResourceManager = new TopoResourceManagerImpl(locale, this.i18nMgr);
        TopoContext.setTopoResourceManager((ITopoResourceManager)this.topoResourceManager);
        List resultList = this.topoBuilderManager.createProtectGroupTopoData(pgId);
        return resultList;
    }

    public List<String> createProtectGroupPollData(String pgId, String lunIdList, long userId, String locale) {
        logger.info((Object)("Create ProtectGroup Poll Data. ProtectGroup ID: " + pgId), 90160758784000L);
        ArrayList<String> resultList = new ArrayList<String>();
        ProtectGroup protectGroup = this.getProtectGroupService().getProtectGroupByID(pgId);
        if (VerifyUtil.isEmpty((String)lunIdList) || VerifyUtil.isEmpty((Object)protectGroup)) {
            resultList.add("success");
            resultList.add(new XMLSerializer((DataBox)new ElementBox()).serializeCommon());
            return resultList;
        }
        ElementBox box = new ElementBox();
        TopoResourceManagerImpl topoResourceManagers = new TopoResourceManagerImpl(locale, this.i18nMgr);
        String[] repLinkIds = lunIdList.split(";");
        HashMap<String, List<String>> trgLunIdMap = new HashMap<String, List<String>>();
        HashMap<String, String> linkIdMap = new HashMap<String, String>();
        for (String linkId : repLinkIds) {
            String[] snInfos;
            if (VerifyUtil.isEmpty((String)linkId) || (snInfos = linkId.split(":")).length != 4) continue;
            String srcSn = snInfos[0];
            String trgSn = snInfos[2];
            String trgLunId = snInfos[3];
            String snKey = srcSn + ":" + trgSn;
            linkIdMap.put(snKey + ":" + trgLunId, linkId);
            if (trgLunIdMap.containsKey(snKey)) {
                ((List)trgLunIdMap.get(snKey)).add(trgLunId);
                continue;
            }
            ArrayList<String> trgLunIds = new ArrayList<String>();
            trgLunIds.add(trgLunId);
            trgLunIdMap.put(snKey, trgLunIds);
        }
        if (!VerifyUtil.isEmpty(trgLunIdMap)) {
            HashMap<String, Schedule> snScheduleMap = new HashMap<String, Schedule>();
            this.getScheduleMap(protectGroup, snScheduleMap);
            this.createLinkInfos(box, (ITopoResourceManager)topoResourceManagers, trgLunIdMap, linkIdMap, snScheduleMap);
        }
        resultList.add("success");
        resultList.add(new XMLSerializer((DataBox)box).serializeCommon());
        return resultList;
    }

    private void getScheduleMap(ProtectGroup protectGroup, Map<String, Schedule> snScheduleMap) {
        Set schedules = protectGroup.getTemplate().getSchedules();
        if (VerifyUtil.isEmpty((Collection)schedules)) {
            logger.error((Object)"schedules is empty", 1073947393L);
            return;
        }
        Set pgRepList = protectGroup.getReplicaList();
        for (ProtectGroupReplica pgRep : pgRepList) {
            int repLocation = pgRep.getProtectLocation();
            Schedule sc = TopoServiceUtil.getSchedule((int)repLocation, (Set)schedules, (ProtectGroup)protectGroup);
            if (VerifyUtil.isEmpty((Object)sc)) continue;
            snScheduleMap.put(pgRep.getProductArray() + pgRep.getRecoveryArray(), sc);
        }
    }

    private void createLinkInfos(ElementBox box, ITopoResourceManager topoResourceManagers, Map<String, List<String>> trgLunIdMap, Map<String, String> linkIdMap, Map<String, Schedule> snScheduleMap) {
        HashMap<String, String> tooltipsMap = new HashMap<String, String>();
        this.buildTooltipsMap(topoResourceManagers, snScheduleMap, tooltipsMap);
        this.createLinks(box, topoResourceManagers, trgLunIdMap, linkIdMap, tooltipsMap);
    }

    protected void createLinks(ElementBox box, ITopoResourceManager topoResourceManagers, Map<String, List<String>> trgLunIdMap, Map<String, String> linkIdMap, Map<String, String> tooltipsMap) {
        for (Map.Entry<String, List<String>> eachEntry : trgLunIdMap.entrySet()) {
            String snKey = eachEntry.getKey();
            List<String> trgLunIds = eachEntry.getValue();
            String[] snInfos = snKey.split(":");
            if (snInfos == null || snInfos.length < 2) continue;
            String srcSn = snInfos[0];
            String trgSn = snInfos[1];
            String tooltipExt = tooltipsMap.get(srcSn + trgSn);
            if (srcSn.equals(trgSn)) {
                List targets = TopoBuildUtil.getTrgLunListFromDB((String)srcSn, trgLunIds);
                this.createHyperCloneLink(box, topoResourceManagers, linkIdMap, snKey, tooltipExt, targets);
                continue;
            }
            DrResource srcDev = this.getDrResource(srcSn);
            if (VerifyUtil.isEmpty((Object)srcDev)) {
                logger.debug((Object)("the drresouce is null, sn=" + srcSn));
                continue;
            }
            Site srcSite = this.getSiteService().getSiteById(srcDev.getSiteId());
            List<ReplicationTargetLun> targets = this.getTrgLunListFromDB(srcSite, srcSn, trgSn, trgLunIds);
            String deviceType = ((IRecoveryResourceService)ServiceLocator.getInstance().getService(IRecoveryResourceService.class)).getStorageType(srcSn);
            for (ReplicationTargetLun eachTrgLun : targets) {
                String linkId = linkIdMap.get(snKey + ":" + eachTrgLun.getTgtLunId());
                Link linkInfo = new Link((Object)linkId);
                linkInfo.setStyle("arrow.to", true);
                this.initReplicationToolTipAndColor((IElement)linkInfo, eachTrgLun, deviceType, topoResourceManagers);
                if (!VerifyUtil.isEmpty((String)tooltipExt)) {
                    linkInfo.setToolTip(linkInfo.getToolTip() + "\n" + tooltipExt);
                }
                box.add((IData)linkInfo);
            }
        }
    }

    protected void createHyperCloneLink(ElementBox box, ITopoResourceManager topoResourceManagers, Map<String, String> linkIdMap, String snKey, String tooltipExt, List<HyperCloneTargetLun> targets) {
        for (HyperCloneTargetLun eachTrgLun : targets) {
            String linkId = linkIdMap.get(snKey + ":" + eachTrgLun.getId());
            Link linkInfo = new Link((Object)linkId);
            linkInfo.setStyle("arrow.to", true);
            this.initReplicationToolTipAndColor((IElement)linkInfo, eachTrgLun, topoResourceManagers);
            if (!VerifyUtil.isEmpty((String)tooltipExt)) {
                linkInfo.setToolTip(linkInfo.getToolTip() + "\n" + tooltipExt);
            }
            box.add((IData)linkInfo);
        }
    }

    private void buildTooltipsMap(ITopoResourceManager topoResourceManagers, Map<String, Schedule> snScheduleMap, Map<String, String> tooltipsMap) {
        for (Map.Entry<String, Schedule> eachEntry : snScheduleMap.entrySet()) {
            String snKey = eachEntry.getKey();
            Schedule eachSchedule = eachEntry.getValue();
            String scheduleInfo = TooltipUtil.getScheduleInfo((ITopoResourceManager)topoResourceManagers, (Schedule)eachSchedule);
            if (VerifyUtil.isEmpty((String)scheduleInfo)) continue;
            tooltipsMap.put(snKey, scheduleInfo);
        }
    }

    private void initReplicationToolTipAndColor(IElement link, HyperCloneTargetLun replication, ITopoResourceManager topoResourceManagers) {
        String linkColor;
        String statusDisplay = topoResourceManagers.getText("ism.drm.topo.policy.replication.status");
        statusDisplay = statusDisplay + " ";
        if (replication == null) {
            statusDisplay = statusDisplay + "--";
            String linkColor2 = "0xbbbbbb";
            String linkToolTip = statusDisplay;
            link.setToolTip(linkToolTip);
            link.setStyle("link.color", (Object)linkColor2);
            link.setStyle("arrow.to.color", (Object)linkColor2);
            link.setStyle("arrow.to", (Object)false);
            return;
        }
        link.setStyle("icons.names", (Object)"/theme/recoverydirector/images/topo/ic_asynchronous.png");
        link.setStyle("icons.position", (Object)"top");
        link.setClient("linkType", (Object)"aysnLink");
        int hyperInfoStatus = 0;
        try {
            hyperInfoStatus = TopoServiceUtil.initNewPairStatus((int)Integer.parseInt(replication.getRunningState()));
        }
        catch (Exception e) {
            logger.debug((Object)("initNewPairError, " + replication.getRunningState()), 1L);
            hyperInfoStatus = 0;
        }
        if (this.checkLunPairStatus(hyperInfoStatus)) {
            statusDisplay = statusDisplay + topoResourceManagers.getText("ism.drm.topo.policy.replication.status." + hyperInfoStatus);
            linkColor = topoResourceManagers.getText("ism.drm.topo.policy.replication.color." + hyperInfoStatus);
        } else {
            statusDisplay = statusDisplay + "--";
            linkColor = "0xbbbbbb";
        }
        this.initReplicationToolTip(link, linkColor, statusDisplay, hyperInfoStatus, replication, topoResourceManagers);
    }

    private boolean checkLunPairStatus(int hyperInfoStatus) {
        return hyperInfoStatus >= 1 && hyperInfoStatus <= 6;
    }

    private void initReplicationToolTip(IElement link, String linkColor, String statusDisplay, int hyperInfoStatus, HyperCloneTargetLun replication, ITopoResourceManager topoResourceManagers) {
        if (hyperInfoStatus == 2 && replication.getProcess() >= 0) {
            link.setName(replication.getProcess() + "%");
            link.setStyle("label.yoffset", (Object)-25);
        }
        String nameDisplay = topoResourceManagers.getText("ism.drm.topo.clone.name");
        nameDisplay = nameDisplay + " ";
        boolean isShowName = false;
        if (!VerifyUtil.isEmpty((String)replication.getName())) {
            nameDisplay = nameDisplay + replication.getName();
            isShowName = true;
        }
        String linkToolTip = isShowName ? nameDisplay + "\n" + statusDisplay : statusDisplay;
        link.setToolTip(linkToolTip);
        link.setStyle("link.color", (Object)linkColor);
        link.setStyle("arrow.to.color", (Object)linkColor);
    }

    private void initReplicationToolTipAndColor(IElement link, ReplicationTargetLun replication, String deviceType, ITopoResourceManager topoResourceManagers) {
        String linkToolTip = "";
        String typeDisplay = topoResourceManagers.getText("ism.drm.topo.policy.replication.type");
        typeDisplay = typeDisplay + " ";
        String linkColor = "0xbbbbbb";
        typeDisplay = this.initReplicationToolTipType(link, replication, typeDisplay, topoResourceManagers);
        String statusDisplay = topoResourceManagers.getText("ism.drm.topo.policy.replication.status");
        statusDisplay = statusDisplay + " ";
        if (replication == null) {
            statusDisplay = statusDisplay + "--";
            linkColor = "0xbbbbbb";
            linkToolTip = typeDisplay + "\n" + statusDisplay;
            link.setToolTip(linkToolTip);
            link.setStyle("link.color", (Object)linkColor);
            link.setStyle("arrow.to.color", (Object)linkColor);
            link.setStyle("arrow.to", (Object)false);
            return;
        }
        int hyperInfoStatus = this.initNewPairStatus(deviceType, replication.getPairStatus());
        if (hyperInfoStatus >= 1 && hyperInfoStatus <= 6 || hyperInfoStatus == 110) {
            statusDisplay = statusDisplay + topoResourceManagers.getText("ism.drm.topo.policy.replication.status." + hyperInfoStatus);
            linkColor = topoResourceManagers.getText("ism.drm.topo.policy.replication.color." + hyperInfoStatus);
        } else {
            statusDisplay = statusDisplay + "--";
            linkColor = "0xbbbbbb";
        }
        link.setStyle("link.color", (Object)linkColor);
        link.setStyle("arrow.to.color", (Object)linkColor);
        this.initReplicationToolTip(link, typeDisplay, statusDisplay, hyperInfoStatus, replication, topoResourceManagers);
    }

    private int initNewPairStatus(String type, int pairStatus) {
        if (type == null || type.endsWith("XveUnit") || type.endsWith("HvsUnit") || type.endsWith("FusionStorageUnit")) {
            pairStatus = TopoServiceUtil.initNewPairStatus((int)pairStatus);
        }
        return pairStatus;
    }

    private String initReplicationToolTipType(IElement link, ReplicationTargetLun trgLunInfo, String typeDisplay, ITopoResourceManager topoResourceManagers) {
        if (trgLunInfo == null) {
            typeDisplay = typeDisplay + "--";
            return typeDisplay;
        }
        int mode = TopoServiceUtil.getArrayReplicationMode((ReplicationTargetLun)trgLunInfo);
        if (mode == 2) {
            typeDisplay = typeDisplay + topoResourceManagers.getText("ism.drm.topo.policy.replication.acyn");
            link.setStyle("icons.names", (Object)"/theme/recoverydirector/images/topo/ic_asynchronous.png");
            link.setStyle("icons.position", (Object)"top");
            link.setClient("linkType", (Object)"aysnLink");
        } else {
            typeDisplay = mode == 1 ? typeDisplay + topoResourceManagers.getText("ism.drm.topo.policy.replication.scyn") : typeDisplay + "--";
        }
        return typeDisplay;
    }

    private void initReplicationToolTip(IElement link, String typeDisplay, String statusDisplay, int hyperInfoStatus, ReplicationTargetLun replication, ITopoResourceManager topoResourceManagers) {
        Site srcSite;
        IRecoveryResourceService recoveryResService;
        ReplicationRelation repliationRelation;
        int mode;
        String nameDisplay = topoResourceManagers.getText("ism.drm.topo.replication.name");
        nameDisplay = nameDisplay + " ";
        boolean isShowName = false;
        String speed = this.getTopoResourceManager().getText("ism.drm.topo.replication.speedlevel." + replication.getSpeedLevel());
        ReplicationPair replicationPair = (ReplicationPair)replication.getParentMo();
        String consistendGroupId = "";
        if (replicationPair != null) {
            mode = replicationPair.getReplicationMode();
            if (!VerifyUtil.isEmpty((String)replicationPair.getName())) {
                nameDisplay = nameDisplay + replicationPair.getName();
                isShowName = true;
            }
            consistendGroupId = replicationPair.getConsistentGroupId();
        } else {
            mode = replication.getSyncMode();
            if (!VerifyUtil.isEmpty((String)replication.getName())) {
                nameDisplay = nameDisplay + replication.getName();
                isShowName = true;
            }
        }
        if (!VerifyUtil.isEmpty((String)consistendGroupId) && null != (repliationRelation = (recoveryResService = (IRecoveryResourceService)ServiceLocator.getInstance().getService(IRecoveryResourceService.class)).queryReplication(srcSite = recoveryResService.getStorageRegisteredSite(replication.getDevSn()), replication.getDevSn(), replication.getTgtDevSN(), consistendGroupId, true))) {
            speed = this.getTopoResourceManager().getText("ism.drm.topo.replication.speedlevel." + ((ReplicationGroup)repliationRelation).getSpeedLevel());
        }
        if (mode == 2 && hyperInfoStatus == 2 && replication.getProgressRatio() != null && replication.getProgressRatio() >= 0) {
            link.setName(replication.getProgressRatio() + "%");
            link.setStyle("label.yoffset", (Object)-25);
        }
        String linkToolTip = isShowName ? nameDisplay + "\n" + typeDisplay + "\n" + statusDisplay : typeDisplay + "\n" + statusDisplay;
        linkToolTip = linkToolTip + "\n" + this.topoResourceManager.getText("ism.drm.topo.replication.speedlevel") + speed;
        link.setToolTip(linkToolTip);
    }

    protected List<ReplicationTargetLun> getTrgLunListFromDB(Site site, String srcSN, String trgSN, List<String> listTrgLunID) {
        if (site.getSiteType() == 1) {
            return this.getTargetLunFromRemote(srcSN, trgSN, site, listTrgLunID);
        }
        return TopoBuildUtil.getTrgLunListFromDB((String)srcSN, (String)trgSN, listTrgLunID);
    }

    protected List<ReplicationTargetLun> getTargetLunFromRemote(String srcSN, String trgSN, Site site, List<String> lunIDs) {
        ArrayList<ReplicationTargetLun> targetsFromTrgDev = new ArrayList<ReplicationTargetLun>();
        Map uriVariables = TopoBuildUtil.buildUriVariables((String)srcSN, (String)trgSN, lunIDs);
        try {
            RestClient client = SiteUtil.initClient((Site)site);
            String result = client.get("/ws/replications/{srcDeviceSn}/{tgtDeviceSn}/action/getReplicationTargetLun?tgtLunId={tgtLunId}", uriVariables);
            JSONArray jsonArray = JSONArray.fromObject((Object)result);
            for (Object o : jsonArray) {
                JSONObject obj = JSONObject.fromObject(o);
                ReplicationTargetLun targetLun = (ReplicationTargetLun)JSONObject.toBean((JSONObject)obj, ReplicationTargetLun.class);
                ReplicationPair pair = new ReplicationPair();
                pair.setConsistentGroupId(obj.getString("consistentGroupId"));
                if (null != obj.getString("replicationMode")) {
                    pair.setReplicationMode(Integer.valueOf(obj.getInt("replicationMode")));
                }
                targetLun.setParentMo((ManagedObject)pair);
                targetsFromTrgDev.add(targetLun);
            }
        }
        catch (Exception e) {
            logger.error((Object)("getTrgLunBySnAndLunID failed" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786962L);
        }
        return targetsFromTrgDev;
    }

    public List<String> createGlobalTopoData(long userId, String locale) {
        logger.info((Object)"Create GlobalTopo Topo Data.", 90160758784000L);
        this.topoResourceManager = new TopoResourceManagerImpl(locale, this.i18nMgr);
        GlobalTopoBuilder builder = new GlobalTopoBuilder();
        builder.setSiteService((ISiteBaseService)this.siteService);
        if (this.storageService instanceof IStorageBaseService) {
            builder.setStorageService((IStorageBaseService)this.storageService);
        }
        builder.setResourceManager(this.topoResourceManager);
        builder.setProtectGroupService((IProtectGroupBaseService)this.protectGroupService);
        builder.setRecoveryPlanService((IRecoveryPlanBaseService)this.recoveryPlanService);
        builder.setTopoBuilderManager(this.topoBuilderManager);
        builder.setLicenseControl((ILicenseBaseControl)this.licenseControl);
        builder.setReplicaService((IReplicaBaseService)this.replicaService);
        builder.setStorageResourceService((IStorageResourceBaseService)this.storageResourceService);
        builder.setTopoService((IDrmTopoBaseService)this);
        builder.setUserId(userId);
        TopoContext.setTopoResourceManager((ITopoResourceManager)this.topoResourceManager);
        List resultList = builder.createGlobalTopo();
        resultList.add(this.convertPeriodToIndex(this.getTopoPeriod()));
        return resultList;
    }

    public String getToolBarToolTips(String localeString) {
        String res = "";
        ElementBox box = new ElementBox();
        XMLSerializer serializer = new XMLSerializer((DataBox)box);
        HashMap<String, String> toolBarTipsMap = new HashMap<String, String>();
        toolBarTipsMap.put("zoomin", "ism.tooltip.zoomin");
        toolBarTipsMap.put("zoomout", "ism.tooltip.zoomout");
        toolBarTipsMap.put("zoomreset", "ism.tooltip.zoomreset");
        toolBarTipsMap.put("fullscreen", "ism.tooltip.fullscreen");
        toolBarTipsMap.put("zoombrowse", "ism.tooltip.zoombrowse");
        toolBarTipsMap.put("savetopo", "ism.tooltip.savetopo");
        toolBarTipsMap.put("back", "ism.tooltip.back");
        toolBarTipsMap.put("clear", "ism.tooltip.clear");
        toolBarTipsMap.put("switch", "ism.tooltip.cluster.switch");
        for (Map.Entry entry : toolBarTipsMap.entrySet()) {
            Node node = new Node(entry.getKey());
            node.setToolTip(this.topoResourceManager.getText((String)entry.getValue()));
            TopoServiceUtil.addElementToBox((ElementBox)box, (IData)node);
        }
        res = serializer.serializeCommon();
        return res;
    }

    public void setTopoBuilderManager(ITopoBuilderManager topoBuilderManager) {
        this.topoBuilderManager = topoBuilderManager;
    }

    public ITopoBuilderManager getTopoBuilderManager() {
        return this.topoBuilderManager;
    }

    public synchronized void clearTopo() {
        logger.info((Object)"Clear Topo Data.", 90160758784000L);
        try {
            Topo topoInfo = (Topo)CommonDAOLocator.getBaseDao().getHibernateTemplate().get(Topo.class, (Serializable)((Object)TOPO_INDEX_ID));
            if (topoInfo != null) {
                CommonDAOLocator.getBaseDao().getHibernateTemplate().delete((Object)topoInfo);
            }
        }
        catch (DataAccessException ex) {
            logger.error((Object)"Clear Topo Data Error.", (Throwable)ex, 90160758786873L);
        }
    }

    public ProtectObjectStorageInfo getProtectObjectStorageInfoByPgId(String pgId) {
        ProtectObjectStorageInfo poStorageInfo = new ProtectObjectStorageInfo();
        ProtectGroup pg = this.protectGroupService.getProtectGroupByID(pgId);
        if (null == pg) {
            logger.error((Object)("pg is null: " + pgId));
            return poStorageInfo;
        }
        ProtectObject po = (ProtectObject)CommonUtil.getFirstElement((Collection)pg.getPolist());
        if (null == po) {
            logger.error((Object)("po is null: " + pgId));
            return poStorageInfo;
        }
        poStorageInfo = (ProtectObjectStorageInfo)CommonUtil.getFirstElement((Collection)po.getUsedStorageResourceSet());
        if (null == poStorageInfo) {
            logger.error((Object)("poStorageInfo is null: " + po.getUuid()));
            poStorageInfo = new ProtectObjectStorageInfo();
        }
        return poStorageInfo;
    }

    public List<Initiator> getConnectInitiators(String devSn, String hostSn) {
        List<Initiator> filtInitiators = new ArrayList<Initiator>();
        if (VerifyUtil.isEmpty((String)devSn) || VerifyUtil.isEmpty((String)hostSn)) {
            return filtInitiators;
        }
        DrResource drStorage = this.getDrResource(devSn);
        if (VerifyUtil.isEmpty((Object)drStorage)) {
            return filtInitiators;
        }
        Site site = this.siteService.getSiteById(drStorage.getSiteId());
        if (VerifyUtil.isEmpty((Object)site)) {
            return filtInitiators;
        }
        if (site.getSiteType() == 1) {
            this.getConnectInitiatorsFromRemote(devSn, hostSn, filtInitiators, site);
            return filtInitiators;
        }
        DrResource drHost = this.getDrResource(hostSn);
        if (VerifyUtil.isEmpty((Object)drHost)) {
            return filtInitiators;
        }
        List initiators = this.storageResourceService.getArrayInitiators(devSn, null);
        if (VerifyUtil.isEmpty((Collection)initiators)) {
            return filtInitiators;
        }
        filtInitiators = this.getConnectInitiators(drHost, initiators);
        return filtInitiators;
    }

    private void getConnectInitiatorsFromRemote(String devSn, String hostSn, List<Initiator> filtInitiators, Site site) {
        RestClient client = SiteUtil.initClient((Site)site);
        HashMap<String, String> uriVariabels = new HashMap<String, String>();
        uriVariabels.put("devSn", devSn);
        uriVariabels.put("hostSn", hostSn);
        try {
            String result = client.get("/ws/storages/{devSn}/hostinitiators?hostSn={hostSn}", uriVariabels);
            JSONArray jsonArray = JSONArray.fromObject((Object)result);
            if (null != jsonArray && jsonArray.size() > 0) {
                Iterator it = jsonArray.iterator();
                while (it.hasNext()) {
                    JSONObject jsonObject = JSONObject.fromObject(it.next());
                    Initiator initiator = new Initiator();
                    initiator.setUuid(jsonObject.getString("uuid"));
                    initiator.setIdentity(jsonObject.getString("identity"));
                    initiator.setHbaType(jsonObject.getString("hbaType"));
                    initiator.setHealthStatus(Integer.valueOf(jsonObject.getInt("healthStatus")));
                    initiator.setRunningStatus(Integer.valueOf(jsonObject.getInt("runningStatus")));
                    filtInitiators.add(initiator);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("getConnectInitiators failed, deviceSn: " + devSn + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786962L);
        }
    }

    private List<Initiator> getConnectInitiators(DrResource resource, List<Initiator> arrayInitiators) {
        ArrayList<Initiator> initiators = new ArrayList<Initiator>();
        try {
            String hostExt = resource.getExtProperty();
            if (VerifyUtil.isEmpty((String)hostExt)) {
                return initiators;
            }
            JSONObject hostExtInfo = JSONObject.fromObject((Object)hostExt);
            if (VerifyUtil.isEmpty((Map)hostExtInfo)) {
                return initiators;
            }
            JSONArray hostInitiators = JSONArray.fromObject((Object)hostExtInfo.get("HBA"));
            if (VerifyUtil.isEmpty((Collection)hostInitiators)) {
                return initiators;
            }
            Iterator it = hostInitiators.iterator();
            block2: while (it.hasNext()) {
                JSONObject initiator = JSONObject.fromObject(it.next());
                String initiatorId = initiator.getString("IDENTITY");
                for (Initiator eachInitiator : arrayInitiators) {
                    if (!initiatorId.equalsIgnoreCase(eachInitiator.getIdentity())) continue;
                    eachInitiator.setParentMo(null);
                    initiators.add(eachInitiator);
                    continue block2;
                }
            }
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("Unable to get initiator, HostSn: " + resource.getDeviceSn()), (Throwable)e, 90160758786873L);
        }
        return initiators;
    }

    public List<SiteLink> getSiteLinks(List<ProtectGroup> protectGroups) {
        List<SiteLink> allPgSitesRelation = new LinkedList<SiteLink>();
        protectGroups = this.setPgPolicyTemplate(protectGroups);
        allPgSitesRelation = this.getSanHyperMetroSites(protectGroups, allPgSitesRelation);
        for (ProtectGroup pg : protectGroups) {
            List<SiteLink> siteLink = this.getProtectGroupSites(pg);
            allPgSitesRelation.addAll(siteLink);
        }
        allPgSitesRelation = this.removeDuplicationRelation(allPgSitesRelation);
        return allPgSitesRelation;
    }

    private List<SiteLink> getProtectGroupSites(ProtectGroup pg) {
        List<SiteLink> sitesRelationList = new ArrayList<SiteLink>();
        sitesRelationList = this.getReplicationSites(pg, sitesRelationList);
        sitesRelationList = this.getCloudSites(pg, sitesRelationList);
        sitesRelationList = this.getNasHyperMetroSites(pg, sitesRelationList);
        return sitesRelationList;
    }

    private List<SiteLink> getReplicationSites(ProtectGroup pg, List<SiteLink> sitesRelationList) {
        Set schedules = pg.getTemplate().getSchedules();
        if (VerifyUtil.isEmpty((Collection)schedules)) {
            return sitesRelationList;
        }
        List<Integer> repProtectedTypes = Arrays.asList(1, 3, 4, 5, 6, 35, 36, 18, 20, 23, 24, 26, 27);
        schedules.stream().forEach(schedule -> {
            int protectedType = schedule.getProtectedType();
            if (repProtectedTypes.contains(protectedType)) {
                String sourceSiteId = schedule.getSourceSiteId();
                String targetSiteId = schedule.getTargetSiteId();
                if (VerifyUtil.isEmpty((String)sourceSiteId) || VerifyUtil.isEmpty((String)targetSiteId)) {
                    return;
                }
                String[] sourceSitesId = sourceSiteId.split(":");
                if (schedule.getProtectLocation() == DrmEnumDefine.ProtectLocation.C_C.getValue() && sourceSitesId.length == 2) {
                    Arrays.stream(sourceSitesId).forEach(siteId -> {
                        SiteLink sitRelationLink = this.buildSiteLinkParam((String)siteId, targetSiteId, "0");
                        sitesRelationList.add(sitRelationLink);
                    });
                } else {
                    SiteLink sitRelationLink = this.buildSiteLinkParam(sourceSiteId, targetSiteId, "0");
                    sitesRelationList.add(sitRelationLink);
                }
            }
        });
        return sitesRelationList;
    }

    private SiteLink buildSiteLinkParam(String sourceSiteId, String targetSiteId, String type) {
        SiteLink sitRelationLink = new SiteLink();
        sitRelationLink.setSourceSiteId(sourceSiteId);
        sitRelationLink.setTargetSiteId(targetSiteId);
        sitRelationLink.setType(type);
        return sitRelationLink;
    }

    private List<SiteLink> getCloudSites(ProtectGroup pg, List<SiteLink> sitesRelationList) {
        Set schedules = pg.getTemplate().getSchedules();
        if (VerifyUtil.isEmpty((Collection)schedules)) {
            return sitesRelationList;
        }
        schedules.stream().forEach(schedule -> {
            if (schedule.getProtectedType() != 101 || VerifyUtil.isEmpty((String)schedule.getExtParameterDatas()) || schedule.isEnable() == Boolean.FALSE) {
                return;
            }
            String sourceSiteId = schedule.getSourceSiteId();
            Map extMap = (Map)JSONObject.toBean((String)schedule.getExtParameterDatas(), Map.class);
            String targetSiteId = (String)extMap.get("CLOUD_SITE_ID");
            if (VerifyUtil.isEmpty((String)sourceSiteId) || VerifyUtil.isEmpty((String)targetSiteId)) {
                return;
            }
            SiteLink sitRelationLink = this.buildSiteLinkParam(sourceSiteId, targetSiteId, "2");
            sitesRelationList.add(sitRelationLink);
        });
        return sitesRelationList;
    }

    private List<SiteLink> removeDuplicationRelation(List<SiteLink> allPgSitesRelation) {
        if (VerifyUtil.isEmpty(allPgSitesRelation)) {
            return allPgSitesRelation;
        }
        LinkedList<SiteLink> resultRelation = new LinkedList<SiteLink>();
        allPgSitesRelation.stream().forEach(link -> {
            boolean isRepeat = resultRelation.stream().anyMatch(newLink -> newLink.getSourceSiteId().equals(link.getSourceSiteId()) && newLink.getTargetSiteId().equals(link.getTargetSiteId()) && newLink.getType().equals(link.getType()));
            if (!isRepeat) {
                resultRelation.add((SiteLink)link);
            }
        });
        return resultRelation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getAllPgIdToPtId() {
        Session session = null;
        HashMap<String, String> pgIdToPtIdMap = new HashMap<String, String>();
        String sql = "select pgId,PTID from ti_protectgroup";
        try {
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            NativeQuery query = session.createNativeQuery(sql);
            List pgIdToPtId = query.list();
            pgIdToPtId.stream().forEach(ele -> {
                if (ele instanceof Object[]) {
                    Object[] values = (Object[])ele;
                    String pgId = (String)values[0];
                    String ptId = (String)values[1];
                    pgIdToPtIdMap.put(pgId, ptId);
                }
            });
        }
        catch (Exception e) {
            try {
                logger.error((Object)("Getting pgId and ptId failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession((Session)session);
        }
        DBOperationUtil.closeSession((Session)session);
        return pgIdToPtIdMap;
    }

    private List<ProtectGroup> setPgPolicyTemplate(List<ProtectGroup> protectGroups) {
        if (VerifyUtil.isEmpty(protectGroups)) {
            return protectGroups;
        }
        List policyTemplates = CommonDAOLocator.getBaseDao().createCriteria(PolicyTemplate.class, new Criterion[0]);
        Map<String, String> pgIdToPtIdMap = this.getAllPgIdToPtId();
        if (VerifyUtil.isEmpty(pgIdToPtIdMap) || VerifyUtil.isEmpty((Collection)policyTemplates)) {
            return protectGroups;
        }
        ArrayList<ProtectGroup> pgList = new ArrayList<ProtectGroup>();
        protectGroups.stream().forEach(protectGroup -> {
            String pgId = protectGroup.getUuid();
            Set pgIdSet = pgIdToPtIdMap.keySet();
            if (pgIdSet.contains(pgId)) {
                String ptId = (String)pgIdToPtIdMap.get(pgId);
                policyTemplates.stream().forEach(policyTemplate -> {
                    if (ptId.equals(policyTemplate.getPtId())) {
                        protectGroup.setTemplate(policyTemplate);
                        pgList.add((ProtectGroup)protectGroup);
                    }
                });
            }
        });
        return pgList;
    }

    private List<SiteLink> getSanHyperMetroSites(List<ProtectGroup> protectGroups, List<SiteLink> allPgSitesRelation) {
        if (VerifyUtil.isEmpty(protectGroups)) {
            return allPgSitesRelation;
        }
        HashSet wwnSet = new HashSet();
        protectGroups.forEach(pg -> {
            List poStorageList = pg.distinctStorageInfo();
            if (!VerifyUtil.isEmpty((Collection)poStorageList)) {
                String wwn = ((ProtectObjectStorageInfo)poStorageList.iterator().next()).getLunWWN();
                wwnSet.add(wwn);
            }
        });
        List lunList = CommonDAOLocator.getBaseDao().createCriteria(Lun.class, new Criterion[]{Restrictions.in((String)"wwn", wwnSet)});
        if (VerifyUtil.isEmpty((Collection)lunList)) {
            return allPgSitesRelation;
        }
        HashMap wwnToLun = new HashMap();
        for (Lun lun : lunList) {
            String wwn = lun.getWwn();
            CommUtil.addToMap(wwnToLun, (String)wwn, (Object)lun);
        }
        HashSet hyperMetroDevSnSets = new HashSet();
        HashMap<String, Set<String>> hyperMetroDevSnMap = new HashMap<String, Set<String>>();
        wwnToLun.entrySet().stream().forEach(entry -> {
            List hyperMetroLun = (List)entry.getValue();
            if (hyperMetroLun.size() == 2) {
                HashSet<String> devSnSet = new HashSet<String>();
                Iterator iteratorLun = hyperMetroLun.iterator();
                ArrayList<String> key = new ArrayList<String>();
                while (iteratorLun.hasNext()) {
                    Lun lun = (Lun)iteratorLun.next();
                    String devSn = lun.getDevSn();
                    hyperMetroDevSnSets.add(devSn);
                    key.add(devSn);
                    devSnSet.add(devSn);
                }
                Collections.sort(key);
                hyperMetroDevSnMap.put(((Object)key).toString(), devSnSet);
            }
        });
        List drResourceList = CommonDAOLocator.getBaseDao().createCriteria(DrResource.class, new Criterion[]{Restrictions.in((String)"deviceSn", hyperMetroDevSnSets)});
        if (VerifyUtil.isEmpty((Collection)drResourceList)) {
            return allPgSitesRelation;
        }
        HashMap<String, String> snToSiteId = new HashMap<String, String>();
        for (DrResource drResource : drResourceList) {
            String devSn = drResource.getDeviceSn();
            String siteId = drResource.getSiteId();
            snToSiteId.put(devSn, siteId);
        }
        this.getAllPgSitesRelation(allPgSitesRelation, hyperMetroDevSnMap, snToSiteId);
        return allPgSitesRelation;
    }

    private void getAllPgSitesRelation(List<SiteLink> allPgSitesRelation, Map<String, Set<String>> hyperMetroDevSnMap, Map<String, String> snToSiteId) {
        hyperMetroDevSnMap.entrySet().stream().forEach(entry -> {
            Set devSnSet = (Set)entry.getValue();
            if (devSnSet.size() == 2) {
                Iterator iteratorDevSnSet = devSnSet.iterator();
                String sourceDevSn = (String)iteratorDevSnSet.next();
                String sourceSiteId = (String)snToSiteId.get(sourceDevSn);
                String targetDevSn = (String)iteratorDevSnSet.next();
                String targetSiteId = (String)snToSiteId.get(targetDevSn);
                if (VerifyUtil.isEmpty((String)sourceSiteId) || VerifyUtil.isEmpty((String)targetSiteId)) {
                    return;
                }
                SiteLink sitRelationLink = this.buildSiteLinkParam(sourceSiteId, targetSiteId, "1");
                allPgSitesRelation.add(sitRelationLink);
            }
        });
    }

    private List<SiteLink> getNasHyperMetroSites(ProtectGroup pg, List<SiteLink> sitesRelationList) {
        String drDevSn;
        if (VerifyUtil.isEmpty((Object)pg) || VerifyUtil.isEmpty((Collection)pg.getPolist())) {
            return sitesRelationList;
        }
        ProtectObject po = (ProtectObject)CommonUtil.getFirstElement((Collection)pg.getPolist());
        ProtectObjectStorageInfo poStorageInfo = (ProtectObjectStorageInfo)CommonUtil.getFirstElement((Collection)po.getUsedStorageResourceSet());
        if (DrmEnumDefine.ResourceTypeE.NAS.getValue() != poStorageInfo.getResourceType().intValue()) {
            return sitesRelationList;
        }
        String srcDevSn = poStorageInfo.getResourceProviderSN();
        Site srcSite = this.getSiteService().getSiteByDeviceSn(srcDevSn);
        StorageResourceServiceRouter router = StorageResourceServiceRouter.getInstance();
        String vStorePairId = (String)pg.getProps().get("PROP_KEY_VSTORE_PAIR_ID");
        if (VerifyUtil.isEmpty((String)vStorePairId)) {
            return sitesRelationList;
        }
        VstoreHyperMetroPair vstoreHyperMetroPair = router.getVstoreHyperMetroPairByVstorePairId(srcDevSn, vStorePairId);
        List vstoreHyperMetroPairs = router.getVstoreHyperPair(srcSite.getServerUuid(), vstoreHyperMetroPair);
        Optional<ManagedObject> moOptional = vstoreHyperMetroPairs.stream().map(pair -> pair.getParentMo()).filter(mo -> mo instanceof HvsUnit && !srcDevSn.equals(((HvsUnit)mo).getDevSn())).findFirst();
        String string = drDevSn = moOptional.isPresent() ? ((HvsUnit)moOptional.get()).getDevSn() : "";
        if (VerifyUtil.isEmpty((String)drDevSn)) {
            return sitesRelationList;
        }
        Site drSite = this.getSiteService().getSiteByDeviceSn(drDevSn);
        SiteLink sitRelationLink = this.buildSiteLinkParam(srcSite.getSiteId(), drSite.getSiteId(), "1");
        sitesRelationList.add(sitRelationLink);
        return sitesRelationList;
    }

    static {
        INDEX_PERIOD_MAP.put("0", STR_POLL_PERIOD_HALF_MINUTE);
        INDEX_PERIOD_MAP.put("1", STR_POLL_PERIOD_ONE_MINUTE);
        INDEX_PERIOD_MAP.put("2", STR_POLL_PERIOD_TWO_MINUTE);
        INDEX_PERIOD_MAP.put(POLL_PERIOD_FIVE_MINUTE_INDEX, STR_POLL_PERIOD_FIVE_MINUTE);
        INDEX_PERIOD_MAP.put(POLL_PERIOD_TEN_MINUTE_INDEX, STR_POLL_PERIOD_TEN_MINUTE);
        INDEX_PERIOD_MAP.put(POLL_PERIOD_THIRTY_MINUTE_INDEX, STR_POLL_PERIOD_THIRTY_MINUTE);
        PERIOD_INDEX_MAP = new HashMap<String, String>();
        PERIOD_INDEX_MAP.put(STR_POLL_PERIOD_HALF_MINUTE, "0");
        PERIOD_INDEX_MAP.put(STR_POLL_PERIOD_ONE_MINUTE, "1");
        PERIOD_INDEX_MAP.put(STR_POLL_PERIOD_TWO_MINUTE, "2");
        PERIOD_INDEX_MAP.put(STR_POLL_PERIOD_FIVE_MINUTE, POLL_PERIOD_FIVE_MINUTE_INDEX);
        PERIOD_INDEX_MAP.put(STR_POLL_PERIOD_TEN_MINUTE, POLL_PERIOD_TEN_MINUTE_INDEX);
        PERIOD_INDEX_MAP.put(STR_POLL_PERIOD_THIRTY_MINUTE, POLL_PERIOD_THIRTY_MINUTE_INDEX);
        logger = LogFactory.getInstance(TopoServiceImpl.class);
    }
}

