#!/bin/sh

cd "$(dirname "$0")"
CUR_PATH=`pwd`

xmlFile=/home/ICUser/RDInstalled.xml
BCMPATH=``
if [ -f "$xmlFile" ]; then
    BCMPATH=`cat $xmlFile  | grep installpath | awk -F "\"" '{print $2}'`
    cp $xmlFile ./RDInstalled.xml
fi

LOG_FILE_NAME="$CUR_PATH"/logs/cliPatch.log
source "$CUR_PATH/common.sh"
JRE_HOME="$BCMPATH/Runtime/jre6.0.18/bin/java"
PATCHINFOFILE="patchInfoTmp"
FRONTPATH1="$BCMPATH/Runtime/Tomcat6/Lego-UI-Plat/WEB-INF/lib/"
BACKPATH="$BCMPATH/Runtime/LegoRuntime/plugins/"
BINPATH="$BCMPATH/Runtime/bin/"
PATCHPATH="$BCMPATH/Runtime/patch/"
statFile="$BCMPATH/Runtime/bin/config/conf/startInfo.properties"
SYSUSER=$(cat "$statFile"| grep -v '^#' | grep custom.user.name |awk -F = '{print $2}'| tr -d '\r\n')
TOMCATUSER=$(cat "$statFile" | grep -v '^#' | grep tomcat.user.name |awk -F = '{print $2}'| tr -d '\r\n')
GROUPNAME=$(cat "$statFile" | grep -v '^#' | grep custom.user.group |awk -F = '{print $2}'| tr -d '\r\n')
staus="false"

# 从原lib目录拷贝jar文件补齐安装的lib目录
cp -n "${BINPATH}"/lib/*.jar "${CUR_PATH}"/lib/

chmod 750 "${CUR_PATH}"
chown -Rh root:"${GROUPNAME}" "${CUR_PATH}"
chmod 750 ./log.sh
./log.sh "$0"

sureInstall()
{
    imp=""
    while [ ! "$imp" = "y" ] && [ ! "$imp" = "n" ]
    do
        read -p "Ensure that the system configuration of UltraVR that needs to be upgraded has been exported and saved? (y/n): " imp
    done
    if [ ! "$imp" = "y" ];then
       exit 0
    fi
}

checkSystemIsRunning()
{
    isRunning=false
    export LD_LIBRARY_PATH="$BINPATH/../ha/libs"
    sh "$BINPATH/../ha/module/hamon/script/status_ha_monitor.sh" | grep -iw "normal" &>/dev/null
    if [ $? = 0 ]; then
        isRunning=true
    fi
    ps -ef | grep "^${SYSUSER}" | grep "ha.bin" &>/dev/null
    if [ $? = 0 ]; then
        isRunning=true
    fi

    if [ "$isRunning" = "true" ];then
        Log "System is running, need shutdown."
        CURPATH=`pwd`
        read -p "Before installing patches, you need to shut down UltraVR. Shut it down now? (y/n): " isShut
        if [ "$isShut" = "y" ] || [ "$isShut" = "Y" ];then
            Log "user shutdown eReplication."
            cd "$BINPATH"
            echo y|sh shutdownSystem.sh
            cd "$CURPATH"
        else
            Log "user cacel shutdown eReplication."
            exit 1
        fi
    fi
}

showPatchInfo()
{
    if [ -f $PATCHINFOFILE ];then
        echo ""
        echo "Patch info:"
        awk -F'[\t]' 'BEGIN{printf "%-42s%-10s\n","Version","Status"; printf "---------------------------------------------------\n\n"  }{ printf "%-42s%-10s\n",$1,$2}END{printf "\n";printf "---------------------------------------------------\n\n";}' $PATCHINFOFILE
    fi
}

deleteTmpFile()
{
    if [ -f $PATCHINFOFILE ];then
        rm -f $PATCHINFOFILE
    fi
}

addLogrotateConfig() {
    local logrotateConfigFile=/etc/logrotate.d/rdlogrotate
    if [ -f ${logrotateConfigFile} ];then
        Log "The file ${logrotateConfigFile} already exites."
        return
    fi
    local templateFile="${CUR_PATH}/logrotate/rdlogrotate"
    local runtimePath="${BCMPATH}/Runtime"
    sed -i "s#@{RUNTIME_PATH}#${runtimePath}#g" "${templateFile}" 2>>"$LOG_FILE_NAME"
    if [ $? -eq 0 ];then
        cp "${templateFile}" ${logrotateConfigFile}
        Log "Create file ${logrotateConfigFile} success."
        /usr/sbin/logrotate /etc/logrotate.conf &>/dev/null
    fi
}

startInstall()
{
    /etc/init.d/gaussdb status | grep PID 1>> "$LOG_FILE_NAME" 2>&1
    if [ $? != 0 ];then
        Log "gaussdb is not run, start gaussdb."
        /etc/init.d/gaussdb start 1>> "$LOG_FILE_NAME"  2>&1
        sleep 2
    fi
    UnlockRootScript "$BCMPATH"
    $JRE_HOME -cp "$ALL_CLASS_PATH" com.huawei.lego.cli.climain.CliMain clipatch install 2>>"$LOG_FILE_NAME"
    LockRootScript "$BCMPATH"
    if [ $? -eq 0 ];then
        Log "install patch successfully."
        staus="true"
        chattr -i "$BINPATH/lib/install.jar"
        cp "$CUR_PATH/lib/install.jar" "$BINPATH/lib/install.jar"
        chattr +i "$BINPATH/lib/install.jar"
    fi
    chmod 400 "$BACKPATH"/*.jar &>/dev/null
    chmod 400 "$FRONTPATH1"/*.jar &>/dev/null
    chmod 500 "$BINPATH"/*.sh &>/dev/null
    chmod 550 "$BINPATH"/commfunc.sh &>/dev/null
    chmod 550 "$BINPATH"/dbAction.sh &>/dev/null
    chmod 550 "$BINPATH"/nodeagent_ctl.sh &>/dev/null
    chmod 550 "$BINPATH"/monitorHA.sh &>/dev/null
    chmod 500 "$BINPATH"/../ha/module/hacom/bin/ha.bin &>/dev/null
    chmod 500 "$BACKPATH"/../*.sh &>/dev/null
    chmod 400 "$BACKPATH"/../*.sign &>/dev/null
    chown -h "$SYSUSER:$GROUPNAME" "$BACKPATH"/../*.sh &>/dev/null
    chown -h "$SYSUSER:$GROUPNAME" "$BACKPATH"/../*.sign &>/dev/null
    chown -h "$SYSUSER:$GROUPNAME" "$BACKPATH"/*.jar &>/dev/null
    chown -h "$TOMCATUSER:$GROUPNAME" "$FRONTPATH1"/*.jar &>/dev/null
    chown -Rh "$SYSUSER:$GROUPNAME" "$PATCHPATH" &>/dev/null
    chmod -R 700 "$PATCHPATH" &>/dev/null
    find "$PATCHPATH" -type f -print0 | xargs -0 chmod 400 &>/dev/null
    chage -M 99999 GaussDB &>/dev/null
    addLogrotateConfig
}

checkSystemIsRunning
sureInstall
deleteTmpFile

$JRE_HOME -cp "$ALL_CLASS_PATH" com.huawei.lego.cli.climain.CliMain clipatch getpatchinfo 2>>"$LOG_FILE_NAME"
if [ $? -ne 0 ];then
    Log "get patch info failed."
    exit 0
fi

showPatchInfo
deleteTmpFile

iTmp=""
while [ ! "$iTmp" = "y" ] && [ ! "$iTmp" = "n" ]
do
    read -p "Are you sure you want to install the new patch? (y/n): " iTmp
done
if [ "$iTmp" = "y" ];then
    startInstall
fi

echo ""
if [ $staus = "true" ];then
    sure=""
    while [ ! "$sure" = "y" ] && [ ! "$sure"  = "n" ]
    do
        read -p "Are you sure to start up the software immediately? (y/n):" sure
    done
    if [ "$sure" = "y" ];then
        cd "$BINPATH"
        sh startSystem.sh
    fi
fi


