/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.adapter.handler;

import com.huawei.ism.drm.rest.client.IResponseHandler;
import com.huawei.ism.drm.rest.client.util.ServiceResponse;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;

public class OpenStackResponseHandler
implements IResponseHandler {
    private static final Log LOG = LogFactory.getInstance(OpenStackResponseHandler.class);
    private static final Map<String, Object[]> ERRORMAPPING = new HashMap<String, Object[]>();

    public void handleReponse(ServiceResponse response) {
        if (null == response) {
            LOG.error((Object)"Response is empty");
            throw new LegoCheckedException(1073947647L);
        }
        if (200 == response.getStatusCode() || 201 == response.getStatusCode() || 202 == response.getStatusCode() || 204 == response.getStatusCode()) {
            return;
        }
        this.handleErrorReponse(response);
    }

    private void handleErrorReponse(ServiceResponse response) {
        LOG.info((Object)"Recieve msg error:statuscode=%s, info=%s", new Object[]{response.getStatusCode(), response.getResponseString()});
        String status = String.valueOf(response.getStatusCode());
        Object[] array = ERRORMAPPING.get(status);
        if (VerifyUtil.isEmpty((Object[])array)) {
            throw new LegoCheckedException(0x300001L, new String[]{String.valueOf(response.getStatusCode()), response.getResponseString()}, response.getResponseString());
        }
        if (array.length == 1) {
            throw new LegoCheckedException(((Long)array[0]).longValue());
        }
        String errorKey = (String)array[1];
        if (response.getResponseString().contains(errorKey)) {
            throw new LegoCheckedException(((Long)array[0]).longValue());
        }
        this.adapterErrorResponse(status, response);
    }

    private void adapterErrorResponse(String status, ServiceResponse response) {
        String content = response.getResponseString();
        String adapted = this.adapterErrorResponse(status, content, "{\"NeutronError\":{\"type\":\"/PortNotFound/\"}}");
        if (!content.equals(adapted)) {
            response.getContentData().update(adapted);
        }
    }

    private String adapterErrorResponse(String status, String content, String ... patterns) {
        if (!"404".equals(status)) {
            return content;
        }
        for (String pattern : patterns) {
            if (pattern == null || !this.matchErrorResponse(content, pattern)) continue;
            return "{\"itemNotFound\":" + content + ", \"statusCode\":400}";
        }
        return content;
    }

    public boolean matchErrorResponse(Object origin, Object pattern) {
        if (origin != null && pattern instanceof String) {
            return this.matchErrorResponseAsStringPattern(origin.toString(), (String)pattern);
        }
        if (origin instanceof JSONObject && pattern instanceof JSONObject) {
            return this.matchErrorResponseAsJSONObjectPattern((JSONObject)origin, (JSONObject)pattern);
        }
        if (origin instanceof JSONArray && pattern instanceof JSONArray) {
            return this.matchErrorResponseAsJSONArrayPattern((JSONArray)origin, (JSONArray)pattern);
        }
        return Objects.equals(origin, pattern);
    }

    private boolean matchErrorResponseAsStringPattern(String originString, String patternString) {
        if (patternString.matches("/([^/]|\\\\.)+/")) {
            String regexp = patternString.substring(1, patternString.length() - 1).replaceAll("\\\\(.)", "$1");
            return originString.matches(regexp);
        }
        if (patternString.startsWith("{") && patternString.endsWith("}")) {
            JSONObject originObject = JSONObject.fromObject((Object)originString);
            JSONObject patternObject = JSONObject.fromObject((Object)patternString);
            return this.matchErrorResponseAsJSONObjectPattern(originObject, patternObject);
        }
        if (patternString.startsWith("[") && patternString.endsWith("]")) {
            JSONArray originArray = JSONArray.fromObject((Object)originString);
            JSONArray patternArray = JSONArray.fromObject((Object)patternString);
            return this.matchErrorResponseAsJSONArrayPattern(originArray, patternArray);
        }
        return false;
    }

    private boolean matchErrorResponseAsJSONObjectPattern(JSONObject originObject, JSONObject patternObject) {
        Iterator keys = patternObject.keys();
        while (keys.hasNext()) {
            boolean match;
            Object key = keys.next();
            Object patternValue = patternObject.get(key);
            if (patternValue == null) continue;
            if (patternValue instanceof Boolean && !(match = (Boolean)patternValue == false ^ patternObject.containsKey(key))) {
                return false;
            }
            Object originValue = originObject.get(key);
            if (this.matchErrorResponse(originValue, patternValue)) continue;
            return false;
        }
        return true;
    }

    private boolean matchErrorResponseAsJSONArrayPattern(JSONArray originArray, JSONArray patternArray) {
        int size = patternArray.size();
        for (int i = 0; i < size; ++i) {
            Object patternObject = patternArray.get(i);
            int osize = originArray.size();
            for (int j = 0; j < osize; ++j) {
                Object originObject = originArray.get(j);
                if (!this.matchErrorResponse(originObject, patternObject)) continue;
                return true;
            }
        }
        return false;
    }

    static {
        ERRORMAPPING.put("404", new Object[]{201L, "404 Not Found"});
        ERRORMAPPING.put("401", new Object[]{401L});
    }
}

