/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.adapter.manager.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.huawei.ism.drm.openstack.adapter.util.ClientUtil;
import com.huawei.ism.drm.openstack.adapter.util.JsonUtil;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeInfo;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.RecursiveTask;

public class CinderVolumeTask
extends RecursiveTask<List<VolumeInfo>> {
    private static final long serialVersionUID = -100164329337063103L;
    private static final Log LOG = LogFactory.getInstance(CinderVolumeTask.class);
    private static int threshold = 1000;
    private String urlStr;
    private String tokenId;
    private Map<String, String> paramMap;
    private long start;
    private static long limitNum = LegoConfig.getInstance().getNumber("volume.query.parallel.quantity.config", 3L);

    public CinderVolumeTask(String urlStr, String tokenId, Map<String, String> paramMap, long start) {
        this.urlStr = urlStr;
        this.tokenId = tokenId;
        this.paramMap = paramMap;
        this.start = start;
    }

    @Override
    protected List<VolumeInfo> compute() {
        ArrayList<VolumeInfo> volumeInfoList = new ArrayList<VolumeInfo>();
        long times = 0L;
        if (this.start < 0L) {
            do {
                ArrayList<CinderVolumeTask> openStackVolumsTasks = new ArrayList<CinderVolumeTask>();
                for (long i = times; i < limitNum + times; ++i) {
                    CinderVolumeTask processTask = new CinderVolumeTask(this.urlStr, this.tokenId, this.paramMap, (long)threshold * i);
                    processTask.fork();
                    openStackVolumsTasks.add(processTask);
                }
                for (CinderVolumeTask openStackVolumTask : openStackVolumsTasks) {
                    List volumeInfos = (List)openStackVolumTask.join();
                    if (VerifyUtil.isEmpty((Collection)volumeInfos)) continue;
                    volumeInfoList.addAll(volumeInfos);
                }
                if ((long)volumeInfoList.size() >= (long)threshold * (times += limitNum)) continue;
                return volumeInfoList;
            } while ((long)volumeInfoList.size() <= (long)threshold * times);
            LOG.error((Object)"VolumeInfoList size: %s, more than threshold: %s", new Object[]{volumeInfoList.size(), (long)threshold * times});
            return volumeInfoList;
        }
        HashMap<String, String> filterProp = new HashMap<String, String>();
        if (!VerifyUtil.isEmpty(this.paramMap)) {
            filterProp.putAll(this.paramMap);
        }
        filterProp.put("offset", String.valueOf(this.start));
        filterProp.put("limit", String.valueOf(threshold));
        String respStr = ClientUtil.sendGetRequest(this.urlStr, filterProp, this.tokenId, new int[0]);
        LOG.debug((Object)"Get batch volumes respStr\uff1a%s", new Object[]{respStr});
        return CinderVolumeTask.getVolumesFromRespStr(respStr);
    }

    private static List<VolumeInfo> getVolumesFromRespStr(String respStr) {
        if (VerifyUtil.isEmpty((String)respStr)) {
            LOG.error((Object)"Failed to get batch volumes.response string is empty,request str:%s", new Object[]{respStr});
            throw new LegoCheckedException(0x300001L);
        }
        JsonNode node = JsonUtil.getJsonNodeFromStr(respStr);
        if (VerifyUtil.isEmpty((Object)node) || node.path("volumes").isMissingNode()) {
            LOG.error((Object)"Failed to get batch volumes.bad Request, response str: %s", new Object[]{respStr});
            throw new LegoCheckedException(0x300001L);
        }
        return JsonUtil.jsonArrayToList(node.path("volumes").toString(), VolumeInfo.class);
    }
}

