/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.adapter.manager.impl;

import com.huawei.ism.drm.openstack.adapter.manager.IDrExtendManager;
import com.huawei.ism.drm.openstack.adapter.msg.AsyncTaskResponse;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.LegoConfig;
import java.util.concurrent.Semaphore;

public abstract class DrExtendManagerBase
implements IDrExtendManager {
    private static final Log LOG = LogFactory.getInstance(DrExtendManagerBase.class);
    private static final String DR_EXTEND_POOL_SIZE = "drextend.pool.size";
    private static Semaphore delRepSemp = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AsyncTaskResponse deleteVolumeReplication(String regionUuid, String tokenId, String projUuid, String replicationId, boolean isForce, boolean isSingleDel) {
        if (null == delRepSemp) {
            return this.deleteVolumeReplicationCall(regionUuid, tokenId, projUuid, replicationId, isForce, isSingleDel);
        }
        try {
            delRepSemp.acquire();
            AsyncTaskResponse asyncTaskResponse = this.deleteVolumeReplicationCall(regionUuid, tokenId, projUuid, replicationId, isForce, isSingleDel);
            return asyncTaskResponse;
        }
        catch (InterruptedException e1) {
            LOG.error((Object)("DeleteVolumeReplicationCall delete replica failed:replicaId=" + replicationId));
            ExceptionUtil.rethrowException((Exception)e1, null, (long)1073948410L, null);
        }
        finally {
            delRepSemp.release();
        }
        LOG.error((Object)("DeleteVolumeReplicationCall delete replica failed:replicaId=" + replicationId));
        throw new LegoCheckedException(1073948410L, new String[]{replicationId});
    }

    protected abstract AsyncTaskResponse deleteVolumeReplicationCall(String var1, String var2, String var3, String var4, boolean var5, boolean var6);

    static {
        delRepSemp = new Semaphore((int)LegoConfig.getInstance().getNumber(DR_EXTEND_POOL_SIZE, 8L));
    }
}

