/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.adapter.manager.impl;

import com.huawei.ism.drm.openstack.adapter.manager.ISfsManilaManager;
import com.huawei.ism.drm.openstack.adapter.util.ClientUtil;
import com.huawei.ism.drm.openstack.sdk.bo.Share;
import com.huawei.ism.drm.openstack.sdk.bo.UrlBaseParams;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.tools.OpenStackBasicUtil;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.SecurityUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.om.util.endpointutil.ServiceEndpointUtil;
import java.util.List;
import java.util.Locale;

public class SfsManilaManager
implements ISfsManilaManager {
    private static final Log LOG = LogFactory.getInstance(SfsManilaManager.class);

    @Override
    public List<Share> queryAllShares(UrlBaseParams urlBaseParams) {
        return this.getShares(urlBaseParams);
    }

    @Override
    public Share queryShareById(UrlBaseParams urlBaseParams, String shareId) {
        if (OpenStackBasicUtil.checkUrlBaseParamsIsNull(urlBaseParams) || VerifyUtil.isEmpty((String)shareId)) {
            LOG.error((Object)"QueryShareById failed.parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String endUrlStr = ServiceEndpointUtil.getInstance().getBaseUrl(urlBaseParams.getRegionUuid(), "manila");
        String urlStr = endUrlStr + String.format(Locale.ROOT, OpenstackEnumDefine.RequestUrl.MANILA_SHARES_DETAIL_BY_ID.getUri(), OpenStackCommonUtil.getIdFromUuid(urlBaseParams.getProjectUuid()), shareId);
        String respStr = null;
        try {
            respStr = ClientUtil.sendGetRequest(urlStr, null, urlBaseParams.getTokenId(), new int[0]);
        }
        catch (LegoCheckedException exception) {
            LOG.error((Object)"Query share(%s) error:%s.", new Object[]{shareId, ExceptionUtil.getErrorMessage((Throwable)exception)});
            throw new LegoCheckedException(1073947487L, new String[]{shareId}, (Throwable)exception);
        }
        LOG.info((Object)"Get share success:share=%s", new Object[]{SecurityUtil.desensitization((String)respStr)});
        return OpenStackBasicUtil.checkAndGetInfo(urlStr, respStr, "share", Share.class);
    }

    private List<Share> getShares(UrlBaseParams urlBaseParams) {
        try {
            String endUrlStr = ServiceEndpointUtil.getInstance().getBaseUrl(urlBaseParams.getRegionUuid(), "manila");
            String urlStr = endUrlStr + String.format(Locale.ROOT, OpenstackEnumDefine.RequestUrl.MANILA_SHARES_DETAIL.getUri(), OpenStackCommonUtil.getIdFromUuid(urlBaseParams.getProjectUuid()));
            String respStr = ClientUtil.sendGetRequest(urlStr, urlBaseParams.getTokenId());
            return OpenStackBasicUtil.checkAndGetListInfo(urlStr, respStr, "shares", Share.class);
        }
        catch (Exception e) {
            LOG.error((Object)"Query Shares error: %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException(1073949769L);
        }
    }
}

