/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.cache;

import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.adapter.manager.ICinderManager;
import com.huawei.ism.drm.openstack.adapter.manager.INovaManager;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.sdk.model.FusionSphereOpenStack;
import com.huawei.ism.drm.openstack.sdk.service.IVolumeService;
import com.huawei.ism.drm.openstack.sdk.struct.Project;
import com.huawei.ism.drm.openstack.sdk.struct.Region;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.lego.core.base.thread.Cache;
import com.huawei.lego.core.base.thread.Enhancer;
import com.huawei.lego.core.base.thread.ExecutionService;
import com.huawei.lego.core.base.thread.FutureResult;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class OpenstackCache {
    private static final Log LOG = LogFactory.getInstance(OpenstackCache.class);
    private static final Map<CacheType, com.google.common.cache.Cache<String, Object>> CACHE_MAP = new HashMap<CacheType, com.google.common.cache.Cache<String, Object>>();
    public static final int DEFAULT_EXPIRE_TIME = 1800;

    public static Map<CacheType, com.google.common.cache.Cache<String, Object>> getCacheMap() {
        return CACHE_MAP;
    }

    public static <T> T run(Supplier<T> supplier) {
        return (T)Cache.run(supplier, (Runnable[])new Runnable[0]);
    }

    public static boolean containsKey(CacheType cacheType, String cacheKey) {
        return Cache.contains(OpenstackCache.key(cacheType, cacheKey));
    }

    public static Object getCache(CacheType cacheType, String cacheKey) {
        return OpenstackCache.getCache(cacheType, cacheKey, null);
    }

    public static <T> T getCache(CacheType cacheType, String cacheKey, Supplier<T> supplier) {
        Map.Entry<CacheType, String> key = OpenstackCache.key(cacheType, cacheKey);
        LOG.debug((Object)"Using cache data. key: %s", new Object[]{key});
        Object data = Cache.get(key, supplier);
        if (data == null) {
            LOG.debug((Object)"Not found cache data for key:%s", new Object[]{key});
        }
        return (T)data;
    }

    public static void putCache(CacheType cacheType, String cacheKey, Object value) {
        Map.Entry<CacheType, String> key = OpenstackCache.key(cacheType, cacheKey);
        if (null == value) {
            LOG.debug((Object)"Cache data key: %s is null", new Object[]{key});
            return;
        }
        Cache.set(key, (Object)value);
        LOG.debug((Object)"Cache data key: %s", new Object[]{key});
    }

    private static Map.Entry<CacheType, String> key(CacheType cacheType, String cacheKey) {
        return new AbstractMap.SimpleEntry<CacheType, String>(cacheType, cacheKey);
    }

    public static void preloadVmAndVolume(ProtectGroup protectGroup) {
        OpenstackCache.preloadVmAndVolume(protectGroup.getProps());
    }

    public static void preloadVolume(ProtectGroup protectGroup) {
        OpenstackCache.preloadVolume(protectGroup.getProps());
    }

    public static void preloadVolume(Map<String, String> protectGroupProps) {
        OpenstackCache.preloadVolume(OpenstackCache.buildProjectsFromGroupProps(protectGroupProps).toArray(new Project[0]));
    }

    public static void preloadVmAndVolume(Map<String, String> protectGroupProps) {
        OpenstackCache.preloadVmAndVolume(OpenstackCache.buildProjectsFromGroupProps(protectGroupProps).toArray(new Project[0]));
    }

    private static List<Project> buildProjectsFromGroupProps(Map<String, String> protectGroupProps) {
        String openstackUuid = OpenStackCommonUtil.getOpenstack(true).getUuid();
        String regionUuid = OpenstackCache.getUuid(openstackUuid, protectGroupProps.get("regionId"));
        String projectUuid = OpenstackCache.getUuid(openstackUuid, protectGroupProps.get("projectId"));
        String drRegionUuid = OpenstackCache.getUuid(openstackUuid, protectGroupProps.get("drRegionId"));
        String drProjectUuid = OpenstackCache.getUuid(openstackUuid, protectGroupProps.get("drProjectId"));
        return Arrays.asList(new Project(new Region(regionUuid), projectUuid), new Project(new Region(drRegionUuid), drProjectUuid));
    }

    private static String getUuid(String openstackUuid, String objectUuid) {
        if (objectUuid == null) {
            return null;
        }
        if (objectUuid.contains(":")) {
            return objectUuid;
        }
        return OpenStackCommonUtil.getObjectUuid(openstackUuid, objectUuid);
    }

    public static void preloadVmAndVolume(Project ... projects) {
        OpenstackCache.preloadResources(projects, OpenstackCache::getVmPreloadTask, OpenstackCache::getVolumePreloadTask);
    }

    public static void preloadVolume(Project ... projects) {
        OpenstackCache.preloadResources(projects, OpenstackCache::getVolumePreloadTask);
    }

    private static void preloadResources(Project[] projects, PreLoader ... preloaders) {
        Cache.eval(cache -> OpenstackCache.doPreloadResources(projects, preloaders));
    }

    private static Object doPreloadResources(Project[] projects, PreLoader[] preloaders) {
        LOG.debug((Object)"Begin to preload resources");
        List projectList = Optional.ofNullable(projects).map(Arrays::asList).orElseGet(Collections::emptyList);
        List validProjectList = projectList.stream().filter(Objects::nonNull).filter(project -> !VerifyUtil.isEmpty((String)project.getId()) && !VerifyUtil.isEmpty((Object)project.getRegion()) && !VerifyUtil.isEmpty((String)project.getRegion().getId())).distinct().collect(Collectors.toList());
        LOG.debug((Object)"Preload resources for %s", new Object[]{validProjectList});
        List tasks = Optional.ofNullable(preloaders).map(Arrays::asList).orElseGet(Collections::emptyList).stream().flatMap(preloader -> validProjectList.stream().map(project -> preloader.createLoadTask((Project)project))).collect(Collectors.toList());
        if (tasks.isEmpty()) {
            LOG.debug((Object)"Not preload task to commit");
            return null;
        }
        Enhancer.timeRunnable((String)"execute preload tasks", () -> FutureResult.check((Collection)ExecutionService.commit((List)tasks, (ExecutionService.ExecuteType)ExecutionService.ExecuteType.FAILED_CONTINUE, (int)60, (int)20))).run();
        return null;
    }

    public static void preloadVmAndVolumeAndSnapshot(Map<String, String> protectGroupProps) {
        FusionSphereOpenStack openstack = OpenStackCommonUtil.getOpenstack(true);
        String openstackUuid = openstack.getUuid();
        String regionUuid = OpenstackCache.getUuid(openstackUuid, protectGroupProps.get("regionId"));
        String projectUuid = OpenstackCache.getUuid(openstackUuid, protectGroupProps.get("projectId"));
        OpenstackCache.preloadVmAndVolumeAndSnapshot(new Project(new Region(regionUuid), projectUuid));
    }

    private static void preloadVmAndVolumeAndSnapshot(Project ... projects) {
        OpenstackCache.preloadResources(projects, OpenstackCache::getVmPreloadTask, OpenstackCache::getVolumePreloadTask, OpenstackCache::getSnapshotPreloadTask);
    }

    private static Callable<Object> getVmPreloadTask(Project project) {
        String regionUuid = project.getRegion().getId();
        String projectUuid = project.getId();
        return Enhancer.timeCallable((String)"preload vm resources", () -> {
            String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid);
            INovaManager novaMgr = ManagerFactory.getInstance().getNovaManager(openstackUuid);
            String tokenId = TokenUtil.getInstance().getRegionTokenId(regionUuid, projectUuid);
            return novaMgr.getVms(regionUuid, tokenId, projectUuid);
        });
    }

    private static Callable<Object> getVolumePreloadTask(Project project) {
        String regionUuid = project.getRegion().getId();
        String projectUuid = project.getId();
        return Enhancer.timeCallable((String)"preload volume resources", () -> {
            IVolumeService volumeService = (IVolumeService)ServiceLocator.getInstance().getService(IVolumeService.class);
            return volumeService.getVolumesFromOpenstack(regionUuid, projectUuid);
        });
    }

    private static Callable<Object> getSnapshotPreloadTask(Project project) {
        String regionUuid = project.getRegion().getId();
        String projectUuid = project.getId();
        return Enhancer.timeCallable((String)"preload snapshot resources", () -> {
            String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid);
            ICinderManager cinderMgr = ManagerFactory.getInstance().getCinderManager(openstackUuid);
            String tokenId = TokenUtil.getInstance().getRegionTokenId(regionUuid, projectUuid);
            return cinderMgr.queryVolumeSnapShots(regionUuid, tokenId, projectUuid, null);
        });
    }

    private static interface PreLoader {
        public Callable<Object> createLoadTask(Project var1);
    }

    public static enum CacheType {
        VOLUME_TYPE_LIST,
        IMAGE_META_DATA,
        OPENSTACK_VM_LIST,
        OPENSTACK_VOLUME_LIST,
        OPENSTACK_HYPERVISOR_LIST,
        OPENSTACK_REP_CG_LIST,
        OPENSTACK_SNAPSHOT_LIST,
        OPENSTACK_PROTECTGROUP_DATA;

    }
}

