/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.discovery.processor;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.discover.framework.AbstractContext;
import com.huawei.ism.cbb.discover.framework.IProcessor;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.openstack.sdk.model.DrFusionSphereOpenStack;
import com.huawei.ism.drm.openstack.sdk.model.FusionSphereOpenStack;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.site.util.SiteResourceServiceProxy;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class SiteResourceProcessor
implements IProcessor {
    private static final Log LOG = LogFactory.getInstance(SiteResourceProcessor.class);

    public boolean process(AbstractContext context) {
        FusionSphereOpenStack openstack = (FusionSphereOpenStack)context.getAttribute("OpenStackObj");
        String action = (String)context.getAttribute("DiscoveryType");
        String siteId = (String)context.getAttribute("siteId");
        if (null == openstack) {
            return false;
        }
        if ("register".equals(action)) {
            this.addDrResource(openstack, siteId);
        } else {
            List resources = CommonDAOLocator.getBaseDao().getHibernateTemplate().find("from DrFusionSphereOpenStack where deviceSn = ? and siteId in (select siteId from Site where siteType = 0)", new Object[]{openstack.getSn()});
            if (!VerifyUtil.isEmpty((Collection)resources) && !resources.isEmpty()) {
                DrFusionSphereOpenStack drOpenstack = (DrFusionSphereOpenStack)resources.get(0);
                this.updateDrResource(openstack, drOpenstack);
            }
        }
        Object obj = context.getAttribute("DiscoveryError_" + openstack.getSn());
        LegoCheckedException openStackError = (LegoCheckedException)((Object)obj);
        if (!VerifyUtil.isEmpty((Object)((Object)openStackError))) {
            throw openStackError;
        }
        return true;
    }

    private void addDrResource(FusionSphereOpenStack openstack, String siteId) {
        if (null == siteId || siteId.isEmpty()) {
            LOG.error((Object)"SiteId is null or empty.");
            throw new LegoCheckedException(1073947393L);
        }
        Site site = ((ISiteService)ServiceLocator.getInstance().getService(ISiteService.class)).getSiteById(siteId);
        if (null == site) {
            LOG.error((Object)"Site is null.");
            throw new LegoCheckedException(1073947393L);
        }
        SiteResourceServiceProxy.getInstance().getSiteResourceService("ism.drm.deviceType.fusionsphere.mainType").registerResource(site, new String[]{openstack.getSn()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDrResource(FusionSphereOpenStack openstack, DrFusionSphereOpenStack drOpenstack) {
        ArrayList<DrResource> newDrResources = new ArrayList<DrResource>();
        ArrayList<DrResource> oldDrResources = new ArrayList<DrResource>();
        HashMap<String, String> openstackSiteMap = new HashMap<String, String>();
        this.getUpdateInfo(openstack, drOpenstack, newDrResources, oldDrResources);
        Session session = null;
        Transaction transaction = null;
        try {
            session = CommonDAOLocator.getMoDao().getHibernateTemplate().getSessionFactory().openSession();
            transaction = session.beginTransaction();
            for (DrResource resource : oldDrResources) {
                openstackSiteMap.put(resource.getDeviceSn(), resource.getSiteId());
                session.delete((Object)resource);
            }
            session.saveOrUpdate((Object)drOpenstack);
            for (DrResource resource : newDrResources) {
                String esxSiteId = null == openstackSiteMap.get(resource.getDeviceSn()) ? drOpenstack.getSiteId() : (String)openstackSiteMap.get(resource.getDeviceSn());
                resource.setSiteId(esxSiteId);
                session.save((Object)resource);
            }
            transaction.commit();
        }
        catch (Exception e) {
            try {
                DBOperationUtil.rollbackSession((Session)session);
                LOG.error((Object)("Update DrResource failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession((Session)session);
        }
        DBOperationUtil.closeSession((Session)session);
    }

    private void getUpdateInfo(FusionSphereOpenStack openstack, DrFusionSphereOpenStack drOpenstack, List<DrResource> newDrResources, List<DrResource> oldDrResoures) {
        drOpenstack.setStatus(openstack.getStatus() + "");
        drOpenstack.setName(openstack.getName());
        DrFusionSphereOpenStack newDrOpenstack = (DrFusionSphereOpenStack)SiteResourceServiceProxy.getInstance().getSiteResourceService("ism.drm.deviceType.fusionsphere.mainType").getDrResourceByMo((ManagedObject)openstack);
        if (null == newDrOpenstack) {
            LOG.error((Object)"NewDrOpenstack is null value.");
            throw new LegoCheckedException(1073947393L);
        }
        oldDrResoures.addAll(drOpenstack.getChildResources());
        drOpenstack.getChildResources().clear();
        for (DrResource resource : newDrOpenstack.getChildResources()) {
            resource.setParentDrResource((DrResource)drOpenstack);
            drOpenstack.addChildResource(resource);
            newDrResources.add(resource);
        }
        newDrOpenstack.getChildResources().clear();
    }

    public void postProcess(AbstractContext context) {
    }

    public void clean(AbstractContext context) {
    }

    public String getName() {
        return null;
    }
}

