/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.discovery.validator;

import com.huawei.ism.cbb.util.DiscParamValidator;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.ism.drm.util.ParamChecker;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.nem.discover.sdk.model.DiscParamVilidateResult;
import com.huawei.lego.nem.discover.sdk.model.DiscoveryPolicy;
import com.huawei.lego.nem.discover.sdk.service.IDisParamValidator;
import java.util.Collection;

public class OpenstackDisParamValidator
implements IDisParamValidator {
    private static final Log LOG = LogFactory.getInstance(OpenstackDisParamValidator.class);

    public DiscParamVilidateResult validate(DiscoveryPolicy policy) {
        Site site;
        DiscParamVilidateResult result = new DiscParamVilidateResult();
        String authType = (String)policy.getParamMap().get("authType");
        String version = (String)policy.getParamMap().get("version");
        String uName = (String)policy.getParamMap().get("username");
        String uPWD = (String)policy.getParamMap().get("password");
        String port = (String)policy.getParamMap().get("port");
        String domain = (String)policy.getParamMap().get("domain");
        String regions = (String)policy.getParamMap().get("discoveryregions");
        String siteId = policy.getLocation();
        if (this.verifyParams(authType, version, uName, uPWD, port, domain) && this.checkRegions(regions)) {
            result.setResult(true);
        } else {
            result.setResult(false);
            result.setErrorCode(2099466L);
        }
        if (null == siteId) {
            result.setResult(false);
            result.setErrorCode(2099466L);
        }
        if (null == (site = ((ISiteService)ServiceLocator.getInstance().getService(ISiteService.class)).getSiteById(siteId))) {
            result.setResult(false);
            result.setErrorCode(2099466L);
        }
        return result;
    }

    private boolean checkRegions(String regions) {
        if (VerifyUtil.isEmpty((String)regions)) {
            return true;
        }
        if (!ParamChecker.checkLongText((String)regions)) {
            LOG.warn((Object)"text of regions is too long");
            return false;
        }
        try {
            JSONArray array = JSONArray.fromObject((Object)regions);
            if (VerifyUtil.isEmpty((Collection)array)) {
                return true;
            }
            if (array.size() > 64) {
                LOG.warn((Object)"The number of regions is gt than 64 %s", new Object[]{regions});
                return false;
            }
            for (int i = 0; i < array.size(); ++i) {
                if (ParamChecker.checkGeneralId((String)array.getString(i))) continue;
                LOG.warn((Object)"One region in regions is incorrect: %s", new Object[]{regions});
                return false;
            }
        }
        catch (LegoCheckedException e) {
            LOG.error((Object)("Regions is not a vailid json array." + regions), (Throwable)e);
            return false;
        }
        return true;
    }

    private boolean verifyParams(String authType, String version, String userName, String pwd, String port, String domain) {
        if (DiscParamValidator.stringisNull((String)userName) || DiscParamValidator.stringisNull((String)pwd) || VerifyUtil.isEmpty((String)port) || VerifyUtil.isEmpty((String)domain)) {
            LOG.error((Object)"UserName, pwd, port or domain is empty.", 90160758786989L);
            return false;
        }
        if (!(DiscParamValidator.stringisNull((String)authType) || "KeyStone".equalsIgnoreCase(authType) || "IAM".equalsIgnoreCase(authType))) {
            LOG.error((Object)"AuthType is incorrect.", 90160758786989L);
            return false;
        }
        if (!(DiscParamValidator.stringisNull((String)version) || "6.0".equalsIgnoreCase(version) || "6.1".equalsIgnoreCase(version))) {
            LOG.error((Object)"Version is incorrect.", 90160758786989L);
            return false;
        }
        if (userName.length() > 255 || pwd.length() > 64 || domain.length() > 64) {
            LOG.error((Object)"UserName or pwd is more than max length.", 90160758786989L);
            return false;
        }
        try {
            return CommUtil.checkDrmPortParam((String)port);
        }
        catch (Exception e) {
            LOG.error((Object)("Check domain or port is error . parm:" + port + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
            return false;
        }
    }

    public String getValidatorKey() {
        return "ism.drm.deviceType.fusionsphere.mainTypeism.drm.deviceType.fusionsphereopenstack.subType";
    }
}

