/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.license;

import com.huawei.ism.drm.common.sdk.model.MessageEvent;
import com.huawei.ism.drm.common.sdk.service.IObjectObserver;
import com.huawei.ism.drm.openstack.license.EvsVolumeLicenseControlImpl;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;

public class EvsVolumeLicenseCheckObserverImpl
implements IObjectObserver {
    private static final Log logger = LogFactory.getInstance(EvsVolumeLicenseCheckObserverImpl.class);

    public void before(MessageEvent event) {
        this.doWithEvsVolumePg(event, (pg, messageType) -> {
            EvsVolumeLicenseControlImpl licenseControl = EvsVolumeLicenseControlImpl.getInstance();
            switch (messageType) {
                case 0: {
                    licenseControl.deductLicense((ProtectGroup)pg);
                    break;
                }
                case 2: {
                    pg.setProperty("ATTACHED_VOLUMES", Collections.emptyMap());
                    licenseControl.releaseLicense((ProtectGroup)pg);
                    break;
                }
                default: {
                    logger.debug((Object)"Check license before not for %s type message.", new Object[]{String.valueOf(messageType)});
                }
            }
        });
    }

    public void onFinal(MessageEvent event) {
        this.doWithEvsVolumePg(event, (pg, messageType) -> {
            switch (messageType) {
                case 0: 
                case 2: {
                    EvsVolumeLicenseControlImpl.getInstance().finishLicense(pg.getUuid());
                    break;
                }
                default: {
                    logger.debug((Object)"Check license final not for %s type message.", new Object[]{String.valueOf(messageType)});
                }
            }
        });
    }

    private void doWithEvsVolumePg(MessageEvent event, BiConsumer<ProtectGroup, Integer> action) {
        List pgList = event.getObjectList(ProtectGroup.class);
        if (VerifyUtil.isEmpty((Collection)pgList)) {
            logger.warn((Object)"No protect group in message.");
            return;
        }
        int messageType = event.getMessageType();
        for (ProtectGroup pg : pgList) {
            if (!EvsVolumeLicenseCheckObserverImpl.isEvsVolumePg(pg)) {
                logger.debug((Object)"Protect group %s is not EVS volume type.", new Object[]{pg.getName()});
                continue;
            }
            action.accept(pg, messageType);
        }
    }

    private static boolean isEvsVolumePg(ProtectGroup pg) {
        return pg.getPoType() == 22;
    }

    public String getObserverType() {
        return ProtectGroup.class.getName();
    }

    public int getPriority() {
        return 1;
    }
}

