/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.license;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.license.sdk.ILicenseInter;
import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.adapter.manager.ICinderManager;
import com.huawei.ism.drm.openstack.adapter.manager.INovaManager;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeAttachmentInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeInfo;
import com.huawei.ism.drm.openstack.tools.OpenStackBasicUtil;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.recovery.framework.task.ForkJoinPoolManager;
import com.huawei.lego.cbb.license.sdk.model.FeatureBo;
import com.huawei.lego.cbb.license.sdk.model.LicenseInfoBo;
import com.huawei.lego.cbb.license.sdk.model.ResourceItemBo;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.hibernate.query.NativeQuery;

public class EvsVolumeLicenseControlImpl {
    private static final Log logger = LogFactory.getInstance(EvsVolumeLicenseControlImpl.class);
    private static final EvsVolumeLicenseControlImpl INSTANCE = new EvsVolumeLicenseControlImpl();
    private static final long QUERY_TIMEOUT = 300L;
    private final ILicenseInter licenseService = (ILicenseInter)ServiceLocator.getInstance().getService(ILicenseInter.class);
    private final ConcurrentHashMap<String, WeakReference<ProtectGroup>> tempPgMap = new ConcurrentHashMap();

    public static EvsVolumeLicenseControlImpl getInstance() {
        return INSTANCE;
    }

    public void updatePgVolumeMap(ProtectGroup pg) {
        this.updatePgVolumeMap(pg, Collections.emptySet());
    }

    public void updatePgVolumeMap(ProtectGroup pg, Collection<ProtectObject> excludePos) {
        Map<String, Integer> volumeMap = this.getAttachedVolumeOfPg(pg, excludePos);
        pg.setProperty("ATTACHED_VOLUMES", volumeMap);
    }

    private Map<String, Integer> getAttachedVolumeOfPg(ProtectGroup pg, Collection<ProtectObject> excludePos) {
        List<String> volumeIdList = pg.getPolist().stream().filter(protectObject -> !excludePos.contains(protectObject)).map(ProtectObject::getMoUuid).map(OpenStackBasicUtil::getIdFromUuid).collect(Collectors.toList());
        String openstackUuid = pg.getPoProviderSN();
        ICinderManager cinderManager = ManagerFactory.getInstance().getCinderManager(openstackUuid);
        String regionUuid = pg.getProperty("regionId");
        String projectUuid = pg.getProperty("projectId");
        TokenUtil tokenUtil = TokenUtil.getInstance();
        Map<String, VolumeInfo> volumeInfoMap = cinderManager.queryVolumes(regionUuid, tokenUtil.getTokenId(projectUuid), projectUuid, volumeIdList);
        return this.getAttachedVolumeOfVols(openstackUuid, regionUuid, projectUuid, volumeInfoMap.values());
    }

    private Map<String, Integer> getAttachedVolumeOfVols(String openstackUuid, String regionUuid, String projectUuid, Collection<VolumeInfo> volumeInfos) {
        ConcurrentHashMap<String, Integer> volumeMap = new ConcurrentHashMap<String, Integer>();
        INovaManager novaManager = ManagerFactory.getInstance().getNovaManager(openstackUuid);
        TokenUtil tokenUtil = TokenUtil.getInstance();
        int parallelism = LegoConfig.getInstance().getInt("batch.nova.size", 10);
        ForkJoinPool forkJoinPool = ForkJoinPoolManager.getInstance().createForkJoinPool(parallelism);
        try {
            ((ForkJoinTask)forkJoinPool.submit(() -> volumeInfos.parallelStream().peek(volumeInfo -> volumeMap.put(volumeInfo.getId(), volumeInfo.getSize())).map(VolumeInfo::getAttachments).filter(Objects::nonNull).flatMap(Collection::stream).map(VolumeAttachmentInfo::getServerId).distinct().map(serverId -> OpenStackCommonUtil.getObjectUuid(openstackUuid, serverId)).map(serverUuid -> novaManager.getVolumeAttachInfoList((String)serverUuid, regionUuid, tokenUtil.getTokenId(projectUuid))).flatMap(Collection::stream).filter(info -> !"local".equals(info.getType())).filter(info -> info.getSize() != null).forEach(info -> volumeMap.merge(info.getId(), info.getSize(), Math::max)))).get(300L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            logger.error((Object)"Query attached volumes error: %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException(1073949734L);
        }
        finally {
            forkJoinPool.shutdown();
        }
        return volumeMap;
    }

    public void deductLicense(ProtectGroup newPg) {
        this.putTempPg(newPg);
        try {
            this.checkLicenseEnough(newPg);
        }
        catch (LegoCheckedException e) {
            this.tempPgMap.remove(newPg.getUuid());
            throw e;
        }
    }

    public void releaseLicense(ProtectGroup newPg) {
        this.putTempPg(newPg);
    }

    private void putTempPg(ProtectGroup newPg) {
        if (newPg == null) {
            logger.error((Object)"Protect group is null.");
            throw new LegoCheckedException(-1L);
        }
        if (this.tempPgMap.computeIfPresent(newPg.getUuid(), (pgId, oldVal) -> {
            logger.warn((Object)"Temp info of protect group %s is not clear.", new Object[]{newPg.getName()});
            if (oldVal.get() != null) {
                return oldVal;
            }
            return null;
        }) != null) {
            logger.error((Object)"Protect group %s is in use.", new Object[]{newPg.getName()});
            throw new LegoCheckedException(-1L);
        }
        if (this.tempPgMap.putIfAbsent(newPg.getUuid(), new WeakReference<ProtectGroup>(newPg)) != null) {
            logger.error((Object)"Protect group %s is in use.", new Object[]{newPg.getName()});
            throw new LegoCheckedException(-1L);
        }
    }

    public void finishLicense(String pgId) {
        this.tempPgMap.remove(pgId);
    }

    public void checkLicenseEnough() {
        this.checkLicenseEnough(null);
    }

    private void checkLicenseEnough(ProtectGroup newPg) {
        if (this.licenseService.isBasicVersion()) {
            logger.error((Object)"License is Basic version.");
            throw new LegoCheckedException(1073947430L);
        }
        OptionalInt totalCapacity = this.getTotalCapacity();
        if (!totalCapacity.isPresent()) {
            if (!this.licenseService.isLicenseProbationTimeout()) {
                logger.info((Object)"License is in probation period.");
                return;
            }
            logger.error((Object)"No license is available.");
            throw new LegoCheckedException(1073947451L);
        }
        int usedCapacity = this.getUsedCapacity(newPg);
        logger.debug((Object)"License total capacity is: TiB, used capacity is: %sGiB", new Object[]{String.valueOf(totalCapacity.getAsInt()), String.valueOf(usedCapacity)});
        if (usedCapacity > totalCapacity.getAsInt()) {
            logger.error((Object)"License is not enough.");
            throw new LegoCheckedException(1073947451L);
        }
    }

    private OptionalInt getTotalCapacity() {
        return Optional.ofNullable(this.licenseService.getLicenseNotUpdateUseNum()).map(LicenseInfoBo::getFeaBolst).flatMap(featureBoList -> featureBoList.stream().filter(Objects::nonNull).map(FeatureBo::getReslst).filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).filter(resourceItemBo -> "BOMVOLDRSSWTB".equals(resourceItemBo.getItemName())).findAny()).map(ResourceItemBo::getItemValue).map(Integer::parseInt).map(OptionalInt::of).orElseGet(OptionalInt::empty);
    }

    public int getUsedCapacity() {
        return this.getUsedCapacity(null);
    }

    private int getUsedCapacity(ProtectGroup newPg) {
        Map<String, PgVolume> pgVolumeMap = this.getPgVolumeMap();
        this.tempPgMap.values().stream().map(Reference::get).filter(Objects::nonNull).forEach(pg -> pgVolumeMap.put(pg.getUuid(), new PgVolume((ProtectGroup)pg)));
        if (newPg != null) {
            pgVolumeMap.put(newPg.getUuid(), new PgVolume(newPg));
        }
        Map<String, Integer> volumeMap = pgVolumeMap.values().stream().flatMap(pgVolume -> pgVolume.getVolumeMap().entrySet().stream().map(entry -> new AbstractMap.SimpleEntry(EvsVolumeLicenseControlImpl.getUniVolumeId(pgVolume.getRegionUuid(), (String)entry.getKey()), entry.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, Math::max));
        return volumeMap.values().stream().mapToInt(Integer::intValue).sum();
    }

    private static Map<String, Integer> deserializeVolumeMap(String jsonStr) {
        return VerifyUtil.isEmpty((String)jsonStr) ? Collections.emptyMap() : JSONObject.fromObject((Object)jsonStr).toMap(Integer.class);
    }

    private static String getUniVolumeId(String regionUuid, String volumeId) {
        return OpenStackCommonUtil.getObjectUuid(regionUuid, volumeId);
    }

    private Map<String, PgVolume> getPgVolumeMap() {
        return (Map)CommonDAOLocator.getBaseDao().getHibernateTemplate().execute(session -> {
            NativeQuery query = session.createNativeQuery("select pg.UUID, region_prop.PROPVALUE as region, vols_prop.PROPVALUE as volumes from TI_PROTECTGROUP pg          left join TI_POLICYTEMPLATE pt on pg.PTID = pt.PTID          left join TI_PROTECTGROUP_PROP region_prop                    on pg.PGID = region_prop.PGID and region_prop.PROPNAME = :region_prop_name          left join TI_PROTECTGROUP_PROP vols_prop                    on pg.PGID = vols_prop.PGID and vols_prop.PROPNAME = :vols_prop_name where pg.POTYPE = :po_type   and pt.TYPE = :pt_type");
            query.setParameter("region_prop_name", (Object)"regionId");
            query.setParameter("vols_prop_name", (Object)"ATTACHED_VOLUMES");
            query.setParameter("po_type", (Object)22);
            query.setParameter("pt_type", (Object)56);
            return query.stream().map(PgVolume::fromResult).filter(Optional::isPresent).map(Optional::get).distinct().collect(Collectors.toConcurrentMap(PgVolume::getPgId, pgVolume -> pgVolume));
        });
    }

    public static class PgVolume {
        private final String pgId;
        private final String regionUuid;
        private final Map<String, Integer> volumeMap;

        public PgVolume(String pgId, String regionUuid, Map<String, Integer> volumeMap) {
            this.pgId = pgId;
            this.regionUuid = regionUuid;
            this.volumeMap = volumeMap;
        }

        public PgVolume(ProtectGroup pg) {
            this.pgId = pg.getUuid();
            this.regionUuid = pg.getProperty("regionId");
            this.volumeMap = EvsVolumeLicenseControlImpl.deserializeVolumeMap(pg.getProperty("ATTACHED_VOLUMES"));
        }

        public static Optional<PgVolume> fromResult(Object[] tuple) {
            if (tuple == null || tuple.length != 3 || VerifyUtil.isEmpty((Object)tuple[0]) || VerifyUtil.isEmpty((Object)tuple[1])) {
                logger.warn((Object)"Result from DB is empty, result: %s", new Object[]{Arrays.toString(tuple)});
                return Optional.empty();
            }
            Map volumes = tuple[2] instanceof String ? EvsVolumeLicenseControlImpl.deserializeVolumeMap((String)tuple[2]) : Collections.emptyMap();
            return Optional.of(new PgVolume(tuple[0].toString(), tuple[1].toString(), volumes));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PgVolume pgVolume = (PgVolume)o;
            return Objects.equals(this.getPgId(), pgVolume.getPgId());
        }

        public int hashCode() {
            return Objects.hash(this.getPgId());
        }

        public String getPgId() {
            return this.pgId;
        }

        public String getRegionUuid() {
            return this.regionUuid;
        }

        public Map<String, Integer> getVolumeMap() {
            return this.volumeMap;
        }
    }
}

