/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.protection.action;

import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.drm.openstack.recovery.utils.OpenStackRecoveryTool;
import com.huawei.ism.drm.openstack.sdk.service.IVolumeService;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.action.model.ActionContext;
import com.huawei.ism.drm.protection.framework.engine.action.AbstractBaseProtectAction;
import com.huawei.ism.drm.protection.framework.engine.util.ProtectionJobUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.Date;

public class OpenStackArraySyncMonitorSubAction
extends AbstractBaseProtectAction {
    private static final Log LOG = LogFactory.getInstance(OpenStackArraySyncMonitorSubAction.class);
    private static final long HOUR_2 = 0x6DDD00L;
    private static final long MINUTE_1 = 60000L;
    private static final long ZERO = 0L;
    private long overTime;
    private String regionUuid;
    private String projUuid;
    private String replicatrionUuid;

    public void preExcute(ActionContext context) {
        super.preExcute(context);
        ProtectGroup pg = (ProtectGroup)context.getObject("PG_ENTITY");
        this.regionUuid = (String)pg.getProps().get("regionId");
        this.projUuid = (String)pg.getProps().get("projectId");
        this.replicatrionUuid = OpenStackRecoveryTool.getReplicaCgUuid(pg);
        this.setName("com.huawei.ism.drm.protection.framework.engine.action.ArraySynMonitorSubAction.ReplicationGroup");
        this.setNameParams(OpenStackCommonUtil.getIdFromUuid(this.replicatrionUuid));
        Date date = new Date();
        this.overTime = date.getTime() + 0x6DDD00L;
        Long nextTime = NumberUtil.convertToLong((Object)context.getObject("PG_NEXT_FIRE_TIME"), (long)0L);
        if (!nextTime.equals(NumberUtil.convertToLong((Object)0L))) {
            this.overTime = nextTime - 60000L;
        }
    }

    public boolean doExecute(ActionContext context) {
        LOG.debug((Object)"Sync monitoring.replicaUuid:%s,regionUuid:%s,projUuid:%s", new Object[]{this.replicatrionUuid, this.regionUuid, this.projUuid});
        while (true) {
            int progress;
            if (ProtectionJobUtil.checkWhetherTerminateTask((ActionContext)context)) {
                this.terminateTask();
                return false;
            }
            CommUtil.pauseThread((long)5000L);
            try {
                progress = ((IVolumeService)ServiceLocator.getInstance().getService(IVolumeService.class)).getReplicationSyncProcess(this.regionUuid, this.projUuid, this.replicatrionUuid, true);
            }
            catch (LegoCheckedException e) {
                LOG.error((Object)("Synchronize replication failed. cgid:" + this.replicatrionUuid + ",regionUuid:" + this.regionUuid + "projUuid:" + this.projUuid), (Throwable)e, 90160758784001L);
                this.setDetail(e.getErrorMessageKey());
                this.setDetailParams(this.constructParams(e.getParameters()));
                return false;
            }
            catch (Exception e) {
                LOG.error((Object)("Synchronize replication failed. cgid:" + this.replicatrionUuid + ",regionUuid:" + this.regionUuid + "projUuid:" + this.projUuid + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
                this.setDetail("lego.err.1073948448");
                return false;
            }
            if (100 == progress) {
                LOG.info((Object)"Synchronize replication success. ", 90160758784000L);
                this.setDetail("com.huawei.ism.drm.protection.framework.engine.action.ArraySynMonitorSubAction.Synchronization.Complete");
                return true;
            }
            long curTime = System.currentTimeMillis();
            if (curTime > this.overTime) {
                LOG.error((Object)"Synchronize replication time out. ", 90160758784001L);
                this.setDetail("lego.err.1073948744");
                return false;
            }
            this.setDetail("com.huawei.ism.drm.protection.framework.engine.action.ArraySynMonitorSubAction.Synchronization.Progress");
            this.setDetailParams(progress + "%");
        }
    }

    private void terminateTask() {
        try {
            ((IVolumeService)ServiceLocator.getInstance().getService(IVolumeService.class)).splitReplication(this.regionUuid, this.projUuid, this.replicatrionUuid, true);
        }
        catch (Exception e) {
            LOG.error((Object)("split replication failed. cgid:" + this.replicatrionUuid + ",regionUuid:" + this.regionUuid + "projUuid:" + this.projUuid + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
        }
    }
}

