/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.protection.observer;

import com.huawei.ism.drm.openstack.adapter.manager.impl.DrExtendManager;
import com.huawei.ism.drm.openstack.adapter.util.JsonUtil;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.protection.service.DelReplicationTask;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaInfo;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaPairInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeReplicationCgInfo;
import com.huawei.ism.drm.openstack.sdk.service.IVolumeService;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.lego.core.base.thread.ExecutionService;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;

public class EvsProtectGroupOperateHandler {
    private static final Log logger = LogFactory.getInstance(EvsProtectGroupOperateHandler.class);
    private IVolumeService volumeService;
    private DrExtendManager drExtendManager = new DrExtendManager();

    public void setVolumeService(IVolumeService volumeService) {
        this.volumeService = volumeService;
    }

    public EvsProtectGroupOperateHandler setDrExtendManager(DrExtendManager drExtendManager) {
        this.drExtendManager = drExtendManager;
        return this;
    }

    public void beforeDelete(ProtectGroup protectGroup) {
        String projectId = (String)protectGroup.getProps().get("projectId");
        String regionId = (String)protectGroup.getProps().get("regionId");
        String drProjectId = (String)protectGroup.getProps().get("drProjectId");
        String drRegionId = (String)protectGroup.getProps().get("drRegionId");
        String cgId = (String)protectGroup.getProps().get("replicaCgUuid");
        String drCgId = (String)protectGroup.getProps().get("drReplicaCgUuid");
        String splitFlag = (String)protectGroup.getProps().get("PG_PROP_REPLICATION_SPLIT_KEY");
        String tokenId = TokenUtil.getInstance().getRegionTokenId(regionId, projectId);
        VolumeReplicationCgInfo cg = this.drExtendManager.queryVolumeReplicationCG(regionId, tokenId, projectId, cgId);
        if (cg == null || cg.isMasterFlag()) {
            OpenStackCommonUtil.deleteCg(this.volumeService, projectId, regionId, cgId, splitFlag);
            OpenStackCommonUtil.deleteCg(this.volumeService, drProjectId, drRegionId, drCgId, splitFlag);
        } else {
            OpenStackCommonUtil.deleteCg(this.volumeService, drProjectId, drRegionId, drCgId, splitFlag);
            OpenStackCommonUtil.deleteCg(this.volumeService, projectId, regionId, cgId, splitFlag);
        }
        List deleteReplicasTaskList = protectGroup.getPolist().stream().map(protectObject -> this.buildDeleteReplicaTask(protectGroup, (ProtectObject)protectObject)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        OpenStackCommonUtil.executeTask(deleteReplicasTaskList, ExecutionService.ExecuteType.FAILED_ABORT, true);
    }

    private Optional<Callable<PoReplicaPairInfo>> buildDeleteReplicaTask(ProtectGroup protectGroup, ProtectObject protectObject) {
        String replicaInfoStr = (String)protectObject.getProps().get("replicationInfo");
        PoReplicaInfo replicaInfo = JsonUtil.jsonToBean(replicaInfoStr, PoReplicaInfo.class);
        if (replicaInfo == null) {
            logger.error((Object)"Json to bean error, replicaInfoStr: %s, protectGroup name: %s, protectObject name: %s.", new Object[]{replicaInfoStr, protectGroup.getName(), protectObject.getName()});
            return Optional.empty();
        }
        if (VerifyUtil.isEmpty((Collection)replicaInfo.getPairInfos())) {
            logger.error((Object)"Pair info of protectObject is empty, protectGroup name: %s, protectObject name: %s.", new Object[]{replicaInfoStr, protectGroup.getName(), protectObject.getName()});
            return Optional.empty();
        }
        PoReplicaPairInfo pairInfo = (PoReplicaPairInfo)replicaInfo.getPairInfos().get(0);
        boolean shouldDeleteDrVolume = Boolean.parseBoolean(protectObject.getProps().getOrDefault("SHOULD_DELETE_DR_VOLUME", Boolean.FALSE.toString()));
        return Optional.of(DelReplicationTask.builder(this.volumeService, protectGroup, pairInfo).shouldDeleteDrVolume(shouldDeleteDrVolume).build());
    }
}

