/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.protection.observer;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.common.sdk.model.DRMObject;
import com.huawei.ism.drm.common.sdk.model.MessageEvent;
import com.huawei.ism.drm.common.sdk.service.IObjectObserver;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.adapter.manager.ISfsFilemeterManager;
import com.huawei.ism.drm.openstack.adapter.manager.ISfsManilaManager;
import com.huawei.ism.drm.openstack.adapter.msg.AsyncTaskResponse;
import com.huawei.ism.drm.openstack.adapter.util.JsonUtil;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.sdk.bo.FileSystem;
import com.huawei.ism.drm.openstack.sdk.bo.Share;
import com.huawei.ism.drm.openstack.sdk.bo.SharePair;
import com.huawei.ism.drm.openstack.sdk.bo.UrlBaseParams;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;

public class SfsProtectOperateObserver
implements IObjectObserver {
    private static final Log LOG = LogFactory.getInstance(SfsProtectOperateObserver.class);
    private static final ConcurrentHashMap<String, AtomicLong> PROTECT_GROUP_CREATING_COUNTER = new ConcurrentHashMap();
    private Map<String, List<ProtectObject>> addPos = new HashMap<String, List<ProtectObject>>();

    public void after(MessageEvent event) {
        LOG.info((Object)"Enter SfsProtectOperateObserver after");
        List objectList = event.getObjectList();
        int messageType = event.getMessageType();
        if (VerifyUtil.isEmpty((Collection)objectList)) {
            return;
        }
        for (DRMObject object : objectList) {
            ProtectGroup protectGroup;
            if (!(object instanceof ProtectGroup) || !this.checkParam(protectGroup = (ProtectGroup)object)) continue;
            if (messageType == 24) {
                this.rollback(protectGroup);
                continue;
            }
            LOG.info((Object)"Error msg.");
        }
    }

    public void before(MessageEvent event) {
        LOG.info((Object)"Enter SfsProtectOperateObserver before");
        List objectList = event.getObjectList();
        int messageType = event.getMessageType();
        if (VerifyUtil.isEmpty((Collection)objectList)) {
            return;
        }
        for (DRMObject object : objectList) {
            ProtectGroup protectGroup;
            if (!(object instanceof ProtectGroup) || !this.checkParam(protectGroup = (ProtectGroup)object)) continue;
            if (messageType == 2) {
                this.operateDeleteProtectGroup(protectGroup);
                continue;
            }
            if (messageType == 0) {
                this.handleCache(protectGroup);
                continue;
            }
            LOG.info((Object)"Error msg.");
        }
    }

    public String getObserverType() {
        return ProtectGroup.class.getName();
    }

    private boolean checkParam(ProtectGroup protectGroup) {
        if (!protectGroup.isPrimary()) {
            return false;
        }
        List<Integer> openstackArray = Collections.singletonList(38);
        return openstackArray.contains(protectGroup.getTemplate().getType());
    }

    private void handleCache(ProtectGroup protectGroup) {
        this.clearCache(protectGroup, this.addPos);
        this.addPos.get(protectGroup.getUuid()).addAll(protectGroup.getPolist());
        AtomicLong counter = PROTECT_GROUP_CREATING_COUNTER.putIfAbsent(protectGroup.getName(), new AtomicLong(1L));
        if (counter != null) {
            counter.incrementAndGet();
            LOG.error((Object)"Instance name repeated!, instanceName=%s", new Object[]{protectGroup.getName()});
            throw new LegoCheckedException(1073947717L);
        }
    }

    private void clearCache(ProtectGroup protectGroup, Map<String, List<ProtectObject>> cache) {
        if (cache.containsKey(protectGroup.getUuid())) {
            cache.get(protectGroup.getUuid()).clear();
        } else {
            cache.put(protectGroup.getUuid(), new ArrayList());
        }
    }

    private void operateDeleteProtectGroup(ProtectGroup protectGroup) {
        try {
            this.deleteProtectGroupResource(protectGroup);
        }
        catch (Exception e) {
            CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)protectGroup);
            ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).updateProtectGroupStatus(DrmEnumDefine.ProtectGroupStatus.INVALID, new String[]{protectGroup.getUuid()});
            LOG.error((Object)"Delete openstack resource failed. pgName:%s . pgUuid:%s.", new Object[]{protectGroup.getName(), protectGroup.getUuid()});
            throw LegoCheckedException.cast((Throwable)e, (long)1073948412L, (String[])new String[0]);
        }
    }

    private void rollback(ProtectGroup protectGroup) {
        logger.info((Object)"Create instance(%s) failed,SfsProtectOperateObserver rollback projectGroup.", new Object[]{protectGroup.getName()});
        String projId = (String)protectGroup.getProps().get("projectId");
        String regionId = (String)protectGroup.getProps().get("regionId");
        String drProjId = (String)protectGroup.getProps().get("drProjectId");
        String drRegionId = (String)protectGroup.getProps().get("drRegionId");
        String tokenId = TokenUtil.getInstance().getTokenId(projId);
        String drTokenId = TokenUtil.getInstance().getTokenId(drProjId);
        UrlBaseParams pdParams = new UrlBaseParams(projId, regionId, tokenId);
        UrlBaseParams drParams = new UrlBaseParams(drProjId, drRegionId, drTokenId);
        ISfsFilemeterManager filemeterManager = ManagerFactory.getInstance().getSfsFilemeterManager();
        ISfsManilaManager manilaManager = ManagerFactory.getInstance().getSfsManilaManager();
        for (ProtectObject po : protectGroup.getPolist()) {
            String pdShareString = po.getProperty("pd_share");
            Share pdShareTmp = (Share)JSONObject.toBean((String)pdShareString, Share.class);
            if (VerifyUtil.isEmpty((Object)pdShareTmp) || VerifyUtil.isEmpty((String)pdShareTmp.getId())) continue;
            Share pdShare = manilaManager.queryShareById(pdParams, pdShareTmp.getId());
            if (!VerifyUtil.isEmpty((String)pdShare.getMetadata().getHypermetroTags())) {
                LOG.info((Object)"Tags have been set on the primary(%s) end and need to be deleted during rollback.", new Object[]{pdShare.getId()});
                filemeterManager.deleteTagToShare(pdParams, pdShare.getId(), pdShare.getName());
            }
            String sharePairJson = po.getProps().getOrDefault("share_pair", "");
            SharePair sharePair = (SharePair)JSONObject.toBean((String)sharePairJson, SharePair.class);
            this.deleteSharePair(pdParams, drParams, filemeterManager, sharePair, po);
            String drShareString = po.getProperty("dr_share");
            Share drShareTmp = (Share)JSONObject.toBean((String)drShareString, Share.class);
            if (!VerifyUtil.isEmpty((Object)drShareTmp) && !VerifyUtil.isEmpty((String)drShareTmp.getId())) {
                LOG.info((Object)"Delete share(%s) and file system.", new Object[]{drShareTmp.getId()});
                filemeterManager.deleteShare(drParams, drShareTmp.getId(), drShareTmp.getName());
            }
            po.getProperty("remote_file_system");
            String drFileSystemJson = po.getProperty("remote_file_system");
            FileSystem drFileSystemTmp = (FileSystem)JSONObject.toBean((String)drFileSystemJson, FileSystem.class);
            this.deleteDrFileSystem(drParams, filemeterManager, drShareTmp, drFileSystemTmp);
        }
    }

    private void deleteDrFileSystem(UrlBaseParams drParams, ISfsFilemeterManager filemeterManager, Share drShareTmp, FileSystem drFileSystemTmp) {
        if (VerifyUtil.isEmpty((Object)drShareTmp) && !VerifyUtil.isEmpty((Object)drFileSystemTmp) && !VerifyUtil.isEmpty((String)drFileSystemTmp.getId())) {
            LOG.info((Object)"Delete file systems(%s).", new Object[]{drFileSystemTmp.getId()});
            filemeterManager.deleteFileSystem(drParams, drFileSystemTmp.getId(), drFileSystemTmp.getShareTypeName(), drFileSystemTmp.getFsName());
        }
    }

    private void deleteSharePair(UrlBaseParams pdParams, UrlBaseParams drParams, ISfsFilemeterManager filemeterManager, SharePair sharePair, ProtectObject po) {
        if (!VerifyUtil.isEmpty((Object)sharePair) && !VerifyUtil.isEmpty((String)sharePair.getSharePairId())) {
            SharePair drSharePair;
            LOG.info((Object)"Delete the created pair and file system.");
            SharePair pdSharePair = filemeterManager.querySharePairById(pdParams, sharePair.getSharePairId());
            if (!VerifyUtil.isEmpty((Object)pdSharePair) && !VerifyUtil.isEmpty((String)pdSharePair.getSharePairId())) {
                LOG.info((Object)"Delete the primary created pair and file system.");
                filemeterManager.deleteShareAndPair(pdParams, drParams, sharePair.getSharePairId(), true, false);
            }
            if (!VerifyUtil.isEmpty((Object)(drSharePair = filemeterManager.querySharePairById(drParams, sharePair.getSharePairId()))) && !VerifyUtil.isEmpty((String)drSharePair.getSharePairId())) {
                LOG.info((Object)"Delete the dr pair and file system.");
                filemeterManager.deleteShareAndPair(drParams, null, sharePair.getSharePairId(), false, true);
                this.checkDrShairDeleteResult(drParams, po);
            }
        }
    }

    private void deleteProtectGroupResource(ProtectGroup protectGroup) {
        String projId = (String)protectGroup.getProps().get("projectId");
        String regionId = (String)protectGroup.getProps().get("regionId");
        String drProjId = (String)protectGroup.getProps().get("drProjectId");
        String drRegionId = (String)protectGroup.getProps().get("drRegionId");
        String tokenId = TokenUtil.getInstance().getTokenId(projId);
        String drTokenId = TokenUtil.getInstance().getTokenId(drProjId);
        UrlBaseParams pdParams = new UrlBaseParams(projId, regionId, tokenId);
        UrlBaseParams drParams = new UrlBaseParams(drProjId, drRegionId, drTokenId);
        ISfsFilemeterManager sfsFilemeterManager = ManagerFactory.getInstance().getSfsFilemeterManager();
        logger.debug((Object)"Starting to delete the DR resources occupied by the protection group (%s).", new Object[]{protectGroup.getName()});
        for (ProtectObject po : protectGroup.getPolist()) {
            String sharePairString = po.getProperty("share_pair");
            SharePair sharePair = (SharePair)JSONObject.toBean((String)sharePairString, SharePair.class);
            if (VerifyUtil.isEmpty((Object)sharePair)) {
                LOG.warn((Object)"The sharePair of projectObject(%s) is null.", new Object[]{po.getName()});
                continue;
            }
            LOG.debug((Object)"Deleting the share,pair and tag(%s).", new Object[]{sharePair.getSharePairId()});
            sfsFilemeterManager.deleteShareAndPair(pdParams, drParams, sharePair.getSharePairId(), true, false);
            sfsFilemeterManager.deleteShareAndPair(drParams, null, sharePair.getSharePairId(), false, true);
            this.checkDrShairDeleteResult(drParams, po);
            Share pdShare = (Share)JSONObject.toBean((String)po.getProperty("pd_share"), Share.class);
            if (VerifyUtil.isEmpty((Object)pdShare)) {
                LOG.warn((Object)"The pdShare of projectObject(%s) is null.", new Object[]{po.getName()});
                continue;
            }
            sfsFilemeterManager.deleteTagToShare(pdParams, pdShare.getId(), pdShare.getName());
        }
    }

    private void checkDrShairDeleteResult(UrlBaseParams drParams, ProtectObject protectObject) {
        Share share = JsonUtil.jsonToBean(protectObject.getProperty("dr_share"), Share.class);
        if (VerifyUtil.isEmpty((Object)share)) {
            LOG.warn((Object)"The protectObject(%s) does not contain %s, no need check.", new Object[]{protectObject.getName(), "dr_share"});
            return;
        }
        ISfsFilemeterManager filemeterManager = ManagerFactory.getInstance().getSfsFilemeterManager();
        ISfsManilaManager sfsManilaManager = ManagerFactory.getInstance().getSfsManilaManager();
        AsyncTaskResponse response = AsyncTaskResponse.queryTaskResponse(share.getId(), response1 -> {
            Share drShare = sfsManilaManager.queryShareById(drParams, share.getId());
            if (VerifyUtil.isEmpty((Object)drShare)) {
                response1.setSuccess(true);
                return true;
            }
            if (OpenstackEnumDefine.ShareStatus.AVAILABLE.getValue().equals(drShare.getStatus())) {
                try {
                    filemeterManager.deleteShare(drParams, drShare.getId(), drShare.getName());
                }
                catch (LegoCheckedException exception) {
                    LOG.error((Object)"Delete dr share(%s) failed,will retry.", new Object[]{drShare.getId()});
                }
            }
            if (OpenstackEnumDefine.ShareStatus.ERROR_DELETING.getValue().equals(drShare.getStatus())) {
                response1.setSuccess(false);
                response1.setErrorCode(String.valueOf(1073949768L));
                response1.setErrorParameter(new String[]{share.getName()});
                LOG.error((Object)"Delete share(%s) failed.", new Object[]{share.getId()});
                return true;
            }
            return false;
        });
        if (response.isSuccess()) {
            LOG.info((Object)"Delete share(%s) succeed.", new Object[]{share.getId()});
            return;
        }
        LOG.error((Object)"Delete share(%s) failed.", new Object[]{share.getId()});
        throw new LegoCheckedException(Long.parseLong(response.getErrorCode()), response.getErrorParameter());
    }

    public void onFinal(MessageEvent event) {
        if (event.getMessageType() != 0) {
            return;
        }
        List objectList = event.getObjectList();
        if (VerifyUtil.isEmpty((Collection)objectList)) {
            return;
        }
        List protectGroups = objectList.stream().filter(ProtectGroup.class::isInstance).map(ProtectGroup.class::cast).filter(this::checkParam).collect(Collectors.toList());
        for (ProtectGroup protectGroup : protectGroups) {
            AtomicLong counter = PROTECT_GROUP_CREATING_COUNTER.get(protectGroup.getName());
            if (counter == null || counter.decrementAndGet() > 0L) continue;
            PROTECT_GROUP_CREATING_COUNTER.remove(protectGroup.getName());
            LOG.debug((Object)"Already remove protectGroup name %s from sets", new Object[]{protectGroup.getName()});
        }
    }
}

