/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.protection.provider;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoverySetting;
import com.huawei.ism.drm.galax.sdk.pg.service.IGalaxProtectObjectCloudProvider;
import com.huawei.ism.drm.openstack.license.EvsVolumeLicenseControlImpl;
import com.huawei.ism.drm.openstack.sdk.model.DrFusionSphereOpenStack;
import com.huawei.ism.drm.openstack.sdk.model.FusionSphereOpenStack;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeInfo;
import com.huawei.ism.drm.openstack.sdk.service.IVolumeService;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.recovery.framework.util.RecoveryProcessUtil;
import com.huawei.ism.drm.virtualization.sdk.service.IProtectGroupRefreshService;
import com.huawei.ism.drm.virtualization.util.ProtectionToolsUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OpenStackVolumeProvider
implements IGalaxProtectObjectCloudProvider {
    private static final Log LOG = LogFactory.getInstance(OpenStackVolumeProvider.class);
    private IProtectGroupRefreshService pgRefreshService;

    public IProtectGroupRefreshService getPgRefreshService() {
        return this.pgRefreshService;
    }

    public void setPgRefreshService(IProtectGroupRefreshService pgRefreshService) {
        this.pgRefreshService = pgRefreshService;
    }

    public String getObjectType() {
        return ServiceInstaceEnumDefine.ObjectType.EVS.getValue();
    }

    public List<ProtectObject> getAvailableProtectObject(String paramString, Map<String, Object> paramMap) {
        return null;
    }

    public String getCloudType() {
        return DrFusionSphereOpenStack.class.getSimpleName();
    }

    public String getProviderType() {
        return FusionSphereOpenStack.class.getSimpleName();
    }

    public void buildProtectObjects(ProtectGroup protectGroup) {
        LOG.debug((Object)"Enter buildProtectObjects, object type is:%s", new Object[]{this.getObjectType()});
        ProtectionToolsUtil.getInstance().checkBuildProtectObjectsParam(protectGroup);
        ProtectionToolsUtil.getInstance().checkProtectObjectNumber(protectGroup, OpenStackCommonUtil.getPgMaxVolume());
        if (protectGroup == null) {
            return;
        }
        String regionUuid = (String)protectGroup.getProps().get("regionId");
        String projectUuid = (String)protectGroup.getProps().get("projectId");
        IVolumeService volumeService = (IVolumeService)ServiceLocator.getInstance().getService(IVolumeService.class);
        for (ProtectObject po : protectGroup.getPolist()) {
            VolumeInfo volumeInfo = volumeService.queryVolumeInfoByUuid(regionUuid, projectUuid, po.getMoUuid());
            po.setName(volumeInfo.getName());
            po.setProviderSN(OpenStackCommonUtil.getOpenstack().getTopMoUuid());
            if (!VerifyUtil.isEmpty((String)po.getUuid())) continue;
            po.setUuid(UUIDGenerator.getUUID());
        }
        EvsVolumeLicenseControlImpl.getInstance().updatePgVolumeMap(protectGroup);
    }

    public void refreshProtectObjectProperties(ProtectGroup protectGroup) {
    }

    public void loadProtectObjectStorageInfo(List<ProtectObject> protectObjectList, Object vmlist) {
    }

    public void refreshProtectGroup(ProtectGroup pg) {
    }

    public void refreshCloud(String cloudSn, String username, boolean isCascade) {
    }

    public Map<String, Object> checkRecoveryContext(DrmEnumDefine.RecoveryPlanExecuteTypeE procType, Map<String, String> recoveryContext, RecoveryPlan recoveryPlan, String reySite) {
        HashMap<String, Object> settings = new HashMap<String, Object>();
        String siteId = RecoveryProcessUtil.getDisterSiteId((String)reySite, (ProtectGroup)((ProtectGroup)CommonUtil.getFirstElement((Collection)recoveryPlan.getProtectGroups())));
        settings.put("DISASTER_SITE_ID", siteId);
        return settings;
    }

    public void checkRecoverySettings(List<RecoverySetting> recoverySettingList) {
    }
}

