/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.protection.replica.builder;

import com.huawei.ism.drm.base.rollback.RollBackTaskManager;
import com.huawei.ism.drm.common.sdk.model.RollBackTaskInfo;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.adapter.manager.INovaManager;
import com.huawei.ism.drm.openstack.adapter.util.JsonUtil;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.protection.replica.builder.ArrayReplicationReplicaBuilder;
import com.huawei.ism.drm.openstack.protection.service.ConfigPhVmTask;
import com.huawei.ism.drm.openstack.protection.service.CreatePhVmTask;
import com.huawei.ism.drm.openstack.protection.service.CreateReplicationTaskResult;
import com.huawei.ism.drm.openstack.protection.service.ReattachVolumeTask;
import com.huawei.ism.drm.openstack.resource.OpenStackVmResRollBackExecutorEx;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaInfo;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.lego.core.base.thread.ExecutionService;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;

public class HyperMetroReplicationReplicaBuilder
extends ArrayReplicationReplicaBuilder {
    private static final Log LOG = LogFactory.getInstance(HyperMetroReplicationReplicaBuilder.class);

    @Override
    protected void afterCreatePair(ProtectGroup pg, Map<String, PoReplicaInfo> poReplicaInfoMap) {
        Set<ProtectObject> addPoSet = pg.getPolist();
        if (!VerifyUtil.isEmpty((Collection)pg.getReplicaList())) {
            addPoSet = this.getWillAddPoSet(pg);
        }
        ArrayList<Callable<PoReplicaInfo>> reattachTaskList = new ArrayList<Callable<PoReplicaInfo>>();
        ArrayList createVmTaskList = new ArrayList();
        for (ProtectObject po : addPoSet) {
            String poUuid = po.getUuid();
            PoReplicaInfo replicaInfo = poReplicaInfoMap.get(poUuid);
            if (VerifyUtil.isEmpty((Object)replicaInfo)) {
                LOG.error((Object)"Can't find porelicaInfo, uuid=%s", new Object[]{poUuid});
                continue;
            }
            ReattachVolumeTask task = new ReattachVolumeTask(replicaInfo);
            task.setIsHyperMetro(true);
            reattachTaskList.add(task);
            this.addTagToVm(replicaInfo);
            if (this.getType() == 25) {
                this.addTagToVm(replicaInfo, "__type_csha");
            }
            if (OpenStackCommonUtil.isCurrentFCVersionHighThan63()) {
                String phvmId = (String)po.getProps().get("occupied_vm");
                if (VerifyUtil.isEmpty((String)phvmId)) {
                    LOG.error((Object)"Can't set phvmId, uuid=%s", new Object[]{poUuid});
                    continue;
                }
                if (this.getType() == 25) {
                    this.addBackUpTagsToCSHAVm(replicaInfo, phvmId);
                }
                createVmTaskList.add(new ConfigPhVmTask(replicaInfo, phvmId, ServiceInstaceEnumDefine.ServiceInstanceTypeE.HYPERMETRO.getValue(), pg.getName()));
                continue;
            }
            createVmTaskList.add(new CreatePhVmTask(pg, replicaInfo));
        }
        int batchNum = OpenStackCommonUtil.getNumFromResource("replication.oper.task.batch.num", 20);
        int timeout = OpenStackCommonUtil.getNumFromResource("replication.oper.task.timeout", 1800);
        super.reattach(reattachTaskList, batchNum, timeout);
        if (VerifyUtil.isEmpty(createVmTaskList)) {
            LOG.info((Object)"CreateVmTaskList is empty");
            return;
        }
        if (29 == this.getType()) {
            return;
        }
        OpenStackCommonUtil.executeTask(createVmTaskList, ExecutionService.ExecuteType.FAILED_ABORT, true);
    }

    @Override
    protected void startRollback(final ProtectGroup pg, final Map<String, PoReplicaInfo> poReplicaInfoMap, String replicationSidee, Map<String, PoReplicaInfo> poDRReplicaInfoMap, Map<String, PoReplicaInfo> poHyperMetroReplicaInfoMap) {
        final int operationType = pg.getReplicaList().isEmpty() ? OpenstackEnumDefine.RollbackOperationTypeE.CREATE_PROTECTGROUP.getType() : OpenstackEnumDefine.RollbackOperationTypeE.ADD_PROTECTOBJECT.getType();
        new Thread("SumbmitRollBackTaskThread"){

            @Override
            public void run() {
                for (PoReplicaInfo poReplicaInfo : poReplicaInfoMap.values()) {
                    LOG.debug((Object)"Start rollback:%s", new Object[]{JsonUtil.beanToJson(poReplicaInfo)});
                    List pairInfoList = poReplicaInfo.getPairInfos();
                    if (VerifyUtil.isEmpty((Collection)pairInfoList)) continue;
                    RollBackTaskInfo taskInfo = new RollBackTaskInfo();
                    taskInfo.setExecutor(OpenStackVmResRollBackExecutorEx.class.getSimpleName());
                    JSONObject json = new JSONObject();
                    json.put((Object)"operationType", (Object)operationType);
                    json.put((Object)"replicationInfo", (Object)JSONObject.fromObject((Object)poReplicaInfo));
                    json.put((Object)"serviceInstanceType", pg.getProps().get("serviceInstanceType"));
                    taskInfo.setExecuteParam(json.toString());
                    taskInfo.setTaskId(poReplicaInfo.getMoUuid());
                    taskInfo.setAlarmId(Long.valueOf(52625448L));
                    taskInfo.setSourceUuid(OpenStackCommonUtil.getOpenstackUuidFromStr(poReplicaInfo.getProjUuid()));
                    taskInfo.setSourceType(FaultEnum.AlarmResourceType.NETWORKENTITY.getValue());
                    taskInfo.setAlarmParam(pg.getObjectType());
                    taskInfo.setTargetName(poReplicaInfo.getVmName());
                    RollBackTaskManager.getInstance().addTask(taskInfo, true);
                }
            }
        }.start();
    }

    public int getType() {
        return 25;
    }

    @Override
    public String getReplicaModel(ProtectGroup protectGroup) {
        LOG.debug((Object)"HyperMetro replication builder get replicationmode=%s, protectGroup name=%s", new Object[]{"hypermetro", protectGroup.getName()});
        return "hypermetro";
    }

    @Override
    public int getProtectType() {
        return 0;
    }

    @Override
    protected List<CreateReplicationTaskResult> generateCreateReplicationTaskList(List<Callable<CreateReplicationTaskResult>> taskList, ProtectGroup pg) {
        return this.genCreateHyperPairTaskResults(taskList, pg);
    }

    protected void addTagToVm(PoReplicaInfo poReplicationInfo, String tag) {
        if (poReplicationInfo == null || VerifyUtil.isEmpty((String)tag)) {
            LOG.error((Object)"Param error,PoReplicaInfo or tag is null");
            return;
        }
        String reginUuid = poReplicationInfo.getRegionUuid();
        String projectUuid = poReplicationInfo.getProjUuid();
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(reginUuid);
        INovaManager novaMgr = ManagerFactory.getInstance().getNovaManager(openstackUuid);
        String tokenId = TokenUtil.getInstance().getRegionTokenId(reginUuid, projectUuid);
        if (VerifyUtil.isEmpty((String)reginUuid) || VerifyUtil.isEmpty((String)projectUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)openstackUuid)) {
            LOG.info((Object)"Some param is null, reginUuid:%s, projectUuid:%s, openstackUuid:%s", new Object[]{reginUuid, projectUuid, openstackUuid});
            return;
        }
        novaMgr.addTagToVm(reginUuid, tokenId, projectUuid, poReplicationInfo.getMoUuid(), tag);
    }

    protected void addBackUpTagsToCSHAVm(PoReplicaInfo poReplicationInfo, String drVmId) {
        String reginUuid = poReplicationInfo.getRegionUuid();
        try {
            this.addTagToVm(poReplicationInfo, "dr_backup_vm::" + drVmId);
            this.addTagToVm(poReplicationInfo, "dr_backup_region::" + OpenStackCommonUtil.getIdFromUuid(reginUuid));
        }
        catch (Exception e) {
            LOG.error((Object)"Attach tags error, openstackUuid:%s", new Object[]{poReplicationInfo.getMoUuid()});
        }
    }
}

