/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.protection.replica.builder;

import com.huawei.ism.drm.base.rollback.RollBackTaskManager;
import com.huawei.ism.drm.common.sdk.model.RollBackTaskInfo;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.openstack.adapter.manager.impl.CinderManager;
import com.huawei.ism.drm.openstack.adapter.util.JsonUtil;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.protection.replica.builder.ArrayReplicationReplicaBuilder;
import com.huawei.ism.drm.openstack.protection.service.CreateReplicationTask;
import com.huawei.ism.drm.openstack.protection.service.CreateReplicationTaskResult;
import com.huawei.ism.drm.openstack.resource.OpenStackVolumeResRollBackExecutor;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaInfo;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaPairInfo;
import com.huawei.ism.drm.openstack.sdk.bo.ResourceLocation;
import com.huawei.ism.drm.openstack.sdk.bo.VolumeErrorItem;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVolume;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVolumeType;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeInfo;
import com.huawei.ism.drm.openstack.serviceinstance.checker.VolumeProtectableChecker;
import com.huawei.ism.drm.openstack.tools.OpenStackBasicUtil;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.lego.core.base.thread.ExecutionService;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class SyncVolumeArrayReplicationReplicaBuilder
extends ArrayReplicationReplicaBuilder {
    private static final Log LOG = LogFactory.getInstance(SyncVolumeArrayReplicationReplicaBuilder.class);

    public int getType() {
        return 56;
    }

    @Override
    public String getReplicaModel(ProtectGroup protectGroup) {
        LOG.debug((Object)"Sync Volume replication builder get replicationmode=%s, protectGroup name=%s", new Object[]{"sync", protectGroup.getName()});
        return "sync";
    }

    @Override
    public int getProtectType() {
        return 1;
    }

    @Override
    protected List<OpenStackVolumeType> getSrcVolumeTypes(Collection<ProtectObject> protectObjects) {
        Set srcVolumeTypeNames = protectObjects.stream().map(po -> (String)po.getProps().get("volumeConfig")).filter(Objects::nonNull).map(JSONArray::fromObject).flatMap(jsonArray -> IntStream.range(0, jsonArray.size()).mapToObj(arg_0 -> ((JSONArray)jsonArray).getJSONObject(arg_0))).map(json -> String.valueOf(json.get("volumeType"))).collect(Collectors.toSet());
        ProtectGroup pg = ((ProtectObject)CommonUtil.getFirstElement(protectObjects)).getProtectGroup();
        String regionUuid = (String)pg.getProps().get("regionId");
        String projectUuid = (String)pg.getProps().get("projectId");
        return this.getVolumeService().getVolumeTypesByName(srcVolumeTypeNames, regionUuid, projectUuid);
    }

    @Override
    public void buildReplica(ProtectGroup pg) {
        LOG.info((Object)"Start to create protectgroup replica:pgName=%s", new Object[]{pg.getName()});
        this.checkPgInfo(pg);
        Map<String, String> drVolTypeMap = this.getDrVolTypeMap(pg);
        HashMap<String, PoReplicaPairInfo> protectedPairInfoMap = new HashMap<String, PoReplicaPairInfo>();
        HashMap<String, List<ProtectObject>> protectedVolUuidPoMap = new HashMap<String, List<ProtectObject>>();
        HashMap<String, List<ProtectObject>> unprotectVolUuidPoMap = new HashMap<String, List<ProtectObject>>();
        this.getPairInfoMap(pg, protectedPairInfoMap, protectedVolUuidPoMap, unprotectVolUuidPoMap);
        if (!this.checkVolumeStatus(pg, protectedPairInfoMap)) {
            LOG.error((Object)("DrVolumeType is not from the same storage device,pgName=" + pg.getName() + " drVolTypes=" + drVolTypeMap.values()));
            throw new LegoCheckedException(1073948416L);
        }
        HashMap<String, List<ProtectObject>> needProtectVolUuidPoMap = new HashMap<String, List<ProtectObject>>();
        HashMap<String, List<ProtectObject>> unNeedProtectVolUuidPoMap = new HashMap<String, List<ProtectObject>>();
        this.getAddedPoVolumeInfoMap(pg, protectedPairInfoMap, needProtectVolUuidPoMap, unNeedProtectVolUuidPoMap);
        LOG.info((Object)"NeedProtectVolUuidPoMap size=%s", new Object[]{String.valueOf(needProtectVolUuidPoMap.size())});
        LOG.info((Object)"UnNeedProtectVolUuidPoMap size=%s", new Object[]{String.valueOf(unNeedProtectVolUuidPoMap.size())});
        Map<String, OpenStackVolume> uuidVolMap = this.getUuidVolMap(pg);
        Optional<VolumeErrorItem> volumeErrorItem = this.checkNeedProtectVolumeInfo(needProtectVolUuidPoMap, pg);
        if (volumeErrorItem.isPresent()) {
            VolumeErrorItem errorItem = volumeErrorItem.get();
            LOG.error((Object)"Create instance check volume info failed. error code=%s, error params=%s, volume ids=%s", new Object[]{errorItem.getErrorCode(), errorItem.getErrorParams(), errorItem.getVolumeIds()});
            throw new LegoCheckedException(errorItem.getErrorCode().longValue(), errorItem.getErrorParams().toArray(new String[0]));
        }
        HashMap<String, PoReplicaInfo> poReplicaInfoMap = new HashMap<String, PoReplicaInfo>();
        try {
            this.protectVolumes(pg, uuidVolMap, drVolTypeMap, poReplicaInfoMap, needProtectVolUuidPoMap);
        }
        catch (LegoCheckedException e) {
            this.mergeShareVolume(poReplicaInfoMap);
            this.startVolumeRollback(pg, poReplicaInfoMap, needProtectVolUuidPoMap);
            LOG.error((Object)("Build replica failed:pgName=" + pg.getName()));
            throw e;
        }
        catch (Exception e) {
            this.rollback(pg, poReplicaInfoMap, needProtectVolUuidPoMap, e);
        }
        String aSrcVolTypeName = ((OpenStackVolume)CommonUtil.getFirstElement(uuidVolMap.values())).getVolType();
        String aDrVolTypeName = (String)CommonUtil.getFirstElement(drVolTypeMap.values());
        this.updatePgProp(pg, aSrcVolTypeName, aDrVolTypeName, null);
        this.updatePoProp(pg, poReplicaInfoMap, uuidVolMap);
        this.makePgReplica(pg);
    }

    private Optional<VolumeErrorItem> checkNeedProtectVolumeInfo(Map<String, List<ProtectObject>> needProtectVolUuidPoMap, ProtectGroup pg) {
        if (VerifyUtil.isEmpty(needProtectVolUuidPoMap)) {
            LOG.error((Object)"The needProtectVolUuidPoMap is Empty");
            return Optional.empty();
        }
        HashMap<String, VolumeInfo> prodVolumeMap = new HashMap<String, VolumeInfo>();
        ResourceLocation prodResourceLocation = this.getProdResourceLocation(pg, prodVolumeMap, needProtectVolUuidPoMap);
        List<ProtectObject> protectObjects = needProtectVolUuidPoMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        HashMap<String, VolumeInfo> drVolumeMap = new HashMap<String, VolumeInfo>();
        ResourceLocation drResourceLocation = this.getDrResourceLocation(pg, drVolumeMap, protectObjects);
        VolumeProtectableChecker volumeProtectableChecker = new VolumeProtectableChecker(ServiceInstaceEnumDefine.ObjectType.EVS, prodResourceLocation, drResourceLocation);
        for (ProtectObject protectObject : protectObjects) {
            String prodVolumeId = OpenStackCommonUtil.getIdFromUuid(protectObject.getMoUuid());
            String drVolumeId = OpenStackCommonUtil.getIdFromUuid(protectObject.getProperty("drVolumeId"));
            List<VolumeErrorItem> drVolumeErrors = volumeProtectableChecker.checkVolumePair((VolumeInfo)prodVolumeMap.get(prodVolumeId), drVolumeMap.getOrDefault(drVolumeId, null), ServiceInstaceEnumDefine.ServiceInstanceTypeE.REPLICATION);
            if (VerifyUtil.isEmpty(drVolumeErrors)) continue;
            LOG.error((Object)"Check volume pair fail");
            return Optional.of(drVolumeErrors.get(0));
        }
        return Optional.empty();
    }

    private ResourceLocation getDrResourceLocation(ProtectGroup pg, Map<String, VolumeInfo> drVolumeMap, List<ProtectObject> protectObjects) {
        String drRegionUuid = (String)pg.getProps().get("drRegionId");
        String drProjectUuid = (String)pg.getProps().get("drProjectId");
        String drAzUuid = (String)pg.getProps().get("drZoneName");
        List drVolumeUuids = protectObjects.stream().filter(protectObject -> !VerifyUtil.isEmpty((String)protectObject.getProperty("drVolumeId"))).map(protectObject -> protectObject.getProperty("drVolumeId")).map(OpenStackBasicUtil::getIdFromUuid).collect(Collectors.toList());
        Map volumeInfoMap = this.getVolumeService().queryVolumeInfosByUuid(drRegionUuid, drProjectUuid, drVolumeUuids);
        drVolumeMap.putAll(volumeInfoMap);
        return new ResourceLocation(drRegionUuid, drProjectUuid, drAzUuid);
    }

    private ResourceLocation getProdResourceLocation(ProtectGroup pg, Map<String, VolumeInfo> prodVolumeMap, Map<String, List<ProtectObject>> needProtectVolUuidPoMap) {
        String regionUuid = (String)pg.getProps().get("regionId");
        String projectUuid = (String)pg.getProps().get("projectId");
        String azUuid = (String)pg.getProps().get("zoneName");
        List prodVolumeUuids = needProtectVolUuidPoMap.keySet().stream().map(OpenStackBasicUtil::getIdFromUuid).collect(Collectors.toList());
        Map volumeInfoMap = this.getVolumeService().queryVolumeInfosByUuid(regionUuid, projectUuid, prodVolumeUuids);
        prodVolumeMap.putAll(volumeInfoMap);
        return new ResourceLocation(regionUuid, projectUuid, azUuid);
    }

    private void checkPgInfo(ProtectGroup pg) {
        if (VerifyUtil.isEmpty((Object)pg) || VerifyUtil.isEmpty((Collection)pg.getPolist())) {
            LOG.error((Object)"Pg or polist is empty");
            throw new LegoCheckedException(1073947393L);
        }
    }

    private Map<String, String> getDrVolTypeMap(ProtectGroup pg) {
        HashMap<String, String> drVolTypeMap = new HashMap<String, String>();
        if (!this.checkDrVolTypeExist(pg, drVolTypeMap, null)) {
            LOG.error((Object)("Drvoltype is empty,pgName=" + pg.getName()));
            throw new LegoCheckedException(1073947393L);
        }
        return drVolTypeMap;
    }

    private void rollback(ProtectGroup pg, Map<String, PoReplicaInfo> poReplicaInfoMap, Map<String, List<ProtectObject>> needProtectVolUuidPoMap, Exception e) {
        this.mergeShareVolume(poReplicaInfoMap);
        this.startVolumeRollback(pg, poReplicaInfoMap, needProtectVolUuidPoMap);
        ExceptionUtil.rethrowException((Throwable)e, (String)"build replica failed", (long)0x300001L, (String[])new String[0], (Log)LOG);
    }

    private void startVolumeRollback(ProtectGroup pg, Map<String, PoReplicaInfo> poReplicaInfoMap, Map<String, List<ProtectObject>> needProtectVolUuidPoMap) {
        int operationType = VerifyUtil.isEmpty((Collection)pg.getReplicaList()) ? OpenstackEnumDefine.RollbackOperationTypeE.CREATE_PROTECTGROUP.getType() : OpenstackEnumDefine.RollbackOperationTypeE.ADD_PROTECTOBJECT.getType();
        ExecutionService.submit(() -> {
            for (PoReplicaInfo poReplicaInfo : poReplicaInfoMap.values()) {
                LOG.info((Object)"Start rollback,poReplicationInfo=%s", new Object[]{JsonUtil.beanToJson(poReplicaInfo)});
                List pairInfoList = poReplicaInfo.getPairInfos();
                if (VerifyUtil.isEmpty((Collection)pairInfoList)) continue;
                JSONObject json = new JSONObject();
                json.put((Object)"operationType", (Object)operationType);
                json.put((Object)"replicationInfo", (Object)JSONObject.fromObject((Object)poReplicaInfo));
                if (needProtectVolUuidPoMap.containsKey(poReplicaInfo.getMoUuid())) {
                    json.put((Object)"isNewDrVolume", (Object)((ProtectObject)((List)needProtectVolUuidPoMap.get(poReplicaInfo.getMoUuid())).get(0)).getProperty("isNewDrVolume"));
                }
                this.startRollBackTask(json, poReplicaInfo, pg.getObjectType());
            }
        });
    }

    private void startRollBackTask(JSONObject json, PoReplicaInfo poReplicaInfo, String objectType) {
        RollBackTaskInfo taskInfo = new RollBackTaskInfo();
        taskInfo.setExecutor(OpenStackVolumeResRollBackExecutor.class.getSimpleName());
        taskInfo.setExecuteParam(json.toString());
        taskInfo.setTaskId(poReplicaInfo.getMoUuid());
        taskInfo.setAlarmId(Long.valueOf(52625448L));
        taskInfo.setSourceUuid(OpenStackCommonUtil.getOpenstackUuidFromStr(poReplicaInfo.getProjUuid()));
        taskInfo.setSourceType(FaultEnum.AlarmResourceType.NETWORKENTITY.getValue());
        taskInfo.setAlarmParam(objectType);
        taskInfo.setTargetName(poReplicaInfo.getVmName());
        RollBackTaskManager.getInstance().addTask(taskInfo, true);
    }

    @Override
    protected List<Callable<CreateReplicationTaskResult>> getCreateReplicaTasks(ProtectGroup pg, Map<String, OpenStackVolume> uuidVolMap, Map<String, String> drVolTypeMap, Map<String, List<ProtectObject>> needProtectVolUuidPoMap) {
        ArrayList<Callable<CreateReplicationTaskResult>> taskList = new ArrayList<Callable<CreateReplicationTaskResult>>();
        Map<String, VolumeInfo> drUuidVolMap = this.getDrUuidVolMap(pg);
        for (String srcVolumeUuid : needProtectVolUuidPoMap.keySet()) {
            String drVolType = drVolTypeMap.get(srcVolumeUuid);
            OpenStackVolume srcVolume = uuidVolMap.get(srcVolumeUuid);
            if (VerifyUtil.isEmpty((Object)srcVolume)) {
                LOG.error((Object)("Create replication task, protectGroup name=" + pg.getName() + ",cant get Openstack Volume by uuid.uuid=" + srcVolumeUuid));
                continue;
            }
            CreateReplicationTask task = new CreateReplicationTask(this.getVolumeService(), srcVolume, pg, drVolType, this.getReplicaModel(pg), drUuidVolMap);
            taskList.add(task);
        }
        return taskList;
    }

    private Map<String, VolumeInfo> getDrUuidVolMap(ProtectGroup pg) {
        ArrayList volUuidList = new ArrayList();
        HashMap drVolAndSrcVolMap = new HashMap();
        pg.getPolist().stream().filter(protectObject -> !VerifyUtil.isEmpty((String)protectObject.getProperty("drVolumeId"))).forEach(protectObject -> {
            drVolAndSrcVolMap.put(protectObject.getProperty("drVolumeId"), protectObject.getMoUuid());
            volUuidList.add(protectObject.getProperty("drVolumeId"));
        });
        if (VerifyUtil.isEmpty(drVolAndSrcVolMap)) {
            return Collections.EMPTY_MAP;
        }
        String drRegionId = (String)pg.getProps().get("drRegionId");
        String drProjUuid = (String)pg.getProps().get("drProjectId");
        CinderManager cinderMgr = new CinderManager();
        String tokenId = TokenUtil.getInstance().getRegionTokenId(drRegionId, drProjUuid);
        HashMap<String, VolumeInfo> uuidDrVolMap = new HashMap<String, VolumeInfo>();
        for (String volUuid : volUuidList) {
            VolumeInfo volInfo = cinderMgr.queryVolume(drRegionId, tokenId, drProjUuid, OpenStackCommonUtil.getIdFromUuid(volUuid));
            uuidDrVolMap.put((String)drVolAndSrcVolMap.get(volUuid), volInfo);
        }
        return uuidDrVolMap;
    }
}

