/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.protection.service;

import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.adapter.manager.ICinderManager;
import com.huawei.ism.drm.openstack.adapter.manager.INovaManager;
import com.huawei.ism.drm.openstack.adapter.msg.AsyncTaskResponse;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.protection.service.AbStractPhVmTask;
import com.huawei.ism.drm.openstack.sdk.bo.PhVmInfo;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaInfo;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVM;
import com.huawei.ism.drm.openstack.sdk.msg.VMInterface;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeSnapShotInfo;
import com.huawei.ism.drm.openstack.sdk.service.IVirtualMachineService;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;

public class ConfigPhVmTask
extends AbStractPhVmTask
implements Callable<PoReplicaInfo> {
    private static final Log LOG = LogFactory.getInstance(ConfigPhVmTask.class);
    private String phVmUuid;

    public ConfigPhVmTask(PoReplicaInfo replicaInfo, String phVmUuid, String instanceType, String protectGroupName) {
        this.phVmUuid = phVmUuid;
        this.setReplicaInfo(replicaInfo);
        this.setDrRegionUuid(replicaInfo.getDrRegionUuid());
        this.setDrProjectUuid(replicaInfo.getDrProjUuid());
        this.setInstanceType(instanceType);
        this.setProtectGroupName(protectGroupName);
    }

    @Override
    public PoReplicaInfo call() {
        try {
            String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(this.getDrRegionUuid());
            INovaManager novaMgr = ManagerFactory.getInstance().getNovaManager(openstackUuid);
            String tokenId = TokenUtil.getInstance().getRegionTokenId(this.getDrRegionUuid(), this.getDrProjectUuid());
            OpenStackVM vmInfo = this.getOpenStackVM(novaMgr, tokenId);
            this.checkVmInfo(openstackUuid, tokenId, vmInfo);
            PhVmInfo phVm = new PhVmInfo();
            this.getReplicaInfo().setPhVmInfo(phVm);
            if (OpenStackCommonUtil.isBareMetalServer(vmInfo)) {
                novaMgr.addTagToVm(this.getDrRegionUuid(), tokenId, this.getDrProjectUuid(), vmInfo.getUuid(), "__type_dr");
                phVm.setStatus(OpenstackEnumDefine.VmStatusE.getStatusByValue((int)vmInfo.getStatus()).getType());
            } else {
                this.detachAllVolumesInVm(vmInfo);
                LOG.info((Object)"Detach volumes successfully,vmName=%s,vmuud=%s,protectGroup name=", new Object[]{vmInfo.getName(), vmInfo.getUuid(), this.getProtectGroupName()});
                HashMap<String, String> metadata = new HashMap<String, String>();
                String pdVMId = OpenStackCommonUtil.getIdFromUuid(OpenStackCommonUtil.getBcmPrimaryVmUuid(this.getReplicaInfo()));
                metadata.put("_bcm_primary_vm", pdVMId);
                novaMgr.updateVMmetadata(this.phVmUuid, this.getDrProjectUuid(), this.getDrRegionUuid(), tokenId, metadata);
                String pdHostname = OpenStackCommonUtil.getProductVmInfo(this.getReplicaInfo()).getHostname();
                if (!VerifyUtil.isEmpty((String)pdHostname) && !pdHostname.equals(vmInfo.getHostname())) {
                    novaMgr.updateVMHostname(this.phVmUuid, this.getDrProjectUuid(), this.getDrRegionUuid(), tokenId, pdHostname);
                }
                this.lockVm(vmInfo.getUuid());
                if (ServiceInstaceEnumDefine.ServiceInstanceTypeE.HYPERMETRO.getValue().equals(this.getInstanceType())) {
                    this.addBackUpTagsToCSHAVm(this.getReplicaInfo(), vmInfo.getUuid(), OpenStackCommonUtil.getIdFromUuid(this.getReplicaInfo().getMoUuid()));
                }
                LOG.debug((Object)"Lock vm successfully, vmuud=%s,vmName=%s, protectGroup name=%s", new Object[]{vmInfo.getUuid(), vmInfo.getName(), this.getProtectGroupName()});
                phVm.setStatus(OpenstackEnumDefine.VmStatusE.STOPPED.getType());
            }
            phVm.setVmUuid(vmInfo.getUuid());
            phVm.setName(vmInfo.getName());
        }
        catch (LegoCheckedException e) {
            LOG.error((Object)("Config phvm phVmUuid=" + this.phVmUuid + ",protectGroup name=" + this.getProtectGroupName()), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"Config phvm failed", (long)1073948363L, (String[])new String[0], (Log)LOG);
        }
        return this.getReplicaInfo();
    }

    private OpenStackVM getOpenStackVM(INovaManager novaMgr, String tokenId) {
        OpenStackVM vmInfo = novaMgr.getVm(this.getDrRegionUuid(), tokenId, this.getDrProjectUuid(), this.phVmUuid, new int[0]);
        if (null == vmInfo) {
            LOG.error((Object)"Occupied vm is not found:%s in (%s # %s), protectGroup name=%s", new Object[]{this.phVmUuid, this.getDrRegionUuid(), this.getDrProjectUuid(), this.getProtectGroupName()});
            throw new LegoCheckedException(1073948375L);
        }
        return vmInfo;
    }

    private void checkVmInfo(String openstackUuid, String tokenId, OpenStackVM vmInfo) {
        if (!OpenStackCommonUtil.isBareMetalServer(vmInfo)) {
            if (OpenstackEnumDefine.VmStatusE.STOPPED.getValue() != vmInfo.getStatus().intValue() && OpenstackEnumDefine.VmStatusE.SHUTOFF.getValue() != vmInfo.getStatus().intValue()) {
                LOG.error((Object)("ECS status is not stopped or shutoff. occupied vm name(" + vmInfo.getName() + "), uuid(" + this.phVmUuid + ") status is error:" + vmInfo.getStatus() + ", protectGroup name=" + this.getProtectGroupName()));
                throw new LegoCheckedException(1073948907L);
            }
            this.checkSnapShots(openstackUuid, tokenId, vmInfo);
        }
    }

    private void checkSnapShots(String openstackUuid, String tokenId, OpenStackVM vmInfo) {
        if (OpenStackCommonUtil.isBareMetalServer(vmInfo)) {
            return;
        }
        List<String> attachedVol = OpenStackCommonUtil.getListFromStr(vmInfo.getVolumeAttached(), ",");
        if (!VerifyUtil.isEmpty(attachedVol)) {
            ICinderManager cinderMgr = ManagerFactory.getInstance().getCinderManager(openstackUuid);
            for (String volUuid : attachedVol) {
                String volumeId = OpenStackCommonUtil.getIdFromUuid(volUuid);
                HashMap<String, String> filterProp = new HashMap<String, String>();
                filterProp.put("volume_id", volumeId);
                List<VolumeSnapShotInfo> volSnapShotList = cinderMgr.queryVolumeSnapShots(this.getDrRegionUuid(), tokenId, this.getDrProjectUuid(), filterProp);
                if (VerifyUtil.isEmpty(volSnapShotList)) continue;
                LOG.error((Object)"Ph vmInfo=%s volumeId=%s has %s snapshots", new Object[]{vmInfo, volumeId, volSnapShotList.size()});
                throw new LegoCheckedException(1073949718L, new String[]{vmInfo.getName(), volumeId});
            }
        }
    }

    private void deletePortForPhVm(INovaManager novaMgr, String tokenId, OpenStackVM vmInfo, PhVmInfo phVm) {
        LOG.info((Object)"Start to delete port for phvm,vmName=%s,phVm=%s, protectGroup name=%s", new Object[]{vmInfo.getName(), phVm, this.getProtectGroupName()});
        if (ConfigPhVmTask.isSwitchNetwork(this.getDrRegionUuid())) {
            List<VMInterface> interfaces = novaMgr.getVmInterfaces(this.getDrRegionUuid(), tokenId, this.getDrProjectUuid(), vmInfo.getUuid());
            if (!VerifyUtil.isEmpty(interfaces)) {
                for (VMInterface vmInterface : interfaces) {
                    phVm.getPortIdList().add(vmInterface.getPortId());
                }
                this.deletePorts(vmInfo);
            }
            LOG.info((Object)"Delete ports successfully,vmName=%s, protectGroup name=%s", new Object[]{vmInfo.getName(), this.getProtectGroupName()});
        }
        LOG.info((Object)"DR regionuuid:%s is not SwitchNetwork, protectGroup name=%s", new Object[]{this.getDrRegionUuid(), this.getProtectGroupName()});
    }

    private void detachAllVolumesInVm(OpenStackVM vmInfo) {
        String regionUuid = this.getDrRegionUuid();
        String projectUuid = this.getDrProjectUuid();
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid);
        String tokenId = TokenUtil.getInstance().getRegionTokenId(regionUuid, projectUuid);
        ICinderManager cinderMgr = ManagerFactory.getInstance().getCinderManager(openstackUuid);
        List<String> attachedVol = OpenStackCommonUtil.getListFromStr(vmInfo.getVolumeAttached(), ",");
        String storageSn = attachedVol.stream().map(volumeUuid -> cinderMgr.queryVolume(regionUuid, tokenId, projectUuid, OpenStackCommonUtil.getIdFromUuid(volumeUuid))).filter(Objects::nonNull).map(VolumeInfo::getStorageSn).filter(sn -> !VerifyUtil.isEmpty((String)sn)).findAny().orElse(null);
        IVirtualMachineService vmService = (IVirtualMachineService)ServiceLocator.getInstance().getService(IVirtualMachineService.class);
        INovaManager novaMgr = ManagerFactory.getInstance().getNovaManager(openstackUuid);
        for (String volUuid : attachedVol) {
            AsyncTaskResponse detachResonse = (AsyncTaskResponse)vmService.runWithAttachVolSemaphore(storageSn, vmInfo.getHostId(), 1800L, () -> novaMgr.detachVolFromVm(tokenId, projectUuid, regionUuid, vmInfo.getUuid(), "ECS", OpenStackCommonUtil.getIdFromUuid(volUuid)));
            if (!detachResonse.isSuccess()) {
                LOG.error((Object)"Detach volume failed:vmUuid=%s, volumeId=%s,vmInfo=%s", new Object[]{vmInfo.getUuid(), volUuid, vmInfo});
                throw new LegoCheckedException(1073948107L);
            }
            AsyncTaskResponse response = cinderMgr.deleteVolume(OpenStackCommonUtil.getIdFromUuid(volUuid), regionUuid, tokenId, projectUuid);
            if (response.isSuccess()) continue;
            LOG.error((Object)("delete the temp boot volume failed:volumeId=" + volUuid + ",vmInfo =" + vmInfo));
            return;
        }
    }

    protected void addBackUpTagsToCSHAVm(PoReplicaInfo poReplicationInfo, String vmUuid, String peerVmId) {
        if (poReplicationInfo == null || VerifyUtil.isEmpty((String)vmUuid) || VerifyUtil.isEmpty((String)peerVmId)) {
            LOG.error((Object)"Param error, PoReplicaInfo, vmUuid or peerVmId is null");
            return;
        }
        String regionUuid = poReplicationInfo.getRegionUuid();
        String openStackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid);
        INovaManager novaMgr = ManagerFactory.getInstance().getNovaManager(openStackUuid);
        String tokenId = TokenUtil.getInstance().getRegionTokenId(this.getDrRegionUuid(), this.getDrProjectUuid());
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)openStackUuid)) {
            LOG.info((Object)"Some param is null, regionUuid:%s, openStackUuid:%s", new Object[]{regionUuid, openStackUuid});
            return;
        }
        try {
            novaMgr.addTagToVm(this.getDrRegionUuid(), tokenId, this.getDrProjectUuid(), vmUuid, "dr_backup_vm::" + peerVmId);
            novaMgr.addTagToVm(this.getDrRegionUuid(), tokenId, this.getDrProjectUuid(), vmUuid, "dr_backup_region::" + OpenStackCommonUtil.getIdFromUuid(regionUuid));
        }
        catch (Exception e) {
            LOG.error((Object)"AddBackUpTagsToCSHAVm, add tags error, vmUuid:%s", new Object[]{vmUuid});
        }
    }
}

