/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.protection.service;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.base.util.AlarmReporter;
import com.huawei.ism.drm.openstack.cache.OpenstackCache;
import com.huawei.ism.drm.openstack.protection.service.OpenstackPgRefreshServiceImpl;
import com.huawei.ism.drm.openstack.sdk.bo.CheckContext;
import com.huawei.ism.drm.openstack.sdk.service.IServiceInstChecker;
import com.huawei.ism.drm.openstack.serviceinstance.checker.ShareChecker;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.virtualization.sdk.service.IProtectGroupRefreshService;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import java.util.ArrayList;
import java.util.Set;

public class OpenstackSfsPgRefreshServiceImpl
extends OpenstackPgRefreshServiceImpl
implements IProtectGroupRefreshService {
    private static final Log LOG = LogFactory.getInstance(OpenstackSfsPgRefreshServiceImpl.class);

    @Override
    public void refreshProtectGroup(ProtectGroup protectGroup) {
        super.refreshProtectGroup(protectGroup);
    }

    @Override
    protected void refresh(ProtectGroup protectGroup) {
        try {
            CheckContext context = new CheckContext(super.getServiceInstByPgId(protectGroup.getUuid()), protectGroup);
            ArrayList<ShareChecker> checkerList = new ArrayList<ShareChecker>();
            checkerList.add(new ShareChecker());
            OpenstackCache.run(() -> {
                for (IServiceInstChecker checker : checkerList) {
                    checker.check(context);
                }
                return null;
            });
            String isManualRefresh = protectGroup.getProperty("isManualRefresh");
            if (!VerifyUtil.isEmpty((String)isManualRefresh) && String.valueOf(0).equals(isManualRefresh)) {
                protectGroup.getProps().remove("isManualRefresh");
            }
            CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)protectGroup);
            this.dealSfsAlarm(context, protectGroup);
        }
        catch (LegoCheckedException ex) {
            LOG.error((Object)"Failed to update protectobject in Group(%s) by LegoCheckedException. errMsg:%s", new Object[]{protectGroup.getName(), ExceptionUtil.getErrorMessage((Throwable)ex)});
            throw ex;
        }
        catch (Exception ex) {
            LOG.error((Object)"Failed to update protectobject in Group(%s) by unexpected exception. errMsg:%s", new Object[]{protectGroup.getName(), ExceptionUtil.getErrorMessage((Throwable)ex)});
            ExceptionUtil.rethrowException((Exception)ex, (String)"Refresh SFS pg failed!", (long)0x300001L, (String[])new String[0]);
        }
    }

    private void dealSfsAlarm(CheckContext context, ProtectGroup pg) {
        LOG.debug((Object)"Begin deal Sfs Alarm of protectGroup(%s).", new Object[]{pg.getUuid()});
        Set abnormalIds = context.getAbnormalPoUuidSet();
        for (ProtectObject po : pg.getPolist()) {
            if (abnormalIds.contains(po.getUuid())) {
                LOG.error((Object)"ProtectObject(%s) of ProtectGroup(%s) abnormal.", new Object[]{po.getUuid(), pg.getUuid()});
                AlarmReporter.sendNoRepeatAlarm((long)52625520L, (String)pg.getUuid(), (String)FaultEnum.AlarmResourceType.DRMOBJECT.getValue(), (FaultEnum.AlarmSeverity)FaultEnum.AlarmSeverity.MAJOR, (String[])new String[]{po.getUuid(), pg.getName(), po.getName()});
                continue;
            }
            LOG.info((Object)"ProtectObject(%s) of ProtectGroup(%s) normal.", new Object[]{po.getUuid(), pg.getUuid()});
            AlarmReporter.restoreAlarm((long)52625520L, (String[])new String[]{po.getUuid()});
        }
        LOG.debug((Object)"End deal Sfs Alarm of protectGroup(%s).", new Object[]{pg.getUuid()});
    }
}

