/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.protection.service;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.base.util.AlarmReporter;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.openstack.cache.OpenstackCache;
import com.huawei.ism.drm.openstack.license.EvsVolumeLicenseControlImpl;
import com.huawei.ism.drm.openstack.protection.service.OpenstackPgRefreshServiceImpl;
import com.huawei.ism.drm.openstack.sdk.bo.CheckContext;
import com.huawei.ism.drm.openstack.serviceinstance.checker.EvsServiceInstanceChecker;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import java.util.Set;

public class OpenstackVolumePgRefreshServiceImpl
extends OpenstackPgRefreshServiceImpl {
    private static final Log LOG = LogFactory.getInstance(OpenstackVolumePgRefreshServiceImpl.class);

    @Override
    public void refreshProtectGroup(ProtectGroup protectGroup) {
        super.refreshProtectGroup(protectGroup);
    }

    @Override
    protected void refresh(ProtectGroup protectGroup) {
        try {
            LOG.debug((Object)"Begin refresh evs disk protectGroup(%s).", new Object[]{protectGroup.getUuid()});
            CheckContext context = new CheckContext(super.getServiceInstByPgId(protectGroup.getUuid()), protectGroup);
            OpenstackCache.run(() -> {
                new EvsServiceInstanceChecker().check(context);
                return null;
            });
            String isManualRefresh = protectGroup.getProperty("isManualRefresh");
            if (!VerifyUtil.isEmpty((String)isManualRefresh) && String.valueOf(0).equals(isManualRefresh)) {
                protectGroup.getProps().remove("isManualRefresh");
            }
            EvsVolumeLicenseControlImpl.getInstance().updatePgVolumeMap(protectGroup);
            CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)protectGroup);
            this.dealAlarm(context, protectGroup);
        }
        catch (LegoCheckedException ex) {
            LOG.error((Object)"Failed to update protect object in evs disk Group(%s) by LegoCheckedException. errMsg:%s", new Object[]{protectGroup.getName(), ExceptionUtil.getErrorMessage((Throwable)ex)});
            throw ex;
        }
        catch (Exception ex) {
            LOG.error((Object)"Failed to update protect object in evs disk Group(%s) by unexpected exception. errMsg:%s", new Object[]{protectGroup.getName(), ExceptionUtil.getErrorMessage((Throwable)ex)});
            ExceptionUtil.rethrowException((Exception)ex, (String)"Refresh evs disk pg failed!", (long)0x300001L, (String[])new String[0]);
        }
    }

    private void dealAlarm(CheckContext context, ProtectGroup pg) {
        LOG.debug((Object)"Begin deal evs disk Alarm of protectGroup(%s).", new Object[]{pg.getUuid()});
        this.dealUnprotectedVolumeAlarm(context.getAbnormalPoUuidSet(), pg);
        this.dealConsistGroupAlarm(context.getCgStatusErrorIds(), pg);
        LOG.debug((Object)"End deal evs disk Alarm of protectGroup(%s).", new Object[]{pg.getUuid()});
    }

    private void dealConsistGroupAlarm(Set<String> cgStatusError, ProtectGroup pg) {
        if (VerifyUtil.isEmpty(cgStatusError)) {
            LOG.info((Object)"Evs disk ProtectGroup(%s) normal.", new Object[]{pg.getUuid()});
            AlarmReporter.restoreAlarm((long)52625455L, (String[])new String[]{pg.getUuid()});
            return;
        }
        LOG.error((Object)"Evs disk ProtectGroup(%s) abnormal.", new Object[]{pg.getUuid()});
        String cgId = (String)pg.getProps().get("replicaCgUuid");
        AlarmReporter.sendAlarm((long)52625455L, (String)pg.getUuid(), (String)FaultEnum.AlarmResourceType.DRMOBJECT.getValue(), (FaultEnum.AlarmSeverity)FaultEnum.AlarmSeverity.CRITICAL, (String[])new String[]{pg.getUuid(), pg.getName(), cgId, ServiceInstaceEnumDefine.ServiceInstanceTypeE.getFrontInstanceType((String)((String)pg.getProps().get("serviceInstanceType")))});
    }

    private void dealUnprotectedVolumeAlarm(Set<String> abnormalIds, ProtectGroup pg) {
        for (ProtectObject po : pg.getPolist()) {
            if (abnormalIds.contains(po.getUuid())) {
                LOG.error((Object)"ProtectObject(%s) of Evs disk ProtectGroup(%s) abnormal.", new Object[]{po.getUuid(), pg.getUuid()});
                AlarmReporter.sendNoRepeatAlarm((long)52625542L, (String)pg.getUuid(), (String)FaultEnum.AlarmResourceType.DRMOBJECT.getValue(), (FaultEnum.AlarmSeverity)FaultEnum.AlarmSeverity.MAJOR, (String[])new String[]{po.getUuid(), pg.getName(), po.getName()});
                continue;
            }
            LOG.info((Object)"ProtectObject(%s) of Evs disk ProtectGroup(%s) normal.", new Object[]{po.getUuid(), pg.getUuid()});
            AlarmReporter.restoreAlarm((long)52625542L, (String[])new String[]{po.getUuid()});
        }
    }
}

