/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.observer;

import com.google.common.collect.ImmutableSet;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.common.sdk.model.DRMObject;
import com.huawei.ism.drm.common.sdk.model.MessageEvent;
import com.huawei.ism.drm.common.sdk.model.ServiceInstance;
import com.huawei.ism.drm.common.sdk.service.IObjectObserver;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.adapter.manager.INovaManager;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.protection.service.OpenstackPgRefreshServiceImpl;
import com.huawei.ism.drm.openstack.recovery.utils.OpenStackRecoveryTool;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVM;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeReplicationCgInfo;
import com.huawei.ism.drm.openstack.serviceinstance.ServiceInstanceHelper;
import com.huawei.ism.drm.openstack.tools.OpenStackBasicUtil;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.framework.template.util.PolicyTemplateTools;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.protection.task.sdk.service.IProtectionTaskService;
import com.huawei.ism.drm.recovery.framework.task.FixedRecoveryThreadPool;
import com.huawei.ism.drm.system.thirdservice.sdk.model.CloudConfig;
import com.huawei.ism.drm.system.thirdservice.sdk.service.ICloudConfigService;
import com.huawei.ism.drm.virtualization.sdk.util.ProtectObjectStatusEnum;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.nem.fault.sdk.service.IAlarmService;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.springframework.orm.hibernate5.HibernateTemplate;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public class RecoveryPlanOperateObserver
implements IObjectObserver {
    private static final Log LOG = LogFactory.getInstance(RecoveryPlanOperateObserver.class);
    private static Map<String, String> statusMap = new HashMap<String, String>();
    private static final Set<Integer> CSHA_CSDR_UPDATE_PROPERTY_EXECUTE_TYPE_SET = ImmutableSet.of((Object)DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue(), (Object)DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY.getValue(), (Object)DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING.getValue(), (Object)DrmEnumDefine.RecoveryPlanExecuteTypeE.CLEAN_DRILLING.getValue());
    private static final Set<Integer> NO_NEED_CHECK_VM_TYPE = ImmutableSet.of((Object)17, (Object)22);

    public void before(MessageEvent event) {
        LOG.info((Object)"Enter before RecoveryPlanOperateObserver");
        this.changeStatus(event, "before");
    }

    public void after(MessageEvent event) {
        this.changeStatus(event, "after");
    }

    public String getObserverType() {
        return RecoveryPlan.class.getName();
    }

    private void changeStatus(MessageEvent event, String notifyType) {
        Object type = event.getMessageMap().get("message_event_excute_type");
        LOG.info((Object)"MESSAGEEVENT_EXECUTE_TYPE: %s", new Object[]{type});
        if (type == null || !(type instanceof DrmEnumDefine.RecoveryPlanExecuteTypeE)) {
            LOG.info((Object)"Excute type is not right");
            return;
        }
        List objectList = event.getObjectList();
        if (VerifyUtil.isEmpty((Collection)objectList)) {
            return;
        }
        int messageType = event.getMessageType();
        DRMObject object = (DRMObject)CommonUtil.getFirstElement((Collection)objectList);
        if (!(object instanceof RecoveryPlan)) {
            return;
        }
        DrmEnumDefine.RecoveryPlanExecuteTypeE excuteType = (DrmEnumDefine.RecoveryPlanExecuteTypeE)type;
        RecoveryPlan recoveryPlan = (RecoveryPlan)object;
        DrmEnumDefine.RecoveryPlanOperationType opreateType = DrmEnumDefine.RecoveryPlanOperationType.getType((int)excuteType.getValue());
        if (ServiceInstaceEnumDefine.ObjectType.NAS.getValue().equals(recoveryPlan.getObjectType())) {
            long changeNasStatusBefore = System.currentTimeMillis();
            this.changeNasStatus(messageType, recoveryPlan, notifyType, excuteType, opreateType);
            LOG.info((Object)"ChangeNasStatus cost %s ms, notifyType:%s.", new Object[]{System.currentTimeMillis() - changeNasStatusBefore, notifyType});
            return;
        }
        this.executeChangeStatus(notifyType, excuteType, opreateType, messageType, recoveryPlan);
    }

    private void executeChangeStatus(String notifyType, DrmEnumDefine.RecoveryPlanExecuteTypeE excuteType, DrmEnumDefine.RecoveryPlanOperationType opreateType, int messageType, RecoveryPlan recoveryPlan) {
        Stream protectGroupStream = recoveryPlan.getProtectGroups().stream();
        protectGroupStream.forEach(protectGroup -> {
            String instanceId = (String)protectGroup.getProps().get("SERVICEINSTANCE_UUID");
            if (VerifyUtil.isEmpty((String)instanceId)) {
                LOG.info((Object)"Change instance status on recoveryPlan excute : instanceId is null");
                return;
            }
            ServiceInstance instance = this.getServiceInstanceById(instanceId);
            if (messageType == 7) {
                this.updateRecoveryPropsForPg(recoveryPlan, opreateType);
            }
            if (!this.isNeedModify(instance, (ProtectGroup)protectGroup, excuteType)) {
                this.setCshaCsdrStatusForExternal(excuteType, (ProtectGroup)protectGroup);
                LOG.info((Object)"Change instance status : replica model is not replication,%s", new Object[]{instance.getType()});
                return;
            }
            if (messageType == 6) {
                if ("before".equals(notifyType)) {
                    this.beforeChangeStatus(instance, opreateType);
                    ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).saveOrUpdateProtectGroupProps(recoveryPlan.getProtectGroup().getUuid(), recoveryPlan.getProtectGroup().getProps());
                } else if ("after".equals(notifyType)) {
                    this.changeInstanceProjectId(excuteType, recoveryPlan, (ProtectGroup)protectGroup, instance);
                }
            } else if (messageType == 7) {
                this.validateRecoveryPlan(excuteType, opreateType, recoveryPlan, (ProtectGroup)protectGroup, instance);
            }
        });
    }

    private void validateRecoveryPlan(DrmEnumDefine.RecoveryPlanExecuteTypeE excuteType, DrmEnumDefine.RecoveryPlanOperationType opreateType, RecoveryPlan recoveryPlan, ProtectGroup protectGroup, ServiceInstance instance) {
        this.checkOperatePermission(excuteType, opreateType, recoveryPlan, instance);
        this.checkPhVmExist(recoveryPlan, opreateType);
        this.checkReplicationStatus(protectGroup, opreateType, recoveryPlan);
        this.checkInstanceAlarms(excuteType, protectGroup, instance);
    }

    private void changeInstanceProjectId(DrmEnumDefine.RecoveryPlanExecuteTypeE excuteType, RecoveryPlan recoveryPlan, ProtectGroup protectGroup, ServiceInstance instance) {
        boolean isEvsDisasterRecovery;
        String projectId = null;
        boolean isReprotect = DrmEnumDefine.RecoveryPlanExecuteTypeE.REPROTECT.getValue() == excuteType.getValue();
        boolean isPlanedMotion = DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue() == excuteType.getValue();
        boolean isEvsType = ServiceInstaceEnumDefine.ObjectType.EVS.getValue().equals(instance.getObjectType());
        boolean bl = isEvsDisasterRecovery = DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY.getValue() == excuteType.getValue() && isEvsType;
        if (isReprotect || isPlanedMotion || isEvsDisasterRecovery) {
            String projectUuid = (String)protectGroup.getProps().get("projectId");
            projectId = OpenStackCommonUtil.getIdFromUuid(projectUuid);
        }
        this.afterChangeInstance(recoveryPlan, instance, projectId);
        this.setCshaCsdrStatusForExternal(excuteType, protectGroup);
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.REPROTECT.getValue() == excuteType.getValue() || DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue() == excuteType.getValue() || DrmEnumDefine.RecoveryPlanExecuteTypeE.HOT_MIGRATION.getValue() == excuteType.getValue() && PolicyTemplateTools.getInstance().isHyperMetroTemplate(protectGroup)) {
            this.asyncRefreshInstance(instance);
        } else if (DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY.getValue() == excuteType.getValue()) {
            OpenStackRecoveryTool.operateReplicationFlagOfPg(protectGroup, !isEvsType);
        }
    }

    private void checkInstanceAlarms(DrmEnumDefine.RecoveryPlanExecuteTypeE excuteType, ProtectGroup protectGroup, ServiceInstance instance) {
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING.getValue() == excuteType.getValue() || DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue() == excuteType.getValue()) {
            String entityId = "10x3230046" + protectGroup.getUuid();
            if (((IAlarmService)ServiceLocator.getInstance().getService(IAlarmService.class)).hasUnclearedAlarm(entityId)) {
                LOG.error((Object)"Can not execute recovery plan of %s, instance has uncleared alarm.", new Object[]{instance.getName()});
                throw new LegoCheckedException(1073949737L, new String[]{instance.getName()});
            }
        }
    }

    private void setCshaCsdrStatusForExternal(DrmEnumDefine.RecoveryPlanExecuteTypeE excuteType, ProtectGroup protectGroup) {
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY.getValue() == excuteType.getValue() && PolicyTemplateTools.getInstance().isCshaCsdrWithinRegionRecovery(protectGroup)) {
            ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).updateProtectGroupStatus(DrmEnumDefine.ProtectGroupStatus.NORMAL, new String[]{protectGroup.getUuid()});
        }
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.REPROTECT.getValue() == excuteType.getValue() && PolicyTemplateTools.getInstance().isCshaCsdrWithinRegionRecovery(protectGroup)) {
            IProtectionTaskService service = (IProtectionTaskService)ServiceLocator.getInstance().getService(IProtectionTaskService.class);
            service.resumeTasks(protectGroup.getUuid());
        }
    }

    private void checkOperatePermission(DrmEnumDefine.RecoveryPlanExecuteTypeE excuteType, DrmEnumDefine.RecoveryPlanOperationType opreateType, RecoveryPlan recoveryPlan, ServiceInstance instance) {
        boolean isFailureRecovery;
        ProtectGroup protectGroup = recoveryPlan.getProtectGroup();
        String key = RecoveryPlanOperateObserver.generateCheckKey(ServiceInstaceEnumDefine.ServiceInstanceStatusE.getType((String)instance.getStatus()), opreateType);
        if (VerifyUtil.isEmpty((String)statusMap.get(key))) {
            LOG.error((Object)("Instance( " + instance.getId() + " ) not allow the operation.instance status:" + instance.getStatus() + " operation type:" + opreateType.getValue()));
            throw new LegoCheckedException(1073948693L);
        }
        boolean isSupportFailureRecovery = protectGroup.getTemplate().getType() == 37 && !OpenStackCommonUtil.isCsdrCshaMode(protectGroup) || protectGroup.getTemplate().getType() == 56;
        boolean bl = isFailureRecovery = DrmEnumDefine.RecoveryPlanStatusE.DISASTER_RECOVERY_COMPLETED.equals((Object)DrmEnumDefine.RecoveryPlanStatusE.getType((int)recoveryPlan.getPlanStatus())) && excuteType.getValue() == DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY.getValue();
        if (!isSupportFailureRecovery && isFailureRecovery) {
            throw new LegoCheckedException(1073948693L);
        }
    }

    private void asyncRefreshInstance(ServiceInstance instance) {
        FixedRecoveryThreadPool.submit(() -> {
            this.refreshInstance(instance);
            return true;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshInstance(ServiceInstance instance) {
        String instanceId = instance.getId();
        if (!ServiceInstanceHelper.getInstance().getLock(instanceId)) {
            LOG.error((Object)"Failed to refresh instance.can not get this instance lock,instanceId:%s,instanceName=%s", new Object[]{instanceId, instance.getName()});
            throw new LegoCheckedException(1073948693L);
        }
        try {
            CommonUtil.sleep((long)5L, (TimeUnit)TimeUnit.SECONDS);
            instance = this.getServiceInstanceById(instanceId);
            if (!ServiceInstaceEnumDefine.ServiceInstanceStatusE.NORMAL.getValue().equals(instance.getStatus()) && !ServiceInstaceEnumDefine.ObjectType.SFS.getValue().equals(instance.getObjectType())) {
                LOG.error((Object)"Instance name:%s status:%s not normal,", new Object[]{instance.getName(), instance.getStatus()});
                throw new LegoCheckedException(1073948693L);
            }
            IProtectGroupService pgService = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
            ProtectGroup protectGroup = pgService.getProtectGroupByID(instance.getProtectGroupId(), true);
            if (null == protectGroup) {
                LOG.error((Object)"Failed to refresh instance .protectGroup is null. protectGroupId=%s, instanceName=%s", new Object[]{instance.getProtectGroupId(), instance.getName()});
                throw new LegoCheckedException(2117645L);
            }
            LOG.debug((Object)"Refresh instance. the inst status:%s,instanceName=%s,pg status:%s", new Object[]{instance.getStatus(), instance.getName(), protectGroup.getStatus()});
            if (ServiceInstaceEnumDefine.ObjectType.SFS.getValue().equals(instance.getObjectType())) {
                protectGroup.getProps().put("isManualRefresh", Integer.toString(1));
            } else {
                protectGroup.getProps().remove("isManualRefresh");
            }
            OpenstackPgRefreshServiceImpl refreshService = new OpenstackPgRefreshServiceImpl();
            refreshService.refreshProtectGroup(protectGroup);
        }
        finally {
            ServiceInstanceHelper.getInstance().releaseLock(instanceId);
        }
    }

    private boolean isNeedModify(ServiceInstance instance, ProtectGroup pg, DrmEnumDefine.RecoveryPlanExecuteTypeE excuteType) {
        if (ServiceInstaceEnumDefine.ServiceInstanceTypeE.REPLICATION.getValue().equals(instance.getType()) && !"csha_csdr".equals(instance.getProtectType())) {
            return true;
        }
        if (ServiceInstaceEnumDefine.ServiceInstanceTypeE.HYPERMETRO.getValue().equals(instance.getType()) || PolicyTemplateTools.getInstance().isCshaCsdrWithinRegionRecovery(pg)) {
            if (DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue() == excuteType.getValue() || DrmEnumDefine.RecoveryPlanExecuteTypeE.HOT_MIGRATION.getValue() == excuteType.getValue()) {
                ServiceInstanceHelper.getInstance().checkServiceInstPoInfo(instance);
                return true;
            }
            if (DrmEnumDefine.RecoveryPlanExecuteTypeE.REPROTECT.getValue() == excuteType.getValue() || DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY.getValue() == excuteType.getValue()) {
                String regionUuid = pg.getProperty("regionId");
                return !RecoveryPlanOperateObserver.isAutoExe(OpenStackBasicUtil.getIdFromUuid(regionUuid));
            }
            return true;
        }
        return true;
    }

    private void checkPhVmExist(RecoveryPlan recoveryPlan, DrmEnumDefine.RecoveryPlanOperationType type) {
        ProtectGroup pg = (ProtectGroup)CommonUtil.getFirstElement((Collection)recoveryPlan.getProtectGroups());
        if (NO_NEED_CHECK_VM_TYPE.contains(pg.getPoType())) {
            LOG.warn((Object)"No vm check is required for type(%s)", (long)pg.getPoType());
            return;
        }
        HashSet<DrmEnumDefine.RecoveryPlanOperationType> cshaCsdrCheckType = new HashSet<DrmEnumDefine.RecoveryPlanOperationType>(Arrays.asList(DrmEnumDefine.RecoveryPlanOperationType.DRILLING, DrmEnumDefine.RecoveryPlanOperationType.PLANED_MOTION, DrmEnumDefine.RecoveryPlanOperationType.REPROTECT, DrmEnumDefine.RecoveryPlanOperationType.HOT_MIGRATION));
        if (37 == pg.getTemplate().getType() && cshaCsdrCheckType.contains(type)) {
            String phVmDrRegion = pg.getProperty("drRegionId");
            String phVmDrProjectUuid = pg.getProperty("drProjectId");
            String cshaPhVmRegion = OpenStackCommonUtil.isCsdrCshaMode(pg) ? phVmDrRegion : pg.getProperty("regionId");
            String cshaPhVmProjectUuid = OpenStackCommonUtil.isCsdrCshaMode(pg) ? phVmDrProjectUuid : pg.getProperty("projectId");
            Set<String> cshaOpenstackVmSet = this.getOpenStackVmSet(cshaPhVmRegion, cshaPhVmProjectUuid);
            this.checkIsVmExist(recoveryPlan, "CSHAPLACEHOLDVM", cshaOpenstackVmSet);
            Set<String> phVmOpenstackVmSet = this.getOpenStackVmSet(phVmDrRegion, phVmDrProjectUuid);
            this.checkIsVmExist(recoveryPlan, "PLACEHOLDVM", phVmOpenstackVmSet);
            return;
        }
        HashSet<DrmEnumDefine.RecoveryPlanOperationType> needCheckType = new HashSet<DrmEnumDefine.RecoveryPlanOperationType>(Arrays.asList(DrmEnumDefine.RecoveryPlanOperationType.DRILLING, DrmEnumDefine.RecoveryPlanOperationType.PLANED_MOTION, DrmEnumDefine.RecoveryPlanOperationType.DISASTER_RECOVERY, DrmEnumDefine.RecoveryPlanOperationType.HOT_MIGRATION));
        if (!needCheckType.contains(type)) {
            return;
        }
        boolean isWithinRegionRecovery = PolicyTemplateTools.getInstance().isCshaCsdrWithinRegionRecovery(pg);
        String regionUuid = isWithinRegionRecovery ? pg.getProperty("regionId") : (String)pg.getProps().get("drRegionId");
        String projectUuid = isWithinRegionRecovery ? pg.getProperty("projectId") : (String)pg.getProps().get("drProjectId");
        Set<String> openstackVmSet = this.getOpenStackVmSet(regionUuid, projectUuid);
        String vmTab = isWithinRegionRecovery ? "CSHAPLACEHOLDVM" : "PLACEHOLDVM";
        this.checkIsVmExist(recoveryPlan, vmTab, openstackVmSet);
    }

    private void checkIsVmExist(RecoveryPlan recoveryPlan, String vmTab, Set<String> openstackVmSet) {
        ProtectGroup pg = (ProtectGroup)CommonUtil.getFirstElement((Collection)recoveryPlan.getProtectGroups());
        for (ProtectObject po : pg.getPolist()) {
            if (ProtectObjectStatusEnum.INVALID.getValue() == po.getPoStatus()) continue;
            String phVmUuid = OpenStackRecoveryTool.getPoRecoverySetting(recoveryPlan, po, vmTab);
            if (VerifyUtil.isEmpty((String)phVmUuid)) {
                LOG.error((Object)("No set PhVm, srcVm uuid is: " + po.getMoUuid()));
                throw new LegoCheckedException(1073948908L, "no set PhVm, srcVm uuid is: " + po.getMoUuid());
            }
            if (openstackVmSet.contains(phVmUuid)) continue;
            LOG.error((Object)("PhVm does not exist, PhVm uuid is: " + phVmUuid));
            throw new LegoCheckedException(1073948375L, "PhVm does not exist, PhVm uuid is: " + phVmUuid);
        }
    }

    private Set<String> getOpenStackVmSet(String regionUuid, String projectUuid) {
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid);
        INovaManager novaMgr = ManagerFactory.getInstance().getNovaManager(openstackUuid);
        String tokenId = TokenUtil.getInstance().getRegionTokenId(regionUuid, projectUuid);
        List<OpenStackVM> openstackVmList = novaMgr.getVms(regionUuid, tokenId, projectUuid);
        HashSet<String> openstackVmSet = new HashSet<String>();
        for (OpenStackVM vm : openstackVmList) {
            openstackVmSet.add(vm.getUuid());
        }
        return openstackVmSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void beforeChangeStatus(ServiceInstance instance, DrmEnumDefine.RecoveryPlanOperationType type) {
        ServiceInstanceHelper instanceHelper = ServiceInstanceHelper.getInstance();
        LOG.info((Object)"Change instance status before excute.");
        if (!instanceHelper.getLock(instance.getId())) {
            LOG.error((Object)("Get instance( " + instance.getId() + " ) lock faild."));
            throw new LegoCheckedException(1073948693L);
        }
        try {
            ServiceInstaceEnumDefine.ServiceInstanceStatusE status = ServiceInstaceEnumDefine.ServiceInstanceStatusE.getType((String)statusMap.get(RecoveryPlanOperateObserver.generateBeforeKey(type)));
            instanceHelper.changeStatus(instance.getId(), status);
        }
        finally {
            instanceHelper.releaseLock(instance.getId());
        }
    }

    private void afterChangeInstance(RecoveryPlan recoveryPlan, ServiceInstance instance, String projectId) {
        ServiceInstanceHelper instanceHelper = ServiceInstanceHelper.getInstance();
        LOG.info((Object)"Change instance status after excute.");
        if (!instanceHelper.getLock(instance.getId())) {
            LOG.error((Object)("Get instance( " + instance.getId() + " ) lock faild."));
            throw new LegoCheckedException(1073948693L);
        }
        try {
            instance = this.getServiceInstanceById(instance.getId());
            if (!VerifyUtil.isEmpty((String)projectId)) {
                instance.setProjectId(projectId);
            }
            recoveryPlan = this.getRecoveryPlanById(recoveryPlan.getPlanId());
            DrmEnumDefine.RecoveryPlanStatusE recoveryStatus = DrmEnumDefine.RecoveryPlanStatusE.getType((int)recoveryPlan.getPlanStatus());
            LOG.info((Object)"%s afterExcute recoveryStatus:%s", new Object[]{recoveryPlan.getName(), recoveryStatus});
            ProtectGroup pg = (ProtectGroup)CommonUtil.getFirstElement((Collection)recoveryPlan.getProtectGroups());
            if (pg.getTemplate().getType() == 56 && recoveryPlan.getPlanStatus() == DrmEnumDefine.RecoveryPlanStatusE.DISASTER_RECOVERY_COMPLETED.getValue()) {
                recoveryStatus = DrmEnumDefine.RecoveryPlanStatusE.REPROTECT_COMPLETED;
                recoveryPlan.setPlanStatus(DrmEnumDefine.RecoveryPlanStatusE.REPROTECT_COMPLETED.getValue());
                CommonDAOLocator.getBaseDao().getHibernateTemplate().update((Object)recoveryPlan);
            }
            ServiceInstaceEnumDefine.ServiceInstanceStatusE inStatus = ServiceInstaceEnumDefine.ServiceInstanceStatusE.getType((String)statusMap.get(RecoveryPlanOperateObserver.generateAfterKey(recoveryStatus)));
            LOG.info((Object)"%s afterExcute inStatus:%s", new Object[]{instance.getName(), inStatus});
            if (!VerifyUtil.isEmpty((Object)inStatus)) {
                instance.setStatus(inStatus.getValue());
            }
            CommonDAOLocator.getBaseDao().getHibernateTemplate().update((Object)instance);
        }
        catch (Exception e) {
            LOG.error((Object)("Save instance error." + ExceptionUtil.getErrorMessage((Throwable)e)));
            throw new LegoCheckedException(-1L, "save instance error.", (Throwable)e);
        }
        finally {
            instanceHelper.releaseLock(instance.getId());
        }
    }

    private ServiceInstance getServiceInstanceById(String instanceId) {
        ServiceInstance instance = (ServiceInstance)CommonDAOLocator.getBaseDao().getHibernateTemplate().get(ServiceInstance.class, (Serializable)((Object)instanceId));
        if (null == instance) {
            LOG.error((Object)"Instance is empty.");
            throw new LegoCheckedException(201L, "instance is empty.");
        }
        return instance;
    }

    private RecoveryPlan getRecoveryPlanById(String recoveryPlanId) {
        IRecoveryPlanService recoveryPlanService = (IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class);
        RecoveryPlan plan = recoveryPlanService.getRecoveryPlan(recoveryPlanId, false, false);
        if (null == plan) {
            LOG.error((Object)"Instance is empty.");
            throw new LegoCheckedException(201L, "instance is empty.");
        }
        return plan;
    }

    private static String generateBeforeKey(DrmEnumDefine.RecoveryPlanOperationType operation) {
        if (null == operation) {
            LOG.error((Object)"RECOVERY_PLAN_OPERATION_TYPE is null");
            throw new LegoCheckedException(1073947393L, "operationE is null.");
        }
        return "before:" + operation.getValue();
    }

    private static String generateAfterKey(DrmEnumDefine.RecoveryPlanStatusE status) {
        if (null == status) {
            LOG.error((Object)"RECOVERY_PLAN_STATUS_E is null");
            throw new LegoCheckedException(1073947393L, "status is null.");
        }
        return "after:" + status.getValue();
    }

    private static String generateCheckKey(ServiceInstaceEnumDefine.ServiceInstanceStatusE status, DrmEnumDefine.RecoveryPlanOperationType operation) {
        if (null == status || null == operation) {
            LOG.error((Object)"Status or operation is null");
            throw new LegoCheckedException(1073947393L, "operation or status is null.");
        }
        return "check:" + status.getValue() + ":" + operation.getValue();
    }

    public static boolean isAutoExe(String regionId) {
        String autoRecoveryValue;
        boolean result = true;
        ICloudConfigService cloudService = (ICloudConfigService)ServiceLocator.getInstance().getService(ICloudConfigService.class);
        CloudConfig config = cloudService.getCloudConfigBy("system");
        if (null != config && null != config.getProps() && !VerifyUtil.isEmpty((String)(autoRecoveryValue = (String)config.getProps().get(regionId + "_" + "system_autorecovery")))) {
            result = Boolean.parseBoolean(autoRecoveryValue);
        }
        return result;
    }

    private void checkReplicationStatus(ProtectGroup pg, DrmEnumDefine.RecoveryPlanOperationType operation, RecoveryPlan recoveryPlan) {
        HashSet<DrmEnumDefine.RecoveryPlanOperationType> cshaCsdrCheckType = new HashSet<DrmEnumDefine.RecoveryPlanOperationType>(Arrays.asList(DrmEnumDefine.RecoveryPlanOperationType.DRILLING, DrmEnumDefine.RecoveryPlanOperationType.PLANED_MOTION));
        if (37 == pg.getTemplate().getType() && cshaCsdrCheckType.contains(operation)) {
            List<String> availableReplicationRepStatus = Arrays.asList(OpenstackEnumDefine.ReplicationRepStatusE.ACTIVESTOPPED.getValue(), OpenstackEnumDefine.ReplicationRepStatusE.ACTIVE.getValue(), OpenstackEnumDefine.ReplicationRepStatusE.STANDBY.getValue());
            String hyperReplicaCgUuid = pg.getProperty("hyperProdrCgUuid");
            String drReplicaCgUuid = pg.getProperty("drReplicaCgUuid");
            VolumeReplicationCgInfo cgInfo = OpenStackCommonUtil.getVolumeReplicaCgInfoForHyperMetro(pg, false);
            if (null == cgInfo || !OpenstackEnumDefine.ReplicationStatusE.AVAILABLE.getValue().equals(cgInfo.getStatus())) {
                LOG.error((Object)"Hypermetro cg: %s is null or replication status is not available", new Object[]{hyperReplicaCgUuid});
                throw new LegoCheckedException(1073949707L, new String[]{OpenStackCommonUtil.getIdFromUuid(hyperReplicaCgUuid)});
            }
            if (!availableReplicationRepStatus.contains(cgInfo.getReplicationStatus())) {
                LOG.error((Object)"Hypermetro cg: %s replication rep status is(%s) not normal\uff08active\\active-stop\uff09", new Object[]{hyperReplicaCgUuid, cgInfo.getReplicationStatus()});
                throw new LegoCheckedException(1073949707L, new String[]{OpenStackCommonUtil.getIdFromUuid(hyperReplicaCgUuid)});
            }
            this.checkReplicationCgInfo(pg, availableReplicationRepStatus, drReplicaCgUuid);
            return;
        }
        if (!DrmEnumDefine.RecoveryPlanOperationType.DRILLING.equals((Object)operation) && !DrmEnumDefine.RecoveryPlanOperationType.PLANED_MOTION.equals((Object)operation) || 21 != pg.getTemplate().getType()) {
            return;
        }
        HashSet<Integer> needCheckStatus = new HashSet<Integer>(Arrays.asList(DrmEnumDefine.RecoveryPlanStatusE.READY.getValue(), DrmEnumDefine.RecoveryPlanStatusE.REPROTECT_COMPLETED.getValue(), DrmEnumDefine.RecoveryPlanStatusE.CLEAN_COMPLETED.getValue()));
        if (!needCheckStatus.contains(recoveryPlan.getPlanStatus())) {
            LOG.debug((Object)"pg name is:%s,recoveryPlan:%s status:%s not normal,no need checkReplicationStatus", new Object[]{pg.getName(), recoveryPlan.getName(), recoveryPlan.getPlanStatus()});
            return;
        }
        String replicationStatus = OpenStackCommonUtil.getRealTimeCGReplicaStatus(pg);
        if (!OpenstackEnumDefine.ReplicationRepStatusE.ACTIVE.getValue().equals(replicationStatus)) {
            LOG.debug((Object)"Pg name is %s,replica's replicaionstatus is:%s,can't excute planed-motion or test.", new Object[]{pg.getName(), replicationStatus});
            throw new LegoCheckedException(1073947722L);
        }
    }

    private void checkReplicationCgInfo(ProtectGroup pg, List<String> availableReplicationRepStatus, String drReplicaCgUuid) {
        VolumeReplicationCgInfo cgInfo = OpenStackCommonUtil.getVolumeReplicationCgInfo(pg, false, new int[0]);
        if (null == cgInfo || !OpenstackEnumDefine.ReplicationStatusE.AVAILABLE.getValue().equals(cgInfo.getStatus())) {
            LOG.error((Object)"Replicate cg: %s is null or replication status is not available", new Object[]{drReplicaCgUuid});
            throw new LegoCheckedException(1073949708L, new String[]{OpenStackCommonUtil.getIdFromUuid(drReplicaCgUuid)});
        }
        if (!availableReplicationRepStatus.contains(cgInfo.getReplicationStatus())) {
            LOG.error((Object)"Replicate cg: %s replication rep status is(%s) not normal\uff08active\\standby\\active-stop\uff09", new Object[]{drReplicaCgUuid, cgInfo.getReplicationStatus()});
            throw new LegoCheckedException(1073949708L, new String[]{OpenStackCommonUtil.getIdFromUuid(drReplicaCgUuid)});
        }
    }

    private void updateRecoveryPropsForPg(RecoveryPlan recoveryPlan, DrmEnumDefine.RecoveryPlanOperationType procType) {
        ProtectGroup pg = recoveryPlan.getProtectGroup();
        if (37 != pg.getTemplate().getType()) {
            return;
        }
        String recoveryRegion = (String)recoveryPlan.getGlobalSettings().get("recovery_region_id");
        String recoveryAz = (String)recoveryPlan.getGlobalSettings().get("recovery_az_id");
        if (CSHA_CSDR_UPDATE_PROPERTY_EXECUTE_TYPE_SET.contains(procType.getValue())) {
            OpenStackRecoveryTool.setRecoveryRegionForCshaCsdrPg(pg, recoveryRegion, this.getExecuteRecoveryRegionType(recoveryPlan, procType, pg, recoveryRegion), recoveryAz);
        }
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.HOT_MIGRATION.getValue() == procType.getValue()) {
            OpenStackRecoveryTool.setRecoveryRegionForCshaCsdrPg(pg, OpenStackCommonUtil.getIdFromUuid(pg.getProperty("regionId")), "REGION_TYPE_WITHIN", OpenStackCommonUtil.getIdFromUuid(pg.getProperty("prod_region_drZoneName")));
        }
    }

    private String getExecuteRecoveryRegionType(RecoveryPlan recoveryPlan, DrmEnumDefine.RecoveryPlanOperationType procType, ProtectGroup pg, String recoveryRegion) {
        String currentRegion = OpenStackCommonUtil.getIdFromUuid(pg.getProperty("regionId"));
        String recoveryRegionType = recoveryRegion.equals(currentRegion) ? "REGION_TYPE_WITHIN" : "REGION_TYPE_BETWEEN";
        String currentDisasterRegion = OpenStackCommonUtil.getIdFromUuid(pg.getProperty("current_disaster_region"));
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY.getValue() == procType.getValue() && DrmEnumDefine.RecoveryPlanStatusE.DISASTER_RECOVERY_COMPLETED.getValue() == recoveryPlan.getPlanStatus()) {
            recoveryRegionType = "REGION_TYPE_BETWEEN";
            pg.setProperty("IsSecondDisasterRecovery", (Object)"true");
        } else if (!VerifyUtil.isEmpty((String)currentDisasterRegion) && DrmEnumDefine.RecoveryPlanStatusE.DISASTER_RECOVERY_COMPLETED.getValue() == recoveryPlan.getPlanStatus() && DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY.getValue() == procType.getValue()) {
            String string = recoveryRegionType = recoveryRegion.equals(currentDisasterRegion) ? "REGION_TYPE_WITHIN" : "REGION_TYPE_BETWEEN";
        }
        if (recoveryPlan.getPlanStatus() == DrmEnumDefine.RecoveryPlanStatusE.PLANED_MOTION_FAILED.getValue()) {
            recoveryRegionType = pg.getProperty("RECOVERY_REGION_TYPE");
        }
        return recoveryRegionType;
    }

    private void changeNasStatus(int messageType, final RecoveryPlan recoveryPlan, String notifyType, DrmEnumDefine.RecoveryPlanExecuteTypeE excuteType, DrmEnumDefine.RecoveryPlanOperationType opreateType) {
        if (messageType == 7) {
            String instanceId = Optional.ofNullable(this.getRecoveryPlanById(recoveryPlan.getPlanId())).map(RecoveryPlan::getProtectGroup).map(protectGroup -> protectGroup.getProperty("SERVICEINSTANCE_UUID")).orElse(null);
            if (VerifyUtil.isEmpty((String)instanceId)) {
                LOG.info((Object)"Change instance status on recoveryPlan excute : instanceId is null");
                return;
            }
            ServiceInstance instance = this.getServiceInstanceById(instanceId);
            this.checkOperatePermission(excuteType, opreateType, recoveryPlan, instance);
        }
        if (messageType != 6) {
            logger.debug((Object)"Nothing need to do on messageType:%s.", (long)messageType);
            return;
        }
        if ("before".equals(notifyType)) {
            final ServiceInstaceEnumDefine.ServiceInstanceStatusE status = ServiceInstaceEnumDefine.ServiceInstanceStatusE.getType((String)statusMap.get(RecoveryPlanOperateObserver.generateBeforeKey(opreateType)));
            this.doInTransaction(new TransactionCallbackWithoutResult(){

                protected void doInTransactionWithoutResult(TransactionStatus transactionStatus) {
                    RecoveryPlanOperateObserver.this.updateServiceInstanceStatus(status.getValue(), recoveryPlan.getProtectGroups().stream().map(protectGroup -> protectGroup.getProperty("SERVICEINSTANCE_UUID")).collect(Collectors.toSet()));
                }
            });
        } else if ("after".equals(notifyType)) {
            this.changeNasStatusAfterRecovery(recoveryPlan, excuteType);
        } else {
            logger.warn((Object)"Nothing need to do on messageType:%s, notifyType:%s.", new Object[]{messageType, notifyType});
        }
    }

    private void doInTransaction(TransactionCallbackWithoutResult action) {
        ((TransactionTemplate)ServiceLocator.getInstance().getService(TransactionTemplate.class)).execute((TransactionCallback)action);
    }

    private void changeNasStatusAfterRecovery(RecoveryPlan recoveryPlan, final DrmEnumDefine.RecoveryPlanExecuteTypeE excuteType) {
        final RecoveryPlan recoveryPlanInDb = this.getRecoveryPlanById(recoveryPlan.getPlanId());
        DrmEnumDefine.RecoveryPlanStatusE recoveryStatus = DrmEnumDefine.RecoveryPlanStatusE.getType((int)recoveryPlanInDb.getPlanStatus());
        LOG.info((Object)"%s afterExcute recoveryStatus:%s", new Object[]{recoveryPlanInDb.getName(), recoveryStatus});
        final ServiceInstaceEnumDefine.ServiceInstanceStatusE inStatus = ServiceInstaceEnumDefine.ServiceInstanceStatusE.getType((String)statusMap.get(RecoveryPlanOperateObserver.generateAfterKey(recoveryStatus)));
        LOG.info((Object)"afterExcute sfs inStatus:%s", new Object[]{inStatus});
        this.doInTransaction(new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                RecoveryPlanOperateObserver.this.updateServiceInstanceStatus(inStatus.getValue(), recoveryPlanInDb.getProtectGroups().stream().map(protectGroup -> protectGroup.getProperty("SERVICEINSTANCE_UUID")).collect(Collectors.toSet()));
                RecoveryPlanOperateObserver.this.updateSfsServiceInstanceProjectId(recoveryPlanInDb, excuteType);
            }
        });
        recoveryPlanInDb.getProtectGroups().stream().map(protectGroup -> protectGroup.getProperty("SERVICEINSTANCE_UUID")).forEach(serviceInstanceId -> FixedRecoveryThreadPool.submitSfsReq(() -> {
            ServiceInstance instance = this.getServiceInstanceById((String)serviceInstanceId);
            if (VerifyUtil.isEmpty((Object)instance)) {
                LOG.error((Object)"Query serviceInstance by id %s failed.", new Object[]{serviceInstanceId});
                return false;
            }
            this.refreshInstance(instance);
            return true;
        }));
    }

    /*
     * Exception decompiling
     */
    private void updateSfsServiceInstanceProjectId(RecoveryPlan recoveryPlanInDb, DrmEnumDefine.RecoveryPlanExecuteTypeE excuteType) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void updateServiceInstanceStatus(String status, Set<String> instanceIds) {
        HibernateTemplate hibernateTemplate = CommonDAOLocator.getBaseDao().getHibernateTemplate();
        Session session = Objects.requireNonNull(hibernateTemplate.getSessionFactory()).getCurrentSession();
        NativeQuery query = session.createSQLQuery("update ti_serviceinstance set status=:status where uuid in(:instanceIds)");
        query.setString("status", status);
        query.setParameterList("instanceIds", instanceIds);
        query.executeUpdate();
    }

    private static /* synthetic */ void lambda$updateSfsServiceInstanceProjectId$10(Session session, String projectId, List datas) {
        NativeQuery query = session.createSQLQuery("update ti_serviceinstance set PROJECTID=:projectId where uuid in(:instanceIds)");
        query.setString("projectId", projectId);
        query.setParameterList("instanceIds", (Collection)datas.stream().map(data -> data[1]).collect(Collectors.toSet()));
        query.executeUpdate();
    }

    private static /* synthetic */ String lambda$updateSfsServiceInstanceProjectId$8(String[] data) {
        return data[0];
    }

    static {
        statusMap.put(RecoveryPlanOperateObserver.generateAfterKey(DrmEnumDefine.RecoveryPlanStatusE.CLEAN_RUNNING), ServiceInstaceEnumDefine.ServiceInstanceStatusE.CLEARING.getValue());
        statusMap.put(RecoveryPlanOperateObserver.generateAfterKey(DrmEnumDefine.RecoveryPlanStatusE.CLEAN_COMPLETED), ServiceInstaceEnumDefine.ServiceInstanceStatusE.NORMAL.getValue());
        statusMap.put(RecoveryPlanOperateObserver.generateAfterKey(DrmEnumDefine.RecoveryPlanStatusE.CLEAN_FAILED), ServiceInstaceEnumDefine.ServiceInstanceStatusE.ERR_CLEAR.getValue());
        statusMap.put(RecoveryPlanOperateObserver.generateAfterKey(DrmEnumDefine.RecoveryPlanStatusE.TEST_RUNNING), ServiceInstaceEnumDefine.ServiceInstanceStatusE.TESTING.getValue());
        statusMap.put(RecoveryPlanOperateObserver.generateAfterKey(DrmEnumDefine.RecoveryPlanStatusE.TEST_COMPLETED), ServiceInstaceEnumDefine.ServiceInstanceStatusE.TESTED.getValue());
        statusMap.put(RecoveryPlanOperateObserver.generateAfterKey(DrmEnumDefine.RecoveryPlanStatusE.TEST_FAILED), ServiceInstaceEnumDefine.ServiceInstanceStatusE.ERR_TEST.getValue());
        statusMap.put(RecoveryPlanOperateObserver.generateAfterKey(DrmEnumDefine.RecoveryPlanStatusE.PLANED_MOTION_RUNNING), ServiceInstaceEnumDefine.ServiceInstanceStatusE.PLANED_MIGRATION_RUNNING.getValue());
        statusMap.put(RecoveryPlanOperateObserver.generateAfterKey(DrmEnumDefine.RecoveryPlanStatusE.PLANED_MOTION_COMPLETED), ServiceInstaceEnumDefine.ServiceInstanceStatusE.PLANED_MIGRATION_COMPLETED.getValue());
        statusMap.put(RecoveryPlanOperateObserver.generateAfterKey(DrmEnumDefine.RecoveryPlanStatusE.PLANED_MOTION_FAILED), ServiceInstaceEnumDefine.ServiceInstanceStatusE.PLANED_MIGRATION_FAILED.getValue());
        statusMap.put(RecoveryPlanOperateObserver.generateAfterKey(DrmEnumDefine.RecoveryPlanStatusE.PLANED_MOTION_PAUSED), ServiceInstaceEnumDefine.ServiceInstanceStatusE.PLANED_MIGRATION_PAUSED.getValue());
        statusMap.put(RecoveryPlanOperateObserver.generateAfterKey(DrmEnumDefine.RecoveryPlanStatusE.HOT_MIGRATION_RUNNING), ServiceInstaceEnumDefine.ServiceInstanceStatusE.HOT_MIGRATION_RUNNING.getValue());
        statusMap.put(RecoveryPlanOperateObserver.generateAfterKey(DrmEnumDefine.RecoveryPlanStatusE.HOT_MIGRATION_FAILED), ServiceInstaceEnumDefine.ServiceInstanceStatusE.HOT_MIGRATION_FAILED.getValue());
        statusMap.put(RecoveryPlanOperateObserver.generateAfterKey(DrmEnumDefine.RecoveryPlanStatusE.REPROTECT_RUNNING), ServiceInstaceEnumDefine.ServiceInstanceStatusE.REPROTECT_RUNNING.getValue());
        statusMap.put(RecoveryPlanOperateObserver.generateAfterKey(DrmEnumDefine.RecoveryPlanStatusE.REPROTECT_COMPLETED), ServiceInstaceEnumDefine.ServiceInstanceStatusE.NORMAL.getValue());
        statusMap.put(RecoveryPlanOperateObserver.generateAfterKey(DrmEnumDefine.RecoveryPlanStatusE.REPROTECT_FAILED), ServiceInstaceEnumDefine.ServiceInstanceStatusE.REPROTECT_FAILED.getValue());
        statusMap.put(RecoveryPlanOperateObserver.generateAfterKey(DrmEnumDefine.RecoveryPlanStatusE.DISASTER_RECOVERY_RUNNING), ServiceInstaceEnumDefine.ServiceInstanceStatusE.DISASTER_RECOVERY_RUNNING.getValue());
        statusMap.put(RecoveryPlanOperateObserver.generateAfterKey(DrmEnumDefine.RecoveryPlanStatusE.DISASTER_RECOVERY_COMPLETED), ServiceInstaceEnumDefine.ServiceInstanceStatusE.DISASTER_RECOVERY_COMPLETED.getValue());
        statusMap.put(RecoveryPlanOperateObserver.generateAfterKey(DrmEnumDefine.RecoveryPlanStatusE.DISASTER_RECOVERY_FAILED), ServiceInstaceEnumDefine.ServiceInstanceStatusE.DISASTER_RECOVERY_FAILED.getValue());
        statusMap.put(RecoveryPlanOperateObserver.generateAfterKey(DrmEnumDefine.RecoveryPlanStatusE.DISASTER_RECOVERY_PAUSED), ServiceInstaceEnumDefine.ServiceInstanceStatusE.DISASTER_RECOVERY_PAUSED.getValue());
        statusMap.put(RecoveryPlanOperateObserver.generateCheckKey(ServiceInstaceEnumDefine.ServiceInstanceStatusE.NORMAL, DrmEnumDefine.RecoveryPlanOperationType.DRILLING), "1");
        statusMap.put(RecoveryPlanOperateObserver.generateCheckKey(ServiceInstaceEnumDefine.ServiceInstanceStatusE.NORMAL, DrmEnumDefine.RecoveryPlanOperationType.PLANED_MOTION), "1");
        statusMap.put(RecoveryPlanOperateObserver.generateCheckKey(ServiceInstaceEnumDefine.ServiceInstanceStatusE.PLANED_MIGRATION_FAILED, DrmEnumDefine.RecoveryPlanOperationType.PLANED_MOTION), "1");
        statusMap.put(RecoveryPlanOperateObserver.generateCheckKey(ServiceInstaceEnumDefine.ServiceInstanceStatusE.HOT_MIGRATION_FAILED, DrmEnumDefine.RecoveryPlanOperationType.PLANED_MOTION), "1");
        statusMap.put(RecoveryPlanOperateObserver.generateCheckKey(ServiceInstaceEnumDefine.ServiceInstanceStatusE.NORMAL, DrmEnumDefine.RecoveryPlanOperationType.HOT_MIGRATION), "1");
        statusMap.put(RecoveryPlanOperateObserver.generateCheckKey(ServiceInstaceEnumDefine.ServiceInstanceStatusE.HOT_MIGRATION_FAILED, DrmEnumDefine.RecoveryPlanOperationType.HOT_MIGRATION), "1");
        statusMap.put(RecoveryPlanOperateObserver.generateCheckKey(ServiceInstaceEnumDefine.ServiceInstanceStatusE.NORMAL, DrmEnumDefine.RecoveryPlanOperationType.DISASTER_RECOVERY), "1");
        statusMap.put(RecoveryPlanOperateObserver.generateCheckKey(ServiceInstaceEnumDefine.ServiceInstanceStatusE.DISASTER_RECOVERY_FAILED, DrmEnumDefine.RecoveryPlanOperationType.DISASTER_RECOVERY), "1");
        statusMap.put(RecoveryPlanOperateObserver.generateCheckKey(ServiceInstaceEnumDefine.ServiceInstanceStatusE.REPROTECT_FAILED, DrmEnumDefine.RecoveryPlanOperationType.REPROTECT), "1");
        statusMap.put(RecoveryPlanOperateObserver.generateCheckKey(ServiceInstaceEnumDefine.ServiceInstanceStatusE.PLANED_MIGRATION_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.REPROTECT), "1");
        statusMap.put(RecoveryPlanOperateObserver.generateCheckKey(ServiceInstaceEnumDefine.ServiceInstanceStatusE.DISASTER_RECOVERY_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.REPROTECT), "1");
        statusMap.put(RecoveryPlanOperateObserver.generateCheckKey(ServiceInstaceEnumDefine.ServiceInstanceStatusE.DISASTER_RECOVERY_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.DISASTER_RECOVERY), "1");
        statusMap.put(RecoveryPlanOperateObserver.generateCheckKey(ServiceInstaceEnumDefine.ServiceInstanceStatusE.TESTED, DrmEnumDefine.RecoveryPlanOperationType.CLEAN_DRILLING), "1");
        statusMap.put(RecoveryPlanOperateObserver.generateCheckKey(ServiceInstaceEnumDefine.ServiceInstanceStatusE.ERR_CLEAR, DrmEnumDefine.RecoveryPlanOperationType.CLEAN_DRILLING), "1");
        statusMap.put(RecoveryPlanOperateObserver.generateCheckKey(ServiceInstaceEnumDefine.ServiceInstanceStatusE.ERR_TEST, DrmEnumDefine.RecoveryPlanOperationType.CLEAN_DRILLING), "1");
        statusMap.put(RecoveryPlanOperateObserver.generateBeforeKey(DrmEnumDefine.RecoveryPlanOperationType.DISASTER_RECOVERY), ServiceInstaceEnumDefine.ServiceInstanceStatusE.DISASTER_RECOVERY_RUNNING.getValue());
        statusMap.put(RecoveryPlanOperateObserver.generateBeforeKey(DrmEnumDefine.RecoveryPlanOperationType.REPROTECT), ServiceInstaceEnumDefine.ServiceInstanceStatusE.REPROTECT_RUNNING.getValue());
        statusMap.put(RecoveryPlanOperateObserver.generateBeforeKey(DrmEnumDefine.RecoveryPlanOperationType.PLANED_MOTION), ServiceInstaceEnumDefine.ServiceInstanceStatusE.PLANED_MIGRATION_RUNNING.getValue());
        statusMap.put(RecoveryPlanOperateObserver.generateBeforeKey(DrmEnumDefine.RecoveryPlanOperationType.HOT_MIGRATION), ServiceInstaceEnumDefine.ServiceInstanceStatusE.HOT_MIGRATION_RUNNING.getValue());
        statusMap.put(RecoveryPlanOperateObserver.generateBeforeKey(DrmEnumDefine.RecoveryPlanOperationType.DRILLING), ServiceInstaceEnumDefine.ServiceInstanceStatusE.TESTING.getValue());
        statusMap.put(RecoveryPlanOperateObserver.generateBeforeKey(DrmEnumDefine.RecoveryPlanOperationType.CLEAN_DRILLING), ServiceInstaceEnumDefine.ServiceInstanceStatusE.CLEARING.getValue());
    }
}

