/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.drm.openstack.adapter.manager.impl.NovaManager;
import com.huawei.ism.drm.openstack.adapter.msg.AsyncTaskResponse;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.recovery.processor.AttachVolTaskQueue;
import com.huawei.ism.drm.openstack.sdk.service.IVolumeService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;

public class AttachVolTask
implements Runnable {
    private static final Log LOG = LogFactory.getInstance(AttachVolTask.class);
    private String projUuid;
    private String regionUuid;
    private String vmUuid;
    private String vmType;
    private String volumeId;
    private String deviceName;
    private int status = 0;
    private long errorCode = 0x300001L;
    private String[] errorParam = null;
    private AttachVolTaskQueue taskManager;

    public AttachVolTask() {
    }

    public AttachVolTask(String projUuid, String regionUuid, String vmUuid, String vmType, String volumeId, String deviceName) {
        this.projUuid = projUuid;
        this.regionUuid = regionUuid;
        this.vmUuid = vmUuid;
        this.vmType = vmType;
        this.volumeId = volumeId;
        this.deviceName = deviceName;
    }

    public String getProjUuid() {
        return this.projUuid;
    }

    public void setProjUuid(String projUuid) {
        this.projUuid = projUuid;
    }

    public String getRegionUuid() {
        return this.regionUuid;
    }

    public void setRegionUuid(String regionUuid) {
        this.regionUuid = regionUuid;
    }

    public String getVmUuid() {
        return this.vmUuid;
    }

    public void setVmUuid(String vmUuid) {
        this.vmUuid = vmUuid;
    }

    public String getVmType() {
        return this.vmType;
    }

    public void setVmType(String vmType) {
        this.vmType = vmType;
    }

    public String getVolumeId() {
        return this.volumeId;
    }

    public void setVolumeId(String volumeId) {
        this.volumeId = volumeId;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public long getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(long errorCode) {
        this.errorCode = errorCode;
    }

    public String[] getErrorParam() {
        return this.errorParam;
    }

    public void setErrorParam(String[] errorParam) {
        this.errorParam = errorParam;
    }

    public void setTaskManager(AttachVolTaskQueue taskManager) {
        this.taskManager = taskManager;
    }

    @Override
    public void run() {
        try {
            ((IVolumeService)ServiceLocator.getInstance().getService(IVolumeService.class)).unreserveVolume(this.volumeId, this.regionUuid, this.projUuid);
            NovaManager novaMgr = new NovaManager();
            String tokenId = TokenUtil.getInstance().getRegionTokenId(this.regionUuid, this.projUuid);
            AsyncTaskResponse response = novaMgr.attachVolumeToVM(tokenId, this.projUuid, this.regionUuid, this.vmUuid, this.vmType, this.volumeId, this.deviceName);
            this.status = response.isSuccess() ? 1 : 2;
        }
        catch (LegoCheckedException e) {
            this.status = 2;
            LOG.error((Object)("Mount vol(" + this.volumeId + ") to vm( " + this.vmUuid + " ) error."), (Throwable)e);
            this.errorCode = e.getErrorCode();
            this.errorParam = e.getParameters();
        }
        catch (Exception e) {
            this.status = 2;
            LOG.error((Object)("Mount vol(" + this.volumeId + ") to vm( " + this.vmUuid + " ) error."), (Throwable)e);
        }
        this.taskManager.markTaskCompleted(this.volumeId);
    }
}

