/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.drm.openstack.recovery.processor.AttachVolTask;
import com.huawei.lego.core.base.thread.ExecutionService;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class AttachVolTaskQueue {
    private static final Log LOG = LogFactory.getInstance(AttachVolTaskQueue.class);
    private BlockingQueue<AttachVolTask> queue = new LinkedBlockingQueue<AttachVolTask>();
    private Set<String> volumeInAttaching = Collections.synchronizedSet(new HashSet());
    private boolean isRunning = true;

    protected void start() {
        this.isRunning = true;
        new Thread(() -> {
            while (this.isRunning) {
                AttachVolTask task = new AttachVolTask();
                try {
                    task = this.queue.take();
                    if (this.volumeInAttaching.contains(task.getVolumeId())) {
                        this.reAddTask(task);
                        continue;
                    }
                    LOG.debug((Object)"%s submit to task pool.target vm is %s", new Object[]{task.getVolumeId(), task.getVmUuid()});
                    this.volumeInAttaching.add(task.getVolumeId());
                    task.setTaskManager(this);
                    ExecutionService.submitTask((Runnable)task);
                }
                catch (Exception e) {
                    LOG.error((Object)(task.getVolumeId() + " error." + ExceptionUtil.getErrorMessage((Throwable)e)));
                    this.volumeInAttaching.remove(task.getVolumeId());
                    this.reAddTask(task);
                }
            }
        }).start();
    }

    private void reAddTask(AttachVolTask task) {
        if (!this.queue.offer(task)) {
            LOG.error((Object)(task.getVolumeId() + " readd to queue error."));
            task.setStatus(2);
        }
    }

    protected void stop() {
        this.isRunning = false;
    }

    protected boolean push(AttachVolTask task) {
        LOG.debug((Object)"%s add to queue. target vm is %s", new Object[]{task.getVolumeId(), task.getVmUuid()});
        return this.queue.offer(task);
    }

    protected void markTaskCompleted(String volId) {
        LOG.debug((Object)"%s is end to attach.", new Object[]{volId});
        this.volumeInAttaching.remove(volId);
    }
}

