/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.adapter.manager.IDrExtendManager;
import com.huawei.ism.drm.openstack.adapter.manager.impl.DrExtendManager;
import com.huawei.ism.drm.openstack.adapter.msg.AsyncTaskResponse;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackCheckDataConsistencyProcessor;
import com.huawei.ism.drm.openstack.recovery.utils.OpenStackRecoveryTool;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeReplicationCgInfo;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;

public class OpenStackCheckRingDataConsistencyProcessor
extends OpenStackCheckDataConsistencyProcessor {
    private static final long serialVersionUID = -6033983210489674659L;
    private static final Log LOG = LogFactory.getInstance(OpenStackCheckRingDataConsistencyProcessor.class);

    @Override
    protected boolean execute(RecoveryProcessorContext context) {
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
            return true;
        }
        boolean executeResult = super.execute(context);
        ProtectGroup pg = context.getProtectGroup();
        LOG.info((Object)"Enter into OpenStackCheckRingDataConsistencyProcessor. pg name is :%s", new Object[]{pg.getName()});
        if (!executeResult) {
            LOG.error((Object)"Execute OpenStackCheckDataConsistencyProcessor Failed. pg name is :%s", new Object[]{pg.getName()});
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        int result = DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue();
        if (!OpenStackCommonUtil.isCsdrVhaMode(pg)) {
            result = this.checkAndSuspendHyperMetro(pg);
        }
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue() == result) {
            LOG.error((Object)"%s: suspend HyperMetro FAILED.", new Object[]{pg.getName()});
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            this.updateProcessDetail("lego.err.1073948906", null);
            return false;
        }
        return true;
    }

    @Override
    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    @Override
    public void updateDescription() {
        this.setDescription("com.huawei.ism.drm.storage.recovery.process.CheckDataConsistencyProcessor.des");
    }

    private int checkAndSuspendHyperMetro(ProtectGroup pg) {
        DrExtendManager mgr = new DrExtendManager();
        String regionUuid = (String)pg.getProps().get("regionId");
        String projUuid = (String)pg.getProps().get("projectId");
        String hyperMetorCG = OpenStackRecoveryTool.getHyperProCgUuid(pg);
        String tokenId = TokenUtil.getInstance().getRegionTokenId(regionUuid, projUuid);
        VolumeReplicationCgInfo repCGInfo = mgr.queryVolumeReplicationCG(regionUuid, tokenId, projUuid, OpenStackCommonUtil.getIdFromUuid(hyperMetorCG));
        if (null == repCGInfo) {
            LOG.info((Object)"%s :the cg is not exist:cgId=%s", new Object[]{pg.getName(), hyperMetorCG});
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue();
        }
        String replicationStatus = repCGInfo.getReplicationStatus();
        String status = repCGInfo.getStatus();
        if (!OpenstackEnumDefine.ReplicationStatusE.AVAILABLE.getValue().equals(status)) {
            LOG.error((Object)"Replica's status is not avaiable.protectGroupName=%s", new Object[]{pg.getName()});
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue();
        }
        if (!OpenstackEnumDefine.ReplicationRepStatusE.ACTIVE.getValue().equals(replicationStatus)) {
            LOG.info((Object)"Replica's replicaionstatus is not activity.protectGroupName=%s", new Object[]{pg.getName()});
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue();
        }
        String slaveHyperMetorCG = OpenStackRecoveryTool.getSlaveHyperMetorCgUuid(pg);
        repCGInfo = mgr.queryVolumeReplicationCG(regionUuid, tokenId, projUuid, OpenStackCommonUtil.getIdFromUuid(slaveHyperMetorCG));
        if (null == repCGInfo) {
            LOG.info((Object)"The cg is not exist:cgId=%s, protectGroupName=%s", new Object[]{slaveHyperMetorCG, pg.getName()});
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue();
        }
        if (OpenstackEnumDefine.ReplicationRepStatusE.ACTIVESTOPPED.getValue().equals(repCGInfo.getReplicationStatus())) {
            LOG.info((Object)" %s:replica's replicaionstatus is not activity", new Object[]{pg.getName()});
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue();
        }
        boolean result = this.suspendHyperMetro(regionUuid, projUuid, hyperMetorCG);
        if (result) {
            return DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue();
        }
        return DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue();
    }

    private boolean suspendHyperMetro(String regionUuid, String projUuid, String hyperMetorCG) {
        IDrExtendManager drExtendMgr = ManagerFactory.getInstance().getDrExtendManager(OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid));
        String tokenId = TokenUtil.getInstance().getRegionTokenId(regionUuid, projUuid);
        hyperMetorCG = OpenStackCommonUtil.getIdFromUuid(hyperMetorCG);
        try {
            AsyncTaskResponse response = drExtendMgr.splitVolumeReplicationCG(regionUuid, tokenId, projUuid, hyperMetorCG);
            if (!response.isSuccess()) {
                this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
                LOG.info((Object)"Set volRepCg(%s) split failed: errorcode is %s", new Object[]{hyperMetorCG, response.getErrorCode()});
                return false;
            }
        }
        catch (LegoCheckedException e) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            LOG.error((Object)("VolRepCg(" + hyperMetorCG + ") fault switch failed."), (Throwable)e);
            return false;
        }
        return true;
    }
}

