/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackClearPortSubProcessor;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackDetachPortProcessor;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackDetachPortSubProcessor;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessConcurrentExecutor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;

public class OpenStackClearPortProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -2845393975473774999L;
    private static final Log LOG = LogFactory.getInstance(OpenStackDetachPortProcessor.class);

    protected boolean execute(RecoveryProcessorContext context) {
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            this.generateSubProcessors();
        }
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            LOG.debug((Object)"No ports need to clear.");
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            return true;
        }
        ArrayList list = new ArrayList(this.getChildProc());
        RecoveryProcessConcurrentExecutor executor = RecoveryProcessConcurrentExecutor.createExecutor(list);
        executor.process(context);
        return this.calcProcessResultBySubProc();
    }

    private void generateSubProcessors() {
        List detachPortSubProcessors = this.getRecoveryProcessors(this.getContextRef().getRecoveryPlan(), DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY.getValue()), OpenStackDetachPortSubProcessor.class);
        if (VerifyUtil.isEmpty((Collection)detachPortSubProcessors)) {
            LOG.info((Object)"End execute generateSubProcessors, cause detachPortSubProcessors is empty.");
            return;
        }
        List recoveryProcessorsOfVm = detachPortSubProcessors.stream().filter(proc -> proc.getBoolean("isCshaPhvm") == false).collect(Collectors.toList());
        HashSet<OpenStackClearPortSubProcessor> subProcessors = new HashSet<OpenStackClearPortSubProcessor>();
        for (RecoveryProcessor detachProcessorOfVm : recoveryProcessorsOfVm) {
            String regionUuid = detachProcessorOfVm.getString("regionUuid");
            String projectUuid = detachProcessorOfVm.getString("projUuid");
            String vmUuid = detachProcessorOfVm.getString("vmUuid");
            String portIdsOfVM = detachProcessorOfVm.getString("portIdsOfVM");
            String vmName = detachProcessorOfVm.getString("vmName");
            OpenStackClearPortSubProcessor subProcessor = new OpenStackClearPortSubProcessor(regionUuid, projectUuid, portIdsOfVM, vmName, vmUuid);
            this.initProc((RecoveryProcessor)subProcessor);
            subProcessors.add(subProcessor);
        }
        this.setChildProc(subProcessors);
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }

    private void initProc(RecoveryProcessor proc) {
        proc.setProcName(proc.getName());
        proc.setProcType(this.getProcType());
        proc.setPlanId(this.getPlanId());
        proc.setProcessId(this.getProcessId());
        proc.setParentProc((RecoveryProcessor)this);
        proc.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
    }

    protected boolean calcProcessResultBySubProc() {
        LOG.debug((Object)"CalcProcessResultBySubProc start");
        DrmEnumDefine.RecoveryPlanExecuteResultE procStatus = this.calcProcStatusBySubProc(this.getChildProc());
        this.setProcStatus(procStatus.getValue());
        return DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue() != procStatus.getValue() && DrmEnumDefine.RecoveryPlanExecuteResultE.PART_SUCCESS.getValue() != procStatus.getValue();
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

