/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.openstack.adapter.manager.impl.NeutronManager;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackDcStatusCheck;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Locale;

public class OpenStackDcNeutronStatusCheckProcessor
extends OpenStackDcStatusCheck {
    private static final long serialVersionUID = -6434728022866975260L;
    private static final Log LOG = LogFactory.getInstance(OpenStackDcNeutronStatusCheckProcessor.class);
    private static final String PORT_ID = "9000";
    private transient NeutronManager neutronManager;

    protected boolean execute(RecoveryProcessorContext context) {
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
            return true;
        }
        boolean checkServerStatus = this.checkServerStatus(context);
        if (checkServerStatus) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            LOG.info((Object)"Leave OpenStackDcNeutronStatusCheckProcessor:check successed.recoveryPlan name=%s", new Object[]{recoveryPlan != null ? recoveryPlan.getName() : ""});
            return true;
        }
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
        this.updateProcessDetail("com.huawei.ism.drm.openstack.recovery.processor.dc.check.error", new String[0]);
        LOG.info((Object)"Leave OpenStackDcNovaStatusCheckProcessor:check failed.recoveryPlan name=%s", new Object[]{recoveryPlan != null ? recoveryPlan.getName() : ""});
        return false;
    }

    @Override
    protected boolean checkSingleStatus(String regionUuid, String projUuid, String tokenId) {
        try {
            if (this.neutronManager == null) {
                this.neutronManager = new NeutronManager();
            }
            this.neutronManager.getPort(regionUuid, tokenId, PORT_ID);
        }
        catch (LegoCheckedException e) {
            if (e.getErrorCode() == 1073947401L || e.getErrorCode() == 1073947398L) {
                LOG.error((Object)String.format(Locale.ROOT, "OpenStackDcNeutronStatusCheckProcessor getPort ( %s, %s ) failed.", regionUuid, PORT_ID), (Throwable)e);
                return false;
            }
        }
        catch (Exception e) {
            LOG.error((Object)"OpenStackDcNeutronStatusCheckProcessor getPort( %s, %s )other exception.", new Object[]{regionUuid, PORT_ID});
        }
        return true;
    }
}

