/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.openstack.adapter.manager.impl.CinderManager;
import com.huawei.ism.drm.openstack.adapter.msg.AsyncTaskResponse;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackCreateVolCgProcessor;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVolume;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeCgInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeCgUpdateInfo;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class OpenStackDelVolCgProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = 5527061912529247987L;
    private static final Log LOG = LogFactory.getInstance(OpenStackDelVolCgProcessor.class);

    protected boolean execute(RecoveryProcessorContext context) {
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
            return true;
        }
        List<RecoveryProcessor> createProcessors = this.getRecoveryProcessors();
        if (createProcessors == null) {
            return true;
        }
        OpenStackCreateVolCgProcessor createVolCgProcessor = (OpenStackCreateVolCgProcessor)((Object)CommonUtil.getFirstElement(createProcessors));
        String volCgUuid = createVolCgProcessor.getString("volCgUuid");
        String drRegionUuid = createVolCgProcessor.getString("regionUuid");
        String drProjUuid = createVolCgProcessor.getString("projUuid");
        LOG.info((Object)"VolCgUuid is:%s, drRegionUuid is:%s, drProjUuid is:%s", new Object[]{volCgUuid, drRegionUuid, drProjUuid});
        if (VerifyUtil.isEmpty((String)volCgUuid)) {
            LOG.info((Object)"VolCgUuid is null.no need to delete cg snapshot.");
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            return true;
        }
        try {
            CinderManager cinderMgr = new CinderManager();
            String tokenId = TokenUtil.getInstance().getRegionTokenId(drRegionUuid, drProjUuid);
            LOG.info((Object)"Start queryVolConsistencyGroup");
            VolumeCgInfo volCg = cinderMgr.queryVolConsistencyGroup(drRegionUuid, tokenId, drProjUuid, volCgUuid);
            if (null == volCg) {
                LOG.info((Object)"volCg(%s) doesn't exit.", new Object[]{volCgUuid});
                this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
                return true;
            }
            if (this.updateVolumeConsistenceGroup(volCgUuid, drRegionUuid, drProjUuid, cinderMgr, tokenId)) {
                return false;
            }
            AsyncTaskResponse response = cinderMgr.deleteVolumeConsistencyGroup(volCgUuid, drRegionUuid, tokenId, drProjUuid);
            if (!response.isSuccess()) {
                this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
                LOG.info((Object)"Del volCg(%s)failed. %s", new Object[]{volCgUuid, response.getErrorCode()});
                this.updateProcessDetail("lego.err.1073948915", null);
                return false;
            }
        }
        catch (LegoCheckedException e) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            this.updateProcessDetail("lego.err.1073948915", null);
            LOG.info((Object)"Del volCg (%s) failed. %s", new Object[]{volCgUuid, e});
            return false;
        }
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        LOG.info((Object)"Leave OpenStackDelVolRepCgSnapShotProcessor");
        return true;
    }

    private List<RecoveryProcessor> getRecoveryProcessors() {
        List createProcessors = this.getRecoveryProcessors(this.getContextRef().getRecoveryPlan(), DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING.getValue()), OpenStackCreateVolCgProcessor.class);
        if (VerifyUtil.isEmpty((Collection)createProcessors)) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            return null;
        }
        return createProcessors;
    }

    private boolean updateVolumeConsistenceGroup(String volCgUuid, String drRegionUuid, String drProjUuid, CinderManager cinderMgr, String tokenId) {
        String drVolUuids = this.getDrVolUuids(volCgUuid, drRegionUuid, drProjUuid, cinderMgr, tokenId);
        LOG.info((Object)"Start remove Volume from ConsistenceGroup:%s", new Object[]{drVolUuids});
        if (!VerifyUtil.isEmpty((String)drVolUuids)) {
            VolumeCgUpdateInfo volCgUpdateInfo = new VolumeCgUpdateInfo();
            volCgUpdateInfo.setRemoveVolUuids(drVolUuids);
            AsyncTaskResponse response = cinderMgr.updateVolumeConsistenceGroup(volCgUpdateInfo, drRegionUuid, tokenId, drProjUuid, volCgUuid);
            if (!response.isSuccess()) {
                this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
                LOG.error((Object)("Update volCg failed." + response.getErrorCode()));
                this.updateProcessDetail("lego.err.1073948915", null);
                return true;
            }
        }
        return false;
    }

    private String getDrVolUuids(String volCgUuid, String drRegionUuid, String drProjUuid, CinderManager cinderMgr, String tokenId) {
        String drVolUuids = "";
        List<OpenStackVolume> vols = cinderMgr.queryAllOpenStackVolumes(drRegionUuid, tokenId, drProjUuid, Collections.singletonMap("consistencygroup_id", volCgUuid));
        if (!VerifyUtil.isEmpty(vols)) {
            HashSet<String> volIdSet = new HashSet<String>();
            for (OpenStackVolume vol : vols) {
                volIdSet.add(OpenStackCommonUtil.getIdFromUuid(vol.getUuid()));
            }
            drVolUuids = OpenStackCommonUtil.getStringFromCollection(volIdSet, ",");
        }
        return drVolUuids;
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

