/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.adapter.manager.INeutronManager;
import com.huawei.ism.drm.openstack.adapter.manager.INovaManager;
import com.huawei.ism.drm.openstack.adapter.util.JsonUtil;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackDetachPortSubProcessor;
import com.huawei.ism.drm.openstack.recovery.utils.OpenStackRecoveryTool;
import com.huawei.ism.drm.openstack.sdk.bo.PhVmInfo;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaInfo;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackPort;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackRegion;
import com.huawei.ism.drm.openstack.sdk.msg.VMInterface;
import com.huawei.ism.drm.openstack.tools.OpenStackBasicUtil;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.framework.template.util.PolicyTemplateTools;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessConcurrentExecutor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class OpenStackDetachPortProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -6717845830095338632L;
    private static final Log LOG = LogFactory.getInstance(OpenStackDetachPortProcessor.class);

    protected boolean execute(RecoveryProcessorContext context) {
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        LOG.debug((Object)"Enter into OpenStackDetachPortProcessor,recoveryPlan name=%s", new Object[]{OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)});
        if (!this.isSwitchNetWork(context)) {
            LOG.info((Object)String.format(Locale.ROOT, "Region config:isSwitchNetwork is false,recoveryPlan name=%s", OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)), 90160758786816L);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            return true;
        }
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            this.generateSubProcessors(context);
        }
        if (null == this.getChildProc() || this.getChildProc().isEmpty()) {
            LOG.debug((Object)String.format(Locale.ROOT, "No ports need to detach,recoveryPlan name=%s", OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)), 90160758786816L);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            return true;
        }
        ArrayList list = new ArrayList(this.getChildProc());
        RecoveryProcessConcurrentExecutor executor = RecoveryProcessConcurrentExecutor.createExecutor(list);
        executor.process(context);
        return this.calcProcessResultBySubProc();
    }

    private boolean isSwitchNetWork(RecoveryProcessorContext context) {
        List<Integer> protype = Arrays.asList(DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY.getValue(), DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue(), DrmEnumDefine.RecoveryPlanExecuteTypeE.REPROTECT.getValue());
        ProtectGroup pg = context.getProtectGroup();
        String regionUuid = (String)pg.getProps().get("regionId");
        if (PolicyTemplateTools.getInstance().isHyperMetroTemplate(pg) && protype.contains(this.getProcType())) {
            List regions = CommonDAOLocator.getMoDao().getMoList(OpenStackRegion.class, "uuid", (Object)regionUuid);
            if (VerifyUtil.isEmpty((Collection)regions)) {
                LOG.error((Object)"Openstack region is not exist.");
                return true;
            }
            return ((OpenStackRegion)CommonUtil.getFirstElement((Collection)regions)).getRegionConfig().getIsSwitchNetwork();
        }
        return true;
    }

    private void generateSubProcessors(RecoveryProcessorContext context) {
        HashSet<RecoveryProcessor> subProcSet = new HashSet<RecoveryProcessor>();
        this.generateDetachPortSubProcessors(context, subProcSet);
        this.setChildProc(subProcSet);
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }

    private void generateDetachPortSubProcessors(RecoveryProcessorContext context, Set<RecoveryProcessor> subProcSet) {
        ProtectGroup pg = context.getProtectGroup();
        String regionUuid = (String)pg.getProps().get("regionId");
        String projectUuid = (String)pg.getProps().get("projectId");
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid);
        INovaManager novaMgr = ManagerFactory.getInstance().getNovaManager(openstackUuid);
        INeutronManager neutronManager = ManagerFactory.getInstance().getNeutronManager(openstackUuid);
        String tokenId = TokenUtil.getInstance().getRegionTokenId(regionUuid, projectUuid);
        List<OpenStackPort> portList = neutronManager.getPorts(openstackUuid, regionUuid, tokenId, projectUuid);
        for (ProtectObject po : pg.getPolist()) {
            if (OpenStackRecoveryTool.isMigration(context.getRecoveryPlan(), po.getMoUuid())) {
                LOG.info((Object)"Po:%s is migration,no need do this processor.", new Object[]{po.getName()});
                continue;
            }
            String vmUuid = po.getMoUuid();
            List<VMInterface> vmPortList = novaMgr.getVmInterfaces(regionUuid, tokenId, projectUuid, vmUuid);
            String portIdStr = OpenStackRecoveryTool.getSortedPortIdStr(vmPortList, portList);
            if (!VerifyUtil.isEmpty((String)portIdStr)) {
                OpenStackDetachPortSubProcessor vmDetachPortSubProcessor = new OpenStackDetachPortSubProcessor(regionUuid, projectUuid, portIdStr, po.getName(), vmUuid);
                this.initProc((RecoveryProcessor)vmDetachPortSubProcessor);
                subProcSet.add((RecoveryProcessor)vmDetachPortSubProcessor);
            } else {
                LOG.info((Object)"The vm has no port,vmName=%s", new Object[]{po.getName()});
            }
            PhVmInfo phVmInfo = this.getPhVmInfo(po);
            String phVmUUid = phVmInfo.getVmUuid();
            List<VMInterface> phVmPortList = novaMgr.getVmInterfaces(regionUuid, tokenId, projectUuid, phVmUUid);
            String phVmPortIdStr = OpenStackRecoveryTool.getSortedPortIdStr(phVmPortList, portList);
            if (!VerifyUtil.isEmpty((String)phVmPortIdStr)) {
                OpenStackDetachPortSubProcessor phVmDetachPortSubProcessor = OpenStackDetachPortSubProcessor.buildInstanceWithCshaVm(regionUuid, projectUuid, phVmPortIdStr, phVmInfo.getName(), phVmUUid);
                this.initProc((RecoveryProcessor)phVmDetachPortSubProcessor);
                subProcSet.add((RecoveryProcessor)phVmDetachPortSubProcessor);
                continue;
            }
            LOG.info((Object)"The vm has no port,vmName=%s", new Object[]{phVmInfo.getName()});
        }
    }

    private PhVmInfo getPhVmInfo(ProtectObject po) {
        PoReplicaInfo replicaInfo;
        String replicaStr = (String)po.getProps().get("replicationInfo");
        boolean isCshaCsdrWithinRegionRecovery = PolicyTemplateTools.getInstance().isCshaCsdrWithinRegionRecovery(this.getContextRef().getProtectGroup());
        if (isCshaCsdrWithinRegionRecovery) {
            replicaStr = po.getProperty("hypermetor_replicationInfo");
        }
        if ((replicaInfo = JsonUtil.jsonToBean(replicaStr, PoReplicaInfo.class)) == null) {
            LOG.error((Object)"Convert PoReplicaInfo return null, replicaStr=%s", new Object[]{replicaStr});
            throw new LegoCheckedException(0x300001L);
        }
        return replicaInfo.getPhVmInfo();
    }

    private void initProc(RecoveryProcessor proc) {
        proc.setProcName(proc.getName());
        proc.setProcType(this.getProcType());
        proc.setPlanId(this.getPlanId());
        proc.setProcessId(this.getProcessId());
        proc.setParentProc((RecoveryProcessor)this);
        proc.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
    }

    protected boolean calcProcessResultBySubProc() {
        LOG.debug((Object)"CalcProcessResultBySubProc start");
        DrmEnumDefine.RecoveryPlanExecuteResultE procStatus = this.calcProcStatusBySubProc(this.getChildProc());
        this.setProcStatus(procStatus.getValue());
        return DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue() != procStatus.getValue() && DrmEnumDefine.RecoveryPlanExecuteResultE.PART_SUCCESS.getValue() != procStatus.getValue();
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

