/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.openstack.adapter.manager.impl.NovaManager;
import com.huawei.ism.drm.openstack.adapter.msg.AsyncTaskResponse;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.sdk.bo.ResourceLocation;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVM;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeAttachmentInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeInfo;
import com.huawei.ism.drm.openstack.sdk.service.IVirtualMachineService;
import com.huawei.ism.drm.openstack.sdk.service.IVolumeService;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.base.util.KeyLocker;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Locale;

public class OpenStackDetachVolOnVmProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -6957370396347134253L;
    private static final Log LOG = LogFactory.getInstance(OpenStackDetachVolOnVmProcessor.class);
    private static final KeyLocker DETACH_VOL_LOCKER = new KeyLocker(OpenStackDetachVolOnVmProcessor.class, "DETACH_VOL_LOCK");

    public OpenStackDetachVolOnVmProcessor() {
    }

    public OpenStackDetachVolOnVmProcessor(String vmUuid, String volUuid, String regionUuid, String projUuid, String vmName, String vmType, String volName) {
        this.addString("vmUuid", vmUuid);
        this.addString("volUuid", volUuid);
        this.addString("regionUuid", regionUuid);
        this.addString("projUuid", projUuid);
        this.addString("vmName", vmName);
        this.addString("vmType", vmType);
        this.addString("volName", volName);
    }

    public void updateProcNameParams() {
        String volName = this.getString("volName");
        this.updateProcessNameParams(new String[]{volName});
    }

    protected boolean execute(RecoveryProcessorContext context) {
        LOG.info((Object)"Enter into OpenStackDetachVolOnVmProcessor");
        String vmUuid = this.getString("vmUuid");
        String volUuid = this.getString("volUuid");
        String regionUuid = this.getString("regionUuid");
        String projUuid = this.getString("projUuid");
        String volName = this.getString("volName");
        String vmType = this.getString("vmType");
        this.updateProcessNameParams(new String[]{volName});
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
            this.updateProcessDetail("ism.drm.recovery.process.no.need", new String[0]);
            return true;
        }
        try {
            IVolumeService volService = (IVolumeService)ServiceLocator.getInstance().getService(IVolumeService.class);
            VolumeInfo volumeInfo = volService.queryVolumeInfoByUuid(regionUuid, projUuid, volUuid);
            if (null == volumeInfo) {
                this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
                this.updateProcessDetail("lego.err.2117645", null);
                LOG.error((Object)"The volume(%s)is not exist", new Object[]{volUuid});
                return false;
            }
            if (this.volIsDetached(volumeInfo, vmUuid, volUuid)) {
                this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
                LOG.info((Object)"The volume(%s) has detached", new Object[]{volUuid});
                return true;
            }
            if (this.uninstallVol(new ResourceLocation(regionUuid, projUuid, null), vmUuid, vmType, volumeInfo, volUuid)) {
                return true;
            }
        }
        catch (LegoCheckedException e) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            this.updateProcessDetail(e);
            LOG.error((Object)("Detach volume(" + volUuid + ") failed from vm(" + vmUuid + ")"), (Throwable)e);
            return true;
        }
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        LOG.info((Object)"Leave OpenStackDetachVolOnVmProcessor");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean uninstallVol(ResourceLocation location, String vmUuid, String vmType, VolumeInfo volumeInfo, String volUuid) {
        block3: {
            boolean bl;
            if (!DETACH_VOL_LOCKER.tryLock(volUuid, PROCESSOR_TIMEOUT)) {
                String message = String.format(Locale.ENGLISH, "Get DETACH_VOL_LOCK failed. volUuid: %s", volUuid);
                throw new LegoCheckedException(2125837L, message, LOG, new String[0]);
            }
            LOG.debug((Object)"Get DETACH_VOL_LOCK success. volUuid: %s", new Object[]{volUuid});
            try {
                String regionUuid = location.getRegionUuid();
                String projectUuid = location.getProjectUuid();
                String tokenId = TokenUtil.getInstance().getRegionTokenId(regionUuid, projectUuid);
                IVirtualMachineService vmService = (IVirtualMachineService)ServiceLocator.getInstance().getService(IVirtualMachineService.class);
                NovaManager novaMgr = new NovaManager();
                OpenStackVM vm = novaMgr.getVm(regionUuid, tokenId, projectUuid, vmUuid, new int[0]);
                AsyncTaskResponse response = (AsyncTaskResponse)vmService.runWithAttachVolSemaphore(volumeInfo.getStorageSn(), vm.getHostId(), PROCESSOR_TIMEOUT.getSeconds(), () -> novaMgr.detachVolFromVm(tokenId, projectUuid, regionUuid, vmUuid, vmType, volumeInfo.getId()));
                if (response.isSuccess()) break block3;
                this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
                this.updateProcessDetail("lego.err." + response.getErrorCode(), null);
                LOG.error((Object)"Detach volume(%s) failed from vm(%s), errorcode is:%s", new Object[]{volUuid, vmUuid, response.getErrorCode()});
                bl = true;
            }
            catch (Throwable throwable) {
                DETACH_VOL_LOCKER.unlock(volUuid);
                LOG.debug((Object)"Release DETACH_VOL_LOCK. volUuid: %s", new Object[]{volUuid});
                throw throwable;
            }
            DETACH_VOL_LOCKER.unlock(volUuid);
            LOG.debug((Object)"Release DETACH_VOL_LOCK. volUuid: %s", new Object[]{volUuid});
            return bl;
        }
        DETACH_VOL_LOCKER.unlock(volUuid);
        LOG.debug((Object)"Release DETACH_VOL_LOCK. volUuid: %s", new Object[]{volUuid});
        return false;
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    private boolean volIsDetached(VolumeInfo volumeInfo, String vmUuid, String volUuid) {
        if (OpenstackEnumDefine.VolumeStatusE.AVAILABLE.getType().equals(volumeInfo.getStatus())) {
            return true;
        }
        if (null == volumeInfo.getAttachments()) {
            return true;
        }
        String serverId = OpenStackCommonUtil.getIdFromUuid(vmUuid);
        if (null == serverId) {
            LOG.error((Object)"Get id from uuid get null value, vmuuid=%s", new Object[]{vmUuid});
            throw new LegoCheckedException(1073947393L);
        }
        for (VolumeAttachmentInfo attach : volumeInfo.getAttachments()) {
            if (!serverId.equals(attach.getServerId())) continue;
            LOG.debug((Object)"Volume(%s) is still in vm(%s).", new Object[]{volUuid, serverId});
            return false;
        }
        return true;
    }
}

