/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.adapter.manager.IDrExtendManager;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.recovery.utils.OpenStackRecoveryTool;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeReplicationCgInfo;
import com.huawei.ism.drm.openstack.sdk.service.IVolumeService;
import com.huawei.ism.drm.openstack.tools.OpenStackBasicUtil;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.framework.template.util.PolicyTemplateTools;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.protection.provider.sdk.service.IProtectObjectProvider;
import com.huawei.ism.drm.protection.provider.sdk.service.IProtectObjectProviderDelegate;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.util.RecoveryProcessUtil;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.reprotect.sdk.service.IReprotectService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;

public class OpenStackHyperMetroSyncProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = 8860321245034605342L;
    private static final Log LOG = LogFactory.getInstance(OpenStackHyperMetroSyncProcessor.class);

    protected boolean execute(RecoveryProcessorContext context) {
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        LOG.info((Object)"Enter into OpenStackHyperMetroSyncProcessor,recoveryPlan name=%s", new Object[]{OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)});
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
            return true;
        }
        ProtectGroup pg = context.getProtectGroup();
        String regionUuid = (String)pg.getProps().get("regionId");
        String projUuid = (String)pg.getProps().get("projectId");
        String replicatrionUuid = (String)pg.getProps().get("replicaCgUuid");
        try {
            this.syncReplication(context, regionUuid, projUuid, replicatrionUuid);
            if (PolicyTemplateTools.getInstance().isCshaCsdrWithinRegionRecovery(pg)) {
                replicatrionUuid = (String)pg.getProps().get("hyperProdrCgUuid");
                this.syncReplication(context, regionUuid, projUuid, replicatrionUuid);
            }
            if (this.checkProtectGroupStatus(pg)) {
                return false;
            }
            IReprotectService reprotectService = (IReprotectService)ServiceLocator.getInstance().getService(IReprotectService.class);
            reprotectService.sendReprotectSuccessMsg(context.getRecoveryPlan());
        }
        catch (LegoCheckedException e) {
            LOG.error((Object)("Executing protect group failed.,recoveryPlan name=" + OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)), (Throwable)e, 90160758784001L);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            this.updateProcessDetail(e);
            return false;
        }
        catch (Exception e) {
            LOG.error((Object)("Executing protect group failed.,recoveryPlan name=" + OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan) + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            this.updateProcessDetail("lego.err.1073947418", new String[0]);
            return false;
        }
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        return true;
    }

    private boolean checkProtectGroupStatus(ProtectGroup pg) {
        ProtectGroup curPg = ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).getProtectGroupByID(pg.getUuid());
        IProtectObjectProvider vmProvider = (IProtectObjectProvider)((IProtectObjectProviderDelegate)ServiceLocator.getInstance().getService(IProtectObjectProviderDelegate.class)).getProviderByAppType(12);
        vmProvider.refreshProtectGroup(curPg);
        OpenStackRecoveryTool.operateReplicationFlagOfPg(curPg, false);
        String[] pgIds = new String[]{pg.getUuid()};
        boolean result = RecoveryProcessUtil.changeProtectGroupStatus((String[])pgIds, (DrmEnumDefine.ProtectGroupStatus)DrmEnumDefine.ProtectGroupStatus.NORMAL);
        if (!result) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            this.updateProcessDetail("lego.err.-1", new String[0]);
            return true;
        }
        return false;
    }

    private void syncReplication(RecoveryProcessorContext context, String regionUuid, String projUuid, String replicatrionUuid) {
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        ProtectGroup pg = context.getProtectGroup();
        LOG.info((Object)"Sync begin. replicaUuid:%s, regionUuid:%s, projUuid:%s", new Object[]{replicatrionUuid, regionUuid, projUuid});
        String tokenId = TokenUtil.getInstance().getRegionTokenId(regionUuid, projUuid);
        IDrExtendManager mgr = ManagerFactory.getInstance().getDrExtendManager(OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid));
        VolumeReplicationCgInfo cg = mgr.queryVolumeReplicationCG(regionUuid, tokenId, projUuid, replicatrionUuid);
        if (null != cg && OpenstackEnumDefine.ReplicationRepStatusE.COPYING.getValue().equals(cg.getReplicationStatus())) {
            LOG.info((Object)"Pg:%s,cg:%s is copying, no need sync.", new Object[]{pg.getName(), replicatrionUuid});
        } else {
            ((IVolumeService)ServiceLocator.getInstance().getService(IVolumeService.class)).syncReplication(regionUuid, projUuid, replicatrionUuid, true);
        }
        LOG.info((Object)"Sync end.,recoveryPlan name=%s", new Object[]{OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)});
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public void updateDescription() {
        this.setDescription("com.huawei.ism.drm.storage.recovery.process.SynchronizeReplicationProcessor.des");
    }
}

