/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.adapter.manager.INovaManager;
import com.huawei.ism.drm.openstack.adapter.msg.AsyncTaskResponse;
import com.huawei.ism.drm.openstack.adapter.util.JsonUtil;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaInfo;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVM;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.framework.template.util.PolicyTemplateTools;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;

public class OpenStackPhVmOperationSubProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -469535219326323662L;
    private static final Log LOG = LogFactory.getInstance(OpenStackPhVmOperationSubProcessor.class);

    public OpenStackPhVmOperationSubProcessor() {
        LOG.debug((Object)"OpenStackPhVmOperationSubProcessor defautl constructor");
    }

    public OpenStackPhVmOperationSubProcessor(String vmName, String replicaInfoStr) {
        this.addString("vmName", vmName);
        this.addString("poReplicaInfo", replicaInfoStr);
    }

    public void updateProcNameParams() {
        String vmName = this.getString("vmName");
        this.updateProcessNameParams(new String[]{vmName});
    }

    protected boolean execute(RecoveryProcessorContext context) {
        boolean result;
        String vmName = this.getString("vmName");
        this.updateProcessNameParams(new String[]{vmName});
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
            this.updateProcessDetail("ism.drm.recovery.process.no.need", new String[0]);
            return true;
        }
        String replicaInfoStr = this.getString("poReplicaInfo");
        if (VerifyUtil.isEmpty((String)replicaInfoStr)) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            LOG.error((Object)("Vm(" + vmName + ") 's replicaInfo is empty."));
            this.updateProcessDetail("lego.err.1073947393", new String[0]);
            return false;
        }
        PoReplicaInfo replicaInfo = JsonUtil.jsonToBean(replicaInfoStr, PoReplicaInfo.class);
        if (VerifyUtil.isEmpty((Object)replicaInfo) || VerifyUtil.isEmpty((Object)replicaInfo.getPhVmInfo())) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            LOG.error((Object)("Vm(" + vmName + ") has no placehold vm."));
            this.updateProcessDetail("lego.err.1073947393", new String[0]);
            return false;
        }
        ProtectGroup pg = context.getProtectGroup();
        boolean useDrRes = DrmEnumDefine.RecoveryPlanExecuteTypeE.REPROTECT.getValue() == this.getProcType() && PolicyTemplateTools.getInstance().isHyperMetroTemplate(pg);
        String regionUuid = useDrRes ? replicaInfo.getDrRegionUuid() : replicaInfo.getRegionUuid();
        String projectUuid = useDrRes ? replicaInfo.getDrProjUuid() : replicaInfo.getProjUuid();
        String vmUuid = useDrRes ? replicaInfo.getPhVmInfo().getVmUuid() : replicaInfo.getMoUuid();
        String drRegionUuid = useDrRes ? replicaInfo.getRegionUuid() : replicaInfo.getDrRegionUuid();
        String drProjectUuid = useDrRes ? replicaInfo.getProjUuid() : replicaInfo.getDrProjUuid();
        String phVmUuid = useDrRes ? replicaInfo.getMoUuid() : replicaInfo.getPhVmInfo().getVmUuid();
        boolean bl = result = this.lockVm(regionUuid, projectUuid, vmUuid, vmName) && this.unLockVm(drRegionUuid, drProjectUuid, phVmUuid, vmName);
        if (result) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            return true;
        }
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
        return false;
    }

    private boolean unLockVm(String drRegionUuid, String drProjectUuid, String phVmUuid, String vmName) {
        try {
            boolean result;
            if (DrmEnumDefine.RecoveryPlanExecuteTypeE.REPROTECT.getValue() != this.getProcType() && !(result = this.configVm(drRegionUuid, drProjectUuid, phVmUuid, false))) {
                this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
                LOG.error((Object)("Lock vm failed:vmUuid=" + phVmUuid));
                this.updateProcessDetail("lego.err.1073948117", null);
                return false;
            }
        }
        catch (LegoCheckedException e) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            LOG.error((Object)("Vm(" + vmName + ") has no placehold vm."));
            this.updateProcessDetail(e);
            return false;
        }
        return true;
    }

    private boolean lockVm(String regionUuid, String projectUuid, String vmUuid, String vmName) {
        block3: {
            try {
                boolean result = this.configVm(regionUuid, projectUuid, vmUuid, true);
                if (!result && DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY.getValue() != this.getProcType()) {
                    this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
                    LOG.error((Object)("Lock vm failed:vmUuid=" + vmUuid));
                    this.updateProcessDetail("lego.err.1073948108", new String[0]);
                    return false;
                }
            }
            catch (LegoCheckedException e) {
                if (DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY.getValue() == this.getProcType()) break block3;
                this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
                LOG.error((Object)("Vm(" + vmName + ") has no placehold vm."));
                this.updateProcessDetail(e);
                return false;
            }
        }
        return true;
    }

    private boolean configVm(String regionUuid, String projectUuid, String vmUuid, boolean willLock) {
        String tokenId;
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid);
        INovaManager novaMgr = ManagerFactory.getInstance().getNovaManager(openstackUuid);
        OpenStackVM vm = novaMgr.getVm(regionUuid, tokenId = TokenUtil.getInstance().getRegionTokenId(regionUuid, projectUuid), projectUuid, vmUuid, new int[0]);
        if (null == vm) {
            LOG.error((Object)("Vm(" + vmUuid + ") doesn't exist."));
            throw new LegoCheckedException(1073947394L);
        }
        if (vm.getLocked() == willLock) {
            LOG.info((Object)"Do not need to operate,the vm=%s, locked flag=%s", new Object[]{vmUuid, willLock});
            return true;
        }
        AsyncTaskResponse response = willLock ? novaMgr.lockVm(regionUuid, tokenId, projectUuid, vmUuid) : novaMgr.unlockVm(regionUuid, tokenId, projectUuid, vmUuid);
        if (response.isSuccess()) {
            this.updateVmTag(vmUuid, regionUuid, projectUuid, willLock);
        }
        return response.isSuccess();
    }

    private void updateVmTag(String vmUuid, String regionUuid, String projUuid, boolean willLock) {
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue() == this.getProcType() || DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY.getValue() == this.getProcType()) {
            String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid);
            INovaManager novaMgr = ManagerFactory.getInstance().getNovaManager(openstackUuid);
            String tokenId = TokenUtil.getInstance().getRegionTokenId(regionUuid, projUuid);
            String addFlag = willLock ? "__type_dr" : "__type_pd";
            String delFlag = willLock ? "__type_pd" : "__type_dr";
            try {
                novaMgr.deleteTagFromVm(regionUuid, tokenId, projUuid, vmUuid, delFlag);
                novaMgr.addTagToVm(regionUuid, tokenId, projUuid, vmUuid, addFlag);
            }
            catch (Exception e) {
                LOG.error((Object)("Update tag on vm (" + vmUuid + ") failed."), (Throwable)e);
            }
        }
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

