/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackPowerOnVmProcessor;
import com.huawei.ism.drm.openstack.recovery.utils.OpenStackRecoveryTool;
import com.huawei.ism.drm.protection.framework.template.util.PolicyTemplateTools;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessConcurrentExecutor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.NumberUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;

public class OpenStackPowerOnVmByPriorityProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = 5053656915800505735L;
    private static final Log LOG = LogFactory.getInstance(OpenStackPowerOnVmByPriorityProcessor.class);
    private Set<ProtectObject> pos;

    public OpenStackPowerOnVmByPriorityProcessor() {
    }

    public OpenStackPowerOnVmByPriorityProcessor(Set<ProtectObject> pos, Integer startPriority) {
        this.pos = pos;
        this.addString("startPriority", String.valueOf(startPriority));
    }

    protected boolean execute(RecoveryProcessorContext context) {
        LOG.info((Object)"Enter into OpenStackStartVmByPriorityProcessor");
        this.updateProcessNameParams(new String[]{this.getString("startPriority")});
        this.generateSubProcessors(context);
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            LOG.info((Object)"No child processors.");
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            this.updateProcessDetail("ism.drm.recovery.process.no.need", new String[0]);
            return true;
        }
        ArrayList subProcessorList = new ArrayList(this.getChildProc());
        RecoveryProcessConcurrentExecutor recoveryTemplate = RecoveryProcessConcurrentExecutor.createExecutor(subProcessorList, (boolean)false);
        recoveryTemplate.process(context);
        LOG.info((Object)"Leave OpenStackStartVmByPriorityProcessor");
        return this.calcProcessResultBySubProc();
    }

    private void generateSubProcessors(RecoveryProcessorContext context) {
        if (!VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            return;
        }
        ProtectGroup pg = context.getProtectGroup();
        String drRegionUuid = (String)pg.getProps().get("drRegionId");
        String drProjUuid = (String)pg.getProps().get("drProjectId");
        boolean isCshaCsdrWithinRegionRecovery = PolicyTemplateTools.getInstance().isCshaCsdrWithinRegionRecovery(pg);
        if (isCshaCsdrWithinRegionRecovery) {
            drRegionUuid = (String)pg.getProps().get("regionId");
            drProjUuid = (String)pg.getProps().get("projectId");
        }
        HashSet<OpenStackPowerOnVmProcessor> subProcessors = new HashSet<OpenStackPowerOnVmProcessor>();
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        for (ProtectObject po : this.pos) {
            String phVmUuid = OpenStackRecoveryTool.getPoRecoverySetting(recoveryPlan, po, "PLACEHOLDVM");
            String phVmName = OpenStackRecoveryTool.getPoRecoverySetting(recoveryPlan, po, "PLACEHOLDVMNAME");
            if (isCshaCsdrWithinRegionRecovery) {
                phVmUuid = OpenStackRecoveryTool.getPoRecoverySetting(recoveryPlan, po, "CSHAPLACEHOLDVM");
                phVmName = OpenStackRecoveryTool.getPoRecoverySetting(recoveryPlan, po, "CSHAPLACEHOLDVMNAME");
            }
            Integer startupWaitingTime = (Integer)Optional.ofNullable(recoveryPlan.getPoRecoverySetting(po, "start_delay_time", NumberUtil::convertToInteger)).orElse(0);
            OpenStackPowerOnVmProcessor subProcessor = new OpenStackPowerOnVmProcessor(phVmUuid, phVmName, drRegionUuid, drProjUuid, startupWaitingTime.toString());
            this.initProc((RecoveryProcessor)subProcessor);
            subProcessors.add(subProcessor);
        }
        this.setChildProc(subProcessors);
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }

    private void initProc(RecoveryProcessor proc) {
        proc.setProcName(proc.getName());
        proc.setProcType(this.getProcType());
        proc.setPlanId(this.getPlanId());
        proc.setProcessId(this.getProcessId());
        proc.setParentProc((RecoveryProcessor)this);
        proc.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

