/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.adapter.manager.ICinderManager;
import com.huawei.ism.drm.openstack.adapter.manager.INovaManager;
import com.huawei.ism.drm.openstack.adapter.manager.model.ReattchParam;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVM;
import com.huawei.ism.drm.openstack.sdk.msg.ReconnectVolumeInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeInfo;
import com.huawei.ism.drm.openstack.sdk.service.IVirtualMachineService;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Locale;

public class OpenStackReattachOneVolSubProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = 124065872564698426L;
    private static final Log LOG = LogFactory.getInstance(OpenStackReattachOneVolSubProcessor.class);

    public OpenStackReattachOneVolSubProcessor() {
        LOG.debug((Object)"OpenStackReattachOneVolSubProcessor defautl constructor");
    }

    public OpenStackReattachOneVolSubProcessor(String regionUuid, String projectUuid, String vmUuid, String volumeUuid, String volumeName) {
        this.addString("regionUuid", regionUuid);
        this.addString("projUuid", projectUuid);
        this.addString("vmUuid", vmUuid);
        this.addString("volUuid", volumeUuid);
        this.addString("volName", volumeName);
    }

    public void updateProcNameParams() {
        String volumeName = this.getString("volName");
        this.updateProcessNameParams(new String[]{volumeName});
    }

    protected boolean execute(RecoveryProcessorContext context) {
        String volumeName = this.getString("volName");
        this.updateProcessNameParams(new String[]{volumeName});
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
            this.updateProcessDetail("ism.drm.recovery.process.no.need", new String[0]);
            LOG.debug((Object)String.format(Locale.ROOT, "%s has reattached to vm", volumeName), 90160758786988L);
            return true;
        }
        String regionUuid = this.getString("regionUuid");
        String projectUuid = this.getString("projUuid");
        String vmUuid = this.getString("vmUuid");
        String volumeUuid = this.getString("volUuid");
        try {
            String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid);
            INovaManager novaMgr = ManagerFactory.getInstance().getNovaManager(openstackUuid);
            ICinderManager cinderMgr = ManagerFactory.getInstance().getCinderManager(openstackUuid);
            String tokenId = TokenUtil.getInstance().getRegionTokenId(regionUuid, projectUuid);
            OpenStackVM vm = novaMgr.getVm(regionUuid, tokenId, projectUuid, vmUuid, new int[0]);
            String volumeId = OpenStackCommonUtil.getIdFromUuid(volumeUuid);
            VolumeInfo volumeInfo = cinderMgr.queryVolume(regionUuid, tokenId, projectUuid, volumeId);
            String storageSn = volumeInfo == null ? null : volumeInfo.getStorageSn();
            IVirtualMachineService vmService = (IVirtualMachineService)ServiceLocator.getInstance().getService(IVirtualMachineService.class);
            ReconnectVolumeInfo reconnVolumeInfo = new ReconnectVolumeInfo();
            reconnVolumeInfo.setVolumeId(volumeId);
            reconnVolumeInfo.setIsHyperMetro(Boolean.valueOf(true));
            vmService.runWithAttachVolSemaphore(storageSn, vm.getHostId(), PROCESSOR_TIMEOUT.getSeconds(), () -> {
                novaMgr.reattachVolume(new ReattchParam(regionUuid, projectUuid, tokenId), vmUuid, reconnVolumeInfo);
                return null;
            });
        }
        catch (LegoCheckedException e) {
            LOG.error((Object)("Reattach volume failed:volume Name=" + volumeName));
            this.updateProcessDetail(e);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        catch (Exception e) {
            LOG.error((Object)("Reattach volumes failed:volume Name=" + volumeName));
            this.updateProcessDetail("lego.err.1073948106", new String[0]);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        return true;
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

