/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.openstack.adapter.util.JsonUtil;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackPowerOnVmProcessor;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackShutDownVmSubProcessor;
import com.huawei.ism.drm.openstack.recovery.utils.OpenStackRecoveryTool;
import com.huawei.ism.drm.openstack.sdk.bo.PhVmInfo;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaInfo;
import com.huawei.ism.drm.openstack.tools.OpenStackBasicUtil;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.framework.template.util.PolicyTemplateTools;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessConcurrentExecutor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class OpenStackShutDownVmProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = 4342741744015498178L;
    private static final Log LOG = LogFactory.getInstance(OpenStackShutDownVmProcessor.class);

    protected boolean execute(RecoveryProcessorContext context) {
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        LOG.info((Object)"Enter into OpenStackShutDownVmProcessor recoveryPlan=%s", new Object[]{OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)});
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.CLEAN_DRILLING.getValue() == this.getProcType()) {
            this.generateCleanDrillingSubProcessors();
        } else if (DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue() == this.getProcType() || DrmEnumDefine.RecoveryPlanExecuteTypeE.REPROTECT.getValue() == this.getProcType() || DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY.getValue() == this.getProcType()) {
            this.generatePlanMotionSubProcessors(context);
        }
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            LOG.info((Object)"No child processors.");
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            this.updateProcessDetail("ism.drm.recovery.process.no.need", new String[0]);
            return true;
        }
        LOG.debug((Object)" OpenStackShutDownVmProcessor complete subproecess recoveryPlan=%s", new Object[]{OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)});
        ArrayList subProcessorList = new ArrayList(this.getChildProc());
        RecoveryProcessConcurrentExecutor recoveryTemplate = RecoveryProcessConcurrentExecutor.createExecutor(subProcessorList, (boolean)false);
        recoveryTemplate.process(context);
        LOG.debug((Object)"Leave OpenStackShutDownVmProcessor recoveryPlan=%s", new Object[]{OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)});
        DrmEnumDefine.RecoveryPlanExecuteResultE procStatus = this.calcProcStatusBySubProc(this.getChildProc());
        this.setProcStatus(procStatus.getValue());
        LOG.info((Object)"Leave OpenStackShutDownVmProcessor setProcStatus =%s", new Object[]{OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)});
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY.getValue() == this.getProcType()) {
            return true;
        }
        return DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == procStatus.getValue();
    }

    private void generatePlanMotionSubProcessors(RecoveryProcessorContext context) {
        if (!VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            return;
        }
        ProtectGroup pg = context.getProtectGroup();
        OpenStackCommonUtil.setProtectObjectVmInfo(pg, null);
        boolean useDrRes = DrmEnumDefine.RecoveryPlanExecuteTypeE.REPROTECT.getValue() == this.getProcType() && PolicyTemplateTools.getInstance().isHyperMetroTemplate(pg);
        boolean csdrCshaReProtect = DrmEnumDefine.RecoveryPlanExecuteTypeE.REPROTECT.getValue() == this.getProcType() && PolicyTemplateTools.getInstance().isCshaCsdrBetweenRegionRecovery(pg) && !OpenStackCommonUtil.isCsdrCshaMode(pg);
        String regionuuid = (String)pg.getProps().get("regionId");
        String projUuid = (String)pg.getProps().get("projectId");
        HashSet<RecoveryProcessor> subProcessors = new HashSet<RecoveryProcessor>();
        for (ProtectObject po : pg.getPolist()) {
            if (OpenStackRecoveryTool.isMigration(context.getRecoveryPlan(), po.getMoUuid())) {
                LOG.info((Object)"Po:%s is migration,no need do this processor.", new Object[]{po.getName()});
                continue;
            }
            String vmUuid = po.getMoUuid();
            String vmName = po.getName();
            if (useDrRes) {
                PoReplicaInfo poReplicaInfo;
                String replicationInfo = (String)po.getProps().get("replicationInfo");
                if (PolicyTemplateTools.getInstance().isCshaCsdrWithinRegionRecovery(pg)) {
                    replicationInfo = (String)po.getProps().get("hypermetor_replicationInfo");
                }
                if (null == (poReplicaInfo = JsonUtil.jsonToBean(replicationInfo, PoReplicaInfo.class))) {
                    LOG.error((Object)("Json to bean error:replicaInfoStr=" + replicationInfo));
                    continue;
                }
                PhVmInfo phVm = poReplicaInfo.getPhVmInfo();
                if (null == phVm || VerifyUtil.isEmpty((String)phVm.getVmUuid())) {
                    LOG.error((Object)("PhvmUuid is empty:replicaInfoStr=" + replicationInfo));
                    continue;
                }
                vmUuid = phVm.getVmUuid();
                vmName = phVm.getName();
            }
            OpenStackShutDownVmSubProcessor subProcussor = new OpenStackShutDownVmSubProcessor(vmUuid, vmName, projUuid, regionuuid);
            this.initProc((RecoveryProcessor)subProcussor);
            subProcessors.add((RecoveryProcessor)subProcussor);
            if (!csdrCshaReProtect) continue;
            this.generateShutDownCshaPhVmSubProcessor(regionuuid, projUuid, subProcessors, po);
        }
        this.setChildProc(subProcessors);
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }

    private void generateShutDownCshaPhVmSubProcessor(String regionuuid, String projUuid, Set<RecoveryProcessor> subProcessors, ProtectObject po) {
        String replicationInfo = (String)po.getProps().get("hypermetor_replicationInfo");
        PoReplicaInfo poReplicaInfo = JsonUtil.jsonToBean(replicationInfo, PoReplicaInfo.class);
        if (null == poReplicaInfo) {
            LOG.error((Object)("Json to bean error:replicaInfoStr=" + replicationInfo));
            return;
        }
        PhVmInfo phVm = poReplicaInfo.getPhVmInfo();
        if (null == phVm || VerifyUtil.isEmpty((String)phVm.getVmUuid())) {
            LOG.error((Object)("PhvmUuid is empty:replicaInfoStr=" + replicationInfo));
            return;
        }
        String vmUuid = phVm.getVmUuid();
        String vmName = phVm.getName();
        OpenStackShutDownVmSubProcessor subProcussorForCshaCsdr = new OpenStackShutDownVmSubProcessor(vmUuid, vmName, projUuid, regionuuid);
        this.initProc((RecoveryProcessor)subProcussorForCshaCsdr);
        subProcessors.add((RecoveryProcessor)subProcussorForCshaCsdr);
    }

    private void generateCleanDrillingSubProcessors() {
        if (!VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            return;
        }
        List createProcessors = this.getRecoveryProcessors(this.getContextRef().getRecoveryPlan(), DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING.getValue()), OpenStackPowerOnVmProcessor.class);
        if (VerifyUtil.isEmpty((Collection)createProcessors)) {
            return;
        }
        HashSet<OpenStackShutDownVmSubProcessor> subProcessors = new HashSet<OpenStackShutDownVmSubProcessor>();
        for (RecoveryProcessor processor : createProcessors) {
            if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() != processor.getProcStatus()) continue;
            OpenStackPowerOnVmProcessor powerOnVmprocessor = (OpenStackPowerOnVmProcessor)processor;
            OpenStackShutDownVmSubProcessor subProcussor = new OpenStackShutDownVmSubProcessor(powerOnVmprocessor.getString("vmUuid"), powerOnVmprocessor.getString("vmName"), powerOnVmprocessor.getString("projUuid"), powerOnVmprocessor.getString("regionUuid"));
            this.initProc((RecoveryProcessor)subProcussor);
            subProcessors.add(subProcussor);
        }
        this.setChildProc(subProcessors);
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }

    private void initProc(RecoveryProcessor proc) {
        proc.setProcName(proc.getName());
        proc.setProcType(this.getProcType());
        proc.setPlanId(this.getPlanId());
        proc.setProcessId(this.getProcessId());
        proc.setParentProc((RecoveryProcessor)this);
        proc.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public void updateDescription() {
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue() == this.getProcType()) {
            this.setDescription("ism.drm.recovery.prepare.process.des");
        }
    }
}

