/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.openstack.adapter.manager.impl.CinderManager;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeInfo;
import com.huawei.ism.drm.openstack.sdk.service.IVolumeService;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;

public class OpenStackUnReserveVolumeSubProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = 8625649865334327956L;
    private static final Log LOG = LogFactory.getInstance(OpenStackUnReserveVolumeSubProcessor.class);

    public OpenStackUnReserveVolumeSubProcessor() {
    }

    public OpenStackUnReserveVolumeSubProcessor(String volumeUuid, String regionUuid, String projUuid) {
        this.addString("volUuid", volumeUuid);
        this.addString("regionUuid", regionUuid);
        this.addString("projUuid", projUuid);
    }

    protected boolean execute(RecoveryProcessorContext context) {
        LOG.info((Object)"Enter into UnReserveVolumeProcessor");
        String volumeUuid = this.getString("volUuid");
        String regionUuid = this.getString("regionUuid");
        String projUuid = this.getString("projUuid");
        String volumeName = this.getString("volName");
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
            this.updateProcessNameParams(new String[]{volumeName});
            return true;
        }
        this.updateProcessNameParams(new String[]{OpenStackCommonUtil.getIdFromUuid(volumeUuid)});
        try {
            CinderManager cinderMgr = new CinderManager();
            String tokenId = TokenUtil.getInstance().getRegionTokenId(regionUuid, projUuid);
            VolumeInfo volInfo = cinderMgr.queryVolume(regionUuid, tokenId, projUuid, OpenStackCommonUtil.getIdFromUuid(volumeUuid));
            if (null == volInfo) {
                LOG.info((Object)"Vol(%s) is not exist", new Object[]{volumeUuid});
                if (DrmEnumDefine.RecoveryPlanExecuteTypeE.CLEAN_DRILLING.getValue() == this.getProcType()) {
                    this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
                    return true;
                }
                this.updateProcessDetail("lego.err.2117645", null);
                this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
                return true;
            }
            this.updateProcessNameParams(new String[]{volInfo.getName()});
            this.addString("volName", volInfo.getName());
            if (volInfo.getStatus().equals(OpenstackEnumDefine.VolumeStatusE.AVAILABLE.getType())) {
                this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
                LOG.info((Object)"Vol(%s) is already is avaiable status", new Object[]{volumeUuid});
                return true;
            }
            IVolumeService volService = (IVolumeService)ServiceLocator.getInstance().getService(IVolumeService.class);
            volService.unreserveVolume(volumeUuid, regionUuid, projUuid);
        }
        catch (LegoCheckedException e) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            this.updateProcessDetail(e);
            LOG.error((Object)("Un reserve volume(" + volumeUuid + ") failed."), (Throwable)e);
            return true;
        }
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        LOG.info((Object)"Leave UnReserveVolumeProcessor");
        return true;
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

