/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.openstack.adapter.manager.impl.DrExtendManager;
import com.huawei.ism.drm.openstack.adapter.msg.AsyncTaskResponse;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.recovery.utils.OpenStackRecoveryTool;
import com.huawei.ism.drm.openstack.tools.OpenStackBasicUtil;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.framework.template.util.PolicyTemplateTools;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;

public class OpenStackVolRepCgFaultSwitchProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = 7640497001755774832L;
    private static final Log LOG = LogFactory.getInstance(OpenStackVolRepCgFaultSwitchProcessor.class);

    protected boolean execute(RecoveryProcessorContext context) {
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        LOG.info((Object)"Enter into OpenStackVolRepCgFaultSwitchProcessor,recoveryPlan name=%s", new Object[]{OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)});
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
            this.updateProcessDetail("ism.drm.recovery.process.no.need", new String[0]);
            return true;
        }
        ProtectGroup pg = context.getProtectGroup();
        String drRegionUuid = (String)pg.getProps().get("drRegionId");
        String drProjUuid = (String)pg.getProps().get("drProjectId");
        String drReplicaCgUuid = OpenStackCommonUtil.getIdFromUuid(OpenStackRecoveryTool.getDrReplicaCgUuid(pg));
        String originalRegionUuid = (String)pg.getProps().get("originalAvailableRegion");
        String regionUuid = (String)pg.getProps().get("regionId");
        boolean result = false;
        if ((34 == pg.getTemplate().getType() || PolicyTemplateTools.getInstance().isCshaCsdrBetweenRegionRecovery(pg)) && regionUuid.equals(originalRegionUuid)) {
            String standRing = (String)pg.getProps().get("standbyDRRingUuid");
            result = this.volRepCgRingFaultSwitch(drRegionUuid, drProjUuid, drReplicaCgUuid, standRing);
        } else {
            result = this.volRepCgFaultSwitch(drRegionUuid, drProjUuid, drReplicaCgUuid);
        }
        if (result) {
            OpenStackRecoveryTool.operateReplicationFlagOfPg(context.getProtectGroup(), true);
            this.invalidProtectGroup(pg);
        }
        return result;
    }

    private void invalidProtectGroup(ProtectGroup pg) {
        if (this.getProcType() != DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY.getValue() && this.getProcType() != DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue()) {
            return;
        }
        IProtectGroupService pgService = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
        try {
            pgService.updateProtectGroupStatus(DrmEnumDefine.ProtectGroupStatus.INVALID, new String[]{pg.getUuid()});
        }
        catch (Exception e) {
            LOG.error((Object)("Setting protect policy invalid failed.protectGroupName=" + pg.getName() + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
    }

    private boolean volRepCgFaultSwitch(String regionUuid, String projUuid, String replicaCgUuid) {
        DrExtendManager drExtendMgr = new DrExtendManager();
        String tokenId = TokenUtil.getInstance().getRegionTokenId(regionUuid, projUuid);
        try {
            AsyncTaskResponse response = drExtendMgr.splitVolumeReplicationCG(regionUuid, tokenId, projUuid, replicaCgUuid);
            if (!response.isSuccess()) {
                this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
                this.updateProcessDetail("lego.err.1073948904", null);
                LOG.info((Object)"Set volRepCg(%s) writable failed: errorcode:%s", new Object[]{replicaCgUuid, response.getErrorCode()});
                return false;
            }
        }
        catch (LegoCheckedException e) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            this.updateProcessDetail("lego.err.1073948904", null);
            LOG.error((Object)("VolRepCg(" + replicaCgUuid + ") fault switch failed."), (Throwable)e);
            return false;
        }
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        return true;
    }

    private boolean volRepCgRingFaultSwitch(String drRegionUuid, String drProjUuid, String drReplicaCgUuid, String ringeID) {
        DrExtendManager drExtendMgr = new DrExtendManager();
        String tokenId = TokenUtil.getInstance().getRegionTokenId(drRegionUuid, drProjUuid);
        try {
            AsyncTaskResponse response = drExtendMgr.splitRingVolumeReplicationCG(drRegionUuid, tokenId, drProjUuid, drReplicaCgUuid, ringeID, "rw");
            if (!response.isSuccess()) {
                this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
                this.updateProcessDetail("lego.err.1073948904", null);
                LOG.info((Object)"Set volRepCg(%s) writable failed: errorcode:%s", new Object[]{drReplicaCgUuid, response.getErrorCode()});
                return false;
            }
        }
        catch (LegoCheckedException e) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            this.updateProcessDetail("lego.err.1073948904", null);
            LOG.error((Object)("VolRepCg(" + drReplicaCgUuid + ") fault switch failed."), (Throwable)e);
            return false;
        }
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        return true;
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public void updateDescription() {
        this.setDescription("com.huawei.ism.drm.storage.recovery.process.SwapReplicationProcessor.des");
    }
}

