/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.openstack.adapter.manager.impl.CinderManager;
import com.huawei.ism.drm.openstack.adapter.msg.AsyncTaskResponse;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeSnapShotInfo;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;

public class OpenstackDeleteVolSnapshotSubProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = 8321698132728644345L;
    private static final Log LOG = LogFactory.getInstance(OpenstackDeleteVolSnapshotSubProcessor.class);

    public OpenstackDeleteVolSnapshotSubProcessor() {
    }

    public OpenstackDeleteVolSnapshotSubProcessor(String drRegionUuid, String drProjUuid, String snapShotId, String volName) {
        this.addString("regionUuid", drRegionUuid);
        this.addString("projUuid", drProjUuid);
        this.addString("volSnapShotUuid", snapShotId);
        this.addString("volName", volName);
    }

    protected boolean execute(RecoveryProcessorContext context) {
        LOG.info((Object)"Enter into OpenstackDeleteVolSnapshotSubProcessor");
        String drRegionUuid = this.getString("regionUuid");
        String drProjUuid = this.getString("projUuid");
        String snapShotId = this.getString("volSnapShotUuid");
        this.updateProcessNameParams(new String[]{this.getString("volName")});
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
            return true;
        }
        if (VerifyUtil.isEmpty((String)snapShotId)) {
            LOG.info((Object)"SnapShotId is empty");
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            return true;
        }
        CinderManager cinderMgr = new CinderManager();
        String tokenId = TokenUtil.getInstance().getRegionTokenId(drRegionUuid, drProjUuid);
        try {
            VolumeSnapShotInfo info = cinderMgr.queryVolumeSnapShotByUuid(drRegionUuid, tokenId, drProjUuid, snapShotId);
            if (null == info) {
                this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
                LOG.info((Object)"SnapShot(%s) doesn't exit.", new Object[]{snapShotId});
                this.updateProcessDetail("ism.drm.recovery.process.no.need", new String[0]);
                return true;
            }
            AsyncTaskResponse response = cinderMgr.deleteVolSnapShotById(drRegionUuid, drProjUuid, tokenId, snapShotId);
            if (!response.isSuccess()) {
                this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
                this.updateProcessDetail("lego.err." + response.getErrorCode(), null);
                LOG.error((Object)("Del vol snapShot(" + snapShotId + ")failed, errorcode is " + response.getErrorCode()));
                return false;
            }
        }
        catch (LegoCheckedException e) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            this.updateProcessDetail(e);
            LOG.error((Object)("Del vol snapShot(" + snapShotId + ")failed."), (Throwable)e);
            return false;
        }
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        LOG.info((Object)"Leave OpenstackDeleteVolSnapshotSubProcessor");
        return true;
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

