/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor.cshacsdr;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessorDetail;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.drp.util.RecoveryServiceUtil;
import com.huawei.ism.drm.openstack.tools.OpenStackBasicUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessSerialExecutor;
import com.huawei.ism.drm.recovery.process.IInitialChildProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class BaseCshaCsdrRecoveryProcessor
extends BaseRecoveryProcessor
implements IInitialChildProcessor {
    private static final long serialVersionUID = -729256930188252874L;
    private static final Log LOG = LogFactory.getInstance(BaseCshaCsdrRecoveryProcessor.class);

    protected boolean execute(RecoveryProcessorContext context) {
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        LOG.info((Object)"RecoveryPlan name:%s, enter into processor:%s", new Object[]{OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan), ((Object)((Object)this)).getClass()});
        DrmEnumDefine.RecoveryPlanExecuteTypeE execType = DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)this.getProcType());
        RecoveryProcessSerialExecutor recoveryTemplate = RecoveryProcessSerialExecutor.createRecoveryProcessExecutor(new ArrayList(RecoveryServiceUtil.sortRecoveryProcessors((Set)this.getChildProc())), (DrmEnumDefine.RecoveryPlanExecuteTypeE)execType);
        if (null == recoveryTemplate) {
            LOG.error((Object)"Create recovery processExecutor failed, recoveryTemplate is null.");
            throw new LegoCheckedException(2117645L);
        }
        IRecoveryPlanService recoveryPlanService = (IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class);
        Map<String, List<RecoveryProcessorDetail>> details = recoveryPlanService.getRecoveryProcessorDetailsByLogId(context.getRecoveryPlan().getPlanId(), context.getRecoveryLogId()).stream().filter(detail -> !VerifyUtil.isEmpty((Collection)detail.getChildDetails())).flatMap(detail -> detail.getChildDetails().stream()).filter(detail -> DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue() != detail.getProcessStatus()).collect(Collectors.groupingBy(RecoveryProcessorDetail::getProcId));
        context.setAttribute("CSHA_CSDR_ALL_RECOVERYPROCESSOR_DETAIL", details);
        recoveryTemplate.process(context);
        LOG.info((Object)"RecoveryPlan name:%s, leave processor:%s", new Object[]{OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan), ((Object)((Object)this)).getClass()});
        boolean result = this.calcProcessResultBySubProc();
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus() && context.getAttributeKeys().contains("PLAN_PROGRESS_COMPLETED_NUM") && this.getChildProc().stream().anyMatch(process -> DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue() == process.getProcStatus())) {
            context.setAttribute("IS_PAUSED_PROCESS", (Object)true);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
        }
        return result;
    }

    protected boolean calcProcessResultBySubProc() {
        boolean executeResult = super.calcProcessResultBySubProc();
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.PART_SUCCESS.getValue() == this.getProcStatus() && DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY.getValue() != this.getProcType()) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            executeResult = false;
        }
        return executeResult;
    }

    protected DrmEnumDefine.RecoveryPlanExecuteResultE calcProcStatusBySubProc(Set<RecoveryProcessor> rProcesses) {
        LOG.debug((Object)"begin calc BaseCshaCsdrRecoveryProcessor Status start");
        if (!VerifyUtil.isEmpty(rProcesses) && DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue() != this.getProcType()) {
            for (RecoveryProcessor process : rProcesses) {
                if (DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue() != process.getProcStatus() || !process.getIsEnabled().booleanValue()) continue;
                return DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED;
            }
        }
        return super.calcProcStatusBySubProc(rProcesses);
    }

    public void resetEnableStatus(ProtectGroup pg, DrmEnumDefine.RecoveryPlanExecuteTypeE procType) {
        String regionType;
        String string = regionType = null == pg ? null : pg.getProperty("RECOVERY_REGION_TYPE");
        if (null == regionType) {
            this.setIsEnabled(true);
        } else {
            this.setIsEnabled(regionType.equals(this.getRecoveryRegionType()));
        }
    }

    abstract String getRecoveryRegionType();
}

