/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor.sfs;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.openstack.adapter.util.JsonUtil;
import com.huawei.ism.drm.openstack.recovery.processor.sfs.OpenStackSfsRefactorNasProcessor;
import com.huawei.ism.drm.openstack.recovery.processor.sfs.OpenStackSfsRefactorShareSubProcessor;
import com.huawei.ism.drm.openstack.sdk.bo.Share;
import com.huawei.ism.drm.openstack.tools.OpenStackBasicUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class OpenStackSfsRefactorShareProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -8038552859866054201L;
    private static final Log LOG = LogFactory.getInstance(OpenStackSfsRefactorNasProcessor.class);

    protected boolean execute(RecoveryProcessorContext context) {
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        LOG.info((Object)"Enter into OpenStackSfsRefactorShareProcessor,recoveryPlan name=%s, procType=%s.", new Object[]{OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan), this.getProcType()});
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.REPROTECT.getValue() != this.getProcType() && DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue() != this.getProcType()) {
            LOG.info((Object)"The procType [%s] no need to execute current processor.", (long)this.getProcType());
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            return true;
        }
        this.generateSubProcessors(recoveryPlan);
        if (!VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            context.setAttribute("IS_SFS_PROCESSOR", (Object)true);
            return this.executeSubProcessor(context);
        }
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        return true;
    }

    private void generateSubProcessors(RecoveryPlan recoveryPlan) {
        Set protectGroups = recoveryPlan.getProtectGroups();
        Set subProcessors = protectGroups.stream().flatMap(protectGroup -> protectGroup.getPolist().stream()).flatMap(protectObject -> Stream.of(this.getSubProcessor((ProtectObject)protectObject, "drProjectId", "drRegionId", "dr_share"), this.getSubProcessor((ProtectObject)protectObject, "projectId", "regionId", "pd_share"))).collect(Collectors.toSet());
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).deleteSubRecoveryProcessor(this.getProcId());
        this.setChildProc(subProcessors);
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }

    private OpenStackSfsRefactorShareSubProcessor getSubProcessor(ProtectObject protectObject, String projectIdKey, String regionIdKey, String sharePropKey) {
        ProtectGroup protectGroup = protectObject.getProtectGroup();
        Share share = JsonUtil.jsonToBean(protectObject.getProperty(sharePropKey), Share.class);
        if (VerifyUtil.isEmpty((Object)share) || VerifyUtil.isEmpty((String)share.getShareType())) {
            LOG.error((Object)"The protectObject(%s) of protectGroup(%s) does not contain pdShare or drShare.", new Object[]{protectObject.getName(), protectGroup.getName()});
            throw new LegoCheckedException(1073949744L, new String[]{protectObject.getName()});
        }
        OpenStackSfsRefactorShareSubProcessor proc = new OpenStackSfsRefactorShareSubProcessor(protectObject, projectIdKey, regionIdKey, sharePropKey, share.getName());
        proc.setProcName(proc.getName());
        proc.setProcType(this.getProcType());
        proc.setPlanId(this.getPlanId());
        proc.setProcessId(this.getProcessId());
        proc.setParentProc((RecoveryProcessor)this);
        proc.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
        return proc;
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

