/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor.sfs;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.galax.sdk.model.HypermetroDomain;
import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.adapter.manager.ISfsFilemeterManager;
import com.huawei.ism.drm.openstack.adapter.util.JsonUtil;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.recovery.processor.sfs.OpenStackSfsShairPairStatusCheckProcessor;
import com.huawei.ism.drm.openstack.sdk.bo.Share;
import com.huawei.ism.drm.openstack.sdk.bo.UrlBaseParams;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.tools.OpenStackBasicUtil;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class OpenStackSfsStatusCheckProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = 3882837116645265380L;
    private static final Log LOG = LogFactory.getInstance(OpenStackSfsStatusCheckProcessor.class);
    private static ISfsFilemeterManager sfsFilemeterManager = ManagerFactory.getInstance().getSfsFilemeterManager();

    protected boolean execute(RecoveryProcessorContext context) {
        HypermetroDomain hypermetroDomain;
        String shareTypeName;
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        LOG.info((Object)"Enter into OpenStackSfsStatusCheckProcessor,recoveryPlan name=%s, procType=%s.", new Object[]{OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan), this.getProcType()});
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY.getValue() == this.getProcType()) {
            shareTypeName = OpenStackCommonUtil.getShareTypeNameFromProtectObject(context, "dr_share");
            hypermetroDomain = this.getHypermetroDomain(recoveryPlan, shareTypeName, "drProjectId", "drRegionId");
            this.checkHyperMetroDomainRunningStatus(hypermetroDomain, shareTypeName, Arrays.asList(OpenstackEnumDefine.HypermetroDomainStatus.NORMAL.getKey(), OpenstackEnumDefine.HypermetroDomainStatus.ERROR.getKey(), OpenstackEnumDefine.HypermetroDomainStatus.SPLIT.getKey()));
            this.generateSubProcessors(recoveryPlan, "drProjectId", "drRegionId");
        }
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.REPROTECT.getValue() == this.getProcType()) {
            String drShareTypeName = OpenStackCommonUtil.getShareTypeNameFromProtectObject(context, "dr_share");
            HypermetroDomain drHypermetroDomain = this.getHypermetroDomain(recoveryPlan, drShareTypeName, "drProjectId", "drRegionId");
            this.checkHyperMetroDomainRunningStatus(drHypermetroDomain, drShareTypeName, Collections.singletonList(OpenstackEnumDefine.HypermetroDomainStatus.SPLIT.getKey()));
            this.checkHyperMetroDomainAccess(drHypermetroDomain, OpenstackEnumDefine.HypermetroDomainAccess.READABLE_AND_WRITABLE.getValue(), drShareTypeName);
            String pdShareTypeName = OpenStackCommonUtil.getShareTypeNameFromProtectObject(context, "pd_share");
            HypermetroDomain pdHypermetroDomain = this.getHypermetroDomain(recoveryPlan, pdShareTypeName, "projectId", "regionId");
            this.checkHyperMetroDomainAccess(pdHypermetroDomain, OpenstackEnumDefine.HypermetroDomainAccess.READABLE_AND_WRITABLE.getValue(), pdShareTypeName);
        }
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue() == this.getProcType()) {
            shareTypeName = OpenStackCommonUtil.getShareTypeNameFromProtectObject(context, "pd_share");
            hypermetroDomain = this.getHypermetroDomain(recoveryPlan, shareTypeName, "projectId", "regionId");
            this.checkHyperMetroDomainRunningStatus(hypermetroDomain, shareTypeName, Arrays.asList(OpenstackEnumDefine.HypermetroDomainStatus.NORMAL.getKey(), OpenstackEnumDefine.HypermetroDomainStatus.RECOVERING.getKey(), OpenstackEnumDefine.HypermetroDomainStatus.SPLIT.getKey()));
            this.generateSubProcessors(recoveryPlan, "projectId", "regionId");
        }
        if (!VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            context.setAttribute("IS_SFS_PROCESSOR", (Object)true);
            return this.executeSubProcessor(context);
        }
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        return true;
    }

    private void generateSubProcessors(RecoveryPlan recoveryPlan, String projectIdKey, String regionIdKey) {
        Set subProcessors = recoveryPlan.getProtectGroups().stream().flatMap(protectGroup -> protectGroup.getPolist().stream()).map(protectObject -> {
            Share share = JsonUtil.jsonToBean(protectObject.getProperty("pd_share"), Share.class);
            OpenStackSfsShairPairStatusCheckProcessor proc = new OpenStackSfsShairPairStatusCheckProcessor((ProtectObject)protectObject, projectIdKey, regionIdKey, share.getName());
            proc.setProcName(proc.getName());
            proc.setProcType(this.getProcType());
            proc.setPlanId(this.getPlanId());
            proc.setProcessId(this.getProcessId());
            proc.setParentProc((RecoveryProcessor)this);
            proc.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
            return proc;
        }).collect(Collectors.toSet());
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).deleteSubRecoveryProcessor(this.getProcId());
        this.setChildProc(subProcessors);
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }

    private void checkHyperMetroDomainAccess(HypermetroDomain hypermetroDomain, String requireAccess, String shareTypeName) {
        if (requireAccess.equals(hypermetroDomain.getAccess())) {
            LOG.info((Object)"The access of HyperMetroDomain(%s) is right.", new Object[]{shareTypeName});
            return;
        }
        LOG.error((Object)"The access of HyperMetroDomain(%s) is %s,requird value is %s.", new Object[]{shareTypeName, hypermetroDomain.getAccess(), requireAccess});
        throw new LegoCheckedException(1073949751L, new String[]{hypermetroDomain.getName()});
    }

    private void checkHyperMetroDomainRunningStatus(HypermetroDomain hypermetroDomain, String shareTypeName, List<String> availableHypermetroDomainStatus) {
        if (hypermetroDomain == null) {
            return;
        }
        if (availableHypermetroDomainStatus.contains(hypermetroDomain.getRunningStatus())) {
            LOG.info((Object)"The status of HyperMetroDomain(%s) is %s, pass the verification.", new Object[]{shareTypeName, hypermetroDomain.getRunningStatus()});
            return;
        }
        LOG.error((Object)"The hypermetroDomain(%s) status %s is invalid.", new Object[]{shareTypeName, hypermetroDomain.getRunningStatus()});
        throw new LegoCheckedException(1073949748L, new String[]{hypermetroDomain.getName(), OpenstackEnumDefine.HypermetroDomainStatus.getTypeFromValue((String)hypermetroDomain.getRunningStatus()).getValue()});
    }

    private HypermetroDomain getHypermetroDomain(RecoveryPlan recoveryPlan, String shareTypeName, String projectIdKey, String regionIdKey) {
        String tokenId;
        String regionUuid;
        ProtectGroup pg = (ProtectGroup)CommonUtil.getFirstElement((Collection)recoveryPlan.getProtectGroups());
        String projUuid = pg.getProperty(projectIdKey);
        UrlBaseParams urlBaseParams = new UrlBaseParams(projUuid, regionUuid = pg.getProperty(regionIdKey), tokenId = TokenUtil.getInstance().getTokenId(projUuid));
        HypermetroDomain hypermetroDomain = sfsFilemeterManager.queryHypermetroDomain(urlBaseParams, shareTypeName);
        if (VerifyUtil.isEmpty((Object)hypermetroDomain)) {
            LOG.error((Object)"The hypermetroDomain %s is not exist.", new Object[]{shareTypeName});
            throw new LegoCheckedException(1073949747L);
        }
        return hypermetroDomain;
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

