/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.provider;

import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoverySetting;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.galax.resource.checker.ProtectObjectCountChecker;
import com.huawei.ism.drm.openstack.adapter.manager.impl.DrExtendManager;
import com.huawei.ism.drm.openstack.adapter.util.JsonUtil;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.recovery.provider.OpenStackCshaCsdrHyperRefactorConfigureProvider;
import com.huawei.ism.drm.openstack.recovery.utils.OpenStackRecoveryTool;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaInfo;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaPairInfo;
import com.huawei.ism.drm.openstack.sdk.bo.Share;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackProject;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeReplicationCgInfo;
import com.huawei.ism.drm.openstack.sdk.service.IOpenstackResourceService;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.framework.template.util.PolicyTemplateTools;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.provider.sdk.service.IProtectObjectProvider;
import com.huawei.ism.drm.protection.provider.sdk.service.IProtectObjectProviderDelegate;
import com.huawei.ism.drm.recovery.framework.provider.BaseRefactorConfigurationProvider;
import com.huawei.ism.drm.recovery.process.IRefactorConfigurationProvider;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class OpenStackRefactorConfigurationProvider
extends BaseRefactorConfigurationProvider
implements IRefactorConfigurationProvider {
    private static final Log LOG = LogFactory.getInstance(OpenStackRefactorConfigurationProvider.class);
    private static final Map<String, String> RECOVERY_SETTING_DEFAULT_VALUE = new HashMap<String, String>();

    public List<String> getAppType() {
        return null;
    }

    public void refactorProtectObjectStorageInfos(ProtectObject protectObject, Map<String, Object> params) {
        LOG.debug((Object)"Refactor protectObject StorageInfos, protectObject name=%s", new Object[]{protectObject != null ? protectObject.getName() : ""});
    }

    protected void reverseProtectObjectAttributes(ProtectObject protectObject, Map<String, Object> params) {
        if (protectObject.getPoType() == 17) {
            this.reverseSfsProtectObjectAttributes(protectObject);
            LOG.info((Object)"ReverseSfsProtectObjectAttributes of protectObject(%s).", new Object[]{protectObject.getName()});
            return;
        }
        boolean isCshaCsdrWithinRegionRecovery = PolicyTemplateTools.getInstance().isCshaCsdrWithinRegionRecovery(protectObject.getProtectGroup());
        if (isCshaCsdrWithinRegionRecovery) {
            this.reverseProtectObjectAttributesForCshaCsdr(protectObject, params);
            return;
        }
        this.poPropsRemoteReplicationInfo(protectObject, params);
        String poReplicaInfoStr = (String)protectObject.getProps().get("replicationInfo");
        PoReplicaInfo poReplicaInfo = JsonUtil.jsonToBean(poReplicaInfoStr, PoReplicaInfo.class);
        if (null == poReplicaInfo) {
            LOG.error((Object)"Parse poReplicaInfo failed. poName=%s, poReplicaInfoJson=%s", new Object[]{protectObject.getName(), poReplicaInfoStr});
            return;
        }
        Map<String, String> drVolUuidToProductVolType = this.reversePoReplicaInfo(protectObject, params, poReplicaInfo);
        protectObject.getProps().put("replicationInfo", JsonUtil.beanToJson(poReplicaInfo));
        JSONArray volConfigArray = JSONArray.fromObject(protectObject.getProps().get("volumeConfig"));
        if (VerifyUtil.isEmpty((Collection)volConfigArray)) {
            LOG.error((Object)"VolumeConfig is null. pg:%s, po:%s", new Object[]{protectObject.getProtectGroup().getName(), protectObject.getName()});
            return;
        }
        JSONObject volJson = volConfigArray.getJSONObject(0);
        String srcVolType = volJson.containsKey((Object)"volumeType") ? volJson.getString("volumeType") : null;
        String drVolType = volJson.containsKey((Object)"drVolumeType") ? volJson.getString("drVolumeType") : null;
        String drHyperVolType = volJson.containsKey((Object)"drHyperVolumeType") ? volJson.getString("drHyperVolumeType") : null;
        volConfigArray.clear();
        this.resetVolConfigArray(drVolUuidToProductVolType, volConfigArray, srcVolType, drVolType, drHyperVolType);
        protectObject.getProps().put("volumeConfig", volConfigArray.toString());
        if (protectObject.getProtectGroup() != null) {
            ProtectGroup pg = protectObject.getProtectGroup();
            String zoneName = (String)pg.getProps().get("zoneName");
            protectObject.setProperty("zoneName", (Object)zoneName);
        }
    }

    private void reverseSfsProtectObjectAttributes(ProtectObject protectObject) {
        String pdShare = (String)protectObject.getProps().get("pd_share");
        String drShare = (String)protectObject.getProps().get("dr_share");
        protectObject.getProps().put("pd_share", drShare);
        protectObject.getProps().put("dr_share", pdShare);
        if (!VerifyUtil.isEmpty((Object)protectObject.getProtectGroup())) {
            ProtectGroup pg = protectObject.getProtectGroup();
            String zoneName = (String)pg.getProps().get("zoneName");
            String regionUuid = (String)pg.getProps().get("regionId");
            String projectUuid = (String)pg.getProps().get("projectId");
            protectObject.getProps().put("regionId", CommUtil.getIdFromUuid((String)regionUuid));
            protectObject.getProps().put("projectName", this.getProjectName(projectUuid));
            protectObject.getProps().put("zoneName", zoneName);
        }
    }

    private String getProjectName(String projectUuid) {
        OpenStackProject openStackProject = ((IOpenstackResourceService)ServiceLocator.getInstance().getService(IOpenstackResourceService.class)).getProjectByProjectUUid(projectUuid);
        if (!VerifyUtil.isEmpty((Object)openStackProject)) {
            return openStackProject.getName();
        }
        LOG.error((Object)("OpenStackProject null,projectUuid:" + projectUuid));
        throw new LegoCheckedException(65540L);
    }

    private void resetVolConfigArray(Map<String, String> drVolUuidToProductVolType, JSONArray volConfigArray, String srcVolType, String drVolType, String drHyperVolType) {
        for (Map.Entry<String, String> entry : drVolUuidToProductVolType.entrySet()) {
            JSONObject jsonInfo = new JSONObject();
            String productVolUuid = entry.getKey();
            String newDrVolType = entry.getValue();
            jsonInfo.put((Object)"volumeId", (Object)productVolUuid);
            jsonInfo.put((Object)"drVolumeType", (Object)newDrVolType);
            if (!VerifyUtil.isEmpty((String)srcVolType)) {
                jsonInfo.put((Object)"volumeType", (Object)(srcVolType.equals(newDrVolType) ? drVolType : srcVolType));
            }
            if (!VerifyUtil.isEmpty((String)drHyperVolType)) {
                jsonInfo.put((Object)"drHyperVolumeType", (Object)drHyperVolType);
            }
            volConfigArray.add((Object)jsonInfo);
        }
    }

    private void reverseProtectObjectAttributesForCshaCsdr(ProtectObject protectObject, Map<String, Object> params) {
        String poReplicaInfoStr = (String)protectObject.getProps().get("hypermetor_replicationInfo");
        PoReplicaInfo poReplicaInfo = JsonUtil.jsonToBean(poReplicaInfoStr, PoReplicaInfo.class);
        if (null == poReplicaInfo) {
            LOG.error((Object)"Parse poReplicaInfo failed. poName=%s, poReplicaInfoJson=%s", new Object[]{protectObject.getName(), poReplicaInfoStr});
            return;
        }
        Map<String, String> drVolUuidToProductVolType = this.reversePoReplicaInfo(protectObject, params, poReplicaInfo);
        protectObject.getProps().put("hypermetor_replicationInfo", JsonUtil.beanToJson(poReplicaInfo));
        JSONArray volConfigArray = JSONArray.fromObject(protectObject.getProps().get("volumeConfig"));
        if (VerifyUtil.isEmpty((Collection)volConfigArray)) {
            LOG.error((Object)"VolumeConfig is null. pg:%s, po:%s", new Object[]{protectObject.getProtectGroup().getName(), protectObject.getName()});
            return;
        }
        JSONObject volJson = volConfigArray.getJSONObject(0);
        String srcVolType = volJson.containsKey((Object)"volumeType") ? volJson.getString("volumeType") : null;
        String drVolType = volJson.containsKey((Object)"drVolumeType") ? volJson.getString("drVolumeType") : null;
        String drHyperVolType = volJson.containsKey((Object)"drHyperVolumeType") ? volJson.getString("drHyperVolumeType") : null;
        volConfigArray.clear();
        for (Map.Entry<String, String> entry : drVolUuidToProductVolType.entrySet()) {
            JSONObject jsonInfo = new JSONObject();
            String productVolUuid = entry.getKey();
            String newHyperVolType = entry.getValue();
            jsonInfo.put((Object)"volumeId", (Object)productVolUuid);
            if (!VerifyUtil.isEmpty((String)srcVolType)) {
                jsonInfo.put((Object)"volumeType", (Object)(srcVolType.equals(newHyperVolType) ? drHyperVolType : srcVolType));
            }
            if (!VerifyUtil.isEmpty((String)drVolType)) {
                jsonInfo.put((Object)"drVolumeType", (Object)drVolType);
            }
            jsonInfo.put((Object)"drHyperVolumeType", (Object)newHyperVolType);
            volConfigArray.add((Object)jsonInfo);
        }
        protectObject.getProps().put("volumeConfig", volConfigArray.toString());
        if (null != protectObject.getProtectGroup()) {
            ProtectGroup pg = protectObject.getProtectGroup();
            String zoneName = (String)pg.getProps().get("zoneName");
            protectObject.setProperty("zoneName", (Object)zoneName);
        }
        this.updatePoReplicaInfoForCshaCsdr(protectObject, params);
    }

    private void updatePoReplicaInfoForCshaCsdr(ProtectObject protectObject, Map<String, Object> params) {
        String replicaInfoUuid = (String)protectObject.getProps().get("replicationInfo");
        String drReplicaInfoUuid = (String)protectObject.getProps().get("remote_replicationInfo");
        boolean migration = OpenStackRecoveryTool.isMigration((RecoveryPlan)params.get("RecoveryPlan"), protectObject.getMoUuid());
        if (migration) {
            PoReplicaInfo poReplicaInfoActive = JsonUtil.jsonToBean(replicaInfoUuid, PoReplicaInfo.class);
            PoReplicaInfo poReplicaInfoStandby = JsonUtil.jsonToBean(drReplicaInfoUuid, PoReplicaInfo.class);
            block0: for (PoReplicaPairInfo activePairInfo : poReplicaInfoActive.getPairInfos()) {
                String volUuid = activePairInfo.getDrVolumeUuid();
                for (PoReplicaPairInfo standbyPairInfo : poReplicaInfoStandby.getPairInfos()) {
                    String standbyVolUuid = standbyPairInfo.getDrVolumeUuid();
                    if (!volUuid.equals(standbyVolUuid)) continue;
                    String standbyReplicationDrId = standbyPairInfo.getDrReplicaUuid();
                    String standbyReplicationId = standbyPairInfo.getReplicaUuid();
                    String standbyReplicationVolType = standbyPairInfo.getVolumeType();
                    String activeReplicationDrId = activePairInfo.getDrReplicaUuid();
                    String activeReplicationId = activePairInfo.getReplicaUuid();
                    String activeReplicationVolType = activePairInfo.getVolumeType();
                    activePairInfo.setReplicaUuid(standbyReplicationId);
                    activePairInfo.setDrReplicaUuid(standbyReplicationDrId);
                    activePairInfo.setVolumeType(standbyReplicationVolType);
                    standbyPairInfo.setReplicaUuid(activeReplicationId);
                    standbyPairInfo.setDrReplicaUuid(activeReplicationDrId);
                    standbyPairInfo.setVolumeType(activeReplicationVolType);
                    continue block0;
                }
            }
            String activeCg = poReplicaInfoActive.getCgUuid();
            String activeDrCg = poReplicaInfoActive.getDrCgUuid();
            String standbyCg = poReplicaInfoStandby.getCgUuid();
            String standbyDrCg = poReplicaInfoStandby.getDrCgUuid();
            poReplicaInfoStandby.setCgUuid(activeCg);
            poReplicaInfoStandby.setDrCgUuid(activeDrCg);
            poReplicaInfoActive.setCgUuid(standbyCg);
            poReplicaInfoActive.setDrCgUuid(standbyDrCg);
            protectObject.getProps().put("replicationInfo", JsonUtil.beanToJson(poReplicaInfoActive));
            protectObject.getProps().put("remote_replicationInfo", JsonUtil.beanToJson(poReplicaInfoStandby));
        } else {
            protectObject.getProps().put("replicationInfo", drReplicaInfoUuid);
            protectObject.getProps().put("remote_replicationInfo", replicaInfoUuid);
        }
    }

    private Map<String, String> reversePoReplicaInfo(ProtectObject protectObject, Map<String, Object> params, PoReplicaInfo poReplicaInfo) {
        String drCgUuid = poReplicaInfo.getDrCgUuid();
        String drProjUuid = poReplicaInfo.getDrProjUuid();
        String drRegionUuid = poReplicaInfo.getDrRegionUuid();
        poReplicaInfo.setDrCgUuid(poReplicaInfo.getCgUuid());
        poReplicaInfo.setDrProjUuid(poReplicaInfo.getProjUuid());
        poReplicaInfo.setDrRegionUuid(poReplicaInfo.getRegionUuid());
        poReplicaInfo.setCgUuid(drCgUuid);
        poReplicaInfo.setProjUuid(drProjUuid);
        poReplicaInfo.setRegionUuid(drRegionUuid);
        poReplicaInfo.setVmName(protectObject.getName());
        boolean migration = OpenStackRecoveryTool.isMigration((RecoveryPlan)params.get("RecoveryPlan"), protectObject.getMoUuid());
        this.updatePoReplicaVmInfo(protectObject, params, poReplicaInfo, migration);
        return OpenStackRefactorConfigurationProvider.reverseStorageReplicationInfo(poReplicaInfo, migration);
    }

    private static Map<String, String> reverseStorageReplicationInfo(PoReplicaInfo poReplicaInfo, boolean isMigration) {
        HashMap<String, String> drVolUuidToProductVolType = new HashMap<String, String>();
        Iterator itr = poReplicaInfo.getPairInfos().iterator();
        while (itr.hasNext()) {
            PoReplicaPairInfo pairInfo = (PoReplicaPairInfo)itr.next();
            String drVolUuid = pairInfo.getDrVolumeUuid();
            if (VerifyUtil.isEmpty((String)drVolUuid)) {
                LOG.info((Object)"%s has no drvolume.", new Object[]{pairInfo.getVolumeName()});
                itr.remove();
                continue;
            }
            if (!VerifyUtil.isEmpty((String)pairInfo.getDrVolumeName())) {
                String drVolName = pairInfo.getDrVolumeName();
                String volName = pairInfo.getVolumeName();
                pairInfo.setVolumeName(drVolName);
                pairInfo.setDrVolumeName(volName);
            }
            String drVolType = pairInfo.getDrVolumeType();
            String volType = pairInfo.getVolumeType();
            pairInfo.setVolumeType(drVolType);
            pairInfo.setDrVolumeType(volType);
            String drReplicaUuid = pairInfo.getDrReplicaUuid();
            String replicaUuid = pairInfo.getReplicaUuid();
            pairInfo.setReplicaUuid(drReplicaUuid);
            String volUuid = pairInfo.getVolumeUuid();
            if (!isMigration) {
                pairInfo.setVolumeUuid(drVolUuid);
                pairInfo.setDrVolumeUuid(volUuid);
            }
            pairInfo.setDrReplicaUuid(replicaUuid);
            if (!OpenstackEnumDefine.VolProtectStatusE.PROTECTED.getStatus().equals(pairInfo.getVolumeStatus())) {
                LOG.info((Object)"%s's status is %s, and set it to removed.", new Object[]{pairInfo.getVolumeName(), pairInfo.getVolumeStatus()});
                pairInfo.setVolumeStatus(OpenstackEnumDefine.VolProtectStatusE.RELEASING.getStatus());
            }
            if (isMigration) {
                drVolUuidToProductVolType.put(volUuid, volType);
                continue;
            }
            drVolUuidToProductVolType.put(drVolUuid, volType);
        }
        return drVolUuidToProductVolType;
    }

    private void updatePoReplicaVmInfo(ProtectObject protectObject, Map<String, Object> params, PoReplicaInfo poReplicaInfo, boolean migration) {
        String holdVmKey = protectObject.getProtectGroup().getUuid() + "_PlaceHolderMap";
        Map holdVmToProductVm = (Map)params.get(holdVmKey);
        if (poReplicaInfo.getPhVmInfo() != null) {
            if (holdVmToProductVm == null) {
                LOG.error((Object)("Get holdVmToProductVm return null. key=" + holdVmKey));
                throw new LegoCheckedException(1073947393L);
            }
            if (!migration) {
                if (37 == protectObject.getProtectGroup().getTemplate().getType()) {
                    String poReplicaInfoUuid = poReplicaInfo.getPhVmInfo().getVmUuid();
                    String poReplicaInfoVmName = poReplicaInfo.getPhVmInfo().getName();
                    poReplicaInfo.getPhVmInfo().setVmUuid(poReplicaInfo.getMoUuid());
                    poReplicaInfo.getPhVmInfo().setName(poReplicaInfo.getVmName());
                    poReplicaInfo.setMoUuid(poReplicaInfoUuid);
                    poReplicaInfo.setVmName(poReplicaInfoVmName);
                } else {
                    poReplicaInfo.getPhVmInfo().setVmUuid((String)holdVmToProductVm.get(protectObject.getMoUuid()));
                    poReplicaInfo.getPhVmInfo().setName((String)holdVmToProductVm.get(protectObject.getName()));
                    poReplicaInfo.setMoUuid(protectObject.getMoUuid());
                    poReplicaInfo.setVmName(protectObject.getName());
                }
            }
        }
    }

    private void poPropsRemoteReplicationInfo(ProtectObject protectObject, Map<String, Object> params) {
        String poReplicaInfoStr = (String)protectObject.getProps().get("remote_replicationInfo");
        if (VerifyUtil.isEmpty((String)poReplicaInfoStr)) {
            LOG.info((Object)"PoReplicaInfo 's remote_replicationInfo is null. poName=%s", new Object[]{protectObject.getName()});
            return;
        }
        PoReplicaInfo poReplicaInfo = JsonUtil.jsonToBean(poReplicaInfoStr, PoReplicaInfo.class);
        if (VerifyUtil.isEmpty((Object)poReplicaInfo)) {
            LOG.error((Object)"Parse poReplicaInfo 's remote_replicationInfo failed. poName=%s, poReplicaInfoJson=%s", new Object[]{protectObject.getName(), poReplicaInfoStr});
            return;
        }
        this.reversePoReplicaInfo(protectObject, params, poReplicaInfo);
        protectObject.getProps().put("remote_replicationInfo", JsonUtil.beanToJson(poReplicaInfo));
    }

    protected void reverseProtectGroupAttributes(ProtectGroup pg, Map<String, Object> params) {
        this.updateProtectGroupProps(pg);
        this.updateProtectObjectMoUUID(pg, params);
        IProtectObjectProvider provider = (IProtectObjectProvider)((IProtectObjectProviderDelegate)ServiceLocator.getInstance().getService(IProtectObjectProviderDelegate.class)).getProviderByAppType(pg.getPoType());
        ProtectObjectCountChecker.checkPoCountInSystem((int)pg.getPoCount(), (String)pg.getUuid());
        provider.buildProtectObjects(pg);
    }

    private void constructAttrForHyperMasterChange(ProtectGroup pg, RecoveryPlan recoveryPlan) {
        String regionUuid = (String)pg.getProps().get("drRegionId");
        String projUuid = (String)pg.getProps().get("drProjectId");
        String hyperProCgUuid = (String)pg.getProps().get("hyperProCgUuid");
        DrExtendManager drExtendMgr = new DrExtendManager();
        String tokenId = TokenUtil.getInstance().getRegionTokenId(regionUuid, projUuid);
        VolumeReplicationCgInfo repCGInfo = drExtendMgr.queryVolumeReplicationCG(regionUuid, tokenId, projUuid, OpenStackCommonUtil.getIdFromUuid(hyperProCgUuid));
        if (repCGInfo == null) {
            LOG.info((Object)"%s :the cg is not exist:cgId=%s", new Object[]{pg.getName(), hyperProCgUuid});
            throw new LegoCheckedException(1073947393L);
        }
        String hyperMasterAz = repCGInfo.getAzName();
        String pgAz = (String)pg.getProps().get("drZoneName");
        String pgDrAz = (String)pg.getProps().get("prod_region_drZoneName");
        if (repCGInfo.isMasterFlag() && hyperMasterAz.equals(OpenStackCommonUtil.getIdFromUuid(pgAz))) {
            return;
        }
        if (!repCGInfo.isMasterFlag() && hyperMasterAz.equals(OpenStackCommonUtil.getIdFromUuid(pgDrAz))) {
            return;
        }
        OpenStackCshaCsdrHyperRefactorConfigureProvider provider = new OpenStackCshaCsdrHyperRefactorConfigureProvider();
        provider.reverseProtectGroupAttributes(pg);
        LOG.debug((Object)"After reverseProtectGroupHyperAttributes:recoveryPlan name:%s", new Object[]{pg.getName()});
        for (ProtectObject po : pg.getPolist()) {
            provider.reverseProtectObjectAttributes(po);
        }
        provider.exchangeRecoverySetting(recoveryPlan, pg);
    }

    private void updateProtectGroupProps(ProtectGroup pg) {
        if (PolicyTemplateTools.getInstance().isCshaCsdrWithinRegionRecovery(pg)) {
            String zoneName = (String)pg.getProps().get("zoneName");
            String drZoneName = (String)pg.getProps().get("prod_region_drZoneName");
            pg.getProps().put("zoneName", drZoneName);
            pg.getProps().put("prod_region_drZoneName", zoneName);
            String hyperCgUuid = (String)pg.getProps().get("hyperProCgUuid");
            String hyperDrCgUuid = (String)pg.getProps().get("hyperProdrCgUuid");
            pg.getProps().put("hyperProCgUuid", hyperDrCgUuid);
            pg.getProps().put("hyperProdrCgUuid", hyperCgUuid);
            this.updateReplicaCgForProtectGroupProps(pg);
        } else {
            String cgUuid = (String)pg.getProps().get("replicaCgUuid");
            String regionUuid = (String)pg.getProps().get("regionId");
            String projUuid = (String)pg.getProps().get("projectId");
            String zoneName = (String)pg.getProps().get("zoneName");
            String drCgUuid = (String)pg.getProps().get("drReplicaCgUuid");
            String drRegionUuid = (String)pg.getProps().get("drRegionId");
            String drProjUuid = (String)pg.getProps().get("drProjectId");
            String drZoneName = (String)pg.getProps().get("drZoneName");
            pg.getProps().put("replicaCgUuid", drCgUuid);
            pg.getProps().put("regionId", drRegionUuid);
            pg.getProps().put("projectId", drProjUuid);
            pg.getProps().put("zoneName", drZoneName);
            pg.getProps().put("drReplicaCgUuid", cgUuid);
            pg.getProps().put("drRegionId", regionUuid);
            pg.getProps().put("drProjectId", projUuid);
            pg.getProps().put("drZoneName", zoneName);
            this.updateRingStandByProtectGroupProps(pg);
        }
    }

    private void updateReplicaCgForProtectGroupProps(ProtectGroup pg) {
        String cgUuid = (String)pg.getProps().get("replicaCgUuid");
        String drCgUuid = (String)pg.getProps().get("drReplicaCgUuid");
        String standbyCgUuid = (String)pg.getProps().get("hyperProRemoteCgUuid");
        String standbyDrCgUuid = (String)pg.getProps().get("hyperProRemotedrCgUuid");
        pg.getProps().put("replicaCgUuid", standbyCgUuid);
        pg.getProps().put("drReplicaCgUuid", standbyDrCgUuid);
        pg.getProps().put("hyperProRemoteCgUuid", cgUuid);
        pg.getProps().put("hyperProRemotedrCgUuid", drCgUuid);
    }

    private void updateRingStandByProtectGroupProps(ProtectGroup pg) {
        if (34 != pg.getTemplate().getType() && !PolicyTemplateTools.getInstance().isCshaCsdrBetweenRegionRecovery(pg)) {
            return;
        }
        String standByCgUuid = (String)pg.getProps().get("hyperProRemoteCgUuid");
        String standDrByCgUuid = (String)pg.getProps().get("hyperProRemotedrCgUuid");
        String prodRingId = (String)pg.getProps().get("prodRingID");
        String standRingId = (String)pg.getProps().get("standbyDRRingUuid");
        pg.getProps().put("hyperProRemoteCgUuid", standDrByCgUuid);
        pg.getProps().put("hyperProRemotedrCgUuid", standByCgUuid);
        pg.getProps().put("prodRingID", standRingId);
        pg.getProps().put("standbyDRRingUuid", prodRingId);
    }

    private void updateProtectObjectMoUUID(ProtectGroup pg, Map<String, Object> params) {
        IRecoveryPlanService rpService = (IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class);
        String rpId = rpService.getAssociatedRecoveryPlanWithProtectGroup(pg.getUuid());
        RecoveryPlan rp = rpService.getRecoveryPlan(rpId);
        boolean isCshaCsdrWithinRegionRecovery = PolicyTemplateTools.getInstance().isCshaCsdrWithinRegionRecovery(pg);
        if (rp == null) {
            LOG.error((Object)("No recovery plan associated with pg(pgName=" + pg.getName() + "), rpId=" + rpId));
            throw new LegoCheckedException(1073947393L);
        }
        HashMap<String, String> holdVmToProductVm = new HashMap<String, String>();
        HashMap<String, String> cshaHoldVmToProductVm = new HashMap<String, String>();
        for (ProtectObject po : pg.getPolist()) {
            if (po.getPoType() == 17) {
                String newMouuid = this.getSfsProtectObjectNewMoUuid(po);
                po.setMoUuid(newMouuid);
                LOG.info((Object)"Update sfs protectObject(%s) mouuid.", new Object[]{po.getName()});
                continue;
            }
            if (po.getPoType() == 22) {
                PoReplicaInfo replicaInfo = JsonUtil.jsonToBean((String)po.getProps().get("replicationInfo"), PoReplicaInfo.class);
                String newMouuid = ((PoReplicaPairInfo)replicaInfo.getPairInfos().stream().findAny().get()).getDrVolumeUuid();
                po.setMoUuid(newMouuid);
                LOG.info((Object)"Update sfs protectObject(%s) mouuid.", new Object[]{po.getName()});
                continue;
            }
            if (OpenStackRecoveryTool.isMigration((RecoveryPlan)params.get("RecoveryPlan"), po.getMoUuid())) {
                LOG.info((Object)"Po:%s is migration,no need reverse po info.", new Object[]{po.getName()});
                continue;
            }
            for (RecoverySetting setting : rp.getRecoverySettings()) {
                this.setPoAndGetHoldVMMap(isCshaCsdrWithinRegionRecovery, holdVmToProductVm, cshaHoldVmToProductVm, po, setting);
            }
        }
        String cshaHoldVmKey = pg.getUuid() + "_CshaPlaceHolderMap";
        params.put(cshaHoldVmKey, cshaHoldVmToProductVm);
        String holdVmKey = pg.getUuid() + "_PlaceHolderMap";
        params.put(holdVmKey, holdVmToProductVm);
    }

    private String getSfsProtectObjectNewMoUuid(ProtectObject protectObject) {
        Share share = JsonUtil.jsonToBean((String)protectObject.getProps().get("dr_share"), Share.class);
        if (VerifyUtil.isEmpty((Object)share)) {
            LOG.error((Object)"The protectObject(%s) does not contain pdShare.", new Object[]{protectObject.getName()});
            throw new LegoCheckedException(1073949744L, new String[]{protectObject.getName()});
        }
        String shareId = share.getId();
        return OpenStackCommonUtil.getObjectUuid(OpenStackCommonUtil.getOpenstackUuidFromStr(protectObject.getMoUuid()), shareId);
    }

    private void setPoAndGetHoldVMMap(boolean isCshaCsdrWithinRegionRecovery, Map<String, String> holdVmToProductVm, Map<String, String> cshaHoldVmToProductVm, ProtectObject po, RecoverySetting setting) {
        if ("CSHAPLACEHOLDVM".equals(setting.getName()) && po.getUuid().equals(setting.getOwnerId())) {
            cshaHoldVmToProductVm.put(setting.getValue(), po.getMoUuid());
            if (isCshaCsdrWithinRegionRecovery) {
                po.setMoUuid(setting.getValue());
            }
        }
        if ("CSHAPLACEHOLDVMNAME".equals(setting.getName()) && po.getUuid().equals(setting.getOwnerId())) {
            cshaHoldVmToProductVm.put(setting.getValue(), po.getName());
        }
        if ("PLACEHOLDVM".equals(setting.getName()) && po.getUuid().equals(setting.getOwnerId())) {
            holdVmToProductVm.put(setting.getValue(), po.getMoUuid());
            if (!isCshaCsdrWithinRegionRecovery) {
                po.setMoUuid(setting.getValue());
            }
        }
        if ("PLACEHOLDVMNAME".equals(setting.getName()) && po.getUuid().equals(setting.getOwnerId())) {
            holdVmToProductVm.put(setting.getValue(), po.getName());
        }
    }

    protected void refactorRecoveryPlan(RecoveryPlan recoveryPlan, Map<String, Object> params) {
        String hotMigrationVms = (String)recoveryPlan.getGlobalSettings().get("HOT_MIGRATION_VMS");
        super.refactorRecoveryPlan(recoveryPlan, params);
        ProtectGroup pg = (ProtectGroup)CommonUtil.getFirstElement((Collection)recoveryPlan.getProtectGroups());
        if (null == pg) {
            return;
        }
        HashMap<String, String> holdVmToProductVm = new HashMap();
        String holdVmKey = pg.getUuid() + "_PlaceHolderMap";
        HashMap<String, String> cshaHoldVmToProductVm = new HashMap();
        String cshaHoldVmKey = pg.getUuid() + "_CshaPlaceHolderMap";
        if (params.containsKey(holdVmKey)) {
            holdVmToProductVm = (Map)params.get(holdVmKey);
        }
        if (params.containsKey(cshaHoldVmKey)) {
            cshaHoldVmToProductVm = (Map)params.get(cshaHoldVmKey);
        }
        for (ProtectObject po : pg.getPolist()) {
            if (OpenStackRecoveryTool.isMigration(hotMigrationVms, po.getMoUuid())) {
                LOG.info((Object)"Po:%s is migration,no need reverse plan ph setting.", new Object[]{po.getName()});
                continue;
            }
            this.reverseHoldVmSetting(recoveryPlan, pg, holdVmToProductVm, cshaHoldVmToProductVm, po);
        }
        if (PolicyTemplateTools.getInstance().isCshaCsdrBetweenRegionRecovery(pg) && OpenStackCommonUtil.isCsdrCshaMode(pg)) {
            this.constructAttrForHyperMasterChange(pg, recoveryPlan);
        }
        this.updateRecoverySetting(recoveryPlan, pg);
        recoveryPlan.getProps().remove("HOT_MIGRATION_VMS");
    }

    private void updateRecoverySetting(RecoveryPlan recoveryPlan, ProtectGroup pg) {
        Iterator iterator = recoveryPlan.getRecoverySettings().iterator();
        while (iterator.hasNext()) {
            RecoverySetting setting = (RecoverySetting)iterator.next();
            if (setting.getName().equals("PLACEHOLDVM") || setting.getName().equals("PLACEHOLDVMNAME") || setting.getName().equals("CSHAPLACEHOLDVM") || setting.getName().equals("CSHAPLACEHOLDVMNAME")) continue;
            if (RECOVERY_SETTING_DEFAULT_VALUE.containsKey(setting.getName())) {
                if (this.getIsReversed().booleanValue() || this.isOpenstackHyperMetro(pg)) continue;
                setting.setValue(RECOVERY_SETTING_DEFAULT_VALUE.get(setting.getName()));
                continue;
            }
            iterator.remove();
        }
    }

    private void reverseHoldVmSetting(RecoveryPlan recoveryPlan, ProtectGroup pg, Map<String, String> holdVmToProductVm, Map<String, String> cshaHoldVmToProductVm, ProtectObject po) {
        if (PolicyTemplateTools.getInstance().isCshaCsdrWithinRegionRecovery(pg)) {
            this.reverseCshaHoldVmSetting(recoveryPlan, cshaHoldVmToProductVm, po);
            return;
        }
        for (RecoverySetting setting : recoveryPlan.getRecoverySettings()) {
            if (setting.getName().equals("PLACEHOLDVM") && po.getUuid().equals(setting.getOwnerId())) {
                String phVmUuid = setting.getValue();
                setting.setValue(holdVmToProductVm.get(phVmUuid));
            }
            if (!setting.getName().equals("PLACEHOLDVMNAME") || !po.getUuid().equals(setting.getOwnerId())) continue;
            String phVmName = setting.getValue();
            setting.setValue(holdVmToProductVm.get(phVmName));
        }
    }

    private void reverseCshaHoldVmSetting(RecoveryPlan recoveryPlan, Map<String, String> cshaHoldVmToProductVm, ProtectObject po) {
        for (RecoverySetting setting : recoveryPlan.getRecoverySettings()) {
            if (setting.getName().equals("CSHAPLACEHOLDVM") && po.getUuid().equals(setting.getOwnerId())) {
                String phVmUuid = setting.getValue();
                setting.setValue(cshaHoldVmToProductVm.get(phVmUuid));
            }
            if (!setting.getName().equals("CSHAPLACEHOLDVMNAME") || !po.getUuid().equals(setting.getOwnerId())) continue;
            String phVmName = setting.getValue();
            setting.setValue(cshaHoldVmToProductVm.get(phVmName));
        }
    }

    private boolean isOpenstackHyperMetro(ProtectGroup protectGroup) {
        if (protectGroup == null) {
            return false;
        }
        if (protectGroup.getTemplate() == null) {
            return false;
        }
        int type = protectGroup.getTemplate().getType();
        if (25 == type) {
            LOG.info((Object)"Refactor csha recoverySetting.");
            return true;
        }
        LOG.info((Object)"Refactor not csha recoverySetting.");
        return false;
    }

    static {
        RECOVERY_SETTING_DEFAULT_VALUE.put("startOrder", String.valueOf(10));
        RECOVERY_SETTING_DEFAULT_VALUE.put("isStart", String.valueOf(true));
        RECOVERY_SETTING_DEFAULT_VALUE.put("start_delay_time", "0");
    }
}

