/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.service;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.galax.recovery.service.IRecoveryProcessorService;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackCleanTestNetWorkProcessor;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackConfigPhVmToNormalVmProcessor;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackConfigTestNetWorkProcessor;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackConfigVmToPhVmProcessor;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackDetachVolProcessor;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackPowerOnVmsProcessor;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackShutDownVmProcessor;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.util.CommonUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenStackRecoveryProcessorServiceImpl
implements IRecoveryProcessorService {
    private static final Logger LOG = LoggerFactory.getLogger(OpenStackRecoveryProcessorServiceImpl.class);
    private static Map<Integer, List<Class<? extends RecoveryProcessor>>> bmsDeleteProcessors = new HashMap<Integer, List<Class<? extends RecoveryProcessor>>>();
    private static Map<Integer, List<Class<? extends RecoveryProcessor>>> ecsDeleteProcessors = new HashMap<Integer, List<Class<? extends RecoveryProcessor>>>();

    private static void init() {
        bmsDeleteProcessors.put(DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING.getValue(), Arrays.asList(OpenStackConfigPhVmToNormalVmProcessor.class, OpenStackConfigTestNetWorkProcessor.class, OpenStackPowerOnVmsProcessor.class));
        bmsDeleteProcessors.put(DrmEnumDefine.RecoveryPlanExecuteTypeE.CLEAN_DRILLING.getValue(), Arrays.asList(OpenStackShutDownVmProcessor.class, OpenStackCleanTestNetWorkProcessor.class, OpenStackConfigVmToPhVmProcessor.class));
        bmsDeleteProcessors.put(DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue(), Arrays.asList(OpenStackShutDownVmProcessor.class, OpenStackPowerOnVmsProcessor.class));
        bmsDeleteProcessors.put(DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY.getValue(), Arrays.asList(OpenStackPowerOnVmsProcessor.class));
        ecsDeleteProcessors.put(DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue(), Collections.singletonList(OpenStackDetachVolProcessor.class));
    }

    public List<Class<? extends RecoveryProcessor>> getUnusedRecoveryProcessor(RecoveryPlan recoveryPlan, int procType) {
        if (null == recoveryPlan) {
            LOG.error("Recovery plan is null.");
            throw new LegoCheckedException(1073947393L);
        }
        if (this.isBareMetalServer(recoveryPlan)) {
            LOG.debug("Recovery opreation: {}, need to delete steps", (Object)procType);
            return bmsDeleteProcessors.get(procType);
        }
        LOG.error("Protect object of the recovery plan(" + recoveryPlan.getPlanId() + ") is not bms.");
        return ecsDeleteProcessors.get(procType);
    }

    private boolean isBareMetalServer(RecoveryPlan recoveryPlan) {
        ProtectGroup pg = recoveryPlan.getProtectGroup();
        ProtectObject po = (ProtectObject)CommonUtil.getFirstElement((Collection)pg.getPolist());
        String vmType = (String)po.getProps().get("vm_type");
        LOG.info("Check recovery plan processor, vm type: {}", (Object)vmType);
        return "BMS".equals(vmType);
    }

    static {
        OpenStackRecoveryProcessorServiceImpl.init();
    }
}

