/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.resource;

import com.huawei.ism.drm.common.sdk.service.IRollBackExecutor;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaInfo;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaPairInfo;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.sdk.service.IVolumeService;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class OpenStackVolumeResRollBackExecutor
implements IRollBackExecutor {
    private static final Log LOG = LogFactory.getInstance(OpenStackVolumeResRollBackExecutor.class);
    private static Map<String, Date> cgUuidLockMap = new ConcurrentHashMap<String, Date>();
    private IVolumeService volumeService;

    public void setVolumeService(IVolumeService volumeService) {
        this.volumeService = volumeService;
    }

    public String getName() {
        return this.getClass().getSimpleName();
    }

    public boolean execute(String param) {
        if (VerifyUtil.isEmpty((String)param)) {
            LOG.warn((Object)"Param is empty.");
            return true;
        }
        LOG.info((Object)String.format(Locale.ROOT, "Start volume rollback param info=%s", param), 90160758786988L);
        return this.rollback(param, "replicationInfo");
    }

    private void rollBackupDeleteVolume(String param, String operationPoRelication) {
        JSONObject json = JSONObject.fromObject((Object)param);
        PoReplicaInfo poReplicaInfo = (PoReplicaInfo)JSONObject.toBean((JSONObject)json.getJSONObject(operationPoRelication), PoReplicaInfo.class);
        String drRegionId = poReplicaInfo.getDrRegionUuid();
        String drProjectId = poReplicaInfo.getDrProjUuid();
        boolean isNewDrEvs = true;
        if (!VerifyUtil.isEmpty((Object)json.get("isNewDrVolume"))) {
            isNewDrEvs = Boolean.valueOf(json.get("isNewDrVolume").toString());
        }
        LOG.info((Object)"Volume rollback.volume name=%s, start delete volume.volumeUUID=%s, isNewDrEvs=%s", new Object[]{poReplicaInfo.getVmName(), poReplicaInfo.getMoUuid(), isNewDrEvs});
        if (isNewDrEvs) {
            this.deleteVolume(poReplicaInfo, drRegionId, drProjectId);
        }
        LOG.info((Object)"Volume rollback.volume name=%s, end delete volume,volumeUUID=%s", new Object[]{poReplicaInfo.getVmName(), poReplicaInfo.getMoUuid()});
    }

    private void deleteVolume(PoReplicaInfo poReplicaInfo, String drRegionId, String drProjectId) {
        List pairInfoList = poReplicaInfo.getPairInfos();
        LOG.debug((Object)"Volume rollback.volume name=%s, start delete volume, volumeUUID=%s", new Object[]{poReplicaInfo.getVmName(), poReplicaInfo.getMoUuid()});
        for (PoReplicaPairInfo pairInfo : pairInfoList) {
            String drVolumeUuid = pairInfo.getDrVolumeUuid();
            if (VerifyUtil.isEmpty((String)drVolumeUuid)) continue;
            LOG.debug((Object)"Volume rollback.volume name=%s,start delete volume,volumeUUID=%s, drVolumeUuid=%s", new Object[]{poReplicaInfo.getVmName(), poReplicaInfo.getMoUuid(), drVolumeUuid});
            this.volumeService.delVolume(drVolumeUuid, drRegionId, drProjectId);
        }
        LOG.debug((Object)"Volume rollback.volume name=%s, end delete volume, volumeUUID=%s", new Object[]{poReplicaInfo.getVmName(), poReplicaInfo.getMoUuid()});
    }

    private void deleteReplica(PoReplicaInfo poReplicaInfo, String regionId, String drRegionId, String projectId, String drProjectId) {
        this.removeReplicaFromCg(poReplicaInfo, true);
        this.removeReplicaFromCg(poReplicaInfo, false);
        List pairInfoList = poReplicaInfo.getPairInfos();
        LOG.info((Object)"Volume rollback.volume name=%s, start delete replication and volumeMetadata,volumeUUID=%s", new Object[]{poReplicaInfo.getVmName(), poReplicaInfo.getMoUuid()});
        for (PoReplicaPairInfo pairInfo : pairInfoList) {
            String srcReplicaUuid = pairInfo.getReplicaUuid();
            String drReplicaUuid = pairInfo.getDrReplicaUuid();
            if (!VerifyUtil.isEmpty((String)srcReplicaUuid)) {
                LOG.debug((Object)"Volume rollback.volume name=%s, start delete production replication, volumeUUID=%s, srcReplicaUuid=%s", new Object[]{poReplicaInfo.getVmName(), poReplicaInfo.getMoUuid(), srcReplicaUuid});
                this.volumeService.delVolReplica(regionId, projectId, srcReplicaUuid, false, false);
            }
            if (!VerifyUtil.isEmpty((String)drReplicaUuid)) {
                LOG.debug((Object)"Volume rollback.volume name=%s, start delete disaster replication, volumeUUID=%s, drReplicaUuid=%s", new Object[]{poReplicaInfo.getVmName(), poReplicaInfo.getMoUuid(), drReplicaUuid});
                this.volumeService.delVolReplica(drRegionId, drProjectId, drReplicaUuid, false, false);
            }
            if (!VerifyUtil.isEmpty((String)pairInfo.getVolumeUuid())) {
                LOG.debug((Object)"Volume rollback.volume name=%s, start delete production volume metadata, volumeUUID=%s, volumeUuid=%s", new Object[]{poReplicaInfo.getVmName(), poReplicaInfo.getMoUuid(), pairInfo.getVolumeUuid()});
                this.volumeService.deleteVolMetadatas(regionId, projectId, OpenStackCommonUtil.getIdFromUuid(pairInfo.getVolumeUuid()), "occupied_volume");
            }
            if (VerifyUtil.isEmpty((String)pairInfo.getDrVolumeUuid())) continue;
            LOG.debug((Object)"Volume rollback.volume name=%s, start delete replication and volumeMetadata, volumeUUID=%s, volumeUuid=%s", new Object[]{poReplicaInfo.getVmName(), poReplicaInfo.getMoUuid(), pairInfo.getDrVolumeUuid()});
            this.volumeService.deleteVolMetadatas(drRegionId, drProjectId, OpenStackCommonUtil.getIdFromUuid(pairInfo.getDrVolumeUuid()), "occupied_volume");
        }
        LOG.info((Object)"Volume rollback.volume name=%s, end delete replication and volumeMetadata,volumeUUID=%s", new Object[]{poReplicaInfo.getVmName(), poReplicaInfo.getMoUuid()});
    }

    private void removeReplicaFromCg(PoReplicaInfo poReplicaInfo, boolean isMaster) {
        String cgUuid;
        String regionUuid = isMaster ? poReplicaInfo.getRegionUuid() : poReplicaInfo.getDrRegionUuid();
        String projectUuid = isMaster ? poReplicaInfo.getProjUuid() : poReplicaInfo.getDrProjUuid();
        String string = cgUuid = isMaster ? poReplicaInfo.getCgUuid() : poReplicaInfo.getDrCgUuid();
        if (VerifyUtil.isEmpty((String)cgUuid)) {
            LOG.info((Object)"Volume rollback.volume name=%s, remove replication from Cg,volumeUUID=%s, the cg is empty,need not to remove replications.cg is %s", new Object[]{poReplicaInfo.getVmName(), poReplicaInfo.getMoUuid(), isMaster ? "production" : "disaster"});
            return;
        }
        Set replicaIdStillInCg = this.volumeService.getReplicaIdsOfCg(regionUuid, projectUuid, cgUuid);
        if (VerifyUtil.isEmpty((Collection)replicaIdStillInCg)) {
            LOG.info((Object)"Volume rollback.volume name=%s, remove replication from Cg,volumeUUID=%s, the cg is has no replica now, cguuid=%s, replications cg is %s", new Object[]{poReplicaInfo.getVmName(), poReplicaInfo.getMoUuid(), cgUuid, isMaster ? "production" : "disaster"});
            return;
        }
        HashSet<String> replicaIdSet = new HashSet<String>();
        for (PoReplicaPairInfo pairInfo : poReplicaInfo.getPairInfos()) {
            String replicaUuid = isMaster ? pairInfo.getReplicaUuid() : pairInfo.getDrReplicaUuid();
            String replicaId = OpenStackCommonUtil.getIdFromUuid(replicaUuid);
            if (!replicaIdStillInCg.contains(replicaId)) continue;
            replicaIdSet.add(replicaId);
        }
        if (replicaIdSet.isEmpty()) {
            LOG.info((Object)"Volume rollback.volume name=%s, remove replication from Cg,volumeUUID=%s, target replications are not in cg now, cguuid=%s, replications cg is %s", new Object[]{poReplicaInfo.getVmName(), poReplicaInfo.getMoUuid(), cgUuid, isMaster ? "production" : "disaster"});
            return;
        }
        this.volumeService.updateVolumeReplicationCG(regionUuid, projectUuid, cgUuid, null, replicaIdSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteCg(PoReplicaInfo poReplicaInfo, String regionId, String drRegionId, String projectId, String drProjectId) {
        Date date;
        String replicaCgUuid = poReplicaInfo.getCgUuid();
        String drReplicaCgUuid = poReplicaInfo.getDrCgUuid();
        LOG.info((Object)"Volume rollback.volume name=%s, start delete CG,volumeUUID=%s, replicaCgUuid=%s, drReplicaCgUuid=%s", new Object[]{poReplicaInfo.getVmName(), poReplicaInfo.getMoUuid(), replicaCgUuid, drReplicaCgUuid});
        if (!VerifyUtil.isEmpty((String)replicaCgUuid)) {
            LOG.debug((Object)"Volume rollback.volume name=%s, delete production CG,cguuid=%s,volumeUUID=%s", new Object[]{poReplicaInfo.getVmName(), replicaCgUuid, poReplicaInfo.getMoUuid()});
            this.genCgUuidLock(replicaCgUuid);
            date = cgUuidLockMap.get(replicaCgUuid);
            synchronized (date) {
                LOG.debug((Object)"Volume rollback.volume name=%s, succeed geting lock and start delete productionCG, cguuid=%s,volumeUUID=%s", new Object[]{poReplicaInfo.getVmName(), replicaCgUuid, poReplicaInfo.getMoUuid()});
                this.volumeService.delReplicaCG(regionId, projectId, replicaCgUuid, false, false);
                LOG.debug((Object)"Volume rollback.volume name=%s,succeed geting lock and end delete production CG, cguuid=%s,volumeUUID=%s", new Object[]{poReplicaInfo.getVmName(), replicaCgUuid, poReplicaInfo.getMoUuid()});
            }
        }
        if (!VerifyUtil.isEmpty((String)drReplicaCgUuid)) {
            LOG.debug((Object)"Volume rollback.volume name=%s delete disaster CG,cguuid=%s,volumeUUID=%s", new Object[]{poReplicaInfo.getVmName(), drReplicaCgUuid, poReplicaInfo.getMoUuid()});
            this.genCgUuidLock(drReplicaCgUuid);
            date = cgUuidLockMap.get(drReplicaCgUuid);
            synchronized (date) {
                LOG.debug((Object)"Volume rollback.volume name=%s,succeed geting lock and  start delete disaster CG, cguuid=%s,volumeUUID=%s", new Object[]{poReplicaInfo.getVmName(), drReplicaCgUuid, poReplicaInfo.getMoUuid()});
                this.volumeService.delReplicaCG(drRegionId, drProjectId, drReplicaCgUuid, false, false);
                LOG.debug((Object)"Volume rollback.volume name=%s,succeed deleting disaster CG,cguuid=%s,volumeUUID=%s", new Object[]{poReplicaInfo.getVmName(), drReplicaCgUuid, poReplicaInfo.getMoUuid()});
            }
        }
        LOG.info((Object)"Volume rollback.volume name=%s, end delete CG,volumeUUID=%s, replicaCgUuid=%s, drReplicaCgUuid=%s", new Object[]{poReplicaInfo.getVmName(), poReplicaInfo.getMoUuid(), replicaCgUuid, drReplicaCgUuid});
    }

    private synchronized void genCgUuidLock(String cgUuid) {
        if (cgUuidLockMap.containsKey(cgUuid)) {
            return;
        }
        if (cgUuidLockMap.size() > 20) {
            ArrayList<Date> lockObjList = new ArrayList<Date>(cgUuidLockMap.values());
            Collections.sort(lockObjList);
            Date value = (Date)lockObjList.get(0);
            for (Map.Entry<String, Date> entry : cgUuidLockMap.entrySet()) {
                if (!value.equals(entry.getValue())) continue;
                cgUuidLockMap.remove(entry.getKey());
                break;
            }
        }
        cgUuidLockMap.put(cgUuid, new Date());
    }

    public IVolumeService getVolumeService() {
        return this.volumeService;
    }

    private boolean rollback(String param, String operationPoRelication) {
        JSONObject json = JSONObject.fromObject((Object)param);
        if (json.getJSONObject(operationPoRelication) == null) {
            LOG.error((Object)"Volume rollback failed.rollback json  is null, rollback info=%s, operationPoRelication=%s", new Object[]{param, operationPoRelication});
            return false;
        }
        PoReplicaInfo poReplicaInfo = (PoReplicaInfo)JSONObject.toBean((JSONObject)json.getJSONObject(operationPoRelication), PoReplicaInfo.class);
        if (poReplicaInfo == null) {
            LOG.error((Object)"Volume rollback failed.json to bean error, poReplicaInfo is null");
            return false;
        }
        String regionId = poReplicaInfo.getRegionUuid();
        String drRegionId = poReplicaInfo.getDrRegionUuid();
        String projectId = poReplicaInfo.getProjUuid();
        String drProjectId = poReplicaInfo.getDrProjUuid();
        if (VerifyUtil.isMultiEmpty((Object[])new Object[]{regionId, drRegionId, projectId, drProjectId})) {
            LOG.error((Object)"Volume rollback failed. volume name=%s param is error.regionId=%s, drRegionId=%s, projectId=%s, ,volumeUUID=%s", new Object[]{poReplicaInfo.getVmName(), regionId, drRegionId, projectId, poReplicaInfo.getMoUuid()});
            return false;
        }
        int operationType = json.getInt("operationType");
        LOG.info((Object)"Start volume rollback. volume name=%s, operationType=%s, volumeUUID=%s", new Object[]{poReplicaInfo.getVmName(), operationType, poReplicaInfo.getMoUuid()});
        if (OpenstackEnumDefine.RollbackOperationTypeE.CREATE_PROTECTGROUP.getType() == operationType) {
            this.deleteCg(poReplicaInfo, regionId, drRegionId, projectId, drProjectId);
        }
        this.deleteReplica(poReplicaInfo, regionId, drRegionId, projectId, drProjectId);
        this.rollBackupDeleteVolume(param, operationPoRelication);
        LOG.info((Object)"Volume rollback succeed.volume name=%s,volumeUUID=%s", new Object[]{poReplicaInfo.getVmName(), poReplicaInfo.getMoUuid()});
        return true;
    }
}

